/*
 * Decompiled with CFR 0.152.
 */
package parsley.errors;

import java.io.Serializable;
import parsley.errors.helpers$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class DefaultErrorBuilder$ {
    public static final DefaultErrorBuilder$ MODULE$ = new DefaultErrorBuilder$();

    public final String Unknown() {
        return "unknown parse error";
    }

    public final String EndOfInput() {
        return "end of input";
    }

    public final String ErrorLineStart() {
        return ">";
    }

    public final int NumLinesBefore() {
        return 1;
    }

    public final int NumLinesAfter() {
        return 1;
    }

    public String format(String pos, Option<String> source, Seq<String> lines) {
        return this.blockError(new StringBuilder(0).append(source.fold((Function0 & Serializable)() -> "", (Function1 & Serializable)name -> new StringBuilder(4).append("In ").append((String)name).append(" ").toString())).append(pos).toString(), (Iterable<String>)lines, 2);
    }

    public Option<String> source(Option<String> sourceName) {
        return sourceName.map((Function1 & Serializable)name -> new StringBuilder(7).append("file '").append((String)name).append("'").toString());
    }

    public Seq<String> vanillaError(Option<String> unexpected, Option<String> expected, Iterable<String> reasons, Seq<String> lines) {
        return this.combineInfoWithLines((Seq<String>)((Seq)package$.MODULE$.Seq().concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Iterable[]{Option$.MODULE$.option2Iterable(unexpected), Option$.MODULE$.option2Iterable(expected), reasons}))), lines);
    }

    public Seq<String> specializedError(Seq<String> msgs, Seq<String> lines) {
        return this.combineInfoWithLines(msgs, lines);
    }

    public String blockError(String header, Iterable<String> lines, int indent) {
        return new StringBuilder(2).append(header).append(":\n").append(this.indentAndUnlines(lines, indent)).toString();
    }

    public String indentAndUnlines(Iterable<String> lines, int indent) {
        return lines.mkString(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), indent), new StringBuilder(1).append("\n").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), indent)).toString(), "");
    }

    public String pos(int line, int col) {
        return new StringBuilder(16).append("(line ").append(Integer.toUnsignedString(line)).append(", column ").append(Integer.toUnsignedString(col)).append(")").toString();
    }

    public Option<String> disjunct(Iterable<String> alts) {
        return this.disjunct(alts, true);
    }

    public Option<String> disjunct(Iterable<String> alts, boolean oxfordComma) {
        return helpers$.MODULE$.junct((List<String>)alts.toList().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$1)))), "or", oxfordComma);
    }

    public Seq<String> combineMessages(Seq<String> alts) {
        return (Seq)alts.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2))));
    }

    public Seq<String> combineInfoWithLines(Seq<String> info, Seq<String> lines) {
        if (info.isEmpty()) {
            return (Seq)lines.$plus$colon((Object)"unknown parse error");
        }
        return (Seq)lines.$plus$plus$colon(info);
    }

    public Option<String> unexpected(Option<String> item) {
        return item.map((Function1 & Serializable)x$3 -> new StringBuilder(11).append("unexpected ").append((String)x$3).toString());
    }

    public Option<String> expected(Option<String> alts) {
        return alts.map((Function1 & Serializable)x$4 -> new StringBuilder(9).append("expected ").append((String)x$4).toString());
    }

    public String reason(String reason) {
        return reason;
    }

    public String message(String msg) {
        return msg;
    }

    public String raw(String item) {
        return helpers$.MODULE$.renderRawString(item);
    }

    public String named(String item) {
        return item;
    }

    public Seq<String> lineInfo(String line2, Seq<String> linesBefore, Seq<String> linesAfter, int errorPointsAt, int errorWidth) {
        return (Seq)package$.MODULE$.Seq().concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Iterable[]{(Iterable)linesBefore.map((Function1 & Serializable)line -> MODULE$.inputLine((String)line)), new .colon.colon((Object)this.inputLine(line2), (List)new .colon.colon((Object)this.caretLine(errorPointsAt, errorWidth), (List)Nil$.MODULE$)), (Iterable)linesAfter.map((Function1 & Serializable)line -> MODULE$.inputLine((String)line))}));
    }

    public String inputLine(String line) {
        return new StringBuilder(1).append(">").append(line).toString();
    }

    public String caretLine(int caretAt, int caretWidth) {
        return new StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), ">".length() + caretAt)).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("^"), caretWidth)).toString();
    }

    private DefaultErrorBuilder$() {
    }
}

