/*
 * Decompiled with CFR 0.152.
 */
package parsley.internal.machine;

import java.io.Serializable;
import parsley.Failure;
import parsley.Result;
import parsley.Success;
import parsley.errors.ErrorBuilder;
import parsley.internal.errors.CaretWidth;
import parsley.internal.errors.ExpectItem;
import parsley.internal.errors.LineBuilder;
import parsley.internal.errors.UnexpectDesc;
import parsley.internal.machine.Failed$;
import parsley.internal.machine.Finished$;
import parsley.internal.machine.Good$;
import parsley.internal.machine.Recover$;
import parsley.internal.machine.Status;
import parsley.internal.machine.errors.AddError;
import parsley.internal.machine.errors.ClassicFancyError;
import parsley.internal.machine.errors.DefuncError;
import parsley.internal.machine.errors.DefuncHints;
import parsley.internal.machine.errors.EmptyHints$;
import parsley.internal.machine.errors.ErrorItemBuilder;
import parsley.internal.machine.errors.ExpectedError;
import parsley.internal.machine.errors.TrivialDefuncError;
import parsley.internal.machine.errors.UnexpectedError;
import parsley.internal.machine.instructions.Instr;
import parsley.internal.machine.stacks.ArrayStack;
import parsley.internal.machine.stacks.CallStack;
import parsley.internal.machine.stacks.CallStack$;
import parsley.internal.machine.stacks.ErrorStack;
import parsley.internal.machine.stacks.ErrorStack$;
import parsley.internal.machine.stacks.HandlerStack;
import parsley.internal.machine.stacks.HandlerStack$;
import parsley.internal.machine.stacks.Stack;
import parsley.internal.machine.stacks.Stack$StackExt$;
import parsley.internal.machine.stacks.StateStack;
import parsley.internal.machine.stacks.StateStack$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\ref!\u00024h\u0005-l\u0007\"\u0003;\u0001\u0005\u0003\u0007I\u0011A4v\u0011-\t\t\u0001\u0001BA\u0002\u0013\u0005q-a\u0001\t\u0013\u0005=\u0001A!A!B\u00131\bbCA\t\u0001\t\u0015\r\u0011\"\u0001h\u0003'A!\"a\u000b\u0001\u0005\u0003\u0005\u000b\u0011BA\u000b\u0011)\ti\u0003\u0001B\u0001B\u0003%\u0011q\u0006\u0005\u000b\u0003k\u0001!Q1A\u0005\n\u0005]\u0002BCA \u0001\t\u0005\t\u0015!\u0003\u0002:!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003BCA)\u0001\t\u0007I\u0011A4\u0002T!A\u0011q\r\u0001!\u0002\u0013\t)\u0006\u0003\u0006\u0002j\u0001\u0001\r\u0011\"\u0001h\u0003WB!\"!\u001c\u0001\u0001\u0004%\taZA8\u0011!\t\u0019\b\u0001Q!\n\u0005=\u0002BCA;\u0001\t\u0007I\u0011A4\u0002l!A\u0011q\u000f\u0001!\u0002\u0013\ty\u0003C\u0005\u0002z\u0001\u0001\r\u0011\"\u0003\u0002|!I\u00111\u0011\u0001A\u0002\u0013%\u0011Q\u0011\u0005\t\u0003\u0013\u0003\u0001\u0015)\u0003\u0002~!Q\u00111\u0012\u0001A\u0002\u0013\u0005q-!$\t\u0015\u0005U\u0005\u00011A\u0005\u0002\u001d\f9\n\u0003\u0005\u0002\u001c\u0002\u0001\u000b\u0015BAH\u0011)\ti\n\u0001a\u0001\n\u00039\u0017q\u0014\u0005\u000b\u0003O\u0003\u0001\u0019!C\u0001O\u0006%\u0006\u0002CAW\u0001\u0001\u0006K!!)\t\u0015\u0005=\u0006\u00011A\u0005\u0002\u001d\fy\n\u0003\u0006\u00022\u0002\u0001\r\u0011\"\u0001h\u0003gC\u0001\"a.\u0001A\u0003&\u0011\u0011\u0015\u0005\u000b\u0003s\u0003\u0001\u0019!C\u0001O\u0006m\u0006BCAb\u0001\u0001\u0007I\u0011A4\u0002F\"A\u0011\u0011\u001a\u0001!B\u0013\ti\f\u0003\u0006\u0002L\u0002\u0001\r\u0011\"\u0001h\u0003WB!\"!4\u0001\u0001\u0004%\taZAh\u0011!\t\u0019\u000e\u0001Q!\n\u0005=\u0002BCAk\u0001\u0001\u0007I\u0011A4\u0002l!Q\u0011q\u001b\u0001A\u0002\u0013\u0005q-!7\t\u0011\u0005u\u0007\u0001)Q\u0005\u0003_A!\"a8\u0001\u0001\u0004%\taZA6\u0011)\t\t\u000f\u0001a\u0001\n\u00039\u00171\u001d\u0005\t\u0003O\u0004\u0001\u0015)\u0003\u00020!Q\u0011\u0011\u001e\u0001A\u0002\u0013\u0005q-a;\t\u0015\u0005=\b\u00011A\u0005\u0002\u001d\f\t\u0010\u0003\u0005\u0002v\u0002\u0001\u000b\u0015BAw\u0011)\t9\u0010\u0001a\u0001\n\u00039\u00171\u000e\u0005\u000b\u0003s\u0004\u0001\u0019!C\u0001O\u0006m\b\u0002CA\u0000\u0001\u0001\u0006K!a\f\t\u0015\t\u0005\u0001\u00011A\u0005\u0002\u001d\u0014\u0019\u0001\u0003\u0006\u0003\u0012\u0001\u0001\r\u0011\"\u0001h\u0005'A\u0001Ba\u0006\u0001A\u0003&!Q\u0001\u0005\n\u00053\u0001\u0001\u0019!C\u0005\u0003WB\u0011Ba\u0007\u0001\u0001\u0004%IA!\b\t\u0011\t\u0005\u0002\u0001)Q\u0005\u0003_A!Ba\t\u0001\u0001\u0004%\ta\u001aB\u0013\u0011)\u0011i\u0003\u0001a\u0001\n\u00039'q\u0006\u0005\t\u0005g\u0001\u0001\u0015)\u0003\u0003(!A!Q\u0007\u0001\u0005\u0002\u001d\u00149\u0004\u0003\u0005\u0003:\u0001!\ta\u001aB\u0002\u0011!\u0011Y\u0004\u0001C\u0001O\nu\u0002\u0002\u0003B#\u0001\u0011\u0005q-a\u001b\t\u0011\t\u001d\u0003\u0001\"\u0001h\u0005oA\u0001B!\u0013\u0001\t\u00039'1\n\u0005\t\u0005G\u0002A\u0011A4\u00038!9!Q\r\u0001\u0005\u0002\t]\u0002b\u0002B4\u0001\u0011%!\u0011\u000e\u0005\t\u0005_\u0002A\u0011A4\u00038!A!\u0011\u000f\u0001\u0005\u0002\u001d\u0014\u0019\b\u0003\u0005\u0003\u000e\u0002!\ta\u001aB\u001c\u0011!\u0011y\t\u0001C\u0001O\u0006M\u0001\u0002\u0003BI\u0001\u0011\u00051Na%\t\u0011\tM\u0007\u0001\"\u0001h\u0005+D\u0001Ba5\u0001\t\u00039'1\u001c\u0005\t\u0005C\u0004A\u0011A4\u00038!A!1\u001d\u0001\u0005\u0002\u001d\u0014)\u000f\u0003\u0005\u0003x\u0002!\ta\u001aB}\u0011!\u0011i\u0010\u0001C\u0001O\n}\b\u0002CB\u0002\u0001\u0011\u0005qm!\u0002\t\u0011\rm\u0001\u0001\"\u0001h\u0007;A\u0001ba\f\u0001\t\u000397\u0011\u0007\u0005\t\u0007o\u0001A\u0011A4\u0004:!A1q\u0007\u0001\u0005\u0002\u001d\u00149\u0004\u0003\u0005\u0004@\u0001!\taZB!\u0011!\u00199\u0005\u0001C\u0001O\u000e%\u0003\u0002CB'\u0001\u0011\u0005qma\u0014\t\u0011\rM\u0003\u0001\"\u0001h\u0005oA\u0001b!\u0016\u0001\t\u000397q\u000b\u0005\t\u0007+\u0002A\u0011A4\u0004`!A1Q\r\u0001\u0005\u0002\u001d\fy\n\u0003\u0005\u0004f\u0001!\taZB4\u0011!\u0019i\u0007\u0001C\u0001O\u000e=\u0004\u0002CB;\u0001\u0011\u0005qma\u001e\t\u0011\re\u0004\u0001\"\u0001h\u0005oA\u0001ba\u001f\u0001\t\u000397Q\u0010\u0005\t\u0007\u0003\u0003A\u0011A4\u0004\u0004\"A1\u0011\u0012\u0001\u0005\u0002\u001d\u00149\u0004\u0003\u0005\u0004\f\u0002!\ta\u001aB\u001c\u0011!\u0019i\t\u0001C\u0001O\u000e=\u0005\u0002CBL\u0001\u0011\u0005qm!'\t\u0013\r\u0005\u0006A1A\u0005\f\r\r\u0006\u0002CBV\u0001\u0001\u0006Ia!*\t\u0015\r5\u0006A1A\u0005\u0004\u001d\u001cy\u000b\u0003\u0005\u00048\u0002\u0001\u000b\u0011BBY\u0005\u001d\u0019uN\u001c;fqRT!\u0001[5\u0002\u000f5\f7\r[5oK*\u0011!n[\u0001\tS:$XM\u001d8bY*\tA.A\u0004qCJ\u001cH.Z=\u0014\u0005\u0001q\u0007CA8s\u001b\u0005\u0001(\"A9\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0004(AB!osJ+g-\u0001\u0004j]N$(o]\u000b\u0002mB\u0019qn^=\n\u0005a\u0004(!B!se\u0006L\bC\u0001>~\u001b\u0005Y(B\u0001?h\u00031Ign\u001d;sk\u000e$\u0018n\u001c8t\u0013\tq8PA\u0003J]N$(o\u0001\u0001\u0002\u0015%t7\u000f\u001e:t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005-\u0001cA8\u0002\b%\u0019\u0011\u0011\u00029\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u001b\u0011\u0011\u0011!a\u0001m\u0006\u0019\u0001\u0010J\u0019\u0002\u000f%t7\u000f\u001e:tA\u0005)\u0011N\u001c9viV\u0011\u0011Q\u0003\t\u0005\u0003/\t)C\u0004\u0003\u0002\u001a\u0005\u0005\u0002cAA\u000ea6\u0011\u0011Q\u0004\u0006\u0004\u0003?y\u0018A\u0002\u001fs_>$h(C\u0002\u0002$A\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u0014\u0003S\u0011aa\u0015;sS:<'bAA\u0012a\u00061\u0011N\u001c9vi\u0002\nqA\\;n%\u0016<7\u000fE\u0002p\u0003cI1!a\rq\u0005\rIe\u000e^\u0001\u000bg>,(oY3GS2,WCAA\u001d!\u0015y\u00171HA\u000b\u0013\r\ti\u0004\u001d\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0017M|WO]2f\r&dW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005\u0015\u0013\u0011JA&\u0003\u001b\ny\u0005E\u0002\u0002H\u0001i\u0011a\u001a\u0005\u0006i&\u0001\rA\u001e\u0005\b\u0003#I\u0001\u0019AA\u000b\u0011\u001d\ti#\u0003a\u0001\u0003_Aq!!\u000e\n\u0001\u0004\tI$A\u0003ti\u0006\u001c7.\u0006\u0002\u0002VA1\u0011qKA/\u0003Cj!!!\u0017\u000b\u0007\u0005ms-\u0001\u0004ti\u0006\u001c7n]\u0005\u0005\u0003?\nIF\u0001\u0006BeJ\f\u0017p\u0015;bG.\u00042a\\A2\u0013\r\t)\u0007\u001d\u0002\u0004\u0003:L\u0018AB:uC\u000e\\\u0007%\u0001\u0004pM\u001a\u001cX\r^\u000b\u0003\u0003_\t!b\u001c4gg\u0016$x\fJ3r)\u0011\t)!!\u001d\t\u0013\u00055Q\"!AA\u0002\u0005=\u0012aB8gMN,G\u000fI\u0001\bS:\u0004X\u000f^:{\u0003!Ig\u000e];ugj\u0004\u0013!B2bY2\u001cXCAA?!\u0011\t9&a \n\t\u0005\u0005\u0015\u0011\f\u0002\n\u0007\u0006dGn\u0015;bG.\f\u0011bY1mYN|F%Z9\u0015\t\u0005\u0015\u0011q\u0011\u0005\n\u0003\u001b\u0011\u0012\u0011!a\u0001\u0003{\naaY1mYN\u0004\u0013AB:uCR,7/\u0006\u0002\u0002\u0010B!\u0011qKAI\u0013\u0011\t\u0019*!\u0017\u0003\u0015M#\u0018\r^3Ti\u0006\u001c7.\u0001\u0006ti\u0006$Xm]0%KF$B!!\u0002\u0002\u001a\"I\u0011QB\u000b\u0002\u0002\u0003\u0007\u0011qR\u0001\bgR\fG/Z:!\u0003\u00119wn\u001c3\u0016\u0005\u0005\u0005\u0006cA8\u0002$&\u0019\u0011Q\u00159\u0003\u000f\t{w\u000e\\3b]\u0006Aqm\\8e?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005-\u0006\"CA\u00071\u0005\u0005\t\u0019AAQ\u0003\u00159wn\u001c3!\u0003\u001d\u0011XO\u001c8j]\u001e\f1B];o]&twm\u0018\u0013fcR!\u0011QAA[\u0011%\tiaGA\u0001\u0002\u0004\t\t+\u0001\u0005sk:t\u0017N\\4!\u0003!A\u0017M\u001c3mKJ\u001cXCAA_!\u0011\t9&a0\n\t\u0005\u0005\u0017\u0011\f\u0002\r\u0011\u0006tG\r\\3s'R\f7m[\u0001\rQ\u0006tG\r\\3sg~#S-\u001d\u000b\u0005\u0003\u000b\t9\rC\u0005\u0002\u000ey\t\t\u00111\u0001\u0002>\u0006I\u0001.\u00198eY\u0016\u00148\u000fI\u0001\u0003a\u000e\fa\u0001]2`I\u0015\fH\u0003BA\u0003\u0003#D\u0011\"!\u0004\"\u0003\u0003\u0005\r!a\f\u0002\u0007A\u001c\u0007%\u0001\u0003mS:,\u0017\u0001\u00037j]\u0016|F%Z9\u0015\t\u0005\u0015\u00111\u001c\u0005\n\u0003\u001b!\u0013\u0011!a\u0001\u0003_\tQ\u0001\\5oK\u0002\n1aY8m\u0003\u001d\u0019w\u000e\\0%KF$B!!\u0002\u0002f\"I\u0011QB\u0014\u0002\u0002\u0003\u0007\u0011qF\u0001\u0005G>d\u0007%\u0001\u0003sK\u001e\u001cXCAAw!\rywO\\\u0001\te\u0016<7o\u0018\u0013fcR!\u0011QAAz\u0011%\tiAKA\u0001\u0002\u0004\ti/A\u0003sK\u001e\u001c\b%\u0001\u0005eK\n,x\r\u001c<m\u00031!WMY;hYZdw\fJ3r)\u0011\t)!!@\t\u0013\u00055Q&!AA\u0002\u0005=\u0012!\u00033fEV<GN\u001e7!\u0003\u0015A\u0017N\u001c;t+\t\u0011)\u0001\u0005\u0003\u0003\b\t5QB\u0001B\u0005\u0015\r\u0011YaZ\u0001\u0007KJ\u0014xN]:\n\t\t=!\u0011\u0002\u0002\f\t\u00164WO\\2IS:$8/A\u0005iS:$8o\u0018\u0013fcR!\u0011Q\u0001B\u000b\u0011%\ti\u0001MA\u0001\u0002\u0004\u0011)!\u0001\u0004iS:$8\u000fI\u0001\u0011Q&tGo\u001d,bY&$wJ\u001a4tKR\fA\u0003[5oiN4\u0016\r\\5e\u001f\u001a47/\u001a;`I\u0015\fH\u0003BA\u0003\u0005?A\u0011\"!\u00044\u0003\u0003\u0005\r!a\f\u0002#!Lg\u000e^:WC2LGm\u00144gg\u0016$\b%\u0001\u0003feJ\u001cXC\u0001B\u0014!\u0011\t9F!\u000b\n\t\t-\u0012\u0011\f\u0002\u000b\u000bJ\u0014xN]*uC\u000e\\\u0017\u0001C3seN|F%Z9\u0015\t\u0005\u0015!\u0011\u0007\u0005\n\u0003\u001b1\u0014\u0011!a\u0001\u0005O\tQ!\u001a:sg\u0002\nAB]3ti>\u0014X\rS5oiN$\"!!\u0002\u0002\u001b%tg\t\\5hQRD\u0015N\u001c;t\u00035IgN\u00127jO\"$XI\u001d:peV\u0011!q\b\t\u0005\u0005\u000f\u0011\t%\u0003\u0003\u0003D\t%!a\u0003#fMVt7-\u0012:s_J\fqcY;se\u0016tG\u000fS5oiN4\u0016\r\\5e\u001f\u001a47/\u001a;\u0002\u00155,'oZ3IS:$8/A\u0006sKBd\u0017mY3IS:$H\u0003BA\u0003\u0005\u001bBqAa\u0014>\u0001\u0004\u0011\t&\u0001\u0004mC\n,Gn\u001d\t\u0007\u0005'\u0012i&!\u0006\u000f\t\tU#\u0011\f\b\u0005\u00037\u00119&C\u0001r\u0013\r\u0011Y\u0006]\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yF!\u0019\u0003\u0011%#XM]1cY\u0016T1Aa\u0017q\u0003!\u0001x\u000e\u001d%j]R\u001c\u0018aD5om\u0006d\u0017\u000eZ1uK\"Kg\u000e^:\u0002\u001f\u0005$G-\u0012:s_J$v\u000eS5oiN$B!!\u0002\u0003l!9!Q\u000e!A\u0002\t}\u0012aA3se\u0006)\u0012\r\u001a3FeJ|'\u000fV8IS:$8/\u00118e!>\u0004\u0018\u0001C1eI\"Kg\u000e^:\u0015\r\u0005\u0015!Q\u000fBE\u0011\u001d\u00119H\u0011a\u0001\u0005s\n\u0011\"\u001a=qK\u000e$X\rZ:\u0011\r\u0005]!1\u0010B@\u0013\u0011\u0011i(!\u000b\u0003\u0007M+G\u000f\u0005\u0003\u0003\u0002\n\u0015UB\u0001BB\u0015\r\u0011Y![\u0005\u0005\u0005\u000f\u0013\u0019I\u0001\u0006FqB,7\r^%uK6DqAa#C\u0001\u0004\ty#A\bv]\u0016D\b/Z2uK\u0012<\u0016\u000e\u001a;i\u0003E)\b\u000fZ1uK\u000eCWmY6PM\u001a\u001cX\r^\u0001\u0007aJ,G\u000f^=\u0002\u0007I,h.\u0006\u0004\u0003\u0016\n\u0015&1\u0017\u000b\u0003\u0005/#BA!'\u00038BA!1\u0014BO\u0005C\u0013\t,D\u0001l\u0013\r\u0011yj\u001b\u0002\u0007%\u0016\u001cX\u000f\u001c;\u0011\t\t\r&Q\u0015\u0007\u0001\t\u001d\u00119+\u0012b\u0001\u0005S\u00131!\u0012:s#\u0011\u0011Y+!\u0019\u0011\u0007=\u0014i+C\u0002\u00030B\u0014qAT8uQ&tw\r\u0005\u0003\u0003$\nMFa\u0002B[\u000b\n\u0007!\u0011\u0016\u0002\u0002\u0003\"I!\u0011X#\u0002\u0002\u0003\u000f!1X\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004C\u0002B_\u0005\u0003\u0014\t+\u0004\u0002\u0003@*\u0019!1B6\n\t\t\r'q\u0018\u0002\r\u000bJ\u0014xN\u001d\"vS2$WM\u001d\u0015\u0004\u000b\n\u001d\u0007\u0003\u0002Be\u0005\u001fl!Aa3\u000b\u0007\t5\u0007/\u0001\u0006b]:|G/\u0019;j_:LAA!5\u0003L\n9A/Y5me\u0016\u001c\u0017\u0001B2bY2$B!!\u0002\u0003X\"1!\u0011\u001c$A\u0002Y\f\u0011B\\3x\u0013:\u001cHO]:\u0015\t\u0005\u0015!Q\u001c\u0005\b\u0005?<\u0005\u0019AA\u0018\u0003\t\tG/A\u0002sKR\fqbY1uG\"tunQ8ogVlW\r\u001a\u000b\u0005\u0005O\u0014\u0019\u0010\u0006\u0003\u0002\u0006\t%\b\u0002\u0003Bv\u0013\u0012\u0005\rA!<\u0002\u000f!\fg\u000e\u001a7feB)qNa<\u0002\u0006%\u0019!\u0011\u001f9\u0003\u0011q\u0012\u0017P\\1nKzBqA!>J\u0001\u0004\ty#A\u0003dQ\u0016\u001c7.A\u0005qkNDWI\u001d:peR!\u0011Q\u0001B~\u0011\u001d\u0011iG\u0013a\u0001\u0005\u007f\t\u0001\"^:f\u0011&tGo\u001d\u000b\u0005\u0005\u007f\u0019\t\u0001C\u0004\u0003n-\u0003\rAa\u0010\u0002\u001f\u0019\f\u0017\u000e\\,ji\"lUm]:bO\u0016$b!!\u0002\u0004\b\rE\u0001bBB\u0005\u0019\u0002\u000711B\u0001\u000bG\u0006\u0014X\r^,jIRD\u0007\u0003\u0002BA\u0007\u001bIAaa\u0004\u0003\u0004\nQ1)\u0019:fi^KG\r\u001e5\t\u000f\rMA\n1\u0001\u0004\u0016\u0005!Qn]4t!\u0015y7qCA\u000b\u0013\r\u0019I\u0002\u001d\u0002\u000byI,\u0007/Z1uK\u0012t\u0014AD;oKb\u0004Xm\u0019;fI\u001a\u000b\u0017\u000e\u001c\u000b\u0007\u0003\u000b\u0019yb!\n\t\u000f\r\u0005R\n1\u0001\u0004$\u0005AQ\r\u001f9fGR,G\r\u0005\u0004\u0003T\tu#q\u0010\u0005\b\u0007Oi\u0005\u0019AB\u0015\u0003))h.\u001a=qK\u000e$X\r\u001a\t\u0005\u0005\u0003\u001bY#\u0003\u0003\u0004.\t\r%\u0001D+oKb\u0004Xm\u0019;EKN\u001c\u0017\u0001D3ya\u0016\u001cG/\u001a3GC&dGCBA\u0003\u0007g\u0019)\u0004C\u0004\u0004\"9\u0003\raa\t\t\u000f\t-e\n1\u0001\u00020\u0005!a-Y5m)\u0011\t)aa\u000f\t\u000f\rur\n1\u0001\u0003@\u0005)QM\u001d:pe\u0006y\u0001/^:i\u0003:$7i\u001c8uS:,X\r\u0006\u0003\u0002\u0006\r\r\u0003bBB##\u0002\u0007\u0011\u0011M\u0001\u0002q\u0006)RO\\:bM\u0016\u0004Vo\u001d5B]\u0012\u001cuN\u001c;j]V,G\u0003BA\u0003\u0007\u0017Bqa!\u0012S\u0001\u0004\t\t'A\nfq\u000eD\u0017M\\4f\u0003:$7i\u001c8uS:,X\r\u0006\u0003\u0002\u0006\rE\u0003bBB#'\u0002\u0007\u0011\u0011M\u0001\u0004S:\u001c\u0017\u0001\u00039fK.\u001c\u0005.\u0019:\u0016\u0005\re\u0003cA8\u0004\\%\u00191Q\f9\u0003\t\rC\u0017M\u001d\u000b\u0005\u00073\u001a\t\u0007C\u0004\u0004dY\u0003\r!a\f\u0002\u00131|wn[!iK\u0006$\u0017!C7pe\u0016Le\u000e];u)\u0011\t\tk!\u001b\t\u000f\r-\u0004\f1\u0001\u00020\u0005\ta.A\u0005va\u0012\fG/\u001a)pgR!\u0011QAB9\u0011\u001d\u0019\u0019(\u0017a\u0001\u00073\n\u0011aY\u0001\fG>t7/^7f\u0007\"\f'\u000f\u0006\u0002\u0004Z\u0005ab-Y:u\u0007>t7/^7f'V\u0004\b\u000f\\3nK:$\u0018M]=DQ\u0006\u0014\u0018!\u00074bgR,fn\u00195fG.,GmQ8ogVlWm\u00115beN$B!!\u0002\u0004\u0000!911\u000e/A\u0002\u0005=\u0012a\u00039vg\"D\u0015M\u001c3mKJ$B!!\u0002\u0004\u0006\"91qQ/A\u0002\u0005=\u0012!\u00027bE\u0016d\u0017!C:bm\u0016\u001cF/\u0019;f\u00031\u0011Xm\u001d;pe\u0016\u001cF/\u0019;f\u0003!9(/\u001b;f%\u0016<GCBA\u0003\u0007#\u001b)\nC\u0004\u0004\u0014\u0002\u0004\r!a\f\u0002\u0007I,w\rC\u0004\u0004F\u0001\u0004\r!!\u0019\u0002\rM$\u0018\r^;t+\t\u0019Y\n\u0005\u0003\u0002H\ru\u0015bABPO\n11\u000b^1ukN\f1\u0002\\5oK\n+\u0018\u000e\u001c3feV\u00111Q\u0015\t\u0005\u0005\u0003\u001b9+\u0003\u0003\u0004*\n\r%a\u0003'j]\u0016\u0014U/\u001b7eKJ\fA\u0002\\5oK\n+\u0018\u000e\u001c3fe\u0002\n\u0001#\u001a:s_JLE/Z7Ck&dG-\u001a:\u0016\u0005\rE\u0006\u0003\u0002B\u0004\u0007gKAa!.\u0003\n\t\u0001RI\u001d:pe&#X-\u001c\"vS2$WM]\u0001\u0012KJ\u0014xN]%uK6\u0014U/\u001b7eKJ\u0004\u0003")
public final class Context {
    private Instr[] instrs;
    private final String input;
    private final Option<String> sourceFile;
    private final ArrayStack<Object> stack;
    private int offset;
    private final int inputsz;
    private CallStack calls;
    private StateStack states;
    private boolean good;
    private boolean running;
    private HandlerStack handlers;
    private int pc;
    private int line;
    private int col;
    private Object[] regs;
    private int debuglvl;
    private DefuncHints hints;
    private int hintsValidOffset;
    private ErrorStack errs;
    private final LineBuilder lineBuilder;
    private final ErrorItemBuilder errorItemBuilder;

    public Instr[] instrs() {
        return this.instrs;
    }

    public void instrs_$eq(Instr[] x$1) {
        this.instrs = x$1;
    }

    public String input() {
        return this.input;
    }

    private Option<String> sourceFile() {
        return this.sourceFile;
    }

    public ArrayStack<Object> stack() {
        return this.stack;
    }

    public int offset() {
        return this.offset;
    }

    public void offset_$eq(int x$1) {
        this.offset = x$1;
    }

    public int inputsz() {
        return this.inputsz;
    }

    private CallStack calls() {
        return this.calls;
    }

    private void calls_$eq(CallStack x$1) {
        this.calls = x$1;
    }

    public StateStack states() {
        return this.states;
    }

    public void states_$eq(StateStack x$1) {
        this.states = x$1;
    }

    public boolean good() {
        return this.good;
    }

    public void good_$eq(boolean x$1) {
        this.good = x$1;
    }

    public boolean running() {
        return this.running;
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    public HandlerStack handlers() {
        return this.handlers;
    }

    public void handlers_$eq(HandlerStack x$1) {
        this.handlers = x$1;
    }

    public int pc() {
        return this.pc;
    }

    public void pc_$eq(int x$1) {
        this.pc = x$1;
    }

    public int line() {
        return this.line;
    }

    public void line_$eq(int x$1) {
        this.line = x$1;
    }

    public int col() {
        return this.col;
    }

    public void col_$eq(int x$1) {
        this.col = x$1;
    }

    public Object[] regs() {
        return this.regs;
    }

    public void regs_$eq(Object[] x$1) {
        this.regs = x$1;
    }

    public int debuglvl() {
        return this.debuglvl;
    }

    public void debuglvl_$eq(int x$1) {
        this.debuglvl = x$1;
    }

    public DefuncHints hints() {
        return this.hints;
    }

    public void hints_$eq(DefuncHints x$1) {
        this.hints = x$1;
    }

    private int hintsValidOffset() {
        return this.hintsValidOffset;
    }

    private void hintsValidOffset_$eq(int x$1) {
        this.hintsValidOffset = x$1;
    }

    public ErrorStack errs() {
        return this.errs;
    }

    public void errs_$eq(ErrorStack x$1) {
        this.errs = x$1;
    }

    public void restoreHints() {
        HandlerStack hintFrame = this.handlers();
        this.hintsValidOffset_$eq(hintFrame.hintOffset());
        this.hints_$eq(hintFrame.hints());
    }

    public DefuncHints inFlightHints() {
        return this.hints();
    }

    public DefuncError inFlightError() {
        return this.errs().error();
    }

    public int currentHintsValidOffset() {
        return this.hintsValidOffset();
    }

    public void mergeHints() {
        HandlerStack hintFrame = this.handlers();
        if (hintFrame.hintOffset() == this.offset()) {
            this.hints_$eq(hintFrame.hints().merge(this.hints()));
            return;
        }
    }

    public void replaceHint(Iterable<String> labels) {
        this.hints_$eq(this.hints().rename(labels));
    }

    public void popHints() {
        if (this.hints() == null) {
            throw null;
        }
        this.hints_$eq(EmptyHints$.MODULE$);
    }

    public void invalidateHints() {
        if (this.hintsValidOffset() < this.offset()) {
            this.hints_$eq(EmptyHints$.MODULE$);
            this.hintsValidOffset_$eq(this.offset());
            return;
        }
    }

    private void addErrorToHints(DefuncError err) {
        if (!err.isExpectedEmpty() && err.presentationOffset() == this.offset()) {
            this.invalidateHints();
            DefuncHints defuncHints = this.hints();
            if (defuncHints == null) {
                throw null;
            }
            DefuncHints addError_this = defuncHints;
            Object var2_2 = null;
            this.hints_$eq(new AddError(addError_this, (TrivialDefuncError)err));
            return;
        }
    }

    public void addErrorToHintsAndPop() {
        this.addErrorToHints(this.errs().error());
        this.errs_$eq(this.errs().tail());
    }

    /*
     * WARNING - void declaration
     */
    public void addHints(Set<ExpectItem> expecteds, int unexpectedWidth) {
        void addError_err;
        this.invalidateHints();
        DefuncHints defuncHints = this.hints();
        ExpectedError expectedError = new ExpectedError(this.offset(), this.line(), this.col(), (Iterable<ExpectItem>)expecteds, unexpectedWidth);
        if (defuncHints == null) {
            throw null;
        }
        DefuncHints addError_this = defuncHints;
        Object var3_4 = null;
        expectedError = null;
        this.hints_$eq(new AddError(addError_this, (TrivialDefuncError)addError_err));
    }

    public void updateCheckOffset() {
        this.handlers().check_$eq(this.offset());
    }

    public String pretty() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(318).append("[\n           |  stack     = [").append(this.stack().mkString(", ")).append("]\n           |  instrs    = ").append(Predef$.MODULE$.wrapRefArray((Object[])this.instrs()).toList().mkString("; ")).append("\n           |  input     = ").append(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(this.input()), this.offset())).append("\n           |  pos       = (").append(this.line()).append(", ").append(this.col()).append(")\n           |  status    = ").append(this.status()).append("\n           |  pc        = ").append(this.pc()).append("\n           |  rets      = ").append(Stack$StackExt$.MODULE$.mkString$extension(this.calls(), ", ", CallStack$.MODULE$.inst())).append("\n           |  handlers  = ").append(Stack$StackExt$.MODULE$.mkString$extension(this.handlers(), ", ", HandlerStack$.MODULE$.inst())).append("\n           |  recstates = ").append(Stack$StackExt$.MODULE$.mkString$extension(this.states(), ", ", StateStack$.MODULE$.inst())).append("\n           |  registers = ").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps(this.regs()))), (Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Object r = x0$1._1();
                int i = x0$1._2$mcI$sp();
                return new StringBuilder(4).append("r").append(i).append(" = ").append(r).toString();
            }
            throw new MatchError(null);
        }, ClassTag$.MODULE$.apply(String.class))).toList().mkString("\n              ")).append("\n           |  errors    = ").append(Stack$StackExt$.MODULE$.mkString$extension(this.errs(), ", ", ErrorStack$.MODULE$.inst())).append("\n           |]").toString()));
    }

    public <Err, A> Result<Err, A> run(ErrorBuilder<Err> evidence$1) {
        while (this.running()) {
            this.instrs()[this.pc()].apply(this);
        }
        if (this.good()) {
            ArrayStack<Object> arrayStack = this.stack();
            if (arrayStack == null) {
                throw null;
            }
            return new Success<Object>(arrayStack.upeek());
        }
        Function0 & Serializable apply_msg = (Function0 & Serializable)() -> this.errs().error().asParseError(this.errorItemBuilder()).format(this.sourceFile(), this.lineBuilder(), evidence$1);
        return new Failure(apply_msg);
    }

    public void call(Instr[] newInstrs) {
        this.call(0);
        this.instrs_$eq(newInstrs);
    }

    public void call(int at) {
        this.calls_$eq(new CallStack(this.pc() + 1, this.instrs(), at, this.calls()));
        this.pc_$eq(at);
    }

    public void ret() {
        this.instrs_$eq(this.calls().instrs());
        this.pc_$eq(this.calls().ret());
        this.calls_$eq(this.calls().tail());
    }

    public void catchNoConsumed(int check, Function0<BoxedUnit> handler) {
        if (this.offset() != check) {
            this.handlers_$eq(this.handlers().tail());
            this.fail();
            return;
        }
        this.good_$eq(true);
        handler.apply$mcV$sp();
    }

    public void pushError(DefuncError err) {
        this.errs_$eq(new ErrorStack(this.useHints(err), this.errs()));
    }

    public DefuncError useHints(DefuncError err) {
        if (this.hintsValidOffset() == err.presentationOffset()) {
            return err.withHints(this.hints());
        }
        this.hintsValidOffset_$eq(err.presentationOffset());
        this.hints_$eq(EmptyHints$.MODULE$);
        return err;
    }

    public void failWithMessage(CaretWidth caretWidth, Seq<String> msgs) {
        this.fail(new ClassicFancyError(this.offset(), this.line(), this.col(), caretWidth, msgs));
    }

    public void unexpectedFail(Iterable<ExpectItem> expected, UnexpectDesc unexpected) {
        this.fail(new UnexpectedError(this.offset(), this.line(), this.col(), expected, unexpected));
    }

    public void expectedFail(Iterable<ExpectItem> expected, int unexpectedWidth) {
        this.fail(new ExpectedError(this.offset(), this.line(), this.col(), expected, unexpectedWidth));
    }

    public void fail(DefuncError error) {
        this.good_$eq(false);
        this.pushError(error);
        this.fail();
    }

    /*
     * WARNING - void declaration
     */
    public void fail() {
        void isEmpty$extension_inst;
        Stack<HandlerStack> stack = HandlerStack$.MODULE$.inst();
        HandlerStack isEmpty$extension_$this = this.handlers();
        Object var3_2 = null;
        stack = null;
        if (isEmpty$extension_inst.isEmpty(isEmpty$extension_$this)) {
            this.running_$eq(false);
            return;
        }
        HandlerStack handler = this.handlers();
        this.instrs_$eq(handler.instrs());
        this.calls_$eq(handler.calls());
        this.pc_$eq(handler.pc());
        int diffstack = this.stack().usize() - handler.stacksz();
        if (diffstack > 0) {
            this.stack().drop(diffstack);
            return;
        }
    }

    public void pushAndContinue(Object x) {
        this.stack().push(x);
        this.inc();
    }

    public void unsafePushAndContinue(Object x) {
        this.stack().upush(x);
        this.inc();
    }

    public void exchangeAndContinue(Object x) {
        this.stack().exchange(x);
        this.inc();
    }

    public void inc() {
        this.pc_$eq(this.pc() + 1);
    }

    public char peekChar() {
        return this.input().charAt(this.offset());
    }

    public char peekChar(int lookAhead) {
        return this.input().charAt(this.offset() + lookAhead);
    }

    public boolean moreInput() {
        return this.offset() < this.inputsz();
    }

    public boolean moreInput(int n) {
        return this.offset() + (n - 1) < this.inputsz();
    }

    public void updatePos(char c) {
        switch (c) {
            case '\n': {
                this.line_$eq(this.line() + 1);
                this.col_$eq(1);
                return;
            }
            case '\t': {
                this.col_$eq(this.col() + 3 & 0xFFFFFFFC | 1);
                return;
            }
        }
        this.col_$eq(this.col() + 1);
    }

    public char consumeChar() {
        char c = this.peekChar();
        this.updatePos(c);
        this.offset_$eq(this.offset() + 1);
        return c;
    }

    public void fastConsumeSupplementaryChar() {
        this.offset_$eq(this.offset() + 2);
        this.col_$eq(this.col() + 1);
    }

    public void fastUncheckedConsumeChars(int n) {
        this.offset_$eq(this.offset() + n);
        this.col_$eq(this.col() + n);
    }

    public void pushHandler(int label) {
        this.handlers_$eq(new HandlerStack(this.calls(), this.instrs(), label, this.stack().usize(), this.offset(), this.hints(), this.hintsValidOffset(), this.handlers()));
    }

    public void saveState() {
        this.states_$eq(new StateStack(this.offset(), this.line(), this.col(), this.states()));
    }

    public void restoreState() {
        StateStack state2 = this.states();
        this.states_$eq(this.states().tail());
        this.offset_$eq(state2.offset());
        this.line_$eq(state2.line());
        this.col_$eq(state2.col());
    }

    public void writeReg(int reg, Object x) {
        this.regs()[reg] = x;
    }

    public Status status() {
        if (this.running()) {
            if (this.good()) {
                return Good$.MODULE$;
            }
            return Recover$.MODULE$;
        }
        if (this.good()) {
            return Finished$.MODULE$;
        }
        return Failed$.MODULE$;
    }

    private LineBuilder lineBuilder() {
        return this.lineBuilder;
    }

    public ErrorItemBuilder errorItemBuilder() {
        return this.errorItemBuilder;
    }

    public Context(Instr[] instrs, String input, int numRegs, Option<String> sourceFile) {
        this.instrs = instrs;
        this.input = input;
        this.sourceFile = sourceFile;
        this.stack = new ArrayStack(8);
        this.offset = 0;
        this.inputsz = input.length();
        this.calls = null;
        this.states = null;
        this.good = true;
        this.running = true;
        this.handlers = null;
        this.pc = 0;
        this.line = 1;
        this.col = 1;
        this.regs = new Object[numRegs];
        this.debuglvl = 0;
        this.hints = EmptyHints$.MODULE$;
        this.hintsValidOffset = 0;
        this.errs = null;
        this.lineBuilder = new LineBuilder(this){
            private final /* synthetic */ Context $outer;

            public Option<Object> nearestNewlineBefore(int off) {
                if (off < 0) {
                    return None$.MODULE$;
                }
                int idx = this.$outer.input().lastIndexOf(10, off - 1);
                return new Some((Object)(idx == -1 ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)(idx + 1))));
            }

            public Option<Object> nearestNewlineAfter(int off) {
                if (off > this.$outer.inputsz()) {
                    return None$.MODULE$;
                }
                int idx = this.$outer.input().indexOf(10, off);
                return new Some((Object)(idx == -1 ? BoxesRunTime.boxToInteger((int)this.$outer.inputsz()) : BoxesRunTime.boxToInteger((int)idx)));
            }

            public String segmentBetween(int start, int end) {
                return this.$outer.input().substring(start, end);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.errorItemBuilder = new ErrorItemBuilder(this){
            private final /* synthetic */ Context $outer;

            public boolean inRange(int offset) {
                return offset < this.$outer.inputsz();
            }

            public int codePointAt(int offset) {
                return this.$outer.input().codePointAt(offset);
            }

            public IndexedSeq<Object> iterableFrom(int offset) {
                return Predef$.MODULE$.wrapString(this.$outer.input().substring(offset));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

