/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.http.eventbusbridge.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.net.URL;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.ReplyException;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.http.eventbusbridge.model.EventBusBridgeResponse;
import org.vertx.java.http.eventbusbridge.model.EventBusMessageType;
import org.vertx.java.http.eventbusbridge.util.EventBusMessageTypeConverter;
import org.vertx.java.http.eventbusbridge.util.SerializationHelper;

public final class HttpResponseHandler
implements Handler<AsyncResult<Message<Object>>> {
    private static final Logger LOGGER = Logger.getLogger(HttpResponseHandler.class);
    private URL url;
    private String mediaType;
    private HttpClient httpClient;
    private HttpReplyResponseHandler responseHandler;
    private String address;

    public HttpResponseHandler(URL url, String mediaType, HttpClient httpClient, String address) {
        this.url = url;
        this.mediaType = mediaType;
        this.httpClient = httpClient;
        this.responseHandler = new HttpReplyResponseHandler();
        this.address = address;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getAddress() {
        return this.address;
    }

    public void handle(AsyncResult<Message<Object>> event) {
        EventBusBridgeResponse response = new EventBusBridgeResponse();
        response.setSuccessful(event.succeeded());
        response.setAddress(this.address);
        if (event.succeeded()) {
            Message result = (Message)event.result();
            Object responseMessage = result.body();
            response.setResponseMessage(EventBusMessageTypeConverter.convertOutgoingMessage(result.body()));
            response.setEventBusMessageType(EventBusMessageType.lookupByClass(responseMessage.getClass()));
        } else {
            Throwable cause = event.cause();
            if (cause != null) {
                if (cause instanceof ReplyException) {
                    ReplyException replyException = (ReplyException)cause;
                    response.setCause(replyException.failureType().name());
                } else {
                    response.setCause(cause.getMessage());
                }
            }
        }
        this.postResponse(response);
    }

    private void postResponse(EventBusBridgeResponse response) {
        this.httpClient.setHost(this.url.getHost());
        this.httpClient.setPort(this.url.getPort());
        HttpClientRequest request = this.httpClient.post(this.url.toExternalForm(), (Handler)this.responseHandler);
        request.setChunked(true);
        request.headers().add("Content-Type", this.mediaType);
        try {
            String responseBody = SerializationHelper.serialize(response, this.mediaType);
            request.write(responseBody);
            request.end();
        }
        catch (JsonProcessingException | JAXBException e) {
            LOGGER.error((Object)("Unable to serialize response\n" + response + "\n to: " + this.mediaType));
        }
    }

    private class HttpReplyResponseHandler
    implements Handler<HttpClientResponse> {
        private Logger logger = Logger.getLogger(HttpReplyResponseHandler.class);

        private HttpReplyResponseHandler() {
        }

        public void handle(HttpClientResponse response) {
            if (response.statusCode() == Response.Status.ACCEPTED.getStatusCode()) {
                this.logger.debug((Object)"Reply sent successfully");
            } else {
                this.logger.warn((Object)("Error sending the reply to client. status code:" + response.statusCode() + "  message: " + response.statusMessage()));
            }
        }
    }
}

