/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.http.eventbusbridge.security;

import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public final class EventBusBridgeRequestValidator {
    private static final String WHITELIST_CONFIG = "whitelist";
    private static final String INBOUND_CONFIG = "inbound";
    private static final String ADDRESS = "address";
    private static final String ADDRESS_REGEX = "address_re";

    private EventBusBridgeRequestValidator() {
    }

    public static boolean validateIncomingAddress(String address, JsonObject config) {
        JsonObject whitelist = config.getObject(WHITELIST_CONFIG);
        JsonObject inboundWhitelist = whitelist.getObject(INBOUND_CONFIG);
        if (EventBusBridgeRequestValidator.checkAddresses(address, inboundWhitelist)) {
            return true;
        }
        return EventBusBridgeRequestValidator.checkAddressRegexes(address, inboundWhitelist);
    }

    public static boolean validateResponseMediaType(String responseMediaType) {
        return responseMediaType == null || "application/json".equals(responseMediaType) || "application/xml".equals(responseMediaType);
    }

    private static boolean checkAddresses(String address, JsonObject inboundWhitelist) {
        JsonArray addresses = inboundWhitelist.getArray(ADDRESS);
        if (addresses != null) {
            for (Object object : addresses) {
                if (!address.equals(object)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkAddressRegexes(String address, JsonObject inboundWhitelist) {
        JsonArray addressRegexes = inboundWhitelist.getArray(ADDRESS_REGEX);
        if (addressRegexes != null) {
            for (Object object : addressRegexes) {
                String regex = (String)object;
                if (!address.matches(regex)) continue;
                return true;
            }
        }
        return false;
    }
}

