/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.http.eventbusbridge.service;

import java.net.MalformedURLException;
import java.net.URL;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.JsonParseException;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.http.eventbusbridge.model.EventBusBridgeRequest;
import org.vertx.java.http.eventbusbridge.model.EventBusInstruction;
import org.vertx.java.http.eventbusbridge.model.HttpResponseHandler;
import org.vertx.java.http.eventbusbridge.model.NoOpResponseHandler;
import org.vertx.java.http.eventbusbridge.security.EventBusBridgeRequestValidator;
import org.vertx.java.http.eventbusbridge.util.EventBusMessageTypeConverter;
import org.vertx.java.platform.Container;
import org.xml.sax.SAXParseException;

@Provider
@Path(value="eventbus")
public final class HttpEventBusBridgeService {
    private static final long DEFAULT_TIMEOUT = 0L;
    private static final String DEFAULT_RESPONSE_MEDIA_TYPE = "application/json";
    private static final NoOpResponseHandler NOOP_RESPONSE_HANDLER = new NoOpResponseHandler();

    @POST
    @Path(value="/{instruction}")
    @Consumes(value={"application/xml", "application/json"})
    public Response forward(EventBusBridgeRequest request, @PathParam(value="instruction") EventBusInstruction instruction, @Context Vertx vertx, @Context Container container) throws MalformedURLException {
        String address = request.getAddress();
        JsonObject config = container.config();
        this.validateRequest(request, config);
        Object messageObject = EventBusMessageTypeConverter.convertIncomingMessage(request.getMessage(), request.getEventBusMessageType());
        switch (instruction) {
            case send: {
                Long timeout = config.getLong("timeout", 0L);
                String mediaType = request.getResponseMediaType() != null ? request.getResponseMediaType() : DEFAULT_RESPONSE_MEDIA_TYPE;
                URL responseUrl = request.getResponseUrl() != null ? new URL(request.getResponseUrl()) : null;
                this.send(address, messageObject, responseUrl, mediaType, vertx, timeout);
                break;
            }
            case publish: {
                this.publish(address, messageObject, vertx);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal event bus instruction provided: " + (Object)((Object)instruction));
            }
        }
        return Response.accepted().build();
    }

    private void send(String address, Object messageObject, URL responseUrl, String mediaType, Vertx vertx, Long timeout) throws MalformedURLException {
        Handler<AsyncResult<Message<Object>>> responseHandler = this.createHandler(responseUrl, mediaType, vertx.createHttpClient(), address);
        vertx.eventBus().sendWithTimeout(address, messageObject, timeout.longValue(), responseHandler);
    }

    private void publish(String address, Object messageObject, Vertx vertx) {
        vertx.eventBus().publish(address, messageObject);
    }

    private void validateRequest(EventBusBridgeRequest request, JsonObject config) {
        String address = request.getAddress();
        String responseMediaType = request.getResponseMediaType();
        if (!EventBusBridgeRequestValidator.validateIncomingAddress(address, config)) {
            throw new WebApplicationException("Not authorized to forward messages to address: " + address, Response.Status.FORBIDDEN);
        }
        if (!EventBusBridgeRequestValidator.validateResponseMediaType(responseMediaType)) {
            throw new WebApplicationException("Unsupported response media type requested: " + responseMediaType, Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }
    }

    private Handler<AsyncResult<Message<Object>>> createHandler(URL url, String mediaType, HttpClient httpClient, String address) throws MalformedURLException {
        return url == null ? NOOP_RESPONSE_HANDLER : new HttpResponseHandler(url, mediaType, httpClient, address);
    }

    @Provider
    public static final class RuntimeExceptionMapper
    implements ExceptionMapper<RuntimeException> {
        public Response toResponse(RuntimeException exception) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Provider
    public static final class WebApplicationExceptionMapper
    implements ExceptionMapper<WebApplicationException> {
        public Response toResponse(WebApplicationException exception) {
            return exception.getResponse();
        }
    }

    @Provider
    public static final class MalformedURLExceptionMapper
    implements ExceptionMapper<MalformedURLException> {
        public Response toResponse(MalformedURLException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @Provider
    public static final class JsonParseExceptionMapper
    implements ExceptionMapper<JsonParseException> {
        public Response toResponse(JsonParseException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @Provider
    public static final class SAXParseExceptionMapper
    implements ExceptionMapper<SAXParseException> {
        public Response toResponse(SAXParseException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }
}

