/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.http.eventbusbridge.util;

import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.http.eventbusbridge.model.EventBusMessageType;

public final class EventBusMessageTypeConverter {
    private EventBusMessageTypeConverter() {
    }

    public static Object convertIncomingMessage(byte[] message, EventBusMessageType messageType) {
        String messageString = new String(message);
        switch (messageType) {
            case String: {
                return messageString;
            }
            case Character: {
                return new Character(messageString.charAt(0));
            }
            case Boolean: {
                return new Boolean(messageString);
            }
            case Byte: {
                return new Byte(messageString);
            }
            case Short: {
                return new Short(messageString);
            }
            case Integer: {
                return new Integer(messageString);
            }
            case Long: {
                return new Long(messageString);
            }
            case Float: {
                return new Float(messageString);
            }
            case Double: {
                return new Double(messageString);
            }
            case JsonArray: {
                return new JsonArray(messageString);
            }
            case JsonObject: {
                return new JsonObject(messageString);
            }
            case ByteArray: {
                return message;
            }
        }
        throw new IllegalArgumentException("EventBusMessageType '" + (Object)((Object)messageType) + "' not recognised. " + "This exception should never be thrown!");
    }

    public static byte[] convertOutgoingMessage(Object message) {
        String messageString = message.toString();
        if (message instanceof String) {
            return messageString.getBytes();
        }
        if (message instanceof Character) {
            return messageString.substring(0, 1).getBytes();
        }
        if (message instanceof Boolean) {
            return messageString.getBytes();
        }
        if (message instanceof Byte) {
            return messageString.getBytes();
        }
        if (message instanceof Short) {
            return messageString.getBytes();
        }
        if (message instanceof Integer) {
            return messageString.getBytes();
        }
        if (message instanceof Long) {
            return messageString.getBytes();
        }
        if (message instanceof Float) {
            return messageString.getBytes();
        }
        if (message instanceof Double) {
            return messageString.getBytes();
        }
        if (message instanceof JsonArray) {
            return messageString.getBytes();
        }
        if (message instanceof JsonObject) {
            return messageString.getBytes();
        }
        if (message instanceof byte[]) {
            return (byte[])message;
        }
        throw new IllegalArgumentException("Class type '" + message.getClass() + "' not supported. This exception should never be thrown!");
    }
}

