/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.http.eventbusbridge.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.vertx.java.http.eventbusbridge.model.EventBusBridgeResponse;

public final class SerializationHelper {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final JAXBContext JAXB_CONTEXT;

    private SerializationHelper() {
    }

    public static String serialize(Object object, String mediaType) throws JsonProcessingException, JAXBException {
        if ("application/json".equals(mediaType)) {
            return SerializationHelper.toJson(object);
        }
        if ("application/xml".equals(mediaType)) {
            return SerializationHelper.toXml(object);
        }
        throw new IllegalArgumentException("Unsupported media type serialization requested for response: " + mediaType);
    }

    private static String toJson(Object jsonObject) throws JsonProcessingException {
        return JSON_MAPPER.writeValueAsString(jsonObject);
    }

    private static String toXml(Object xmlObject) throws JAXBException {
        StringWriter writer = new StringWriter();
        Marshaller jaxbMarshaller = JAXB_CONTEXT.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        jaxbMarshaller.marshal(xmlObject, (Writer)writer);
        return writer.toString();
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{EventBusBridgeResponse.class});
            JSON_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            JSON_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Class initialization failed due to JAXBException", e);
        }
    }
}

