/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.el;

import com.google.common.base.Objects;
import com.google.common.base.Stopwatch;
import de.japkit.el.ELImports;
import de.japkit.el.ELProvider;
import de.japkit.el.ELProviderException;
import de.japkit.el.ValueStack;
import de.japkit.model.AnnotationAndParent;
import de.japkit.rules.LibraryRule;
import de.japkit.rules.Rule;
import de.japkit.services.ElementsExtensions;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.GenerateClassContext;
import de.japkit.services.MessageCollector;
import de.japkit.services.ReportedException;
import de.japkit.services.RuleException;
import de.japkit.services.TypeElementNotFoundException;
import de.japkit.services.TypesExtensions;
import de.japkit.util.MoreCollectionExtensions;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ELSupport {
    @Extension
    private final transient ElementsExtensions elements = ExtensionRegistry.get(ElementsExtensions.class);
    @Extension
    private TypesExtensions types = ExtensionRegistry.get(TypesExtensions.class);
    @Extension
    private final transient MessageCollector _messageCollector = ExtensionRegistry.get(MessageCollector.class);
    private final Map<String, ELProvider> elProviders = CollectionLiterals.newHashMap();
    private final Map<String, ELProvider> templateProviders = CollectionLiterals.newHashMap();
    private final ELProvider defaultElProvider;
    private final String defaultLanguage = "JavaEL";
    public static ELImports EMPTY_EL_IMPORTS = new ELImports(CollectionLiterals.emptyList());

    public ValueStack getValueStack() {
        Functions.Function0 _function = () -> {
            Pair _mappedTo = Pair.of((Object)"elements", (Object)this.elements);
            Pair _mappedTo_1 = Pair.of((Object)"types", (Object)this.types);
            HashMap _newHashMap = CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo, _mappedTo_1});
            return new ValueStack(_newHashMap, null);
        };
        return ExtensionRegistry.get(ValueStack.class, _function);
    }

    public ELSupport() {
        Stopwatch sw = Stopwatch.createStarted();
        try {
            Functions.Function1 _function = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Searching EL-Providers using classloader ");
                ClassLoader _classLoader = ELProvider.class.getClassLoader();
                _builder.append((Object)_classLoader);
                _builder.append(". Context CL: ");
                ClassLoader _contextClassLoader = Thread.currentThread().getContextClassLoader();
                _builder.append((Object)_contextClassLoader);
                return _builder.toString();
            };
            this._messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function);
            Consumer<ELProvider> _function_1 = it -> {
                ELProvider provider = it;
                Consumer<String> _function_2 = it_1 -> this.elProviders.put((String)it_1, provider);
                ((List)Conversions.doWrapArray((Object)provider.getSupportedLanguages())).forEach(_function_2);
                Consumer<String> _function_3 = it_1 -> this.templateProviders.put((String)it_1, provider);
                ((List)Conversions.doWrapArray((Object)provider.getSupportedTemplateLanguages())).forEach(_function_3);
            };
            ServiceLoader.load(ELProvider.class, ELProvider.class.getClassLoader()).forEach(_function_1);
        }
        catch (Throwable _t) {
            if (_t instanceof Throwable) {
                Throwable t = _t;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Error when loading EL-Providers: ");
                String _message = t.getMessage();
                _builder.append(_message);
                throw new RuntimeException(_builder.toString(), t);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        Functions.Function1 _function_2 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Init EL-Providers: ");
            long _elapsed = sw.elapsed(TimeUnit.MILLISECONDS);
            _builder_1.append((Object)_elapsed);
            return _builder_1.toString();
        };
        this._messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_2);
        sw.stop();
        this.defaultElProvider = this.elProviders.get(this.defaultLanguage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T scope(Object e, Functions.Function1<? super ValueStack, ? extends T> closure) {
        Object _xblockexpression = null;
        ValueStack vs = this.getValueStack();
        Object _xtrycatchfinallyexpression = null;
        try {
            Object _xblockexpression_1 = null;
            vs.push();
            vs.put("src", e);
            _xtrycatchfinallyexpression = _xblockexpression_1 = closure.apply((Object)vs);
        }
        finally {
            vs.pop();
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return (T)_xblockexpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T scope(Functions.Function1<? super ValueStack, ? extends T> closure) {
        Object _xblockexpression = null;
        ValueStack vs = this.getValueStack();
        Object _xtrycatchfinallyexpression = null;
        try {
            Object _xblockexpression_1 = null;
            vs.push();
            _xtrycatchfinallyexpression = _xblockexpression_1 = closure.apply((Object)vs);
        }
        finally {
            vs.pop();
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return (T)_xblockexpression;
    }

    public Element getCurrentSrcElement() {
        return this.getCurrentSrc(Element.class);
    }

    public <T> T getCurrentSrc(Class<T> clazz) {
        T _xblockexpression = null;
        Object currSrc = this.getCurrentSrc();
        if (currSrc != null && !clazz.isInstance(currSrc)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Current src ");
            _builder.append(currSrc);
            _builder.append(" is of type ");
            Class<?> _class = null;
            if (currSrc != null) {
                _class = currSrc.getClass();
            }
            _builder.append(_class);
            _builder.append(", but type ");
            _builder.append(clazz);
            _builder.append(" is required here.");
            throw new RuleException(_builder.toString());
        }
        _xblockexpression = clazz.cast(currSrc);
        return _xblockexpression;
    }

    public Object getCurrentSrc() {
        return this.getValueStack().getRequired("src");
    }

    public Object getCurrentSrcOptional() {
        return this.getValueStack().get("src");
    }

    public Element getNearestSrcElement() {
        return this.getNearestSrcElement(this.getValueStack());
    }

    public Element getNearestSrcElement(ValueStack vs) {
        Element _xblockexpression = null;
        Object src = vs.get("src");
        Element _xifexpression = null;
        if (src instanceof Element) {
            _xifexpression = (Element)src;
        } else {
            ValueStack _parent = vs.getParent();
            Element _nearestSrcElement = null;
            if (_parent != null) {
                _nearestSrcElement = this.getNearestSrcElement(_parent);
            }
            _xifexpression = _nearestSrcElement;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public <T> T eval(String expr, String lang, Class<T> expectedType, CharSequence errorMessage, T errorResult) {
        T _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = this.eval(expr, lang, expectedType, true);
        }
        catch (Throwable _t) {
            if (_t instanceof TypeElementNotFoundException) {
                TypeElementNotFoundException tenfe = (TypeElementNotFoundException)_t;
                throw tenfe;
            }
            if (_t instanceof ReportedException) {
                ReportedException e = (ReportedException)_t;
                _xtrycatchfinallyexpression = errorResult;
            }
            if (_t instanceof Exception) {
                Exception e_1 = (Exception)_t;
                this._messageCollector.reportRuleError(e_1);
                if (errorResult != null) {
                    return errorResult;
                }
                throw new ReportedException(e_1);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    private <T> T evalFromValueStack(String expr, String lang, Class<T> expectedType) {
        Object _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)lang);
        if (_isNullOrEmpty) {
            Object _xblockexpression = null;
            Object v = this.getValueStack().get(expr);
            Object _xifexpression_1 = null;
            _xifexpression_1 = v instanceof Functions.Function0 ? ((Functions.Function0)v).apply() : v;
            Object result = _xifexpression_1;
            if (result != null && !expectedType.isInstance(result)) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Value or function ");
                _builder.append(expr);
                _builder.append(" on values stack is not of expected type ");
                _builder.append(expectedType);
                _builder.append(", but ");
                Class<?> _class = result.getClass();
                _builder.append(_class);
                throw new ELProviderException(_builder.toString());
            }
            _xifexpression = _xblockexpression = result;
        } else {
            _xifexpression = null;
        }
        return (T)_xifexpression;
    }

    public <T> T eval(String expr, String lang, Class<T> expectedType) {
        return this.eval(expr, lang, expectedType, false);
    }

    public <T> T eval(String expr, String lang, Class<T> expectedType, boolean evalFromValueStackFirst) {
        return this.eval(expr, lang, expectedType, evalFromValueStackFirst, this.findElImports());
    }

    private ELImports findElImports() {
        GenerateClassContext GenerateClassContext2 = ExtensionRegistry.get(GenerateClassContext.class);
        Rule rule = GenerateClassContext2.getCurrentRule();
        AnnotationMirror metaAnnotation = rule.getMetaAnnotation();
        Element _xifexpression = null;
        if (metaAnnotation instanceof AnnotationAndParent) {
            Element _rootAnnotatedElement = null;
            if ((AnnotationAndParent)metaAnnotation != null) {
                _rootAnnotatedElement = ((AnnotationAndParent)metaAnnotation).getRootAnnotatedElement();
            }
            _xifexpression = _rootAnnotatedElement;
        } else {
            Element _metaElement = null;
            if (rule != null) {
                _metaElement = rule.getMetaElement();
            }
            _xifexpression = _metaElement;
        }
        Element metaElement = _xifexpression;
        ELImports _xifexpression_1 = null;
        _xifexpression_1 = metaElement != null ? LibraryRule.findELImports(metaElement) : EMPTY_EL_IMPORTS;
        return _xifexpression_1;
    }

    public <T> T eval(String expr, String lang, Class<T> expectedType, boolean evalFromValueStackFirst, ELImports elImports) {
        T resultFromValueStack;
        if (evalFromValueStackFirst && (resultFromValueStack = this.evalFromValueStack(expr, lang, expectedType)) != null) {
            return resultFromValueStack;
        }
        if (StringExtensions.isNullOrEmpty((String)expr) && Objects.equal(expectedType, String.class)) {
            return (T)"";
        }
        Object _eval = this.getElProvider(lang).eval(this.getValueStack(), expr, expectedType, lang, elImports.getImportedClasses());
        return (T)_eval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withValueStack(ValueStack valueStack, Functions.Function0<? extends T> closure) {
        boolean _notEquals;
        Object _xblockexpression = null;
        ValueStack oldValueStackTL = null;
        ValueStack _valueStack = this.getValueStack();
        boolean bl = _notEquals = !Objects.equal((Object)valueStack, (Object)_valueStack);
        if (_notEquals) {
            oldValueStackTL = this.getValueStack();
            ExtensionRegistry.register(ValueStack.class, valueStack);
        }
        Object _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = closure.apply();
        }
        finally {
            if (oldValueStackTL != null) {
                ExtensionRegistry.register(ValueStack.class, oldValueStackTL);
            }
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return (T)_xblockexpression;
    }

    public ELProvider getElProvider(String lang) {
        ELProvider _xblockexpression = null;
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)lang);
        _xifexpression = _isNullOrEmpty ? this.defaultLanguage : lang;
        ELProvider p = this.elProviders.get(_xifexpression);
        if (p == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No ELProvider found for language ");
            _builder.append(lang);
            throw new ELProviderException(_builder.toString());
        }
        _xblockexpression = p;
        return _xblockexpression;
    }

    public void write(Writer writer, URL templateUrl, String templateLanguage, Long templateLastModified) {
        this.getTemplateProvider(templateLanguage).write(writer, templateUrl, this.getValueStack(), templateLanguage, templateLastModified);
    }

    public ELProvider getTemplateProvider(String lang) {
        ELProvider _xblockexpression = null;
        ELProvider p = this.templateProviders.get(lang);
        if (p == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No ELProvider found for template language ");
            _builder.append(lang);
            throw new ELProviderException(_builder.toString());
        }
        _xblockexpression = p;
        return _xblockexpression;
    }

    public Map<String, Object> getVariablesForShadowAnnotation(ValueStack vs) {
        Functions.Function1 _function = it -> CollectionLiterals.newHashMap();
        return (Map)MoreCollectionExtensions.getOrCreate(vs, "variablesForShadowAnnotation", _function);
    }
}

