/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.model;

import com.google.common.base.Objects;
import de.japkit.activeannotations.FieldsFromInterface;
import de.japkit.activeannotations.Required;
import de.japkit.model.GenAnnotatedConstruct;
import de.japkit.model.GenName;
import de.japkit.model.GenParameterizable;
import de.japkit.services.ElementsExtensions;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeMirror;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;

@FieldsFromInterface
public abstract class GenElement
extends GenAnnotatedConstruct
implements Element {
    @Required
    private Name simpleName;
    private List<AnnotationMirror> annotationMirrors = CollectionLiterals.newArrayList();
    private List<Element> enclosedElements = CollectionLiterals.newArrayList();
    private Element enclosingElement;
    private Set<Modifier> modifiers = CollectionLiterals.newHashSet();
    private CharSequence comment;

    @Override
    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    @Override
    public TypeMirror asType() {
        throw new UnsupportedOperationException("asType() is not supported for " + this);
    }

    @Override
    public abstract ElementKind getKind();

    public void addEnclosedElement(Element enclosedEl) {
        boolean _tripleEquals;
        if (!(enclosedEl instanceof GenElement)) {
            throw new IllegalArgumentException("Only GenElements might be added to a GenElement, but not " + enclosedEl);
        }
        GenElement enclosed = (GenElement)enclosedEl;
        if (enclosed.getEnclosingElement() != null && !Objects.equal((Object)enclosed.getEnclosingElement(), (Object)this)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Element ");
            _builder.append((Object)enclosed);
            _builder.append(" has already a different enclosing element:");
            Element _enclosingElement = enclosed.getEnclosingElement();
            _builder.append((Object)_enclosingElement);
            throw new IllegalStateException(_builder.toString());
        }
        Comparator<Element> _enclosedElementComparator = this.enclosedElementComparator();
        boolean bl = _tripleEquals = _enclosedElementComparator == null;
        if (_tripleEquals) {
            this.enclosedElements.add(enclosed);
        } else {
            int index = Collections.binarySearch(this.enclosedElements, enclosed, this.enclosedElementComparator());
            if (index < 0) {
                index = -(index + 1);
            }
            while (index < this.enclosedElements.size() && this.enclosedElementComparator().compare(enclosed, this.enclosedElements.get(index)) == 0) {
                ++index;
            }
            this.enclosedElements.add(index, enclosed);
        }
        enclosed.setEnclosingElement(this);
    }

    public Comparator<Element> enclosedElementComparator() {
        return null;
    }

    public void add(GenElement ... elements) {
        Consumer<GenElement> _function = e -> this.addEnclosedElement((Element)e);
        ((List)Conversions.doWrapArray((Object)elements)).forEach(_function);
    }

    public GenParameterizable enclosingParameterizable() {
        GenParameterizable _xifexpression = null;
        if (this.enclosingElement == null) {
            _xifexpression = null;
        } else {
            GenParameterizable _xifexpression_1 = null;
            _xifexpression_1 = this.enclosingElement instanceof GenParameterizable ? (GenParameterizable)this.enclosingElement : ((GenElement)this.enclosingElement).enclosingParameterizable();
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public boolean setVisibility(Modifier visibility) {
        boolean _xblockexpression = false;
        if (visibility != null && !ElementsExtensions.VISIBILITY_MODIFIERS.contains((Object)visibility)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)visibility);
            _builder.append(" is not a valid visibility modifier");
            throw new IllegalArgumentException(_builder.toString());
        }
        this.modifiers.removeAll(ElementsExtensions.VISIBILITY_MODIFIERS);
        boolean _xifexpression = false;
        if (visibility != null) {
            _xifexpression = this.modifiers.add(visibility);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void resolveContainedTypeVariables(GenParameterizable parameterizable) {
    }

    public CharSequence getComment() {
        return this.comment;
    }

    public CharSequence setComment(CharSequence comment) {
        this.comment = comment;
        return this.comment;
    }

    public Name setSimpleName(CharSequence name) {
        String _string = name.toString();
        GenName _genName = new GenName(_string);
        this.simpleName = _genName;
        return this.simpleName;
    }

    public GenElement() {
    }

    public GenElement(Name simpleName) {
        this.simpleName = simpleName;
    }

    public GenElement(String simpleName) {
        this(new GenName(simpleName));
    }

    @Override
    public Set<Modifier> getModifiers() {
        return Collections.unmodifiableSet(this.modifiers);
    }

    public void addModifier(Modifier aModifier_) {
        this.modifiers.add(aModifier_);
    }

    public void removeModifier(Modifier aModifier_) {
        this.modifiers.remove((Object)aModifier_);
    }

    public void setModifiers(Set<Modifier> modifiers) {
        this.modifiers.clear();
        for (Modifier aModifier_ : modifiers) {
            this.addModifier(aModifier_);
        }
    }

    @Override
    public Name getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(Name simpleName) {
        this.simpleName = simpleName;
    }

    @Override
    public Element getEnclosingElement() {
        return this.enclosingElement;
    }

    public void setEnclosingElement(Element enclosingElement) {
        this.enclosingElement = enclosingElement;
    }

    @Override
    public List<? extends Element> getEnclosedElements() {
        return Collections.unmodifiableList(this.enclosedElements);
    }

    public void removeEnclosedElement(Element aEnclosedElement_) {
        this.enclosedElements.remove(aEnclosedElement_);
    }

    public void setEnclosedElements(List<? extends Element> enclosedElements) {
        this.enclosedElements.clear();
        for (Element element : enclosedElements) {
            this.addEnclosedElement(element);
        }
    }

    @Override
    public List<? extends AnnotationMirror> getAnnotationMirrors() {
        return Collections.unmodifiableList(this.annotationMirrors);
    }

    public void addAnnotationMirror(AnnotationMirror aAnnotationMirror_) {
        this.annotationMirrors.add(aAnnotationMirror_);
    }

    public void removeAnnotationMirror(AnnotationMirror aAnnotationMirror_) {
        this.annotationMirrors.remove(aAnnotationMirror_);
    }

    public void setAnnotationMirrors(List<? extends AnnotationMirror> annotationMirrors) {
        this.annotationMirrors.clear();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            this.addAnnotationMirror(annotationMirror);
        }
    }
}

