/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.model;

import com.google.common.base.Objects;
import de.japkit.activeannotations.FieldsFromInterface;
import de.japkit.model.CodeBody;
import de.japkit.model.GenJava8ExecutableElement;
import de.japkit.model.GenParameter;
import de.japkit.model.GenParameterizable;
import de.japkit.model.GenVariableElement;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.TypesExtensions;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@FieldsFromInterface
public abstract class GenExecutableElement
extends GenJava8ExecutableElement
implements ExecutableElement {
    private CodeBody body;
    private AnnotationValue defaultValue;
    private List<VariableElement> parameters = CollectionLiterals.newArrayList();
    private TypeMirror returnType = new Functions.Function0<TypeMirror>(){

        public TypeMirror apply() {
            return ExtensionRegistry.get(TypesExtensions.class).getNoType(TypeKind.VOID);
        }
    }.apply();
    private List<TypeMirror> thrownTypes = CollectionLiterals.newArrayList();
    private boolean varArgs;

    public CodeBody getBody() {
        return this.body;
    }

    public void setBody(CodeBody body) {
        this.body = body;
        if (body != null) {
            this.removeModifier(Modifier.ABSTRACT);
        }
    }

    @Override
    public void addModifier(Modifier m) {
        if (this.body != null && Objects.equal((Object)((Object)m), (Object)((Object)Modifier.ABSTRACT))) {
            return;
        }
        super.addModifier(m);
    }

    public void addParameter(VariableElement ve) {
        GenParameter p = (GenParameter)ve;
        this.parameters.add(p);
        p.setEnclosingElement(this);
    }

    @Override
    public TypeMirror resolveTypeVariable(TypeVariable tv) {
        TypeVariable _xifexpression = null;
        Functions.Function1 _function = it -> it.getSimpleName().contentEquals(tv.asElement().getSimpleName());
        boolean _exists = IterableExtensions.exists(this.getTypeParameters(), (Functions.Function1)_function);
        _xifexpression = _exists ? tv : null;
        return _xifexpression;
    }

    @Override
    public void resolveContainedTypeVariables(GenParameterizable parameterizable) {
        this.returnType = parameterizable.resolveTypeVariables(this.returnType);
        Consumer<VariableElement> _function = p -> ((GenVariableElement)p).resolveContainedTypeVariables(parameterizable);
        this.parameters.forEach(_function);
    }

    public GenExecutableElement(String simpleName) {
        super(simpleName);
    }

    public GenExecutableElement(Name simpleName) {
        super(simpleName);
    }

    public void setReturnType(TypeMirror returnType) {
        TypeMirror _xifexpression = null;
        _xifexpression = returnType == null || Objects.equal((Object)((Object)returnType.getKind()), (Object)((Object)TypeKind.NONE)) || Objects.equal((Object)((Object)returnType.getKind()), (Object)((Object)TypeKind.NULL)) ? ExtensionRegistry.get(TypesExtensions.class).getNoType(TypeKind.VOID) : returnType;
        this.returnType = _xifexpression;
    }

    public String toString() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)this.returnType);
        _builder.append(" ");
        Name _simpleName = this.getSimpleName();
        _builder.append((Object)_simpleName);
        _builder.append("(");
        boolean _hasElements = false;
        for (VariableElement p : this.parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            _builder.append("p");
        }
        _builder.append(")");
        return _builder.toString();
    }

    @Override
    public TypeMirror getReturnType() {
        return this.returnType;
    }

    @Override
    public List<? extends VariableElement> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public void removeParameter(VariableElement aParameter_) {
        this.parameters.remove(aParameter_);
    }

    public void setParameters(List<? extends VariableElement> parameters) {
        this.parameters.clear();
        for (VariableElement variableElement : parameters) {
            this.addParameter(variableElement);
        }
    }

    @Override
    public boolean isVarArgs() {
        return this.varArgs;
    }

    public void setVarArgs(boolean varArgs) {
        this.varArgs = varArgs;
    }

    @Override
    public List<? extends TypeMirror> getThrownTypes() {
        return Collections.unmodifiableList(this.thrownTypes);
    }

    public void addThrownType(TypeMirror aThrownType_) {
        this.thrownTypes.add(aThrownType_);
    }

    public void removeThrownType(TypeMirror aThrownType_) {
        this.thrownTypes.remove(aThrownType_);
    }

    public void setThrownTypes(List<? extends TypeMirror> thrownTypes) {
        this.thrownTypes.clear();
        for (TypeMirror typeMirror : thrownTypes) {
            this.addThrownType(typeMirror);
        }
    }

    @Override
    public AnnotationValue getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(AnnotationValue defaultValue) {
        this.defaultValue = defaultValue;
    }

    public GenExecutableElement() {
    }
}

