/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.model;

import com.google.common.base.Objects;
import de.japkit.annotations.Order;
import de.japkit.metaannotations.Clazz;
import de.japkit.metaannotations.classselectors.ClassSelector;
import de.japkit.model.CodeBody;
import de.japkit.model.GenAnnotationMirror;
import de.japkit.model.GenAnnotationValue;
import de.japkit.model.GenConstructor;
import de.japkit.model.GenElement;
import de.japkit.model.GenExecutableElement;
import de.japkit.model.GenField;
import de.japkit.model.GenMethod;
import de.japkit.model.GenParameter;
import de.japkit.model.GenTypeElement;
import de.japkit.rules.TypeResolver;
import de.japkit.services.ElementsExtensions;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.TypeElementNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class GenExtensions {
    @Extension
    private final transient ElementsExtensions _elementsExtensions = ExtensionRegistry.get(ElementsExtensions.class);
    @Extension
    private final transient TypeResolver _typeResolver = ExtensionRegistry.get(TypeResolver.class);
    private final Set<String> japkitAnnotationPackages = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{Clazz.class.getPackage().getName(), Order.class.getPackage().getName(), ClassSelector.class.getPackage().getName()}));
    public final Functions.Function1<AnnotationMirror, Boolean> isNoJapkitAnnotationFilter = am -> {
        boolean _isJapkitAnnotation = this.isJapkitAnnotation((AnnotationMirror)am);
        return !_isJapkitAnnotation;
    };

    public GenMethod createOverride(ExecutableElement m, CodeBody b) {
        GenMethod _copyFrom = this.copyFrom(m);
        Procedures.Procedure1 _function = it -> {
            ElementKind _kind = m.getEnclosingElement().getKind();
            boolean _equals = Objects.equal((Object)((Object)_kind), (Object)((Object)ElementKind.INTERFACE));
            if (_equals) {
                it.addModifier(Modifier.PUBLIC);
            }
            it.setBody(b);
        };
        return (GenMethod)ObjectExtensions.operator_doubleArrow((Object)_copyFrom, (Procedures.Procedure1)_function);
    }

    public GenMethod copyFrom(ExecutableElement m) {
        return this.copyFrom(m, false);
    }

    public GenMethod copyFrom(ExecutableElement m, boolean copyAnnotations) {
        Functions.Function1 _function = t -> t;
        GenElement _copyFrom = this.copyFrom(m, copyAnnotations, (Functions.Function1<? super TypeMirror, ? extends TypeMirror>)_function);
        return (GenMethod)_copyFrom;
    }

    protected GenElement _copyFrom(ExecutableElement m, boolean copyAnnotations, Functions.Function1<? super TypeMirror, ? extends TypeMirror> typeTransformer) {
        GenExecutableElement _xblockexpression = null;
        GenExecutableElement _xifexpression = null;
        ElementKind _kind = m.getKind();
        boolean _equals = Objects.equal((Object)((Object)_kind), (Object)((Object)ElementKind.METHOD));
        if (_equals) {
            Name _simpleName = m.getSimpleName();
            _xifexpression = new GenMethod(_simpleName);
        } else {
            GenConstructor _xifexpression_1 = null;
            ElementKind _kind_1 = m.getKind();
            boolean _equals_1 = Objects.equal((Object)((Object)_kind_1), (Object)((Object)ElementKind.CONSTRUCTOR));
            if (!_equals_1) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Copying ");
                _builder.append((Object)m);
                _builder.append(" not supported.");
                throw new IllegalArgumentException(_builder.toString());
            }
            _xifexpression_1 = new GenConstructor();
            _xifexpression = _xifexpression_1;
        }
        GenMethod result = _xifexpression;
        Procedures.Procedure1 _function = it -> {
            ElementKind _kind_2;
            boolean _equals_2;
            if (copyAnnotations) {
                it.setAnnotationMirrors(this.copyAnnotations(m));
            }
            if (_equals_2 = Objects.equal((Object)((Object)(_kind_2 = m.getKind())), (Object)((Object)ElementKind.METHOD))) {
                TypeMirror _apply = (TypeMirror)typeTransformer.apply((Object)m.getReturnType());
                TypeMirror _resolveType = null;
                if (_apply != null) {
                    _resolveType = this._typeResolver.resolveType(_apply);
                }
                it.setReturnType(_resolveType);
            }
            Functions.Function1 _function_1 = it_1 -> (TypeMirror)typeTransformer.apply(it_1);
            it.setThrownTypes(ListExtensions.map(m.getThrownTypes(), (Functions.Function1)_function_1));
            Functions.Function1 _function_2 = tp -> it.getOrCreateTypeParameter((TypeParameterElement)tp);
            it.setTypeParameters(ListExtensions.map(m.getTypeParameters(), (Functions.Function1)_function_2));
            it.setVarArgs(m.isVarArgs());
            it.setParameters(this.copyParametersFrom(m, copyAnnotations, typeTransformer));
            it.setModifiers(m.getModifiers());
        };
        _xblockexpression = (GenExecutableElement)ObjectExtensions.operator_doubleArrow((Object)result, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    public List<GenParameter> copyParametersFrom(ExecutableElement m, boolean copyAnnotations) {
        Functions.Function1 _function = t -> t;
        return this.copyParametersFrom(m, copyAnnotations, (Functions.Function1<? super TypeMirror, ? extends TypeMirror>)_function);
    }

    public List<GenParameter> copyParametersFrom(ExecutableElement method, boolean copyAnnotations, Functions.Function1<? super TypeMirror, ? extends TypeMirror> typeTransformer) {
        Functions.Function1 _function = p -> this.copyParamFrom((VariableElement)p, copyAnnotations, typeTransformer);
        return ListExtensions.map(this._elementsExtensions.parametersWithSrcNames(method), (Functions.Function1)_function);
    }

    public GenParameter copyParamFrom(VariableElement p, boolean copyAnnotations, Functions.Function1<? super TypeMirror, ? extends TypeMirror> typeTransformer) {
        Name _simpleName = p.getSimpleName();
        TypeMirror _apply = (TypeMirror)typeTransformer.apply((Object)p.asType());
        GenParameter _genParameter = new GenParameter(_simpleName, _apply);
        Procedures.Procedure1 _function = it -> {
            if (copyAnnotations) {
                it.setAnnotationMirrors(this.copyAnnotations(p));
            }
        };
        return (GenParameter)ObjectExtensions.operator_doubleArrow((Object)_genParameter, (Procedures.Procedure1)_function);
    }

    protected GenElement _copyFrom(VariableElement ve, boolean copyAnnotations, Functions.Function1<? super TypeMirror, ? extends TypeMirror> typeTransformer) {
        Name _simpleName = ve.getSimpleName();
        TypeMirror _asType = ve.asType();
        TypeMirror _resolveType = null;
        if (_asType != null) {
            _resolveType = this._typeResolver.resolveType(_asType);
        }
        TypeMirror _apply = (TypeMirror)typeTransformer.apply(_resolveType);
        GenField _genField = new GenField(_simpleName, _apply);
        Procedures.Procedure1 _function = it -> {
            it.setModifiers(ve.getModifiers());
            if (copyAnnotations) {
                it.setAnnotationMirrors(this.copyAnnotations(ve));
            }
        };
        return (GenElement)ObjectExtensions.operator_doubleArrow((Object)_genField, (Procedures.Procedure1)_function);
    }

    public GenMethod asMemberOf(ExecutableElement m, TypeElement type) {
        GenMethod _copyFrom = this.copyFrom(m);
        Procedures.Procedure1 _function = it -> {
            it.setEnclosingElement(m.getEnclosingElement());
            it.resolveContainedTypeVariables((GenTypeElement)type);
        };
        return (GenMethod)ObjectExtensions.operator_doubleArrow((Object)_copyFrom, (Procedures.Procedure1)_function);
    }

    public GenMethod asInterfaceMethod(ExecutableElement m) {
        GenMethod _copyFrom = this.copyFrom(m);
        Procedures.Procedure1 _function = it -> {
            it.setModifiers(CollectionLiterals.emptySet());
            it.setBody(null);
        };
        return (GenMethod)ObjectExtensions.operator_doubleArrow((Object)_copyFrom, (Procedures.Procedure1)_function);
    }

    public GenMethod asAbstractMethod(ExecutableElement m) {
        GenMethod _copyFrom = this.copyFrom(m);
        Procedures.Procedure1 _function = it -> {
            it.addModifier(Modifier.ABSTRACT);
            it.setBody(null);
        };
        return (GenMethod)ObjectExtensions.operator_doubleArrow((Object)_copyFrom, (Procedures.Procedure1)_function);
    }

    public boolean isJapkitAnnotation(AnnotationMirror am) {
        return this.japkitAnnotationPackages.contains(this._elementsExtensions.getPackage(this._elementsExtensions.annotationAsTypeElement(am)).getQualifiedName().toString());
    }

    public ArrayList<GenAnnotationMirror> copyAnnotations(Element src) {
        Functions.Function1 _function = it -> it;
        return this.copyAnnotations(src, this.isNoJapkitAnnotationFilter, _function);
    }

    public ArrayList<GenAnnotationMirror> copyAnnotations(Element src, Functions.Function1<? super AnnotationMirror, ? extends Boolean> filter, Functions.Function1<? super Object, ?> valueTransformer) {
        Functions.Function1 _function = it -> GenExtensions.copy(it, valueTransformer);
        List _list = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(src.getAnnotationMirrors(), filter), (Functions.Function1)_function));
        return new ArrayList<GenAnnotationMirror>(_list);
    }

    public static GenAnnotationMirror copy(AnnotationMirror am) {
        Functions.Function1 _function = it -> it;
        return GenExtensions.copy(am, _function);
    }

    public static GenAnnotationMirror copy(AnnotationMirror am, Functions.Function1<? super Object, ?> valueTransformer) {
        DeclaredType _annotationType = am.getAnnotationType();
        GenAnnotationMirror _genAnnotationMirror = new GenAnnotationMirror(_annotationType);
        Procedures.Procedure1 _function = it -> {
            Consumer<Map.Entry> _function_1 = avEntry -> it.setValue(((ExecutableElement)avEntry.getKey()).getSimpleName().toString(), GenExtensions.copy((AnnotationValue)avEntry.getValue(), valueTransformer));
            am.getElementValues().entrySet().forEach(_function_1);
        };
        return (GenAnnotationMirror)ObjectExtensions.operator_doubleArrow((Object)_genAnnotationMirror, (Procedures.Procedure1)_function);
    }

    public static GenAnnotationValue copy(AnnotationValue av, Functions.Function1<? super Object, ?> valueTransformer) {
        GenAnnotationValue _xblockexpression = null;
        ElementsExtensions ElementsExtensions2 = ExtensionRegistry.get(ElementsExtensions.class);
        Object _copyAvValue = GenExtensions.copyAvValue(ElementsExtensions2.getValueWithErrorHandling(av), valueTransformer);
        _xblockexpression = new GenAnnotationValue(_copyAvValue);
        return _xblockexpression;
    }

    protected static Object _copyAvValue(List<? extends AnnotationValue> values, Functions.Function1<? super Object, ?> valueTransformer) {
        Functions.Function1 _function = it -> GenExtensions.copy(it, valueTransformer);
        List _map = ListExtensions.map(values, (Functions.Function1)_function);
        return new ArrayList(_map);
    }

    protected static Object _copyAvValue(AnnotationMirror v, Functions.Function1<? super Object, ?> valueTransformer) {
        return GenExtensions.copy(v, valueTransformer);
    }

    protected static Object _copyAvValue(Object v, Functions.Function1<? super Object, ?> valueTransformer) {
        boolean _equals = Objects.equal((Object)v, (Object)"<error>");
        if (_equals) {
            throw new TypeElementNotFoundException();
        }
        return valueTransformer.apply(v);
    }

    public GenElement copyFrom(Element m, boolean copyAnnotations, Functions.Function1<? super TypeMirror, ? extends TypeMirror> typeTransformer) {
        if (m instanceof ExecutableElement && typeTransformer != null) {
            return this._copyFrom((ExecutableElement)m, copyAnnotations, typeTransformer);
        }
        if (m instanceof VariableElement && typeTransformer != null) {
            return this._copyFrom((VariableElement)m, copyAnnotations, typeTransformer);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(m, copyAnnotations, typeTransformer).toString());
    }

    public static Object copyAvValue(Object values, Functions.Function1<? super Object, ?> valueTransformer) {
        if (values instanceof List && valueTransformer != null) {
            return GenExtensions._copyAvValue((List)values, valueTransformer);
        }
        if (values instanceof AnnotationMirror && valueTransformer != null) {
            return GenExtensions._copyAvValue((AnnotationMirror)values, valueTransformer);
        }
        if (values != null && valueTransformer != null) {
            return GenExtensions._copyAvValue(values, valueTransformer);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(values, valueTransformer).toString());
    }
}

