/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.model;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.japkit.activeannotations.Derived;
import de.japkit.activeannotations.FieldsFromInterface;
import de.japkit.model.GenDeclaredType;
import de.japkit.model.GenElement;
import de.japkit.model.GenExtensions;
import de.japkit.model.GenMethod;
import de.japkit.model.GenName;
import de.japkit.model.GenPackage;
import de.japkit.model.GenParameterizable;
import de.japkit.services.ElementsExtensions;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.TypesExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@FieldsFromInterface
public abstract class GenTypeElement
extends GenParameterizable
implements TypeElement {
    private List<TypeMirror> interfaces = CollectionLiterals.newArrayList();
    private NestingKind nestingKind;
    private TypeMirror superclass;
    @Accessors
    private Set<GenTypeElement> auxTopLevelClasses = CollectionLiterals.newHashSet();
    @Accessors
    private boolean auxClass;
    private Name qualifiedName;
    private final Map<TypeParameterElement, TypeMirror> resolvedTypeArgsMap = CollectionLiterals.newHashMap();
    private static final Functions.Function2<Element, Element, Integer> memberComparator = (e1, e2) -> Integer.valueOf(GenTypeElement.memberOrderOf(e1)).compareTo(GenTypeElement.memberOrderOf(e2));
    private static final List<ElementKind> memberOrder = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ElementKind[]{ElementKind.ENUM_CONSTANT, ElementKind.FIELD, ElementKind.STATIC_INIT, ElementKind.INSTANCE_INIT, ElementKind.CONSTRUCTOR, ElementKind.METHOD, ElementKind.ENUM, ElementKind.INTERFACE, ElementKind.CLASS}));

    @Override
    @Derived
    public Name getQualifiedName() {
        return this.qualifiedName;
    }

    public GenTypeElement(String name, String packageName) {
        this(name, GenPackage.packageForName(packageName));
    }

    public GenTypeElement(String name, Element enclosingElement) {
        super(name);
        this.setEnclosingElement(enclosingElement);
        StringConcatenation _builder = new StringConcatenation();
        Name _qualifiedName = null;
        if ((QualifiedNameable)enclosingElement != null) {
            _qualifiedName = ((QualifiedNameable)enclosingElement).getQualifiedName();
        }
        _builder.append(_qualifiedName);
        _builder.append(".");
        Name _simpleName = this.getSimpleName();
        _builder.append((Object)_simpleName);
        GenName _genName = new GenName(_builder.toString());
        this.qualifiedName = _genName;
        if (enclosingElement instanceof PackageElement) {
            this.setNestingKind(NestingKind.TOP_LEVEL);
        } else if (enclosingElement instanceof TypeElement) {
            this.setNestingKind(NestingKind.MEMBER);
        } else {
            throw new IllegalArgumentException("Enclosing element of a class must be a PackageElement or a TypeElement, but not " + enclosingElement);
        }
    }

    @Override
    public void setEnclosingElement(Element e) {
        super.setEnclosingElement(e);
        StringConcatenation _builder = new StringConcatenation();
        Element _enclosingElement = this.getEnclosingElement();
        Name _qualifiedName = null;
        if ((QualifiedNameable)_enclosingElement != null) {
            _qualifiedName = ((QualifiedNameable)_enclosingElement).getQualifiedName();
        }
        _builder.append(_qualifiedName);
        _builder.append(".");
        Name _simpleName = this.getSimpleName();
        _builder.append((Object)_simpleName);
        GenName _genName = new GenName(_builder.toString());
        this.qualifiedName = _genName;
    }

    public void setSuperclass(DeclaredType type, TypeMirror ... typeArgs) {
        if (type != null) {
            TypeMirror _asType = type.asElement().asType();
            DeclaredType superclassPrototype = (DeclaredType)_asType;
            this.superclass = this.resolveTypeArgs(superclassPrototype, typeArgs);
        } else {
            this.superclass = null;
        }
    }

    public void setSuperclass(DeclaredType type) {
        TypeMirror[] _elvis = null;
        List<? extends TypeMirror> _typeArguments = null;
        if (type != null) {
            _typeArguments = type.getTypeArguments();
        }
        _elvis = (TypeMirror[])Conversions.unwrapArray(_typeArguments, TypeMirror.class) != null ? (TypeMirror[])Conversions.unwrapArray(_typeArguments, TypeMirror.class) : null;
        this.setSuperclass(type, _elvis);
    }

    public void addInterface(DeclaredType type, TypeMirror ... typeArgs) {
        TypeMirror _asType = type.asElement().asType();
        DeclaredType interfacePrototype = (DeclaredType)_asType;
        this.interfaces.add(this.resolveTypeArgs(interfacePrototype, typeArgs));
    }

    public void addInterface(TypeMirror type) {
        this.addInterface((DeclaredType)type, (TypeMirror[])Conversions.unwrapArray(((DeclaredType)type).getTypeArguments(), TypeMirror.class));
    }

    public void copyTypeParametersFrom(GenTypeElement other) {
        Consumer<TypeParameterElement> _function = p -> {
            TypeParameterElement ownParam = this.getOrCreateTypeParameter((TypeParameterElement)p);
            this.addTypeParameter(ownParam);
        };
        other.getTypeParameters().forEach(_function);
    }

    public Map<TypeParameterElement, TypeMirror> getResolvedTypeArgsMap() {
        return this.resolvedTypeArgsMap;
    }

    public DeclaredType resolveTypeArgs(DeclaredType prototype, TypeMirror[] typeArgs) {
        DeclaredType _xblockexpression = null;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(prototype.getTypeArguments());
        if (_isNullOrEmpty) {
            return prototype;
        }
        int _size = prototype.getTypeArguments().size();
        Functions.Function1 _function = n -> {
            Element _asElement;
            TypeMirror _xblockexpression_1 = null;
            TypeMirror _xifexpression = null;
            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)typeArgs)));
            _xifexpression = _isNullOrEmpty_1 ? null : typeArgs[n];
            TypeMirror typeArg = _xifexpression;
            TypeMirror _get = prototype.getTypeArguments().get((int)n);
            TypeVariable typeVariable = (TypeVariable)_get;
            TypeMirror _xifexpression_1 = null;
            if (typeArg == null) {
                TypeVariable _xblockexpression_2 = null;
                _asElement = typeVariable.asElement();
                this.addTypeParameter(this.getOrCreateTypeParameter((TypeParameterElement)_asElement));
                _xblockexpression_2 = typeVariable;
                _xifexpression_1 = _xblockexpression_2;
            } else {
                _xifexpression_1 = typeArg;
            }
            TypeMirror resolved = _xifexpression_1;
            _asElement = typeVariable.asElement();
            this.resolvedTypeArgsMap.put((TypeParameterElement)_asElement, resolved);
            _xblockexpression_1 = resolved;
            return _xblockexpression_1;
        };
        Iterable resolvedTypeArgs = IterableExtensions.map((Iterable)new ExclusiveRange(0, _size, true), (Functions.Function1)_function);
        _xblockexpression = this.getDeclaredType(prototype, resolvedTypeArgs);
        return _xblockexpression;
    }

    @Override
    protected TypeMirror resolveTypeVariable(TypeVariable tv) {
        TypeMirror _xblockexpression = null;
        TypeMirror resolvedTypeVar = this.resolvedTypeArgsMap.get(tv.asElement());
        if (resolvedTypeVar != null || Objects.equal((Object)((Object)this.nestingKind), (Object)((Object)NestingKind.TOP_LEVEL))) {
            // empty if block
        }
        _xblockexpression = resolvedTypeVar;
        return _xblockexpression;
    }

    @Override
    public void addEnclosedElement(Element enclosed) {
        super.addEnclosedElement(enclosed);
        ((GenElement)enclosed).resolveContainedTypeVariables(this);
    }

    public static int memberOrderOf(Element e) {
        int _xblockexpression = 0;
        int index = memberOrder.indexOf((Object)e.getKind());
        int _xifexpression = 0;
        _xifexpression = index >= 0 ? index : memberOrder.size();
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    public Comparator<Element> enclosedElementComparator() {
        return new Comparator<Element>(){

            @Override
            public int compare(Element arg0, Element arg1) {
                return (Integer)memberComparator.apply((Object)arg0, (Object)arg1);
            }
        };
    }

    public List<ExecutableElement> allMethods() {
        ArrayList _xblockexpression = null;
        TypesExtensions TypesExtensions2 = ExtensionRegistry.get(TypesExtensions.class);
        ElementsExtensions ElementsExtensions2 = ExtensionRegistry.get(ElementsExtensions.class);
        ArrayList methods = CollectionLiterals.newArrayList();
        GenTypeElement te = this;
        if (this.superclass != null) {
            Functions.Function1 _function = m -> !IterableExtensions.exists(ElementsExtensions2.declaredMethods(this), it -> ElementsExtensions2.overrides((ExecutableElement)it, (ExecutableElement)m)) && (ElementsExtensions2.isPublic((Element)m) || ElementsExtensions2.isProtected((Element)m) || ElementsExtensions2.isDefaultAccess((Element)m) && ElementsExtensions2.samePackage((Element)m, te));
            Functions.Function1 _function_1 = m -> {
                GenMethod m1;
                GenMethod _xblockexpression_1 = null;
                _xblockexpression_1 = m1 = ExtensionRegistry.get(GenExtensions.class).asMemberOf((ExecutableElement)m, te);
                return _xblockexpression_1;
            };
            Iterables.addAll((Collection)methods, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(ElementsExtensions2.allMethods(TypesExtensions2.asElement(this.superclass)), (Functions.Function1)_function), (Functions.Function1)_function_1));
        }
        methods.addAll(ElementsExtensions2.declaredMethods(this));
        _xblockexpression = methods;
        return _xblockexpression;
    }

    @Override
    public TypeMirror asType() {
        Procedures.Procedure1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> it_1.asType();
            it.setTypeArguments(ListExtensions.map(this.getTypeParameters(), (Functions.Function1)_function_1));
        };
        return new GenDeclaredType(this, (Procedures.Procedure1<? super GenDeclaredType>)_function);
    }

    public GenTypeElement(String name) {
        super(name);
    }

    public GenTypeElement(Name name) {
        super(name);
    }

    public GenTypeElement() {
    }

    @Override
    public NestingKind getNestingKind() {
        return this.nestingKind;
    }

    public void setNestingKind(NestingKind nestingKind) {
        this.nestingKind = nestingKind;
    }

    public void setQualifiedName(Name qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    @Override
    public TypeMirror getSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(TypeMirror superclass) {
        this.superclass = superclass;
    }

    @Override
    public List<? extends TypeMirror> getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public void removeInterface(TypeMirror aInterface_) {
        this.interfaces.remove(aInterface_);
    }

    public void setInterfaces(List<? extends TypeMirror> interfaces) {
        this.interfaces.clear();
        for (TypeMirror typeMirror : interfaces) {
            this.addInterface(typeMirror);
        }
    }

    @Pure
    public Set<GenTypeElement> getAuxTopLevelClasses() {
        return this.auxTopLevelClasses;
    }

    public void setAuxTopLevelClasses(Set<GenTypeElement> auxTopLevelClasses) {
        this.auxTopLevelClasses = auxTopLevelClasses;
    }

    @Pure
    public boolean isAuxClass() {
        return this.auxClass;
    }

    public void setAuxClass(boolean auxClass) {
        this.auxClass = auxClass;
    }
}

