/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.processor;

import com.google.common.collect.Iterables;
import de.japkit.annotations.Behavior;
import de.japkit.el.ELSupport;
import de.japkit.metaannotations.Trigger;
import de.japkit.model.GenTypeElement;
import de.japkit.processor.JavaEmitter;
import de.japkit.rules.AnnotationExtensions;
import de.japkit.rules.RuleFactory;
import de.japkit.rules.TriggerAnnotationRule;
import de.japkit.services.ElementsExtensions;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.GenerateClassContext;
import de.japkit.services.MessageCollector;
import de.japkit.services.ReportedException;
import de.japkit.services.TypeElementFromCompilerCache;
import de.japkit.services.TypeElementNotFoundException;
import de.japkit.services.TypesExtensions;
import de.japkit.services.TypesRegistry;
import de.japkit.util.MoreCollectionExtensions;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class JapkitProcessor
extends AbstractProcessor {
    @Extension
    private ProcessingEnvironment processingEnv;
    protected Elements elementUtils;
    protected Types typeUtils;
    @Extension
    private ElementsExtensions elementsExtensions;
    @Extension
    private TypesExtensions typesExtensions;
    @Extension
    private AnnotationExtensions annotationExtensions;
    @Extension
    private MessageCollector messageCollector;
    @Extension
    private GenerateClassContext generateClassContext;
    @Extension
    private TypesRegistry typesRegistry;
    @Extension
    private RuleFactory ruleFactory;
    @Extension
    private ELSupport elSupport;
    @Extension
    private TypeElementFromCompilerCache typeElementCache;
    private final Map<String, TypeElementNotFoundException> deferredClasses = new HashMap<String, TypeElementNotFoundException>();
    private boolean servicesInitialized;
    private final Set<String> writtenTypeElements = CollectionLiterals.newHashSet();

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.processingEnv = processingEnv;
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
        this.initServices();
    }

    public boolean initServices() {
        boolean _xifexpression = false;
        if (!this.servicesInitialized) {
            boolean _xblockexpression = false;
            ExtensionRegistry.cleanup();
            ExtensionRegistry.register(ProcessingEnvironment.class, this.processingEnv);
            ExtensionRegistry.register(Types.class, this.typeUtils);
            ExtensionRegistry.register(Elements.class, this.elementUtils);
            this.elementsExtensions = ExtensionRegistry.get(ElementsExtensions.class);
            this.typesExtensions = ExtensionRegistry.get(TypesExtensions.class);
            this.annotationExtensions = ExtensionRegistry.get(AnnotationExtensions.class);
            this.messageCollector = ExtensionRegistry.get(MessageCollector.class);
            this.messageCollector.setDiagnosticLogging("true".equals(this.processingEnv.getOptions().get("diagnosticMessages")));
            Functions.Function1 _function = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Init japkit annotation processor.");
                return _builder.toString();
            };
            this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function);
            this.generateClassContext = ExtensionRegistry.get(GenerateClassContext.class);
            this.typeElementCache = ExtensionRegistry.get(TypeElementFromCompilerCache.class);
            this.typesRegistry = ExtensionRegistry.get(TypesRegistry.class);
            this.ruleFactory = ExtensionRegistry.get(RuleFactory.class);
            this.elSupport = ExtensionRegistry.get(ELSupport.class);
            this.servicesInitialized = true;
            _xifexpression = _xblockexpression = true;
        }
        return _xifexpression;
    }

    public boolean cleanupServices() {
        boolean _xblockexpression = false;
        ExtensionRegistry.cleanup();
        this.servicesInitialized = false;
        _xblockexpression = false;
        return _xblockexpression;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        String _name = Behavior.class.getPackage().getName();
        _builder.append(_name);
        _builder.append(".*");
        StringConcatenation _builder_1 = new StringConcatenation();
        String _name_1 = Trigger.class.getPackage().getName();
        _builder_1.append(_name_1);
        _builder_1.append(".*");
        HashSet set = CollectionLiterals.newHashSet((Object[])new String[]{_builder.toString(), _builder_1.toString()});
        String annotationsOption = this.processingEnv.getOptions().get("annotations");
        if (annotationsOption != null) {
            Consumer<String> _function = it -> set.add(it);
            ((List)Conversions.doWrapArray((Object)annotationsOption.split(","))).forEach(_function);
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The processor option 'annotations' is not set. ");
        }
        _xblockexpression = set;
        return _xblockexpression;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{"annotations", "diagnosticMessages", "templateDir"}));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, @Extension RoundEnvironment roundEnv) {
        boolean _xblockexpression = false;
        this.initServices();
        this.elementsExtensions.clearCaches();
        this.ruleFactory.clearCaches();
        this.typesRegistry.clearCaches();
        this.typeElementCache.clear();
        long startTime = System.currentTimeMillis();
        Functions.Function1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("New Round. ");
            Set<? extends Element> _rootElements = roundEnv.getRootElements();
            _builder.append(_rootElements);
            _builder.append(" Annotations: ");
            _builder.append((Object)annotations);
            _builder.append(" errorRaised ");
            boolean _errorRaised = roundEnv.errorRaised();
            _builder.append((Object)_errorRaised);
            _builder.append(" processingOver: ");
            boolean _processingOver = roundEnv.processingOver();
            _builder.append((Object)_processingOver);
            return _builder.toString();
        };
        this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function);
        boolean _processingOver = roundEnv.processingOver();
        if (_processingOver) {
            this.typesRegistry.persist();
            this.printAllErrors();
            this.cleanupServices();
            return false;
        }
        Functions.Function1 _function_1 = it -> this.typeElementCache.getTypeElement((String)it);
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.map(this.deferredClasses.keySet(), (Functions.Function1)_function_1));
        HashSet<TypeElement> annotatedClassesToDefer = new HashSet<TypeElement>(_set);
        this.deferredClasses.clear();
        List classesToProcessUnfiltered = IterableExtensions.toList(this.elementsExtensions.typeElements(roundEnv.getRootElements()));
        HashSet<TypeElement> classesToProcess = new HashSet<TypeElement>(classesToProcessUnfiltered);
        Functions.Function1 _function_2 = it -> this.getTriggerAnnotationsAndShadowFlag((TypeElement)it);
        Functions.Function2 _function_3 = (ac, t) -> {
            boolean _isEmpty = t.isEmpty();
            return !_isEmpty;
        };
        Map annotatedClassesAndTriggerAnnotations = MapExtensions.filter((Map)IterableExtensions.toInvertedMap(classesToProcess, (Functions.Function1)_function_2), (Functions.Function2)_function_3);
        Functions.Function1 _function_4 = it -> this.annotationExtensions.isTriggerAnnotation((TypeElement)it);
        Functions.Function1 _function_5 = it -> it.getQualifiedName().toString();
        Set _set_1 = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(classesToProcess, (Functions.Function1)_function_4), (Functions.Function1)_function_5));
        HashSet<String> triggerAnnotations = new HashSet<String>(_set_1);
        triggerAnnotations.addAll(this.typesRegistry.getTriggerAnnotationsForMetaTypeElements(classesToProcess));
        Functions.Function1 _function_6 = it -> this.typesRegistry.findAllTypeElementsWithTriggerAnnotation((String)it, false);
        Set classesWithTrigger = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map(triggerAnnotations, (Functions.Function1)_function_6)));
        BiConsumer<TypeElement, List> _function_7 = (ac, t) -> this.typesRegistry.registerAnnotatedClass((TypeElement)ac, (List<Pair<AnnotationMirror, Boolean>>)t);
        annotatedClassesAndTriggerAnnotations.forEach(_function_7);
        Functions.Function2 _function_8 = (ac, t) -> {
            Functions.Function1 _function_9 = it -> {
                Boolean _value = (Boolean)it.getValue();
                return _value == false;
            };
            return IterableExtensions.exists((Iterable)t, (Functions.Function1)_function_9);
        };
        classesToProcess.retainAll(MapExtensions.filter((Map)annotatedClassesAndTriggerAnnotations, (Functions.Function2)_function_8).keySet());
        Functions.Function1 _function_9 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Annotated classes in root TypeElements: ");
            _builder.append((Object)classesToProcess);
            return _builder.toString();
        };
        this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_9);
        Functions.Function1 _function_10 = it -> !this.typesRegistry.isCommitted((TypeElement)it) && !it.getQualifiedName().toString().endsWith("_RuntimeMetadata");
        Functions.Function1 _function_11 = it -> this.typesRegistry.getAnnotatedClassForGenClassOnDisk((TypeElement)it);
        Functions.Function1 _function_12 = it -> it != null;
        Set annotatedClassesForUncommitedGenClasses = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)classesToProcessUnfiltered, (Functions.Function1)_function_10), (Functions.Function1)_function_11), (Functions.Function1)_function_12));
        Functions.Function1 _function_13 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Annotated classes for uncommited gen classes: ");
            _builder.append((Object)annotatedClassesForUncommitedGenClasses);
            return _builder.toString();
        };
        this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_13);
        classesToProcess.addAll(annotatedClassesForUncommitedGenClasses);
        Functions.Function1 _function_14 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Annotated classes for triggers found in root TypeElements: ");
            _builder.append((Object)classesWithTrigger);
            return _builder.toString();
        };
        this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_14);
        classesToProcess.addAll(classesWithTrigger);
        boolean roundDone = false;
        HashSet writtenTypeElementsInCurrentRound = CollectionLiterals.newHashSet();
        while (!roundDone) {
            boolean _not;
            HashSet<TypeElement> allClasses = new HashSet<TypeElement>(annotatedClassesToDefer);
            allClasses.addAll(classesToProcess);
            boolean _isEmpty = allClasses.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                boolean layerCompleted = this.processLayerAsFarAsPossible(annotatedClassesToDefer, classesToProcess, this.getMinLayer(allClasses), writtenTypeElementsInCurrentRound);
                roundDone = !layerCompleted;
                classesToProcess.retainAll(annotatedClassesToDefer);
                continue;
            }
            roundDone = true;
        }
        Consumer<TypeElement> _function_15 = it -> this.deferredClasses.put(it.getQualifiedName().toString(), null);
        annotatedClassesToDefer.forEach(_function_15);
        this.typesRegistry.cleanUpTypesAtEndOfRound();
        Functions.Function1 _function_16 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Deferred classes: ");
            String _join = IterableExtensions.join(this.deferredClasses.keySet(), (CharSequence)", ");
            _builder.append(_join);
            _builder.newLineIfNotEmpty();
            _builder.append("Dependencies: ");
            _builder.newLine();
            Functions.Function1 _function_17 = it_1 -> {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(it_1);
                _builder_1.append(" depends on ");
                Set<Pair<String, String>> _typesByGenClassOnWhichThatAnnotatedClassDependsOn = this.typesRegistry.getTypesByGenClassOnWhichThatAnnotatedClassDependsOn((CharSequence)it_1);
                _builder_1.append(_typesByGenClassOnWhichThatAnnotatedClassDependsOn);
                return _builder_1.toString();
            };
            String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map(this.deferredClasses.keySet(), (Functions.Function1)_function_17), (CharSequence)"\n");
            _builder.append(_join_1);
            _builder.newLineIfNotEmpty();
            return _builder.toString();
        };
        this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_16);
        Functions.Function1 _function_17 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Round Time (ms): ");
            long _currentTimeMillis = System.currentTimeMillis();
            long _minus = _currentTimeMillis - startTime;
            _builder.append((Object)_minus);
            return _builder.toString();
        };
        this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_17);
        _xblockexpression = false;
        return _xblockexpression;
    }

    public Integer getMinLayer(Set<TypeElement> annotatedClasses) {
        Integer _xblockexpression = null;
        Functions.Function1 _function = it -> this.getLayer((TypeElement)it);
        Set layers = IterableExtensions.toSet((Iterable)IterableExtensions.map(annotatedClasses, (Functions.Function1)_function));
        _xblockexpression = (Integer)Collections.min(layers);
        return _xblockexpression;
    }

    public Integer getLayer(TypeElement annotatedClass) {
        Integer _xblockexpression = null;
        Functions.Function1 _function = it -> this.elementsExtensions.metaAnnotation((AnnotationMirror)it, (Class<? extends Annotation>)Trigger.class);
        Functions.Function1 _function_1 = it -> this.elementsExtensions.value((AnnotationMirror)it, "layer", Integer.class);
        Set layers = IterableExtensions.toSet((Iterable)ListExtensions.map((List)ListExtensions.map(this.annotationExtensions.getTriggerAnnotations(annotatedClass), (Functions.Function1)_function), (Functions.Function1)_function_1));
        Integer _xifexpression = null;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)layers);
        if (_isNullOrEmpty) {
            int _xblockexpression_1 = 0;
            Functions.Function1 _function_2 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Error: Layer could not be determined for ");
                _builder.append((Object)annotatedClass);
                _builder.append(" of type ");
                Class<?> _class = null;
                if (annotatedClass != null) {
                    _class = annotatedClass.getClass();
                }
                _builder.append(_class);
                return _builder.toString();
            };
            this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_2);
            _xblockexpression_1 = 0;
            _xifexpression = _xblockexpression_1;
        } else {
            _xifexpression = (Integer)Collections.max(layers);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public HashSet<TypeElement> filterLayer(Iterable<TypeElement> elements, int l) {
        Functions.Function1 _function = it -> {
            Integer _layer = this.getLayer((TypeElement)it);
            return _layer == l;
        };
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.filter(elements, (Functions.Function1)_function));
        return new HashSet<TypeElement>(_set);
    }

    public boolean processLayerAsFarAsPossible(HashSet<TypeElement> annotatedClassesToDefer, HashSet<TypeElement> classesInCurrentRound, int layer, HashSet<GenTypeElement> writtenTypeElementsInCurrentRound) {
        boolean layerDone;
        Functions.Function1 _function_4;
        HashSet<TypeElement> classesToProcess;
        boolean _xblockexpression = false;
        Functions.Function1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Processing layer ");
            _builder.append((Object)layer);
            return _builder.toString();
        };
        this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function);
        HashMap generatedTypeElementsInCurrentRound = CollectionLiterals.newHashMap();
        HashSet writtenTypeElementsInCurrentLoop = CollectionLiterals.newHashSet();
        HashSet<TypeElement> ctp = classesToProcess = this.filterLayer(classesInCurrentRound, layer);
        Functions.Function1 _function_1 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Annotated classes to process in layer ");
            _builder.append((Object)layer);
            _builder.append(": ");
            _builder.append((Object)ctp);
            return _builder.toString();
        };
        this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_1);
        HashSet<TypeElement> higherLayerClassesInCurrentRound = new HashSet<TypeElement>(classesInCurrentRound);
        higherLayerClassesInCurrentRound.removeAll(classesToProcess);
        annotatedClassesToDefer.addAll(higherLayerClassesInCurrentRound);
        do {
            Functions.Function1 _function_2 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Loop begins");
                return _builder.toString();
            };
            this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_2);
            writtenTypeElementsInCurrentLoop.clear();
            Functions.Function1 _function_3 = it -> writtenTypeElementsInCurrentRound.isEmpty() || !this.typesRegistry.hasUnresolvedTypeDependencies(it.getQualifiedName().toString(), CollectionLiterals.emptySet());
            HashSet<TypeElement> annotatedClassesFromPreviousIterationWithNoDependencies = this.filterLayer(IterableExtensions.filter(annotatedClassesToDefer, (Functions.Function1)_function_3), layer);
            _function_4 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Annotated classes from previous rounds / iterations with no type dependencies: ");
                _builder.append((Object)annotatedClassesFromPreviousIterationWithNoDependencies);
                return _builder.toString();
            };
            this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_4);
            classesToProcess.addAll(annotatedClassesFromPreviousIterationWithNoDependencies);
            this.processClassesAndWriteTypeElements(classesToProcess, false, generatedTypeElementsInCurrentRound, annotatedClassesToDefer, writtenTypeElementsInCurrentLoop);
            classesToProcess = this.filterLayer(annotatedClassesToDefer, layer);
            this.processClassesWithCycles(classesToProcess, generatedTypeElementsInCurrentRound, annotatedClassesToDefer, writtenTypeElementsInCurrentLoop);
            classesToProcess = this.filterLayer(annotatedClassesToDefer, layer);
            if (writtenTypeElementsInCurrentLoop.isEmpty() && writtenTypeElementsInCurrentRound.isEmpty() && !classesToProcess.isEmpty()) {
                this.writeClassesWithPermanentTypeErrors(classesToProcess, generatedTypeElementsInCurrentRound, annotatedClassesToDefer, writtenTypeElementsInCurrentLoop, false);
            }
            Functions.Function1 _function_5 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Loop ends. Written: ");
                Functions.Function1 _function_6 = it_1 -> it_1.getQualifiedName();
                Iterable _map = IterableExtensions.map((Iterable)writtenTypeElementsInCurrentLoop, (Functions.Function1)_function_6);
                _builder.append((Object)_map);
                return _builder.toString();
            };
            this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_5);
            writtenTypeElementsInCurrentRound.addAll(writtenTypeElementsInCurrentLoop);
            HashSet _hashSet = new HashSet();
            classesToProcess = _hashSet;
        } while (!writtenTypeElementsInCurrentLoop.isEmpty());
        boolean _isEmpty = writtenTypeElementsInCurrentRound.isEmpty();
        if (_isEmpty) {
            Functions.Function1 _function_2 = it -> this.typesRegistry.dependsOnUnknownTypes(it.getQualifiedName());
            Set annotatedClassesWithUnknownDependencies = IterableExtensions.toSet((Iterable)IterableExtensions.filter(this.filterLayer(annotatedClassesToDefer, layer), (Functions.Function1)_function_2));
            Functions.Function1 _function_3 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Consider Annotated classes from previous rounds /iterations with unknown type dependencies: ");
                _builder.append((Object)annotatedClassesWithUnknownDependencies);
                return _builder.toString();
            };
            this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_3);
            this.processClassesAndWriteTypeElements(IterableExtensions.toSet((Iterable)annotatedClassesWithUnknownDependencies), false, generatedTypeElementsInCurrentRound, annotatedClassesToDefer, writtenTypeElementsInCurrentRound);
            classesToProcess = this.filterLayer(annotatedClassesToDefer, layer);
            this.processClassesWithCycles(classesToProcess, generatedTypeElementsInCurrentRound, annotatedClassesToDefer, writtenTypeElementsInCurrentRound);
            classesToProcess = this.filterLayer(annotatedClassesToDefer, layer);
            this.writeClassesWithPermanentTypeErrors(classesToProcess, generatedTypeElementsInCurrentRound, annotatedClassesToDefer, writtenTypeElementsInCurrentRound, false);
        }
        classesToProcess = this.filterLayer(annotatedClassesToDefer, layer);
        boolean _isEmpty_1 = writtenTypeElementsInCurrentRound.isEmpty();
        if (_isEmpty_1) {
            this.writeClassesWithPermanentTypeErrors(classesToProcess, generatedTypeElementsInCurrentRound, annotatedClassesToDefer, writtenTypeElementsInCurrentRound, true);
        }
        if (layerDone = this.filterLayer(annotatedClassesToDefer, layer).isEmpty()) {
            _function_4 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Finished processing of layer ");
                _builder.append((Object)layer);
                return _builder.toString();
            };
            this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_4);
        } else {
            Functions.Function1 _function_5 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Need to defer processing of layer ");
                _builder.append((Object)layer);
                _builder.append(" to next annotation processing round.");
                return _builder.toString();
            };
            this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_5);
        }
        _xblockexpression = layerDone;
        return _xblockexpression;
    }

    public void writeClassesWithPermanentTypeErrors(Set<TypeElement> classesToProcess, Map<TypeElement, Set<GenTypeElement>> generatedTypeElementsInCurrentRound, HashSet<TypeElement> annotatedClassesToDefer, HashSet<GenTypeElement> writtenTypeElementsInCurrentRound, boolean alsoWriteClassesThatDependOnUnknownTypes) {
        boolean _not;
        Functions.Function1 _function = it -> {
            boolean _dependsOnOtherAnnotatedClasses = this.typesRegistry.dependsOnOtherAnnotatedClasses(it.getQualifiedName().toString());
            return !_dependsOnOtherAnnotatedClasses;
        };
        Set annotatedClassesWithUnresolvableTypeErrors = IterableExtensions.toSet((Iterable)IterableExtensions.filter(classesToProcess, (Functions.Function1)_function));
        boolean _isEmpty = annotatedClassesWithUnresolvableTypeErrors.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Functions.Function1 _function_1 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Consider classes with unresolvable type errors (alsoWriteClassesThatDependOnUnknownTypes = ");
                _builder.append((Object)alsoWriteClassesThatDependOnUnknownTypes);
                _builder.append("): ");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function_2 = it_1 -> {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append(it_1);
                    _builder_1.append(" depends on: ");
                    Iterable<String> _unresolvableTypesOnWhichThatAnnotatedClassDependsOn = this.typesRegistry.unresolvableTypesOnWhichThatAnnotatedClassDependsOn(it_1.getQualifiedName().toString(), false);
                    _builder_1.append(_unresolvableTypesOnWhichThatAnnotatedClassDependsOn);
                    return _builder_1.toString();
                };
                String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)annotatedClassesWithUnresolvableTypeErrors, (Functions.Function1)_function_2), (CharSequence)"\n");
                _builder.append(_join);
                _builder.newLineIfNotEmpty();
                return _builder.toString();
            };
            this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_1);
            Functions.Function1 _function_2 = it -> IterableExtensions.isNullOrEmpty((Iterable)((Iterable)generatedTypeElementsInCurrentRound.get(it)));
            Iterable stillToGenerate = IterableExtensions.filter((Iterable)annotatedClassesWithUnresolvableTypeErrors, (Functions.Function1)_function_2);
            Consumer<TypeElement> _function_3 = it -> {
                BiConsumer<GenTypeElement, TypeElement> _function_4 = (gen, org) -> MoreCollectionExtensions.getOrCreateSet(generatedTypeElementsInCurrentRound, org).add(gen);
                this.processAnnotatedClass((TypeElement)it).forEach(_function_4);
            };
            stillToGenerate.forEach(_function_3);
            this.typesRegistry.setThrowTypeElementNotFoundExceptionWhenResolvingSimpleTypeNames(false);
            Functions.Function2 _function_4 = (annotatedClass, genTypeElements) -> annotatedClassesWithUnresolvableTypeErrors.contains(annotatedClass);
            BiConsumer<TypeElement, Set> _function_5 = (annotatedClass, genTypeElements) -> {
                HashSet genClassesNotWritten = CollectionLiterals.newHashSet();
                Consumer<GenTypeElement> _function_6 = it -> {
                    if (alsoWriteClassesThatDependOnUnknownTypes || !this.typesRegistry.dependsOnUnknownTypes(annotatedClass.getQualifiedName().toString(), it.getQualifiedName().toString())) {
                        this.writeSourceFileAndCommitTypeElement((GenTypeElement)it, (TypeElement)annotatedClass, (Set<GenTypeElement>)writtenTypeElementsInCurrentRound);
                    } else {
                        genClassesNotWritten.add(it);
                    }
                };
                genTypeElements.forEach(_function_6);
                boolean _isEmpty_1 = genClassesNotWritten.isEmpty();
                if (_isEmpty_1) {
                    annotatedClassesToDefer.remove(annotatedClass);
                }
            };
            MapExtensions.filter(generatedTypeElementsInCurrentRound, (Functions.Function2)_function_4).forEach(_function_5);
            this.typesRegistry.setThrowTypeElementNotFoundExceptionWhenResolvingSimpleTypeNames(true);
        }
    }

    public void processClassesWithCycles(Set<TypeElement> classesToProcess, Map<TypeElement, Set<GenTypeElement>> generatedTypeElementsInCurrentRound, Set<TypeElement> annotatedClassesToDefer, HashSet<GenTypeElement> writtenTypeElementsInCurrentRound) {
        if (writtenTypeElementsInCurrentRound.isEmpty() && !classesToProcess.isEmpty()) {
            boolean _not;
            Iterable<Set<TypeElement>> cyclesToProcess = this.findCyclesInAnnotatedClasses(classesToProcess);
            boolean _isEmpty = IterableExtensions.isEmpty(cyclesToProcess);
            boolean bl = _not = !_isEmpty;
            if (_not) {
                Functions.Function1 _function = it -> {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Try to resolve cyclic dependencies: ");
                    _builder.append((Object)cyclesToProcess);
                    return _builder.toString();
                };
                this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function);
                Consumer<Set> _function_1 = it -> this.processClassesAndWriteTypeElements((Set<TypeElement>)it, true, generatedTypeElementsInCurrentRound, annotatedClassesToDefer, (Set<GenTypeElement>)writtenTypeElementsInCurrentRound);
                cyclesToProcess.forEach(_function_1);
            }
        }
    }

    public Iterable<Set<TypeElement>> findCyclesInAnnotatedClasses(Set<TypeElement> annotatedClasses) {
        Iterable _xblockexpression = null;
        Functions.Function1 _function = it -> it.getQualifiedName().toString();
        Map byFqn = IterableExtensions.toMap(annotatedClasses, (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> !this.typesRegistry.dependOnOtherAnnotatedClasses((Set<String>)it) && !this.typesRegistry.dependOnUnknownTypes((Set<String>)it);
        Functions.Function1 _function_2 = it -> {
            Functions.Function1 _function_3 = it_1 -> (TypeElement)byFqn.get(it_1);
            return IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)it, (Functions.Function1)_function_3));
        };
        _xblockexpression = IterableExtensions.map((Iterable)IterableExtensions.filter(this.typesRegistry.findCyclesInAnnotatedClasses(byFqn.keySet()), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        return _xblockexpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processClassesAndWriteTypeElements(Set<TypeElement> classesToProcess, boolean isCycle, Map<TypeElement, Set<GenTypeElement>> generatedTypeElementsInCurrentRound, Set<TypeElement> annotatedClassesToDefer, Set<GenTypeElement> writtenTypeElementsInCurrentRound) {
        try {
            Functions.Function1 _function = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Classes to process: ");
                _builder.append((Object)classesToProcess);
                _builder.append(". Is cycle: ");
                _builder.append((Object)isCycle);
                return _builder.toString();
            };
            this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function);
            if (isCycle) {
                this.typesRegistry.startUsingUncomittedGenTypes();
            }
            HashMap generatedTypeElements = CollectionLiterals.newHashMap();
            int _xifexpression = 0;
            _xifexpression = isCycle ? classesToProcess.size() : 1;
            int repeats = _xifexpression;
            Consumer<Integer> _function_1 = it -> {
                generatedTypeElements.clear();
                Consumer<TypeElement> _function_2 = ac -> {
                    Map<GenTypeElement, TypeElement> generated = this.processAnnotatedClass((TypeElement)ac);
                    generatedTypeElements.putAll(generated);
                };
                classesToProcess.forEach(_function_2);
            };
            new IntegerRange(1, repeats).forEach(_function_1);
            BiConsumer<GenTypeElement, TypeElement> _function_2 = (gen, original) -> MoreCollectionExtensions.getOrCreateSet(generatedTypeElementsInCurrentRound, original).add(gen);
            generatedTypeElements.forEach(_function_2);
            HashSet<TypeElement> finishedAnnotatedClasses = new HashSet<TypeElement>(classesToProcess);
            if (!isCycle) {
                annotatedClassesToDefer.removeAll(classesToProcess);
                Functions.Function1 _function_3 = it -> this.typesRegistry.hasUnresolvedTypeDependencies(it.getQualifiedName().toString(), CollectionLiterals.emptySet());
                Iterables.addAll(annotatedClassesToDefer, (Iterable)IterableExtensions.filter(classesToProcess, (Functions.Function1)_function_3));
                Functions.Function1 _function_4 = ac -> {
                    Functions.Function1 _function_5 = otherAc -> {
                        Functions.Function1 _function_6 = it -> (AnnotationMirror)it.getKey();
                        return this.typesRegistry.hasGenericDependencyOnTriggerShadowAnnotation((TypeElement)ac, ListExtensions.map(this.getTriggerAnnotationsAndShadowFlag((TypeElement)otherAc), (Functions.Function1)_function_6));
                    };
                    return IterableExtensions.exists((Iterable)classesToProcess, (Functions.Function1)_function_5);
                };
                Iterables.addAll(annotatedClassesToDefer, (Iterable)IterableExtensions.filter(classesToProcess, (Functions.Function1)_function_4));
            } else {
                Functions.Function1 _function_5 = it -> it.getQualifiedName().toString();
                Set annotatedClassesInCycle = IterableExtensions.toSet((Iterable)IterableExtensions.map(classesToProcess, (Functions.Function1)_function_5));
                Functions.Function1 _function_6 = it -> this.typesRegistry.hasUnresolvedTypeDependencies(it.getQualifiedName().toString(), annotatedClassesInCycle);
                boolean _exists = IterableExtensions.exists(classesToProcess, (Functions.Function1)_function_6);
                if (_exists) {
                    annotatedClassesToDefer.addAll(classesToProcess);
                } else {
                    annotatedClassesToDefer.removeAll(classesToProcess);
                }
            }
            finishedAnnotatedClasses.removeAll(annotatedClassesToDefer);
            Functions.Function1 _function_7 = it -> this.getTriggerAnnotationsAndShadowFlag((TypeElement)it);
            Functions.Function1 _function_8 = it -> (AnnotationMirror)it.getKey();
            Iterable processedTriggerAnnotations = IterableExtensions.map((Iterable)IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map(finishedAnnotatedClasses, (Functions.Function1)_function_7))), (Functions.Function1)_function_8);
            Iterable<TypeElement> annotatedClassesDependingGenericallyOnProcessedTriggerAnnotations = this.typesRegistry.getAnnotatedClassesDependingGenericallyOnThatTriggerAnnotations(processedTriggerAnnotations);
            Iterables.addAll(annotatedClassesToDefer, annotatedClassesDependingGenericallyOnProcessedTriggerAnnotations);
            Functions.Function1 _function_9 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Defer or wake up annotated classes that depend generically on processed annotations ");
                _builder.append((Object)processedTriggerAnnotations);
                _builder.append(": ");
                _builder.append((Object)annotatedClassesDependingGenericallyOnProcessedTriggerAnnotations);
                return _builder.toString();
            };
            this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_9);
            Functions.Function2 _function_10 = (genClass, original) -> {
                boolean _contains = annotatedClassesToDefer.contains(original);
                return !_contains;
            };
            Map genClassesToWrite = MapExtensions.filter((Map)generatedTypeElements, (Functions.Function2)_function_10);
            BiConsumer<GenTypeElement, TypeElement> _function_11 = (genClass, original) -> {
                try {
                    this.writeSourceFileAndCommitTypeElement((GenTypeElement)genClass, (TypeElement)original, writtenTypeElementsInCurrentRound);
                }
                catch (Throwable _t) {
                    if (_t instanceof TypeElementNotFoundException) {
                        TypeElementNotFoundException e = (TypeElementNotFoundException)_t;
                        annotatedClassesToDefer.add((TypeElement)original);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            };
            genClassesToWrite.forEach(_function_11);
        }
        finally {
            this.typesRegistry.stopUsingUncommitedGenTypes();
            Functions.Function1 _function_12 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("AnnotatedClassesToDefer: ");
                _builder.append((Object)annotatedClassesToDefer);
                _builder.append(". GeneratedTypeElementsInCurrentRound: ");
                _builder.append((Object)generatedTypeElementsInCurrentRound);
                return _builder.toString();
            };
            this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_12);
        }
    }

    public void printAllErrors() {
        boolean _not;
        boolean _isEmpty = this.deferredClasses.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            BiConsumer<String, TypeElementNotFoundException> _function = (fqn, exc) -> {
                Functions.Function1 _function_1 = it -> {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("For ");
                    _builder.append(fqn);
                    _builder.append(", code generation has failed partially or completely due to errors.");
                    return _builder.toString();
                };
                this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_1);
            };
            this.deferredClasses.forEach(_function);
        }
        this.messageCollector.printAllMessages();
    }

    public Object writeSourceFileAndCommitTypeElement(GenTypeElement genTypeElement, TypeElement original, Set<GenTypeElement> writtenTypeElementsInCurrentRound) {
        Functions.Function1 _function = it -> {
            Object _xblockexpression = null;
            this.generateClassContext.setCurrentAnnotatedClass(original);
            try {
                boolean _writeSourceFile = this.writeSourceFile(genTypeElement, original);
                if (_writeSourceFile) {
                    writtenTypeElementsInCurrentRound.add(genTypeElement);
                }
                this.typesRegistry.commitGeneratedTypeElement(genTypeElement);
            }
            catch (Throwable _t) {
                if (_t instanceof TypeElementNotFoundException) {
                    TypeElementNotFoundException e = (TypeElementNotFoundException)_t;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Type ");
                    String _fqn = e.getFqn();
                    _builder.append(_fqn);
                    _builder.append(" not found when writing source file for ");
                    Name _qualifiedName = genTypeElement.getQualifiedName();
                    _builder.append((Object)_qualifiedName);
                    this.typesRegistry.handleTypeElementNotFound((CharSequence)_builder, e.getFqn(), original);
                    throw e;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            _xblockexpression = null;
            return _xblockexpression;
        };
        return this.elSupport.scope(_function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<GenTypeElement, TypeElement> processAnnotatedClass(TypeElement annotatedClass) {
        Map _xtrycatchfinallyexpression;
        block7: {
            _xtrycatchfinallyexpression = null;
            try {
                HashMap _xblockexpression = null;
                this.generateClassContext.setCurrentAnnotatedClass(annotatedClass);
                HashMap generatedTopLevelClasses = CollectionLiterals.newHashMap();
                this.messageCollector.removeMessagesForAnnotatedClass(annotatedClass.getQualifiedName().toString());
                this.typesRegistry.removeDependenciesForAnnotatedClass(annotatedClass.getQualifiedName().toString());
                Consumer<GenTypeElement> _function = it -> generatedTopLevelClasses.put(it, annotatedClass);
                this.processTriggerAnnotations(annotatedClass).forEach(_function);
                _xblockexpression = generatedTopLevelClasses;
                _xtrycatchfinallyexpression = _xblockexpression;
            }
            catch (Throwable _t) {
                if (_t instanceof ReportedException) {
                    ReportedException re = (ReportedException)_t;
                    _xtrycatchfinallyexpression = CollectionLiterals.emptyMap();
                    break block7;
                }
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    Map _xblockexpression_1 = null;
                    this.messageCollector.reportError("Unexpected Exception when processing annotated class:", e, annotatedClass, null, null);
                    _xtrycatchfinallyexpression = _xblockexpression_1 = CollectionLiterals.emptyMap();
                    break block7;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            finally {
                this.generateClassContext.setCurrentAnnotatedClass(null);
            }
        }
        return _xtrycatchfinallyexpression;
    }

    private Set<GenTypeElement> processTriggerAnnotations(TypeElement annotatedClass) {
        Set _xblockexpression = null;
        List<Pair<AnnotationMirror, Boolean>> triggerAnnotations = this.getTriggerAnnotationsAndShadowFlag(annotatedClass);
        Functions.Function1 _function = it -> {
            Boolean _value = (Boolean)it.getValue();
            return _value == false;
        };
        Functions.Function1 _function_1 = it -> {
            Set<GenTypeElement> _emptySet;
            Set<GenTypeElement> _xblockexpression_1 = null;
            TriggerAnnotationRule triggerAnnotationRule = null;
            try {
                triggerAnnotationRule = this.ruleFactory.createTriggerAnnotationRule(this.elementsExtensions.annotationAsTypeElement((AnnotationMirror)it.getKey()));
            }
            catch (Throwable _t) {
                if (_t instanceof TypeElementNotFoundException) {
                    TypeElementNotFoundException tenfe = (TypeElementNotFoundException)_t;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Type ");
                    String _fqn = tenfe.getFqn();
                    _builder.append(_fqn);
                    _builder.append(" not found when creating trigger annotation rule ");
                    String _qualifiedName = this.typesExtensions.qualifiedName(((AnnotationMirror)it.getKey()).getAnnotationType());
                    _builder.append(_qualifiedName);
                    this.typesRegistry.handleTypeElementNotFound((CharSequence)_builder, tenfe.getFqn());
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            Set<GenTypeElement> _elvis = null;
            Set<GenTypeElement> _processTriggerAnnotation = null;
            if (triggerAnnotationRule != null) {
                _processTriggerAnnotation = triggerAnnotationRule.processTriggerAnnotation(annotatedClass, (AnnotationMirror)it.getKey());
            }
            _elvis = _processTriggerAnnotation != null ? _processTriggerAnnotation : (_emptySet = CollectionLiterals.emptySet());
            _xblockexpression_1 = _elvis;
            return _xblockexpression_1;
        };
        _xblockexpression = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(triggerAnnotations, (Functions.Function1)_function), (Functions.Function1)_function_1)));
        return _xblockexpression;
    }

    public List<Pair<AnnotationMirror, Boolean>> getTriggerAnnotationsAndShadowFlag(TypeElement annotatedClass) {
        Functions.Function1 _function = it -> {
            boolean _isShadowAnnotation = this.annotationExtensions.isShadowAnnotation((AnnotationMirror)it);
            return Pair.of((Object)it, (Object)_isShadowAnnotation);
        };
        return IterableExtensions.toList((Iterable)ListExtensions.map(this.annotationExtensions.getTriggerAnnotations(annotatedClass), (Functions.Function1)_function));
    }

    public boolean writeSourceFile(TypeElement typeElement, TypeElement orgClass) {
        try {
            boolean _not;
            boolean _xblockexpression = false;
            Functions.Function1 _function = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Try to write source file: ");
                Name _qualifiedName = typeElement.getQualifiedName();
                _builder.append((Object)_qualifiedName);
                return _builder.toString();
            };
            this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function);
            boolean _contains = this.writtenTypeElements.contains(typeElement.getQualifiedName().toString());
            boolean bl = _not = !_contains;
            if (_not) {
                JavaEmitter emitter = new JavaEmitter(typeElement);
                CharSequence code = emitter.compilationUnit();
                JavaFileObject file = this.processingEnv.getFiler().createSourceFile(typeElement.getQualifiedName(), orgClass);
                Writer writer = file.openWriter();
                writer.append(code);
                writer.close();
                Functions.Function1 _function_1 = it -> {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Source file written: ");
                    Name _qualifiedName = typeElement.getQualifiedName();
                    _builder.append((Object)_qualifiedName);
                    return _builder.toString();
                };
                this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_1);
            } else {
                Functions.Function1 _function_2 = it -> {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Source file ");
                    Name _qualifiedName = typeElement.getQualifiedName();
                    _builder.append((Object)_qualifiedName);
                    _builder.append(" already exists.");
                    return _builder.toString();
                };
                this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_2);
            }
            _xblockexpression = this.writtenTypeElements.add(typeElement.getQualifiedName().toString());
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

