/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.processor;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.japkit.model.CodeBody;
import de.japkit.model.EmitterContext;
import de.japkit.model.GenElement;
import de.japkit.model.GenExecutableElement;
import de.japkit.model.GenField;
import de.japkit.services.ElementsExtensions;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.TypesExtensions;
import de.japkit.services.TypesRegistry;
import de.japkit.util.MoreCollectionExtensions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class JavaEmitter
implements EmitterContext {
    @Extension
    private TypesRegistry typesRegistry = ExtensionRegistry.get(TypesRegistry.class);
    @Extension
    private TypesExtensions _typesExtensions = ExtensionRegistry.get(TypesExtensions.class);
    @Extension
    private ElementsExtensions _elementsExtensions = ExtensionRegistry.get(ElementsExtensions.class);
    public final Map<String, String> imports = CollectionLiterals.newHashMap();
    private TypeElement rootTypeElement;
    public final List<String> importOrder = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"java.", "javax.", "org.", "com.", "*"}));
    public final TreeSet<String> importGroupsLongestFirst = (TreeSet)ObjectExtensions.operator_doubleArrow((Object)CollectionLiterals.newTreeSet((s1, s2) -> {
        int _compareTo = Integer.valueOf(s1.length()).compareTo(s2.length());
        return -_compareTo;
    }), it -> it.addAll(this.importOrder));
    private ThreadLocal<TypeElement> currentTypeElement = new ThreadLocal();

    public CharSequence importIfPossibleAndGetNameForCode(TypeElement te, String shortName, String fqn) {
        String _xifexpression = null;
        boolean _importIfPossible = this.importIfPossible(shortName, fqn);
        if (_importIfPossible) {
            _xifexpression = shortName;
        } else {
            String _xifexpression_1 = null;
            if (te != null && te.getEnclosingElement() instanceof TypeElement) {
                String _xblockexpression = null;
                Element _enclosingElement = te.getEnclosingElement();
                TypeElement enclosing = (TypeElement)_enclosingElement;
                CharSequence _importIfPossibleAndGetNameForCode = this.importIfPossibleAndGetNameForCode(enclosing, enclosing.getSimpleName().toString(), enclosing.getQualifiedName().toString());
                String _plus = _importIfPossibleAndGetNameForCode + ".";
                _xifexpression_1 = _xblockexpression = _plus + shortName;
            } else {
                _xifexpression_1 = fqn;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public boolean importIfPossible(String shortName, String fqn) {
        boolean _xblockexpression = false;
        boolean _equals = Objects.equal((Object)shortName, (Object)fqn);
        if (_equals) {
            return true;
        }
        if (!this.imports.containsKey(shortName) && !this.isShadowedOrDeclared(this.currentTypeElement.get(), shortName)) {
            this.imports.put(shortName, fqn);
        }
        _xblockexpression = fqn.equals(this.imports.get(shortName)) || this.isDeclaredAndVisible(this.currentTypeElement.get(), shortName, fqn);
        return _xblockexpression;
    }

    public boolean isShadowedOrDeclared(TypeElement namespace, String shortName) {
        return IterableExtensions.exists(this._elementsExtensions.declaredTypes(namespace), it -> it.getSimpleName().toString().equals(shortName)) || namespace.getEnclosingElement() instanceof TypeElement && this.isShadowedOrDeclared((TypeElement)namespace.getEnclosingElement(), shortName);
    }

    public boolean isDeclaredAndVisible(TypeElement namespace, String shortName, String fqn) {
        boolean _xblockexpression = false;
        Functions.Function1 _function = it -> it.getSimpleName().toString().equals(shortName);
        TypeElement candidate = (TypeElement)IterableExtensions.findFirst(this._elementsExtensions.declaredTypes(namespace), (Functions.Function1)_function);
        boolean _xifexpression = false;
        if (candidate == null) {
            _xifexpression = namespace.getEnclosingElement() instanceof TypeElement && this.isDeclaredAndVisible((TypeElement)namespace.getEnclosingElement(), shortName, fqn);
        } else {
            boolean _xifexpression_1 = false;
            boolean _equals = candidate.getQualifiedName().toString().equals(fqn);
            _xifexpression_1 = _equals;
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public JavaEmitter(TypeElement rootTypeElement) {
        this.rootTypeElement = rootTypeElement;
    }

    public CharSequence compilationUnit() {
        StringConcatenation _xblockexpression = null;
        Name packageName = this.enclosingPackageName(this.rootTypeElement);
        CharSequence typeDecl = this.code(this.rootTypeElement);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append((Object)packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        CharSequence _importStatements = this.importStatements(this.rootTypeElement);
        _builder.append((Object)_importStatements);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)typeDecl);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence importStatements(TypeElement rootTypeElement) {
        StringConcatenation _xblockexpression = null;
        Functions.Function2 _function = (shortName, fqn) -> {
            boolean _not;
            boolean _and = false;
            boolean _isImplicitelyImported = this.isImplicitelyImported((String)fqn);
            boolean bl = _not = !_isImplicitelyImported;
            if (!_not) {
                _and = false;
            } else {
                boolean _not_1;
                StringConcatenation _builder = new StringConcatenation();
                Name _qualifiedName = rootTypeElement.getQualifiedName();
                _builder.append((Object)_qualifiedName);
                _builder.append(".");
                _builder.append(shortName);
                boolean _equals = fqn.equals(_builder.toString());
                _and = _not_1 = !_equals;
            }
            return _and;
        };
        Collection<String> fqnsToImport = MapExtensions.filter(this.imports, (Functions.Function2)_function).values();
        List<String> fqnsToImportOrdered = this.orderImports(fqnsToImport);
        StringConcatenation _builder = new StringConcatenation();
        for (String i : fqnsToImportOrdered) {
            _builder.append("import ");
            _builder.append(i);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public boolean isImplicitelyImported(String fqn) {
        return fqn.startsWith("java.lang.") && !fqn.substring("java.lang.".length()).contains(".");
    }

    public List<String> orderImports(Collection<String> fqnsToImport) {
        List _xblockexpression = null;
        HashMap fqnsToImportByGroup = CollectionLiterals.newHashMap();
        Consumer<String> _function = fqn -> {
            String _elvis = null;
            Functions.Function1 _function_1 = it -> fqn.startsWith((String)it);
            String _findFirst = (String)IterableExtensions.findFirst(this.importGroupsLongestFirst, (Functions.Function1)_function_1);
            _elvis = _findFirst != null ? _findFirst : "*";
            String group = _elvis;
            MoreCollectionExtensions.getOrCreateSortedSet(fqnsToImportByGroup, group).add(fqn);
        };
        fqnsToImport.forEach(_function);
        Functions.Function1 _function_1 = it -> {
            Set _elvis = null;
            SortedSet _get = (SortedSet)fqnsToImportByGroup.get(it);
            if (_get != null) {
                _elvis = _get;
            } else {
                Set _emptySet = CollectionLiterals.emptySet();
                _elvis = _emptySet;
            }
            return _elvis;
        };
        _xblockexpression = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map(this.importOrder, (Functions.Function1)_function_1)));
        return _xblockexpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CharSequence _code(TypeElement typeElement) {
        CharSequence _xtrycatchfinallyexpression = null;
        try {
            CharSequence _xblockexpression = null;
            this.currentTypeElement.set(typeElement);
            CharSequence _switchResult = null;
            ElementKind _kind = typeElement.getKind();
            if (_kind != null) {
                switch (_kind) {
                    case CLASS: {
                        _switchResult = this.codeForClass(typeElement);
                        break;
                    }
                    case INTERFACE: {
                        _switchResult = this.codeForInterface(typeElement);
                        break;
                    }
                    case ENUM: {
                        _switchResult = this.codeForEnum(typeElement);
                        break;
                    }
                    case ANNOTATION_TYPE: {
                        _switchResult = this.codeForAnnotationType(typeElement);
                        break;
                    }
                    default: {
                        _switchResult = this.unknownElement(typeElement);
                        break;
                    }
                }
            } else {
                _switchResult = this.unknownElement(typeElement);
            }
            _xtrycatchfinallyexpression = _xblockexpression = _switchResult;
        }
        finally {
            this.currentTypeElement.remove();
        }
        return _xtrycatchfinallyexpression;
    }

    public CharSequence codeForInterface(@Extension TypeElement element) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _docCommentCode = this.docCommentCode(element);
        _builder.append((Object)_docCommentCode);
        _builder.newLineIfNotEmpty();
        CharSequence _annotationsCode = this.annotationsCode(element);
        _builder.append((Object)_annotationsCode);
        _builder.newLineIfNotEmpty();
        CharSequence _modifiersCode = this.modifiersCode(element);
        _builder.append((Object)_modifiersCode);
        _builder.append("interface ");
        Name _simpleName = element.getSimpleName();
        _builder.append((Object)_simpleName);
        _builder.append(" ");
        CharSequence _typeParamsCode = this.typeParamsCode(element);
        _builder.append((Object)_typeParamsCode);
        CharSequence _codeForInterfaces = this.codeForInterfaces(element);
        _builder.append((Object)_codeForInterfaces);
        _builder.append("{");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _enclosedElementsCode = this.enclosedElementsCode(element);
        _builder.append((Object)_enclosedElementsCode, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence codeForAnnotationType(@Extension TypeElement element) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _docCommentCode = this.docCommentCode(element);
        _builder.append((Object)_docCommentCode);
        _builder.newLineIfNotEmpty();
        CharSequence _annotationsCode = this.annotationsCode(element);
        _builder.append((Object)_annotationsCode);
        _builder.newLineIfNotEmpty();
        CharSequence _modifiersCode = this.modifiersCode(element);
        _builder.append((Object)_modifiersCode);
        _builder.append("@interface ");
        Name _simpleName = element.getSimpleName();
        _builder.append((Object)_simpleName);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _enclosedElementsCode = this.enclosedElementsCode(element);
        _builder.append((Object)_enclosedElementsCode, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence codeForClass(@Extension TypeElement element) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _docCommentCode = this.docCommentCode(element);
        _builder.append((Object)_docCommentCode);
        _builder.newLineIfNotEmpty();
        CharSequence _annotationsCode = this.annotationsCode(element);
        _builder.append((Object)_annotationsCode);
        _builder.newLineIfNotEmpty();
        CharSequence _modifiersCode = this.modifiersCode(element);
        _builder.append((Object)_modifiersCode);
        _builder.append("class ");
        Name _simpleName = element.getSimpleName();
        _builder.append((Object)_simpleName);
        _builder.append(" ");
        CharSequence _typeParamsCode = this.typeParamsCode(element);
        _builder.append((Object)_typeParamsCode);
        CharSequence _codeForSuper = this.codeForSuper(element);
        _builder.append((Object)_codeForSuper);
        CharSequence _codeForInterfaces = this.codeForInterfaces(element);
        _builder.append((Object)_codeForInterfaces);
        _builder.append("{");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _enclosedElementsCode = this.enclosedElementsCode(element);
        _builder.append((Object)_enclosedElementsCode, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence codeForEnum(@Extension TypeElement element) {
        boolean _not;
        StringConcatenation _xblockexpression = null;
        Functions.Function1 _function = it -> {
            ElementKind _kind = it.getKind();
            return Objects.equal((Object)((Object)_kind), (Object)((Object)ElementKind.ENUM_CONSTANT));
        };
        Iterable enumConstants = IterableExtensions.filter(element.getEnclosedElements(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> {
            ElementKind _kind = it.getKind();
            return !Objects.equal((Object)((Object)_kind), (Object)((Object)ElementKind.ENUM_CONSTANT));
        };
        Iterable classBodyDeclarations = IterableExtensions.filter(element.getEnclosedElements(), (Functions.Function1)_function_1);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _docCommentCode = this.docCommentCode(element);
        _builder.append((Object)_docCommentCode);
        _builder.newLineIfNotEmpty();
        CharSequence _annotationsCode = this.annotationsCode(element);
        _builder.append((Object)_annotationsCode);
        _builder.newLineIfNotEmpty();
        CharSequence _modifiersCode = this.modifiersCode(element);
        _builder.append((Object)_modifiersCode);
        _builder.append("enum ");
        Name _simpleName = element.getSimpleName();
        _builder.append((Object)_simpleName);
        _builder.append(" ");
        CharSequence _codeForInterfaces = this.codeForInterfaces(element);
        _builder.append((Object)_codeForInterfaces);
        _builder.append("{");
        _builder.newLineIfNotEmpty();
        boolean _hasElements = false;
        for (Element ec : enumConstants) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",\n", "\t");
            }
            _builder.append("\t");
            CharSequence _docCommentCode_1 = this.docCommentCode(ec);
            _builder.append((Object)_docCommentCode_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _annotationsCode_1 = this.annotationsCode(ec);
            _builder.append((Object)_annotationsCode_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            Name _simpleName_1 = ec.getSimpleName();
            _builder.append((Object)_simpleName_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t");
        }
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)classBodyDeclarations);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        CharSequence _enclosedElementsCode = this.enclosedElementsCode(classBodyDeclarations);
        _builder.append((Object)_enclosedElementsCode, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence _docCommentCode(GenElement element) {
        boolean _tripleEquals;
        StringConcatenation _xifexpression = null;
        CharSequence _comment = element.getComment();
        boolean bl = _tripleEquals = _comment == null;
        if (_tripleEquals) {
            StringConcatenation _builder;
            _xifexpression = _builder = new StringConcatenation();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("/** ");
            CharSequence _comment_1 = element.getComment();
            _builder_1.append((Object)_comment_1);
            _builder_1.append(" */");
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    protected CharSequence _docCommentCode(Element element) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public CharSequence codeForInterfaces(TypeElement e) {
        StringConcatenation _xblockexpression = null;
        String _xifexpression = null;
        ElementKind _kind = e.getKind();
        boolean _equals = Objects.equal((Object)((Object)_kind), (Object)((Object)ElementKind.INTERFACE));
        _xifexpression = _equals ? "extends " : "implements ";
        String keyword = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        List<? extends TypeMirror> _interfaces = e.getInterfaces();
        boolean _hasElements = false;
        for (TypeMirror typeMirror : _interfaces) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(keyword);
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _typeRef = this.typeRef(typeMirror);
            _builder.append((Object)_typeRef);
        }
        if (_hasElements) {
            _builder.append(" ");
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence codeForSuper(TypeElement e) {
        StringConcatenation _builder = new StringConcatenation();
        if (e.getSuperclass() != null && !Objects.equal((Object)this._typesExtensions.qualifiedName(e.getSuperclass()), (Object)"java.lang.Object")) {
            _builder.append("extends ");
            CharSequence _typeRef = this.typeRef(e.getSuperclass());
            _builder.append((Object)_typeRef);
            _builder.append(" ");
        }
        return _builder;
    }

    protected CharSequence _code(@Extension VariableElement field) {
        boolean _not;
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        ElementKind _kind = field.getKind();
        boolean bl = _notEquals = !Objects.equal((Object)((Object)_kind), (Object)((Object)ElementKind.FIELD));
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Only fields are allowed here, not ");
            ElementKind _kind_1 = field.getKind();
            _builder.append((Object)_kind_1);
            _builder.append(". VariableElement: ");
            _builder.append((Object)field);
            throw new IllegalArgumentException(_builder.toString());
        }
        TypeMirror type = field.asType();
        CharSequence _constantExpressionCode = this.constantExpressionCode(field);
        String _string = null;
        if (_constantExpressionCode != null) {
            _string = _constantExpressionCode.toString();
        }
        String constantExpr = _string;
        StringConcatenation _builder_1 = new StringConcatenation();
        CharSequence _docCommentCode = this.docCommentCode(field);
        _builder_1.append((Object)_docCommentCode);
        _builder_1.newLineIfNotEmpty();
        CharSequence _annotationsCode = this.annotationsCode(field);
        _builder_1.append((Object)_annotationsCode);
        _builder_1.newLineIfNotEmpty();
        CharSequence _modifiersCode = this.modifiersCode(field);
        _builder_1.append((Object)_modifiersCode);
        CharSequence _typeRef = this.typeRef(type);
        _builder_1.append((Object)_typeRef);
        _builder_1.append(" ");
        Name _simpleName = field.getSimpleName();
        _builder_1.append((Object)_simpleName);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)constantExpr);
        boolean bl2 = _not = !_isNullOrEmpty;
        if (_not) {
            _builder_1.append(" = ");
            _builder_1.append(constantExpr);
        }
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _xblockexpression = _builder_1;
        return _xblockexpression;
    }

    protected CharSequence _constantExpressionCode(VariableElement field) {
        Object _constantValue = field.getConstantValue();
        String _constantExpression = null;
        if (_constantValue != null) {
            _constantExpression = this._elementsExtensions.getConstantExpression(_constantValue);
        }
        return _constantExpression;
    }

    protected CharSequence _constantExpressionCode(GenField field) {
        CodeBody _constantExpr = field.getConstantExpr();
        CharSequence _code = null;
        if (_constantExpr != null) {
            _code = _constantExpr.code(this);
        }
        return _code;
    }

    protected CharSequence _code(@Extension ExecutableElement ee) {
        CharSequence _switchResult = null;
        ElementKind _kind = ee.getKind();
        if (_kind != null) {
            switch (_kind) {
                case METHOD: {
                    _switchResult = this.codeForMethod(ee);
                    break;
                }
                case CONSTRUCTOR: {
                    _switchResult = this.codeForConstructor(ee);
                    break;
                }
                case STATIC_INIT: {
                    _switchResult = this.codeForStaticInitializer(ee);
                    break;
                }
                case INSTANCE_INIT: {
                    _switchResult = this.codeForInstanceInitializer(ee);
                    break;
                }
                default: {
                    _switchResult = this.unknownElement(ee);
                    break;
                }
            }
        } else {
            _switchResult = this.unknownElement(ee);
        }
        return _switchResult;
    }

    public CharSequence codeForInstanceInitializer(ExecutableElement element) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public CharSequence codeForStaticInitializer(ExecutableElement element) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public CharSequence codeForConstructor(@Extension ExecutableElement e) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _docCommentCode = this.docCommentCode(e);
        _builder.append((Object)_docCommentCode);
        _builder.newLineIfNotEmpty();
        CharSequence _annotationsCode = this.annotationsCode(e);
        _builder.append((Object)_annotationsCode);
        _builder.newLineIfNotEmpty();
        CharSequence _modifiersCode = this.modifiersCode(e);
        _builder.append((Object)_modifiersCode);
        CharSequence _typeParamsCode = this.typeParamsCode(e);
        _builder.append((Object)_typeParamsCode);
        Name _simpleName = e.getEnclosingElement().getSimpleName();
        _builder.append((Object)_simpleName);
        CharSequence _codeForParameters = this.codeForParameters(e);
        _builder.append((Object)_codeForParameters);
        CharSequence _codeForThrows = this.codeForThrows(e);
        _builder.append((Object)_codeForThrows);
        CharSequence _block = this.block(this.codeForBody(e));
        _builder.append((Object)_block);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence codeForMethod(@Extension ExecutableElement e) {
        StringConcatenation _xblockexpression = null;
        String _xifexpression = null;
        if (this.isAbstract(e) || Objects.equal((Object)((Object)e.getEnclosingElement().getKind()), (Object)((Object)ElementKind.INTERFACE))) {
            _xifexpression = ";";
        } else {
            String _xifexpression_1 = null;
            ElementKind _kind = e.getEnclosingElement().getKind();
            boolean _equals = Objects.equal((Object)((Object)_kind), (Object)((Object)ElementKind.ANNOTATION_TYPE));
            if (_equals) {
                boolean _tripleNotEquals;
                StringConcatenation _builder = new StringConcatenation();
                AnnotationValue _defaultValue = e.getDefaultValue();
                boolean bl = _tripleNotEquals = _defaultValue != null;
                if (_tripleNotEquals) {
                    _builder.append(" default ");
                    CharSequence _annotationValueCode = this.annotationValueCode(e.getDefaultValue());
                    _builder.append((Object)_annotationValueCode);
                }
                _builder.append(";");
                _xifexpression_1 = _builder.toString();
            } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                CharSequence _block = this.block(this.codeForBody(e));
                _builder_1.append((Object)_block);
                _xifexpression_1 = _builder_1.toString();
            }
            _xifexpression = _xifexpression_1;
        }
        String body = _xifexpression;
        StringConcatenation _builder_2 = new StringConcatenation();
        CharSequence _docCommentCode = this.docCommentCode(e);
        _builder_2.append((Object)_docCommentCode);
        _builder_2.newLineIfNotEmpty();
        CharSequence _annotationsCode = this.annotationsCode(e);
        _builder_2.append((Object)_annotationsCode);
        _builder_2.newLineIfNotEmpty();
        CharSequence _modifiersCode = this.modifiersCode(e);
        _builder_2.append((Object)_modifiersCode);
        CharSequence _typeParamsCode = this.typeParamsCode(e);
        _builder_2.append((Object)_typeParamsCode);
        CharSequence _typeRef = this.typeRef(e.getReturnType());
        _builder_2.append((Object)_typeRef);
        _builder_2.append(" ");
        Name _simpleName = e.getSimpleName();
        _builder_2.append((Object)_simpleName);
        CharSequence _codeForParameters = this.codeForParameters(e);
        _builder_2.append((Object)_codeForParameters);
        CharSequence _codeForThrows = this.codeForThrows(e);
        _builder_2.append((Object)_codeForThrows);
        _builder_2.append(body);
        _builder_2.newLineIfNotEmpty();
        _xblockexpression = _builder_2;
        return _xblockexpression;
    }

    public CharSequence codeForThrows(ExecutableElement e) {
        StringConcatenation _builder = new StringConcatenation();
        List<? extends TypeMirror> _thrownTypes = e.getThrownTypes();
        boolean _hasElements = false;
        for (TypeMirror typeMirror : _thrownTypes) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(" throws ");
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _typeRef = this.typeRef(typeMirror);
            _builder.append((Object)_typeRef);
        }
        if (_hasElements) {
            _builder.append(" ");
        }
        return _builder;
    }

    protected CharSequence _codeForBody(GenExecutableElement e) {
        boolean _tripleNotEquals;
        CharSequence _xifexpression = null;
        CodeBody _body = e.getBody();
        boolean bl = _tripleNotEquals = _body != null;
        if (_tripleNotEquals) {
            _xifexpression = e.getBody().code(this);
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("throw new UnsupportedOperationException(\"Method not implemented\");");
            _xifexpression = _builder;
        }
        return _xifexpression;
    }

    protected CharSequence _codeForBody(ExecutableElement e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("throw new UnsupportedOperationException(\"Method not implemented\");");
        return _builder;
    }

    public CharSequence block(CharSequence statements) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append((Object)statements, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence codeForParameters(ExecutableElement ee) {
        Functions.Function1 _function = it -> this.codeForParameter((VariableElement)it);
        return this.codeListInlineOrWithLinebreaks(IterableExtensions.toList((Iterable)ListExtensions.map(ee.getParameters(), (Functions.Function1)_function)), "(", ",", ")");
    }

    public CharSequence codeForParameter(@Extension VariableElement p) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _annotationsCodeInline = this.annotationsCodeInline(p);
        _builder.append((Object)_annotationsCodeInline);
        CharSequence _modifiersCode = this.modifiersCode(p);
        _builder.append((Object)_modifiersCode);
        CharSequence _typeRef = this.typeRef(p.asType());
        _builder.append((Object)_typeRef);
        _builder.append(" ");
        Name _simpleName = p.getSimpleName();
        _builder.append((Object)_simpleName);
        return _builder;
    }

    protected CharSequence _code(Element element) {
        return this.unknownElement(element);
    }

    @Override
    public CharSequence typeRef(TypeMirror type) {
        CharSequence _xifexpression = null;
        boolean _equals = this._typesExtensions.operator_equals(type, null);
        _xifexpression = _equals ? "Object" : type.accept(new SimpleTypeVisitor8<CharSequence, Void>(){

            @Override
            public CharSequence defaultAction(TypeMirror type, Void p) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("/* Unsuported type: ");
                String _string = type.toString();
                _builder.append(_string);
                _builder.append(" */ Object");
                return _builder;
            }

            @Override
            public CharSequence visitPrimitive(PrimitiveType type, Void p) {
                return type.getKind().toString().toLowerCase();
            }

            @Override
            public CharSequence visitNoType(NoType type, Void p) {
                return type.getKind().toString().toLowerCase();
            }

            @Override
            public CharSequence visitDeclared(DeclaredType type, Void p) {
                String result;
                String _xblockexpression = null;
                CharSequence _xifexpression = null;
                boolean _isError = JavaEmitter.this._typesExtensions.isError(JavaEmitter.this._typesExtensions.erasure(type));
                if (_isError) {
                    CharSequence _xblockexpression_1 = null;
                    String simpleName = JavaEmitter.this.typesRegistry.getSimpleNameForErrorType(JavaEmitter.this._typesExtensions.erasure(type));
                    String fqn = JavaEmitter.this.typesRegistry.tryToGetFqnForErrorType(JavaEmitter.this._typesExtensions.erasure(type));
                    _xifexpression = _xblockexpression_1 = JavaEmitter.this.importIfPossibleAndGetNameForCode(null, simpleName, fqn);
                } else {
                    CharSequence _xblockexpression_2 = null;
                    TypeElement te = JavaEmitter.this.typesRegistry.asTypeElement(JavaEmitter.this._typesExtensions.erasure(type));
                    _xifexpression = _xblockexpression_2 = JavaEmitter.this.importIfPossibleAndGetNameForCode(te, te.getSimpleName().toString(), te.getQualifiedName().toString());
                }
                CharSequence rawType = _xifexpression;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)rawType);
                List<? extends TypeMirror> _typeArguments = type.getTypeArguments();
                boolean _hasElements = false;
                for (TypeMirror typeMirror : _typeArguments) {
                    if (!_hasElements) {
                        _hasElements = true;
                        _builder.append("<");
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    CharSequence _typeRef = JavaEmitter.this.typeRef(typeMirror);
                    _builder.append((Object)_typeRef);
                }
                if (_hasElements) {
                    _builder.append(">");
                }
                _xblockexpression = result = _builder.toString();
                return _xblockexpression;
            }

            @Override
            public CharSequence visitError(ErrorType type, Void p) {
                return this.visitDeclared((DeclaredType)type, p);
            }

            @Override
            public CharSequence visitWildcard(WildcardType type, Void p) {
                boolean _tripleNotEquals;
                String _xifexpression = null;
                TypeMirror _extendsBound = type.getExtendsBound();
                boolean bl = _tripleNotEquals = _extendsBound != null;
                if (_tripleNotEquals) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("? extends ");
                    CharSequence _typeRef = JavaEmitter.this.typeRef(type.getExtendsBound());
                    _builder.append((Object)_typeRef);
                    _xifexpression = _builder;
                } else {
                    boolean _tripleNotEquals_1;
                    String _xifexpression_1 = null;
                    TypeMirror _superBound = type.getSuperBound();
                    boolean bl2 = _tripleNotEquals_1 = _superBound != null;
                    if (_tripleNotEquals_1) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("? super ");
                        CharSequence _typeRef_1 = JavaEmitter.this.typeRef(type.getSuperBound());
                        _builder_1.append((Object)_typeRef_1);
                        _xifexpression_1 = _builder_1;
                    } else {
                        _xifexpression_1 = "?";
                    }
                    _xifexpression = _xifexpression_1;
                }
                return _xifexpression;
            }

            @Override
            public CharSequence visitArray(ArrayType type, Void p) {
                StringConcatenation _builder = new StringConcatenation();
                CharSequence _typeRef = JavaEmitter.this.typeRef(type.getComponentType());
                _builder.append((Object)_typeRef);
                _builder.append(" []");
                return _builder;
            }
        }, null);
        return _xifexpression;
    }

    @Override
    public CharSequence staticTypeRef(TypeMirror type) {
        CharSequence _xifexpression = null;
        if (type == null) {
            _xifexpression = "void";
        } else {
            CharSequence _xblockexpression = null;
            TypeElement _xifexpression_1 = null;
            boolean _isDeclared = this._typesExtensions.isDeclared(type);
            _xifexpression_1 = _isDeclared ? this.typesRegistry.asTypeElement(type) : null;
            TypeElement te = _xifexpression_1;
            _xblockexpression = this.importIfPossibleAndGetNameForCode(te, this._typesExtensions.simpleName(type).toString(), this._typesExtensions.qualifiedName(type).toString());
            _xifexpression = _xblockexpression;
        }
        return _xifexpression;
    }

    @Override
    public boolean importIfPossible(DeclaredType type) {
        return this.importIfPossible(this._typesExtensions.simpleName(type).toString(), this._typesExtensions.qualifiedName(type).toString());
    }

    public CharSequence staticTypeRef(TypeElement type) {
        return this.importIfPossibleAndGetNameForCode(type, type.getSimpleName().toString(), type.getQualifiedName().toString());
    }

    private CharSequence enclosedElementsCode(Element element) {
        return this.enclosedElementsCode(element.getEnclosedElements());
    }

    private CharSequence enclosedElementsCode(Iterable<? extends Element> enclosedelements) {
        StringConcatenation _builder = new StringConcatenation();
        for (Element element : enclosedelements) {
            CharSequence _code = this.code(element);
            _builder.append((Object)_code);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence modifiersCode(Element element) {
        StringConcatenation _xblockexpression = null;
        Functions.Function1 _function = it -> it.ordinal();
        List orderedModifiers = IterableExtensions.sortBy(element.getModifiers(), (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Modifier m : orderedModifiers) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" ", "");
            }
            _builder.append((Object)m);
        }
        if (_hasElements) {
            _builder.append(" ");
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence annotationsCode(Element element) {
        StringConcatenation _builder = new StringConcatenation();
        List<? extends AnnotationMirror> _annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : _annotationMirrors) {
            CharSequence _annotationCode = this.annotationCode(annotationMirror);
            _builder.append((Object)_annotationCode);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence annotationsCodeInline(Element element) {
        StringConcatenation _builder = new StringConcatenation();
        List<? extends AnnotationMirror> _annotationMirrors = element.getAnnotationMirrors();
        boolean _hasElements = false;
        for (AnnotationMirror annotationMirror : _annotationMirrors) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" ", "");
            }
            CharSequence _annotationCode = this.annotationCode(annotationMirror);
            _builder.append((Object)_annotationCode);
        }
        if (_hasElements) {
            _builder.append(" ");
        }
        return _builder;
    }

    public CharSequence annotationCode(AnnotationMirror a) {
        StringConcatenation _xblockexpression = null;
        CharSequence typeName = this.staticTypeRef(a.getAnnotationType());
        Set<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> values = a.getElementValues().entrySet();
        CharSequence _xifexpression = null;
        boolean _isEmpty = values.isEmpty();
        if (_isEmpty) {
            _xifexpression = "";
        } else {
            CharSequence _xifexpression_1 = null;
            if (values.size() == 1 && ((ExecutableElement)((Map.Entry)IterableExtensions.head(values)).getKey()).getSimpleName().contentEquals("value")) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("(");
                CharSequence _annotationValueCode = this.annotationValueCode(((Map.Entry)IterableExtensions.head(values)).getValue());
                _builder.append((Object)_annotationValueCode);
                _builder.append(")");
                _xifexpression_1 = _builder.toString();
            } else {
                CharSequence _xblockexpression_1 = null;
                Functions.Function1 _function = av -> {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    Name _simpleName = ((ExecutableElement)av.getKey()).getSimpleName();
                    _builder_1.append((Object)_simpleName);
                    _builder_1.append(" = ");
                    CharSequence _annotationValueCode_1 = this.annotationValueCode(av.getValue());
                    _builder_1.append((Object)_annotationValueCode_1);
                    return _builder_1.toString();
                };
                List avCode = IterableExtensions.toList((Iterable)IterableExtensions.map(values, (Functions.Function1)_function));
                _xifexpression_1 = _xblockexpression_1 = this.codeListInlineOrWithLinebreaks(avCode, "(", ",", ")");
            }
            _xifexpression = _xifexpression_1;
        }
        String elementValuePairs = _xifexpression;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("@");
        _builder_1.append((Object)typeName);
        _builder_1.append((Object)elementValuePairs);
        _xblockexpression = _builder_1;
        return _xblockexpression;
    }

    public CharSequence codeListInlineOrWithLinebreaks(Iterable<? extends CharSequence> codeList, String before, String separator, String after) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(before);
        StringConcatenation _codeListInlineOrWithLinebreaks = this.codeListInlineOrWithLinebreaks(codeList, separator);
        _builder.append(_codeListInlineOrWithLinebreaks);
        _builder.append(after);
        return _builder;
    }

    public StringConcatenation codeListInlineOrWithLinebreaks(Iterable<? extends CharSequence> codeList, String separator) {
        StringConcatenation _xblockexpression = null;
        Integer _elvis = null;
        Functions.Function1 _function = it -> it.length();
        Functions.Function2 _function_1 = (l1, l2) -> l1 + l2;
        Integer _reduce = (Integer)IterableExtensions.reduce((Iterable)IterableExtensions.map(codeList, (Functions.Function1)_function), (Functions.Function2)_function_1);
        _elvis = _reduce != null ? _reduce : Integer.valueOf(0);
        Integer codeLength = _elvis;
        StringConcatenation sc = new StringConcatenation();
        StringConcatenation _xifexpression = null;
        if (codeLength < 150) {
            StringConcatenation _builder = new StringConcatenation();
            boolean _hasElements = false;
            for (CharSequence charSequence : codeList) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)(separator + " "), "");
                }
                _builder.append((Object)charSequence);
            }
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            boolean _hasElements_1 = false;
            for (CharSequence charSequence : codeList) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder_1.appendImmediate((Object)(separator + StringConcatenation.DEFAULT_LINE_DELIMITER), "");
                }
                _builder_1.append((Object)charSequence);
            }
            _xifexpression = _builder_1;
        }
        sc.append((Object)_xifexpression, "\t\t");
        _xblockexpression = sc;
        return _xblockexpression;
    }

    protected CharSequence _annotationValueCode(AnnotationValue value) {
        return this.annotationValueCode(value.getValue());
    }

    protected CharSequence _annotationValueCode(String value) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        String _escapeJava = StringEscapeUtils.escapeJava((String)value);
        _builder.append(_escapeJava);
        _builder.append("\"");
        return _builder;
    }

    protected CharSequence _annotationValueCode(TypeMirror type) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _staticTypeRef = this.staticTypeRef(type);
        _builder.append((Object)_staticTypeRef);
        _builder.append(".class");
        return _builder;
    }

    protected CharSequence _annotationValueCode(VariableElement ve) {
        StringConcatenation _builder = new StringConcatenation();
        Element _enclosingElement = ve.getEnclosingElement();
        CharSequence _staticTypeRef = this.staticTypeRef((TypeElement)_enclosingElement);
        _builder.append((Object)_staticTypeRef);
        _builder.append(".");
        Name _simpleName = ve.getSimpleName();
        _builder.append((Object)_simpleName);
        return _builder;
    }

    protected CharSequence _annotationValueCode(AnnotationMirror a) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _annotationCode = this.annotationCode(a);
        _builder.append((Object)_annotationCode);
        return _builder;
    }

    protected CharSequence _annotationValueCode(Void a) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("null");
        return _builder;
    }

    protected CharSequence _annotationValueCode(List<? extends AnnotationValue> values) {
        boolean _equals;
        CharSequence _xifexpression = null;
        int _size = values.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            _xifexpression = this.annotationValueCode(IterableExtensions.head(values));
        } else {
            CharSequence _xblockexpression = null;
            Functions.Function1 _function = it -> this.annotationValueCode(it);
            List avCode = IterableExtensions.toList((Iterable)ListExtensions.map(values, (Functions.Function1)_function));
            _xifexpression = _xblockexpression = this.codeListInlineOrWithLinebreaks(avCode, "{", ",", "}");
        }
        return _xifexpression;
    }

    protected CharSequence _annotationValueCode(Object value) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(value);
        return _builder;
    }

    protected Iterable<? extends TypeParameterElement> _typeParams(Element e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)e);
        _builder.append(" does not support type parameters");
        throw new UnsupportedOperationException(_builder.toString());
    }

    protected Iterable<? extends TypeParameterElement> _typeParams(TypeElement e) {
        return e.getTypeParameters();
    }

    protected Iterable<? extends TypeParameterElement> _typeParams(ExecutableElement e) {
        return e.getTypeParameters();
    }

    public CharSequence typeParamsCode(Element e) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<? extends TypeParameterElement> _typeParams = this.typeParams(e);
        boolean _hasElements = false;
        for (TypeParameterElement typeParameterElement : _typeParams) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("<");
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _typeParamCode = this.typeParamCode(typeParameterElement);
            _builder.append((Object)_typeParamCode);
        }
        if (_hasElements) {
            _builder.append("> ");
        }
        return _builder;
    }

    public CharSequence typeParamCode(TypeParameterElement tpe) {
        StringConcatenation _builder = new StringConcatenation();
        Name _simpleName = tpe.getSimpleName();
        _builder.append((Object)_simpleName);
        CharSequence _boundsCode = this.boundsCode(tpe);
        _builder.append((Object)_boundsCode);
        return _builder;
    }

    public CharSequence boundsCode(TypeParameterElement tpe) {
        StringConcatenation _xblockexpression = null;
        Functions.Function1 _function = it -> {
            String _qualifiedName = this._typesExtensions.qualifiedName((TypeMirror)it);
            return !Objects.equal((Object)_qualifiedName, (Object)"java.lang.Object");
        };
        Iterable bounds = IterableExtensions.filter(tpe.getBounds(), (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (TypeMirror b : bounds) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(" extends ");
            } else {
                _builder.appendImmediate((Object)" & ", "");
            }
            CharSequence _typeRef = this.typeRef(b);
            _builder.append((Object)_typeRef);
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence unknownElement(Element element) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**unsupported element: ");
        _builder.append((Object)element);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("*/");
        _builder.newLine();
        return _builder;
    }

    public boolean isAbstract(Element e) {
        return e.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public Name enclosingPackageName(TypeElement typeElement) {
        Name _xblockexpression = null;
        Element enclosingElement = typeElement.getEnclosingElement();
        if (enclosingElement == null || !(enclosingElement instanceof PackageElement)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Enclosing element of ");
            Name _simpleName = typeElement.getSimpleName();
            _builder.append((Object)_simpleName);
            _builder.append(" is not a package but ");
            _builder.append((Object)enclosingElement);
            throw new IllegalArgumentException(_builder.toString());
        }
        Name packageName = ((PackageElement)enclosingElement).getQualifiedName();
        if (packageName == null || packageName.length() == 0) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Default package not supported: ");
            Name _simpleName_1 = typeElement.getSimpleName();
            _builder_1.append((Object)_simpleName_1);
            throw new IllegalArgumentException(_builder_1.toString());
        }
        _xblockexpression = packageName;
        return _xblockexpression;
    }

    public CharSequence code(Element ee) {
        if (ee instanceof ExecutableElement) {
            return this._code((ExecutableElement)ee);
        }
        if (ee instanceof TypeElement) {
            return this._code((TypeElement)ee);
        }
        if (ee instanceof VariableElement) {
            return this._code((VariableElement)ee);
        }
        if (ee != null) {
            return this._code(ee);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ee).toString());
    }

    public CharSequence docCommentCode(Element element) {
        if (element instanceof GenElement) {
            return this._docCommentCode((GenElement)element);
        }
        if (element != null) {
            return this._docCommentCode(element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }

    public CharSequence constantExpressionCode(VariableElement field) {
        if (field instanceof GenField) {
            return this._constantExpressionCode((GenField)field);
        }
        if (field != null) {
            return this._constantExpressionCode(field);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(field).toString());
    }

    public CharSequence codeForBody(ExecutableElement e) {
        if (e instanceof GenExecutableElement) {
            return this._codeForBody((GenExecutableElement)e);
        }
        if (e != null) {
            return this._codeForBody(e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }

    public CharSequence annotationValueCode(Object values) {
        if (values instanceof List) {
            return this._annotationValueCode((List)values);
        }
        if (values instanceof VariableElement) {
            return this._annotationValueCode((VariableElement)values);
        }
        if (values instanceof String) {
            return this._annotationValueCode((String)values);
        }
        if (values instanceof TypeMirror) {
            return this._annotationValueCode((TypeMirror)values);
        }
        if (values == null) {
            return this._annotationValueCode((Void)null);
        }
        if (values instanceof AnnotationMirror) {
            return this._annotationValueCode((AnnotationMirror)values);
        }
        if (values instanceof AnnotationValue) {
            return this._annotationValueCode((AnnotationValue)values);
        }
        if (values != null) {
            return this._annotationValueCode(values);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(values).toString());
    }

    public Iterable<? extends TypeParameterElement> typeParams(Element e) {
        if (e instanceof ExecutableElement) {
            return this._typeParams((ExecutableElement)e);
        }
        if (e instanceof TypeElement) {
            return this._typeParams((TypeElement)e);
        }
        if (e != null) {
            return this._typeParams(e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }
}

