/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import de.japkit.rules.AbstractRule;
import de.japkit.rules.IParameterlessFunctionRule;
import de.japkit.services.RuleException;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public abstract class AbstractFunctionRule<T>
extends AbstractRule
implements IParameterlessFunctionRule<T> {
    private final Class<? extends T> type;
    private final List<Pair<Class<?>, String>> params;
    private final Functions.Function0<? extends T> errorValue;
    private static final Map<TypeKind, Class<?>> primitiveTypes = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)((Object)TypeKind.BOOLEAN), Boolean.TYPE), Pair.of((Object)((Object)TypeKind.INT), Integer.TYPE), Pair.of((Object)((Object)TypeKind.LONG), Long.TYPE), Pair.of((Object)((Object)TypeKind.SHORT), Short.TYPE), Pair.of((Object)((Object)TypeKind.CHAR), Character.TYPE), Pair.of((Object)((Object)TypeKind.FLOAT), Float.TYPE), Pair.of((Object)((Object)TypeKind.DOUBLE), Double.TYPE)}));

    public AbstractFunctionRule(AnnotationMirror metaAnnotation, Element metaElement, Class<? extends T> type) {
        this(metaAnnotation, metaElement, type, null);
    }

    public AbstractFunctionRule(AnnotationMirror metaAnnotation, Element metaElement, Class<? extends T> type, Functions.Function0<? extends T> errorValue) {
        super(metaAnnotation, metaElement);
        this.params = this.createParams(metaElement);
        Class<Object> _elvis = null;
        Class<? extends T> _elvis_1 = null;
        if (type != null) {
            _elvis_1 = type;
        } else {
            TypeMirror _value = null;
            if (metaAnnotation != null) {
                _value = this._elementsExtensions.value(metaAnnotation, "type", TypeMirror.class);
            }
            Class<?> _loadClass = null;
            if (_value != null) {
                _loadClass = this.loadClass(_value);
            }
            _elvis_1 = _loadClass;
        }
        _elvis = _elvis_1 != null ? _elvis_1 : Object.class;
        this.type = _elvis;
        this.errorValue = errorValue;
    }

    public List<Pair<Class<?>, String>> createParams(Element element) {
        List _xifexpression = null;
        if (element instanceof ExecutableElement) {
            Functions.Function1 _function = p -> {
                Class<?> _loadClass = this.loadClass(p.asType());
                String _string = p.getSimpleName().toString();
                return Pair.of(_loadClass, (Object)_string);
            };
            _xifexpression = ListExtensions.map(this._elementsExtensions.parametersWithSrcNames((ExecutableElement)element), (Functions.Function1)_function);
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    public boolean mustBeCalledWithParams() {
        return this.params != null;
    }

    public T eval(Object src) {
        T _xblockexpression = null;
        if (this.params != null) {
            Element _metaElement = this.getMetaElement();
            String _plus = "A function with params must be called using the evalWithParams method " + _metaElement;
            String _plus_1 = _plus + " ";
            AnnotationMirror _metaAnnotation = this.getMetaAnnotation();
            String _plus_2 = _plus_1 + _metaAnnotation;
            String _plus_3 = _plus_2 + " ";
            String _plus_4 = _plus_3 + src;
            throw new IllegalStateException(_plus_4);
        }
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> {
                Functions.Function0 _function_2 = () -> this.evalInternal();
                return this._ruleUtils.handleException(this.errorValue, null, _function_2);
            };
            return this._eLSupport.scope(src, _function_1);
        };
        _xblockexpression = this.inRule(_function);
        return _xblockexpression;
    }

    public T evalWithParams(Object[] args) {
        Functions.Function1 _function = it -> {
            Functions.Function0 _function_1 = () -> {
                boolean _notEquals;
                Object _xblockexpression = null;
                if (this.params == null) {
                    throw new RuleException("A function without params cannot be called using the evalWithParams method");
                }
                int _length = args.length;
                int _length_1 = ((Object[])Conversions.unwrapArray(this.params, Object.class)).length;
                boolean bl = _notEquals = _length != _length_1;
                if (_notEquals) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("The function requires ");
                    int _length_2 = ((Object[])Conversions.unwrapArray(this.params, Object.class)).length;
                    _builder.append((Object)_length_2);
                    _builder.append(" parameters but only ");
                    int _length_3 = args.length;
                    _builder.append((Object)_length_3);
                    _builder.append(" are passed in.");
                    throw new RuleException(_builder.toString());
                }
                Functions.Function1 _function_2 = it_1 -> {
                    Object _xblockexpression_1 = null;
                    int _length_4 = args.length;
                    Consumer<Integer> _function_3 = it_2 -> this._eLSupport.getValueStack().put((String)this.params.get((int)it_2).getValue(), args[it_2]);
                    new ExclusiveRange(0, _length_4, true).forEach(_function_3);
                    _xblockexpression_1 = this.evalInternal();
                    return _xblockexpression_1;
                };
                _xblockexpression = this._eLSupport.scope(_function_2);
                return _xblockexpression;
            };
            return this._ruleUtils.handleException(this.errorValue, null, _function_1);
        };
        return this.inRule(_function);
    }

    protected abstract T evalInternal();

    public T apply(Object src) {
        return this.eval(src);
    }

    public T apply() {
        return this.eval(this._eLSupport.getCurrentSrc());
    }

    private Class<?> loadClass(final TypeMirror type) {
        Class _accept = null;
        if (type != null) {
            _accept = (Class)type.accept(new SimpleTypeVisitor8<Class<?>, Void>(){

                @Override
                public Class<?> defaultAction(TypeMirror t, Void p) {
                    throw new IllegalArgumentException("Cannot load class for type " + type);
                }

                @Override
                public Class<?> visitDeclared(DeclaredType type2, Void p) {
                    try {
                        String _elvis = null;
                        TypeElement _asTypeElement = null;
                        if (type2 != null) {
                            _asTypeElement = AbstractFunctionRule.this._typesRegistry.asTypeElement(type2);
                        }
                        Name _qualifiedName = null;
                        if (_asTypeElement != null) {
                            _qualifiedName = _asTypeElement.getQualifiedName();
                        }
                        String _string = null;
                        if (_qualifiedName != null) {
                            _string = _qualifiedName.toString();
                        }
                        _elvis = _string != null ? _string : "java.lang.Object";
                        return Class.forName(_elvis);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }

                @Override
                public Class<?> visitError(ErrorType type2, Void p) {
                    return this.visitDeclared((DeclaredType)type2, p);
                }

                @Override
                public Class<?> visitArray(ArrayType type2, Void p) {
                    return Array.newInstance(AbstractFunctionRule.this.loadClass(type2.getComponentType()), 0).getClass();
                }

                @Override
                public Class<?> visitPrimitive(PrimitiveType type2, Void p) {
                    return (Class)primitiveTypes.get(type2);
                }
            }, null);
        }
        return _accept;
    }

    @Override
    @Pure
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + (this.errorValue == null ? 0 : this.errorValue.hashCode());
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractFunctionRule other = (AbstractFunctionRule)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        return !(this.errorValue == null ? other.errorValue != null : !this.errorValue.equals(other.errorValue));
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public Class<? extends T> getType() {
        return this.type;
    }

    @Pure
    public List<Pair<Class<?>, String>> getParams() {
        return this.params;
    }

    @Pure
    public Functions.Function0<? extends T> getErrorValue() {
        return this.errorValue;
    }
}

