/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import de.japkit.metaannotations.Trigger;
import de.japkit.model.GenAnnotationMirror;
import de.japkit.model.GenAnnotationValue;
import de.japkit.model.GenExtensions;
import de.japkit.services.ElementsExtensions;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.ProcessingException;
import de.japkit.services.TypeElementNotFoundException;
import de.japkit.services.TypesExtensions;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class AnnotationExtensions {
    @Extension
    private ElementsExtensions _elementsExtensions = ExtensionRegistry.get(ElementsExtensions.class);
    @Extension
    private final transient TypesExtensions _typesExtensions = ExtensionRegistry.get(TypesExtensions.class);
    public final String SHADOW_AV = "shadow";

    public List<GenAnnotationMirror> overrideAnnotations(Element overrideElement, List<GenAnnotationMirror> existingAnnotations) {
        ArrayList<GenAnnotationMirror> _xblockexpression = null;
        if (overrideElement == null) {
            return new ArrayList<GenAnnotationMirror>(existingAnnotations);
        }
        Functions.Function1 _function = am -> {
            Functions.Function1 _function_1 = it -> this._elementsExtensions.fqn((AnnotationMirror)it).equals(this._elementsExtensions.fqn((AnnotationMirror)am));
            boolean _exists = IterableExtensions.exists(overrideElement.getAnnotationMirrors(), (Functions.Function1)_function_1);
            return !_exists;
        };
        List _list = IterableExtensions.toList((Iterable)IterableExtensions.filter(existingAnnotations, (Functions.Function1)_function));
        ArrayList<GenAnnotationMirror> result = new ArrayList<GenAnnotationMirror>(_list);
        result.addAll(ExtensionRegistry.get(GenExtensions.class).copyAnnotations(overrideElement));
        _xblockexpression = result;
        return _xblockexpression;
    }

    public boolean isShadowAnnotation(AnnotationMirror am) {
        Boolean _value = null;
        if (am != null) {
            _value = this._elementsExtensions.value(am, this.SHADOW_AV, Boolean.class);
        }
        return Boolean.TRUE.equals(_value);
    }

    public GenAnnotationValue setShadowIfAppropriate(GenAnnotationMirror am) {
        GenAnnotationValue _xifexpression = null;
        boolean _shallSetShadow = this.shallSetShadow(am);
        if (_shallSetShadow) {
            GenAnnotationValue _genAnnotationValue = new GenAnnotationValue(true);
            _xifexpression = am.setValue(this.SHADOW_AV, _genAnnotationValue);
        }
        return _xifexpression;
    }

    private boolean shallSetShadow(GenAnnotationMirror am) {
        boolean _and = false;
        boolean _isTriggerAnnotation = this.isTriggerAnnotation(am);
        if (!_isTriggerAnnotation) {
            _and = false;
        } else {
            boolean _xblockexpression = false;
            ExecutableElement avMethod = am.getAVMethod(this.SHADOW_AV, false);
            if (avMethod == null || !this._typesExtensions.isBoolean(avMethod.getReturnType())) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("The annotation value '");
                _builder.append(this.SHADOW_AV);
                _builder.append("' could not be set on annotation ");
                DeclaredType _annotationType = am.getAnnotationType();
                _builder.append((Object)_annotationType);
                _builder.append(", since it is not declared in the annotation type or is not boolean.");
                throw new ProcessingException(_builder.toString(), null);
            }
            _and = _xblockexpression = true;
        }
        return _and;
    }

    public boolean isTriggerAnnotation(AnnotationMirror am) {
        boolean _xtrycatchfinallyexpression = false;
        try {
            _xtrycatchfinallyexpression = this._elementsExtensions.hasMetaAnnotation(am, Trigger.class.getName());
        }
        catch (Throwable _t) {
            if (_t instanceof TypeElementNotFoundException) {
                TypeElementNotFoundException e = (TypeElementNotFoundException)_t;
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    public boolean isTriggerAnnotation(TypeElement te) {
        AnnotationMirror _annotationMirror = this._elementsExtensions.annotationMirror((Element)te, Trigger.class.getName());
        return _annotationMirror != null;
    }

    public List<? extends AnnotationMirror> getTriggerAnnotations(TypeElement annotatedClass) {
        Functions.Function1 _function = it -> this.isTriggerAnnotation((AnnotationMirror)it);
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(annotatedClass.getAnnotationMirrors(), (Functions.Function1)_function));
    }
}

