/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import com.google.common.base.Objects;
import de.japkit.annotations.AnnotationTemplate;
import de.japkit.metaannotations.AnnotationMode;
import de.japkit.metaannotations.DefaultAnnotation;
import de.japkit.model.GenAnnotationMirror;
import de.japkit.model.GenAnnotationValue;
import de.japkit.model.GenExtensions;
import de.japkit.rules.AbstractRule;
import de.japkit.rules.AnnotationExtensions;
import de.japkit.rules.AnnotationValueMappingRule;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.GenerateClassContext;
import de.japkit.services.ProcessingException;
import de.japkit.services.ReportedException;
import de.japkit.services.RuleException;
import de.japkit.services.TypeElementNotFoundException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class AnnotationMappingRule
extends AbstractRule {
    @Extension
    private final transient AnnotationExtensions _annotationExtensions = ExtensionRegistry.get(AnnotationExtensions.class);
    private final String id;
    private final Functions.Function0<? extends Boolean> activationRule;
    private final DeclaredType targetAnnotation;
    private final AnnotationValueMappingRule[] valueMappings;
    private final AnnotationMode mode;
    private final Set<String> copyAnnotationsFqns;
    private final String[] copyAnnotationsFromPackages;
    private final boolean setShadowOnTriggerAnnotations;
    private final Functions.Function1<? super Functions.Function1<? super Object, ?>, ? extends Iterable<Object>> scopeRule;

    public void mapOrCopyAnnotations(List<GenAnnotationMirror> annotations) {
        Functions.Function1 _function = it -> {
            Iterable _xtrycatchfinallyexpression = null;
            try {
                boolean _not;
                Iterable _xblockexpression = null;
                Boolean _apply = (Boolean)this.activationRule.apply();
                boolean bl = _not = _apply == false;
                if (_not) {
                    return null;
                }
                Functions.Function1 _function_1 = it_1 -> {
                    boolean _equals;
                    boolean _not_1;
                    Object _xblockexpression_1 = null;
                    this.copyAnnotations(annotations);
                    String _name = DefaultAnnotation.class.getName();
                    String _qualifiedName = null;
                    if (this.targetAnnotation != null) {
                        _qualifiedName = this._typesExtensions.qualifiedName(this.targetAnnotation);
                    }
                    boolean bl = _not_1 = !(_equals = _name.equals(_qualifiedName));
                    if (_not_1) {
                        this.mapAnnotation(annotations);
                    }
                    _xblockexpression_1 = null;
                    return _xblockexpression_1;
                };
                _xtrycatchfinallyexpression = _xblockexpression = (Iterable)this.scopeRule.apply((Object)_function_1);
            }
            catch (Throwable _t) {
                if (_t instanceof TypeElementNotFoundException) {
                    TypeElementNotFoundException tenfe = (TypeElementNotFoundException)_t;
                    Object _xblockexpression_1 = null;
                    this._typesRegistry.handleTypeElementNotFound(tenfe, this._generateClassContext.currentAnnotatedClass());
                    _xblockexpression_1 = null;
                    _xtrycatchfinallyexpression = _xblockexpression_1;
                }
                if (_t instanceof ReportedException) {
                    ReportedException re = (ReportedException)_t;
                    _xtrycatchfinallyexpression = null;
                }
                if (_t instanceof RuntimeException) {
                    RuntimeException re_1 = (RuntimeException)_t;
                    Object _xblockexpression_2 = null;
                    this._messageCollector.reportRuleError("Error during annotation mapping." + re_1);
                    _xblockexpression_2 = null;
                    _xtrycatchfinallyexpression = _xblockexpression_2;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return _xtrycatchfinallyexpression;
        };
        this.inRule(_function);
    }

    private void copyAnnotations(List<GenAnnotationMirror> annotations) {
        if (!this.copyAnnotationsFqns.isEmpty() || !((List)Conversions.doWrapArray((Object)this.copyAnnotationsFromPackages)).isEmpty()) {
            Functions.Function1 _function = it -> this.shallCopyAnnotation((AnnotationMirror)it);
            Consumer<AnnotationMirror> _function_1 = it -> {
                try {
                    annotations.add(this.copyAnnotation((AnnotationMirror)it));
                }
                catch (Throwable _t) {
                    if (_t instanceof ProcessingException) {
                        ProcessingException e = (ProcessingException)_t;
                        this._messageCollector.reportError(e);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            };
            IterableExtensions.filter(this._eLSupport.getCurrentSrcElement().getAnnotationMirrors(), (Functions.Function1)_function).forEach(_function_1);
        }
    }

    private GenAnnotationMirror copyAnnotation(AnnotationMirror am) {
        GenAnnotationMirror _xblockexpression = null;
        GenerateClassContext GenerateClassContext2 = ExtensionRegistry.get(GenerateClassContext.class);
        GenAnnotationMirror _copy = GenExtensions.copy(am);
        Procedures.Procedure1 _function = it -> {
            String _qualifiedName_1;
            String _qualifiedName = this._typesExtensions.qualifiedName(it.getAnnotationType());
            boolean _equals = Objects.equal((Object)_qualifiedName, (Object)(_qualifiedName_1 = this._typesExtensions.qualifiedName(GenerateClassContext2.getCurrentTriggerAnnotation().getAnnotationType())));
            if (_equals) {
                GenerateClassContext2.putShadowAnnotation((AnnotationMirror)it);
            }
            if (this.setShadowOnTriggerAnnotations) {
                this._annotationExtensions.setShadowIfAppropriate((GenAnnotationMirror)it);
            }
        };
        _xblockexpression = (GenAnnotationMirror)ObjectExtensions.operator_doubleArrow((Object)_copy, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    private boolean shallCopyAnnotation(AnnotationMirror am) {
        boolean _not;
        boolean _and = false;
        boolean _isJapkitAnnotation = ExtensionRegistry.get(GenExtensions.class).isJapkitAnnotation(am);
        boolean bl = _not = !_isJapkitAnnotation;
        if (!_not) {
            _and = false;
        } else {
            boolean _or = false;
            boolean _contains = this.copyAnnotationsFqns.contains(this._typesExtensions.qualifiedName(am.getAnnotationType()));
            if (_contains) {
                _or = true;
            } else {
                boolean _xblockexpression = false;
                String packageFqn = this._elementsExtensions.getPackage(am.getAnnotationType().asElement()).getQualifiedName().toString();
                Functions.Function1 _function = it -> it.equals(packageFqn) || it.equals("*") || it.endsWith(".*") && packageFqn.equals(it.substring(0, it.length() - 2)) || it.endsWith(".**") && packageFqn.startsWith(it.substring(0, it.length() - 3));
                _or = _xblockexpression = IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)this.copyAnnotationsFromPackages)), (Functions.Function1)_function);
            }
            _and = _or;
        }
        return _and;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void mapAnnotation(List<GenAnnotationMirror> annotations) {
        Functions.Function1 _function = it -> this._elementsExtensions.hasFqn((AnnotationMirror)it, (CharSequence)this._typesExtensions.qualifiedName(this.targetAnnotation));
        GenAnnotationMirror am = (GenAnnotationMirror)IterableExtensions.findFirst(annotations, (Functions.Function1)_function);
        if (am == null) {
            GenAnnotationMirror _genAnnotationMirror;
            boolean _equals = Objects.equal((Object)this.mode, (Object)AnnotationMode.REMOVE);
            if (_equals) {
                return;
            }
            am = _genAnnotationMirror = new GenAnnotationMirror(this.targetAnnotation);
            annotations.add(am);
        } else {
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.id);
            if (_isNullOrEmpty) {
                AnnotationMode mode = this.mode;
                if (mode == null) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Annotation mapping mode ");
                    _builder_1.append((Object)this.mode);
                    _builder_1.append(" is not supported.");
                    throw new RuleException(_builder_1.toString());
                }
                switch (mode) {
                    case ERROR_IF_EXISTS: {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("The annotation ");
                        String _qualifiedName = this._typesExtensions.qualifiedName(this.targetAnnotation);
                        _builder.append(_qualifiedName);
                        _builder.append(" was already generated by another rule and the mapping mode is ");
                        _builder.append((Object)this.mode);
                        _builder.append(".");
                        throw new RuleException(_builder.toString());
                    }
                    case REPLACE: {
                        GenAnnotationMirror _genAnnotationMirror_1;
                        annotations.remove(am);
                        am = _genAnnotationMirror_1 = new GenAnnotationMirror(this.targetAnnotation);
                        annotations.add(am);
                        break;
                    }
                    case JOIN_LIST: {
                        GenAnnotationMirror _genAnnotationMirror_2;
                        am = _genAnnotationMirror_2 = new GenAnnotationMirror(this.targetAnnotation);
                        annotations.add(am);
                        break;
                    }
                    case REMOVE: {
                        annotations.remove(am);
                        return;
                    }
                    case MERGE: {
                        break;
                    }
                    case IGNORE: {
                        return;
                    }
                    default: {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("Annotation mapping mode ");
                        _builder_1.append((Object)this.mode);
                        _builder_1.append(" is not supported.");
                        throw new RuleException(_builder_1.toString());
                    }
                }
            } else {
                GenAnnotationMirror _genAnnotationMirror_3;
                am = _genAnnotationMirror_3 = new GenAnnotationMirror(this.targetAnnotation);
                annotations.add(am);
            }
        }
        GenAnnotationMirror anno = am;
        this._eLSupport.getValueStack().put("targetAnnotation", (Object)anno);
        Procedures.Procedure1 _function_1 = it -> {
            Consumer<AnnotationValueMappingRule> _function_2 = vm -> {
                Functions.Function1 _function_3 = avType -> vm.mapAnnotationValue(anno, (TypeMirror)avType);
                it.setValue(vm.getName(), (Functions.Function1<? super TypeMirror, ? extends GenAnnotationValue>)_function_3);
            };
            ((List)Conversions.doWrapArray((Object)this.valueMappings)).forEach(_function_2);
        };
        ObjectExtensions.operator_doubleArrow((Object)anno, (Procedures.Procedure1)_function_1);
    }

    public AnnotationMappingRule(AnnotationMirror am, Map<String, AnnotationMappingRule> annotationMappingsById) {
        super(am, null);
        this.id = this._elementsExtensions.value(am, "id", String.class);
        this.activationRule = this._ruleUtils.createActivationRule(am, null);
        this.targetAnnotation = this._elementsExtensions.value(am, "targetAnnotation", DeclaredType.class);
        Functions.Function1 _function = it -> new AnnotationValueMappingRule((AnnotationMirror)it, annotationMappingsById);
        this.valueMappings = (AnnotationValueMappingRule[])Conversions.unwrapArray((Object)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)this._elementsExtensions.value(am, "values", AnnotationMirror[].class))), (Functions.Function1)_function), AnnotationValueMappingRule.class);
        this.mode = this._elementsExtensions.value(am, "mode", AnnotationMode.class);
        this.scopeRule = this._ruleUtils.createScopeRule(am, null, null);
        Functions.Function1 _function_1 = it -> this._typesExtensions.qualifiedName((TypeMirror)it);
        this.copyAnnotationsFqns = IterableExtensions.toSet((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)this._elementsExtensions.value(am, "copyAnnotations", DeclaredType[].class))), (Functions.Function1)_function_1));
        this.copyAnnotationsFromPackages = this._elementsExtensions.value(am, "copyAnnotationsFromPackages", String[].class);
        this.setShadowOnTriggerAnnotations = this._elementsExtensions.value(am, "setShadowOnTriggerAnnotations", Boolean.class);
    }

    public AnnotationMappingRule(AnnotationMirror annotationTemplate, Element templateElement) {
        super(annotationTemplate, templateElement);
        this.id = null;
        this.setShadowOnTriggerAnnotations = false;
        this.activationRule = this._ruleUtils.createActivationRule(annotationTemplate, "_");
        this.targetAnnotation = this._elementsExtensions.value(this._elementsExtensions.metaAnnotation(annotationTemplate, AnnotationTemplate.class), "targetAnnotation", DeclaredType.class);
        Functions.Function1 _function = it -> it.getSimpleName();
        Functions.Function1 _function_1 = name -> {
            String _string = name.toString();
            return new AnnotationValueMappingRule(annotationTemplate, templateElement, _string);
        };
        this.valueMappings = (AnnotationValueMappingRule[])Conversions.unwrapArray((Object)ListExtensions.map((List)ListExtensions.map(this._elementsExtensions.declaredMethods(this._typesRegistry.asTypeElement(this.targetAnnotation)), (Functions.Function1)_function), (Functions.Function1)_function_1), AnnotationValueMappingRule.class);
        this.mode = AnnotationMode.JOIN_LIST;
        this.scopeRule = this._ruleUtils.createScopeRule(annotationTemplate, null, "_");
        this.copyAnnotationsFqns = CollectionLiterals.emptySet();
        this.copyAnnotationsFromPackages = (String[])Conversions.unwrapArray((Object)CollectionLiterals.emptyList(), String.class);
    }

    @Override
    @Pure
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.activationRule == null ? 0 : this.activationRule.hashCode());
        result = 31 * result + (this.targetAnnotation == null ? 0 : this.targetAnnotation.hashCode());
        result = 31 * result + (this.valueMappings == null ? 0 : Arrays.deepHashCode(this.valueMappings));
        result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
        result = 31 * result + (this.copyAnnotationsFqns == null ? 0 : this.copyAnnotationsFqns.hashCode());
        result = 31 * result + (this.copyAnnotationsFromPackages == null ? 0 : Arrays.deepHashCode(this.copyAnnotationsFromPackages));
        result = 31 * result + (this.setShadowOnTriggerAnnotations ? 1231 : 1237);
        result = 31 * result + (this.scopeRule == null ? 0 : this.scopeRule.hashCode());
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AnnotationMappingRule other = (AnnotationMappingRule)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.activationRule == null ? other.activationRule != null : !this.activationRule.equals(other.activationRule)) {
            return false;
        }
        if (this.targetAnnotation == null ? other.targetAnnotation != null : !this.targetAnnotation.equals(other.targetAnnotation)) {
            return false;
        }
        if (this.valueMappings == null ? other.valueMappings != null : !Arrays.deepEquals(this.valueMappings, other.valueMappings)) {
            return false;
        }
        if (this.mode == null ? other.mode != null : !this.mode.equals((Object)other.mode)) {
            return false;
        }
        if (this.copyAnnotationsFqns == null ? other.copyAnnotationsFqns != null : !this.copyAnnotationsFqns.equals(other.copyAnnotationsFqns)) {
            return false;
        }
        if (this.copyAnnotationsFromPackages == null ? other.copyAnnotationsFromPackages != null : !Arrays.deepEquals(this.copyAnnotationsFromPackages, other.copyAnnotationsFromPackages)) {
            return false;
        }
        if (other.setShadowOnTriggerAnnotations != this.setShadowOnTriggerAnnotations) {
            return false;
        }
        return !(this.scopeRule == null ? other.scopeRule != null : !this.scopeRule.equals(other.scopeRule));
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public String getId() {
        return this.id;
    }

    @Pure
    public Functions.Function0<? extends Boolean> getActivationRule() {
        return this.activationRule;
    }

    @Pure
    public DeclaredType getTargetAnnotation() {
        return this.targetAnnotation;
    }

    @Pure
    public AnnotationValueMappingRule[] getValueMappings() {
        return this.valueMappings;
    }

    @Pure
    public AnnotationMode getMode() {
        return this.mode;
    }

    @Pure
    public Set<String> getCopyAnnotationsFqns() {
        return this.copyAnnotationsFqns;
    }

    @Pure
    public String[] getCopyAnnotationsFromPackages() {
        return this.copyAnnotationsFromPackages;
    }

    @Pure
    public boolean isSetShadowOnTriggerAnnotations() {
        return this.setShadowOnTriggerAnnotations;
    }

    @Pure
    public Functions.Function1<? super Functions.Function1<? super Object, ?>, ? extends Iterable<Object>> getScopeRule() {
        return this.scopeRule;
    }
}

