/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.japkit.metaannotations.AVMode;
import de.japkit.model.GenAnnotationMirror;
import de.japkit.model.GenAnnotationValue;
import de.japkit.rules.AbstractRule;
import de.japkit.rules.AnnotationMappingRule;
import de.japkit.rules.RuleUtils;
import de.japkit.services.RuleException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class AnnotationValueMappingRule
extends AbstractRule {
    private final Functions.Function0<? extends Boolean> activationRule;
    private final String name;
    private final Object value;
    private final String expr;
    private final String errorAvName;
    private final String lang;
    private final Functions.Function0<? extends AnnotationMappingRule> lazyAnnotationMapping;
    private final AVMode mode;
    private final Functions.Function1<? super Functions.Function1<? super Object, ?>, ? extends Iterable<Object>> scopeRule;

    public GenAnnotationValue mapAnnotationValue(GenAnnotationMirror annotation, TypeMirror avType) {
        Functions.Function1 _function = it -> {
            AVMode mode;
            boolean _not;
            GenAnnotationValue _xblockexpression = null;
            GenAnnotationValue _valueWithoutDefault = null;
            if (annotation != null) {
                _valueWithoutDefault = annotation.getValueWithoutDefault(this.name);
            }
            GenAnnotationValue existingValue = _valueWithoutDefault;
            Boolean _apply = (Boolean)this.activationRule.apply();
            boolean bl = _not = _apply == false;
            if (_not) {
                return existingValue;
            }
            if (existingValue != null && (mode = this.mode) != null) {
                switch (mode) {
                    case ERROR_IF_EXISTS: {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("The annotation value ");
                        _builder.append(this.name);
                        _builder.append(" was already generated by another rule and the mapping mode is ");
                        _builder.append((Object)this.mode);
                        _builder.append(".");
                        throw new RuleException(_builder.toString());
                    }
                    case IGNORE: {
                        return existingValue;
                    }
                    case REMOVE: {
                        return null;
                    }
                    case REPLACE: {
                        break;
                    }
                    case JOIN_LIST: {
                        break;
                    }
                    case MERGE: {
                        break;
                    }
                }
            }
            if (this.value == null && this.expr == null && this.lazyAnnotationMapping == null) {
                return existingValue;
            }
            Functions.Function0 _function_1 = () -> {
                Object _xblockexpression_1 = null;
                ArrayList flatValues = CollectionLiterals.newArrayList();
                Functions.Function1 _function_2 = it_1 -> {
                    Object _xifexpression = null;
                    if (this.value != null) {
                        _xifexpression = this.value;
                    } else {
                        Object _xifexpression_1 = null;
                        if (this.lazyAnnotationMapping != null) {
                            ArrayList _xblockexpression_2 = null;
                            AnnotationMappingRule annotationMapping = (AnnotationMappingRule)this.lazyAnnotationMapping.apply();
                            ArrayList annotations = CollectionLiterals.newArrayList();
                            annotationMapping.mapOrCopyAnnotations(annotations);
                            _xblockexpression_2 = annotations;
                            _xifexpression_1 = _xblockexpression_2;
                        } else {
                            Object _xifexpression_2 = null;
                            if (this.expr == null) {
                                throw new IllegalStateException("Annotation value could not be determined.");
                            }
                            _xifexpression_2 = this.evaluateExpression(avType, this.expr);
                            _xifexpression_1 = _xifexpression_2;
                        }
                        _xifexpression = _xifexpression_1;
                    }
                    return _xifexpression;
                };
                Iterable _apply_1 = (Iterable)this.scopeRule.apply((Object)_function_2);
                if (_apply_1 != null) {
                    Consumer<Object> _function_3 = it_1 -> {
                        if (it_1 instanceof Iterable) {
                            Iterables.addAll((Collection)flatValues, (Iterable)((Iterable)it_1));
                        } else {
                            flatValues.add(it_1);
                        }
                    };
                    _apply_1.forEach(_function_3);
                }
                _xblockexpression_1 = this._elementsExtensions.coerceAnnotationValue(flatValues, avType);
                return _xblockexpression_1;
            };
            Object v = this._ruleUtils.handleException(null, this.errorAvName, _function_1);
            if (v == null) {
                return existingValue;
            }
            GenAnnotationValue _xifexpression = null;
            if (Objects.equal((Object)this.mode, (Object)AVMode.JOIN_LIST) && existingValue != null) {
                GenAnnotationValue _xblockexpression_1 = null;
                Object _valueWithErrorHandling = this._elementsExtensions.getValueWithErrorHandling(existingValue);
                ArrayList joined = new ArrayList((List)_valueWithErrorHandling);
                joined.addAll((List)v);
                _xifexpression = _xblockexpression_1 = new GenAnnotationValue(joined);
            } else {
                _xifexpression = new GenAnnotationValue(v);
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        };
        return (GenAnnotationValue)this.inRule(_function);
    }

    private Object evaluateExpression(TypeMirror avType, String expr) {
        Object _xblockexpression = null;
        Class _xifexpression = null;
        boolean _isPrimitive = avType.getKind().isPrimitive();
        _xifexpression = _isPrimitive ? this._elementsExtensions.toAnnotationValueClass(avType) : Object.class;
        Class<Object> targetClass = _xifexpression;
        _xblockexpression = this._eLSupport.eval(expr, this.lang, targetClass);
        return _xblockexpression;
    }

    public AnnotationValueMappingRule(AnnotationMirror a, Map<String, AnnotationMappingRule> mappingsWithId) {
        super(a, null);
        Functions.Function0 _function;
        this.name = this._elementsExtensions.value(a, null, "name", String.class);
        HashSet setAvNames = CollectionLiterals.newHashSet();
        this.value = this.valueAndRemember(a, "value", String.class, setAvNames);
        this.expr = this.valueAndRemember(a, "expr", String.class, setAvNames);
        this.lang = this._elementsExtensions.value(a, "lang", String.class);
        this.mode = this._elementsExtensions.value(a, "mode", AVMode.class);
        String annotationMappingId = this.valueAndRemember(a, "annotationMappingId", String.class, setAvNames);
        Functions.Function0 _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)annotationMappingId);
        _xifexpression = _isNullOrEmpty ? null : (_function = () -> {
            AnnotationMappingRule _xblockexpression = null;
            AnnotationMappingRule amr = (AnnotationMappingRule)mappingsWithId.get(annotationMappingId);
            if (amr == null) {
                throw new RuleException("Annotation Mapping with id " + annotationMappingId + " not found");
            }
            _xblockexpression = amr;
            return _xblockexpression;
        });
        this.lazyAnnotationMapping = _xifexpression;
        this.errorAvName = this.atMostOneAvName(setAvNames, true);
        this.activationRule = this._ruleUtils.createActivationRule(a, null);
        this.scopeRule = this._ruleUtils.createScopeRule(a, null, null);
    }

    public AnnotationValueMappingRule(AnnotationMirror a, Element templateElement, String avName) {
        super(a, templateElement);
        this.name = avName;
        HashSet setAvNames = CollectionLiterals.newHashSet();
        this.value = this.valueAndRemember(a, avName, Object.class, setAvNames);
        String avPrefix = avName + "_";
        this.expr = this.valueAndRemember(a, RuleUtils.withPrefix("expr", avPrefix), String.class, setAvNames);
        this.lang = this._elementsExtensions.value(a, RuleUtils.withPrefix("lang", avPrefix), String.class);
        this.mode = AVMode.JOIN_LIST;
        AnnotationMirror annotationMappingAnnotation = this.valueAndRemember(a, avPrefix, AnnotationMirror.class, setAvNames);
        Functions.Function0 _xifexpression = null;
        if (annotationMappingAnnotation == null) {
            _xifexpression = null;
        } else {
            Functions.Function0 _function;
            Functions.Function0 _xblockexpression = null;
            AnnotationMappingRule amr = new AnnotationMappingRule(annotationMappingAnnotation, templateElement);
            _xifexpression = _xblockexpression = (_function = () -> amr);
        }
        this.lazyAnnotationMapping = _xifexpression;
        this.errorAvName = this.atMostOneAvName(setAvNames, false);
        this.activationRule = this._ruleUtils.createActivationRule(a, avPrefix);
        this.scopeRule = this._ruleUtils.createScopeRule(a, null, avPrefix);
    }

    private <T> T valueAndRemember(AnnotationMirror am, String avName, Class<T> avType, Set<String> setAvNames) {
        T _xblockexpression = null;
        T v = this._elementsExtensions.value(am, avName, avType);
        if (v != null) {
            setAvNames.add(avName);
        }
        _xblockexpression = v;
        return _xblockexpression;
    }

    private String atMostOneAvName(Set<String> setAvNames, boolean required) {
        boolean _greaterThan;
        String _xblockexpression = null;
        int _size = setAvNames.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("At most one of the annotation values ");
            String _join = IterableExtensions.join(setAvNames, (CharSequence)", ");
            _builder.append(_join);
            _builder.append(" must be set.");
            this.throwRuleCreationException(_builder.toString());
        }
        if (required && setAvNames.isEmpty()) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("At least one of the annotation values ");
            String _join_1 = IterableExtensions.join(setAvNames, (CharSequence)", ");
            _builder_1.append(_join_1);
            _builder_1.append(" must be set.");
            this.throwRuleCreationException(_builder_1.toString());
        }
        _xblockexpression = (String)IterableExtensions.head(setAvNames);
        return _xblockexpression;
    }

    @Override
    @Pure
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.activationRule == null ? 0 : this.activationRule.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        result = 31 * result + (this.errorAvName == null ? 0 : this.errorAvName.hashCode());
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        result = 31 * result + (this.lazyAnnotationMapping == null ? 0 : this.lazyAnnotationMapping.hashCode());
        result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
        result = 31 * result + (this.scopeRule == null ? 0 : this.scopeRule.hashCode());
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AnnotationValueMappingRule other = (AnnotationValueMappingRule)obj;
        if (this.activationRule == null ? other.activationRule != null : !this.activationRule.equals(other.activationRule)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
            return false;
        }
        if (this.errorAvName == null ? other.errorAvName != null : !this.errorAvName.equals(other.errorAvName)) {
            return false;
        }
        if (this.lang == null ? other.lang != null : !this.lang.equals(other.lang)) {
            return false;
        }
        if (this.lazyAnnotationMapping == null ? other.lazyAnnotationMapping != null : !this.lazyAnnotationMapping.equals(other.lazyAnnotationMapping)) {
            return false;
        }
        if (this.mode == null ? other.mode != null : !this.mode.equals((Object)other.mode)) {
            return false;
        }
        return !(this.scopeRule == null ? other.scopeRule != null : !this.scopeRule.equals(other.scopeRule));
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public Functions.Function0<? extends Boolean> getActivationRule() {
        return this.activationRule;
    }

    @Pure
    public String getName() {
        return this.name;
    }

    @Pure
    public Object getValue() {
        return this.value;
    }

    @Pure
    public String getExpr() {
        return this.expr;
    }

    @Pure
    public String getErrorAvName() {
        return this.errorAvName;
    }

    @Pure
    public String getLang() {
        return this.lang;
    }

    @Pure
    public Functions.Function0<? extends AnnotationMappingRule> getLazyAnnotationMapping() {
        return this.lazyAnnotationMapping;
    }

    @Pure
    public AVMode getMode() {
        return this.mode;
    }

    @Pure
    public Functions.Function1<? super Functions.Function1<? super Object, ?>, ? extends Iterable<Object>> getScopeRule() {
        return this.scopeRule;
    }
}

