/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import com.google.common.base.Objects;
import de.japkit.model.CodeBody;
import de.japkit.model.GenClass;
import de.japkit.model.GenConstructor;
import de.japkit.model.GenElement;
import de.japkit.model.GenExtensions;
import de.japkit.model.GenField;
import de.japkit.model.GenInterface;
import de.japkit.model.GenMethod;
import de.japkit.model.GenParameter;
import de.japkit.model.GenTypeElement;
import de.japkit.model.GenUnresolvedType;
import de.japkit.rules.AbstractRule;
import de.japkit.rules.TypeResolver;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.TypeElementNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class BehaviorDelegationRule
extends AbstractRule {
    @Extension
    private final transient TypeResolver typesResolver = ExtensionRegistry.get(TypeResolver.class);
    private final Functions.Function0<? extends Boolean> activationRule;
    private final TypeMirror behaviorClass;
    private final String renamePrefix;
    private final String internalInterfaceName;
    private final Boolean internalInterfaceIsInnerClass;
    private final String internalInterfaceImplName;
    private final String abstractBehaviorClassName;

    public BehaviorDelegationRule(AnnotationMirror metaAnnotation) {
        super(metaAnnotation, null);
        this.activationRule = this._ruleUtils.createActivationRule(metaAnnotation, "customBehavior", null);
        this.behaviorClass = this._elementsExtensions.value(metaAnnotation, "behaviorClass", TypeMirror.class);
        this.renamePrefix = this._elementsExtensions.value(metaAnnotation, "behaviorGenMethodRenamePrefix", String.class);
        this.internalInterfaceName = this._elementsExtensions.value(metaAnnotation, "behaviorInternalInterface", String.class);
        this.internalInterfaceIsInnerClass = this._elementsExtensions.value(metaAnnotation, "behaviorInternalInterfaceIsInnerClass", Boolean.class);
        this.internalInterfaceImplName = this._elementsExtensions.value(metaAnnotation, "behaviorInternalInterfaceImpl", String.class);
        this.abstractBehaviorClassName = this._elementsExtensions.value(metaAnnotation, "behaviorAbstractClass", String.class);
    }

    private GenExtensions getGenExtensions() {
        return ExtensionRegistry.get(GenExtensions.class);
    }

    public void createBehaviorDelegation(GenTypeElement c) {
        Functions.Function1 _function = it -> {
            Object _xblockexpression = null;
            if (this.activationRule != null && !((Boolean)this.activationRule.apply()).booleanValue()) {
                return null;
            }
            Pair<GenClass, TypeElement> behaviorProxyAndTypeElement = this.resolveTypeAndCreateProxy(this.behaviorClass);
            TypeElement foundBehaviorClass = (TypeElement)behaviorProxyAndTypeElement.getValue();
            if (this.activationRule == null && foundBehaviorClass == null) {
                return null;
            }
            GenClass behaviorClass = (GenClass)behaviorProxyAndTypeElement.getKey();
            boolean behaviorClassInSamePackageAsGenClass = this._elementsExtensions.getPackage(c).getQualifiedName().contentEquals(this._elementsExtensions.getPackage(behaviorClass).getQualifiedName());
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Could not determine all methods of generated class ");
            Name _qualifiedName = c.getQualifiedName();
            _builder.append((Object)_qualifiedName);
            _builder.append(", probably due to some missing supertype.");
            Functions.Function1 _function_1 = it_1 -> {
                Functions.Function1 _function_2 = it_2 -> {
                    boolean _isStatic = this._elementsExtensions.isStatic((Element)it_2);
                    return !_isStatic;
                };
                return IterableExtensions.filter(c.allMethods(), (Functions.Function1)_function_2);
            };
            Iterable allInstanceMethods = this._typesRegistry.handleTypeElementNotFound(CollectionLiterals.emptyList(), (CharSequence)_builder, _function_1);
            Iterable<ExecutableElement> _xifexpression = null;
            if (foundBehaviorClass == null) {
                _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList());
            } else {
                Functions.Function1 _function_2 = it_1 -> !this._elementsExtensions.isStatic((Element)it_1) && !this._elementsExtensions.isPrivate((Element)it_1);
                _xifexpression = IterableExtensions.filter(this._elementsExtensions.declaredMethods(foundBehaviorClass), (Functions.Function1)_function_2);
            }
            List<ExecutableElement> customBehaviorMethods = _xifexpression;
            IdentityHashMap collidingBehaviorMethods = new IdentityHashMap();
            Consumer<ExecutableElement> _function_3 = m -> {
                Functions.Function1 _function_4 = it_1 -> {
                    boolean result;
                    boolean _xblockexpression_1 = false;
                    _xblockexpression_1 = result = this._elementsExtensions.isSubSignature((ExecutableElement)it_1, (ExecutableElement)m);
                    return _xblockexpression_1;
                };
                ExecutableElement collidingMethod = (ExecutableElement)IterableExtensions.findFirst((Iterable)customBehaviorMethods, (Functions.Function1)_function_4);
                if (collidingMethod != null) {
                    collidingBehaviorMethods.put(collidingMethod, (GenMethod)m);
                }
            };
            this._elementsExtensions.declaredMethods(c).forEach(_function_3);
            Consumer<GenMethod> _function_4 = it_1 -> {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(this.renamePrefix);
                String _firstUpper = StringExtensions.toFirstUpper((String)it_1.getSimpleName().toString());
                _builder_1.append(_firstUpper);
                String newName = _builder_1.toString();
                it_1.setSimpleName(newName);
            };
            collidingBehaviorMethods.values().forEach(_function_4);
            Functions.Function1 _function_5 = it_1 -> this._elementsExtensions.notDeclaredBy((Element)it_1, Object.class.getName()) && !this._elementsExtensions.isAbstractOrInInterface((Element)it_1);
            Iterable internalMethods = IterableExtensions.filter((Iterable)allInstanceMethods, (Functions.Function1)_function_5);
            Iterable<Object> _xifexpression_1 = null;
            boolean _isAbstract = this._elementsExtensions.isAbstract(c);
            if (_isAbstract) {
                _xifexpression_1 = Collections.unmodifiableList(CollectionLiterals.newArrayList());
            } else {
                Functions.Function1 _function_6 = it_1 -> this._elementsExtensions.isAbstractOrInInterface((Element)it_1);
                _xifexpression_1 = IterableExtensions.filter((Iterable)allInstanceMethods, (Functions.Function1)_function_6);
            }
            List abstractMethodsToImplement = _xifexpression_1;
            IdentityHashMap orgMethod = new IdentityHashMap();
            GenInterface _xifexpression_2 = null;
            if (this.internalInterfaceIsInnerClass.booleanValue()) {
                GenInterface _genInterface = new GenInterface(this.internalInterfaceName);
                Procedures.Procedure1 _function_7 = it_1 -> c.add((GenElement)it_1);
                _xifexpression_2 = (GenInterface)ObjectExtensions.operator_doubleArrow((Object)_genInterface, (Procedures.Procedure1)_function_7);
            } else {
                Name _simpleName = c.getSimpleName();
                String _plus = _simpleName + this.internalInterfaceName;
                PackageElement _package = this._elementsExtensions.getPackage(c);
                GenInterface _genInterface_1 = new GenInterface(_plus, _package);
                Procedures.Procedure1 _function_8 = it_1 -> {
                    this._generateClassContext.getCurrentPrimaryGenClass().getAuxTopLevelClasses().add((GenTypeElement)it_1);
                    this._typesRegistry.registerGeneratedTypeElement((GenTypeElement)it_1, this._generateClassContext.currentAnnotatedClass(), null);
                };
                _xifexpression_2 = (GenInterface)ObjectExtensions.operator_doubleArrow((Object)_genInterface_1, (Procedures.Procedure1)_function_8);
            }
            GenInterface internalInterface = _xifexpression_2;
            if (!behaviorClassInSamePackageAsGenClass) {
                internalInterface.setVisibility(Modifier.PUBLIC);
            }
            Procedures.Procedure1 _function_9 = it_1 -> {
                it_1.copyTypeParametersFrom(c);
                Consumer<ExecutableElement> _function_10 = m -> {
                    GenMethod interfaceMethod = this.getGenExtensions().asInterfaceMethod((ExecutableElement)m);
                    it_1.add(interfaceMethod);
                    orgMethod.put(interfaceMethod, m);
                };
                internalMethods.forEach(_function_10);
            };
            ObjectExtensions.operator_doubleArrow((Object)internalInterface, (Procedures.Procedure1)_function_9);
            GenClass _genClass = new GenClass(this.internalInterfaceImplName);
            Procedures.Procedure1 _function_10 = it_1 -> {
                it_1.addModifier(Modifier.PRIVATE);
                it_1.addInterface(internalInterface.asType());
                Consumer<ExecutableElement> _function_11 = m -> {
                    CodeBody _function_12 = it_2 -> {
                        CharSequence _xblockexpression_1 = null;
                        String _xifexpression_3 = null;
                        Element _enclosingElement = ((ExecutableElement)orgMethod.get(m)).getEnclosingElement();
                        boolean _equals = Objects.equal((Object)_enclosingElement, (Object)c);
                        _xifexpression_3 = _equals ? "this" : "super";
                        String thisOrSuper = _xifexpression_3;
                        StringConcatenation _builder_1 = new StringConcatenation();
                        Name _simpleName_1 = c.getSimpleName();
                        _builder_1.append((Object)_simpleName_1);
                        _builder_1.append(".");
                        _builder_1.append(thisOrSuper);
                        String delegate = _builder_1.toString();
                        _xblockexpression_1 = this.codeForDelegation((ExecutableElement)m, delegate);
                        return _xblockexpression_1;
                    };
                    it_1.add(this.getGenExtensions().createOverride((ExecutableElement)m, _function_12));
                };
                this._elementsExtensions.declaredMethods(internalInterface).forEach(_function_11);
            };
            GenClass internalInterfaceImpl = (GenClass)ObjectExtensions.operator_doubleArrow((Object)_genClass, (Procedures.Procedure1)_function_10);
            c.add(internalInterfaceImpl);
            GenClass _genClass_1 = new GenClass(this.abstractBehaviorClassName);
            Procedures.Procedure1 _function_11 = it_1 -> {
                it_1.copyTypeParametersFrom(c);
                it_1.setModifiers(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Modifier[]{Modifier.STATIC, Modifier.ABSTRACT})));
                if (!behaviorClassInSamePackageAsGenClass) {
                    it_1.setVisibility(Modifier.PUBLIC);
                }
                String internalInterfaceFieldName = StringExtensions.toFirstLower((String)this.internalInterfaceName);
                TypeMirror _asType = internalInterface.asType();
                GenField _genField = new GenField(internalInterfaceFieldName, _asType);
                Procedures.Procedure1 _function_12 = it_2 -> it_2.setVisibility(Modifier.PRIVATE);
                GenField _doubleArrow = (GenField)ObjectExtensions.operator_doubleArrow((Object)_genField, (Procedures.Procedure1)_function_12);
                it_1.add(_doubleArrow);
                GenConstructor _genConstructor = new GenConstructor();
                Procedures.Procedure1 _function_13 = it_2 -> {
                    it_2.setVisibility(Modifier.PROTECTED);
                    TypeMirror _asType_1 = internalInterface.asType();
                    GenParameter _genParameter = new GenParameter(internalInterfaceFieldName, _asType_1);
                    it_2.addParameter(_genParameter);
                    CodeBody _function_14 = it_3 -> {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("this.");
                        _builder_1.append(internalInterfaceFieldName);
                        _builder_1.append(" = ");
                        _builder_1.append(internalInterfaceFieldName);
                        _builder_1.append(";");
                        return _builder_1;
                    };
                    it_2.setBody(_function_14);
                };
                GenConstructor _doubleArrow_1 = (GenConstructor)ObjectExtensions.operator_doubleArrow((Object)_genConstructor, (Procedures.Procedure1)_function_13);
                it_1.add(_doubleArrow_1);
                Consumer<ExecutableElement> _function_14 = m -> {
                    GenMethod _copyFrom = this.getGenExtensions().copyFrom((ExecutableElement)m);
                    Procedures.Procedure1 _function_15 = it_2 -> {
                        Modifier _elvis = null;
                        Modifier _visibilityFromJavaLangObject = this.getVisibilityFromJavaLangObject((ExecutableElement)m);
                        _elvis = _visibilityFromJavaLangObject != null ? _visibilityFromJavaLangObject : Modifier.PROTECTED;
                        it_2.setVisibility(_elvis);
                        CodeBody _function_16 = it_3 -> this.codeForDelegation((ExecutableElement)m, internalInterfaceFieldName);
                        it_2.setBody(_function_16);
                    };
                    GenMethod _doubleArrow_2 = (GenMethod)ObjectExtensions.operator_doubleArrow((Object)_copyFrom, (Procedures.Procedure1)_function_15);
                    it_1.add(_doubleArrow_2);
                };
                this._elementsExtensions.declaredMethods(internalInterface).forEach(_function_14);
                Consumer<ExecutableElement> _function_15 = m -> it_1.add(this.getGenExtensions().asAbstractMethod((ExecutableElement)m));
                abstractMethodsToImplement.forEach(_function_15);
                List<ExecutableElement> _declaredMethods = this._elementsExtensions.declaredMethods((TypeElement)it_1);
                ArrayList<ExecutableElement> methodsAddedSoFar = new ArrayList<ExecutableElement>(_declaredMethods);
                Functions.Function1 _function_16 = m1 -> {
                    Functions.Function1 _function_17 = m2 -> {
                        boolean _isOverrideEquivalent = this._elementsExtensions.isOverrideEquivalent((ExecutableElement)m1, (ExecutableElement)m2);
                        return !_isOverrideEquivalent;
                    };
                    return IterableExtensions.forall((Iterable)methodsAddedSoFar, (Functions.Function1)_function_17);
                };
                Consumer<ExecutableElement> _function_17 = m -> it_1.add(this.getGenExtensions().asAbstractMethod((ExecutableElement)m));
                IterableExtensions.filter((Iterable)customBehaviorMethods, (Functions.Function1)_function_16).forEach(_function_17);
            };
            GenClass abstractBehaviorClass = (GenClass)ObjectExtensions.operator_doubleArrow((Object)_genClass_1, (Procedures.Procedure1)_function_11);
            c.add(abstractBehaviorClass);
            behaviorClass.setSuperclass(abstractBehaviorClass.asType());
            String behaviorFieldName = "behavior";
            TypeMirror _asType = abstractBehaviorClass.asType();
            GenField _genField = new GenField("behavior", _asType);
            Procedures.Procedure1 _function_12 = it_1 -> {
                it_1.setVisibility(Modifier.PRIVATE);
                it_1.addModifier(Modifier.TRANSIENT);
                CodeBody _function_13 = it_2 -> {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("new ");
                    TypeMirror _asType_1 = behaviorClass.asType();
                    _builder_1.append((Object)_asType_1);
                    _builder_1.append("(new ");
                    CharSequence _typeRef = it_2.typeRef(internalInterfaceImpl.asType());
                    _builder_1.append((Object)_typeRef);
                    _builder_1.append("())");
                    return _builder_1;
                };
                it_1.setConstantExpr(_function_13);
            };
            GenField _doubleArrow = (GenField)ObjectExtensions.operator_doubleArrow((Object)_genField, (Procedures.Procedure1)_function_12);
            c.add(_doubleArrow);
            Consumer<ExecutableElement> _function_13 = m -> {
                GenMethod _copyFrom = this.getGenExtensions().copyFrom((ExecutableElement)m, true);
                Procedures.Procedure1 _function_14 = it_1 -> {
                    CodeBody _function_15 = it_2 -> this.codeForDelegation((ExecutableElement)m, "behavior");
                    it_1.setBody(_function_15);
                    it_1.setComment(this._elementsExtensions.getDocComment((Element)m));
                    GenMethod genMethod = (GenMethod)collidingBehaviorMethods.get(m);
                    if (genMethod != null) {
                        Modifier _visibility_1;
                        Modifier _elvis = null;
                        Modifier _visibility = this._elementsExtensions.getVisibility(genMethod);
                        _elvis = _visibility != null ? _visibility : (_visibility_1 = this._elementsExtensions.getVisibility((Element)m));
                        it_1.setVisibility(_elvis);
                        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(it_1.getAnnotationMirrors());
                        if (_isNullOrEmpty) {
                            it_1.setAnnotationMirrors(this.getGenExtensions().copyAnnotations(genMethod));
                        }
                        int _size = it_1.getParameters().size();
                        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
                        for (Integer i : _doubleDotLessThan) {
                            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty(it_1.getParameters().get(i).getAnnotationMirrors());
                            if (!_isNullOrEmpty_1) continue;
                            VariableElement _get = it_1.getParameters().get(i);
                            ((GenParameter)_get).setAnnotationMirrors(this.getGenExtensions().copyAnnotations(genMethod.getParameters().get(i)));
                        }
                    }
                };
                GenMethod _doubleArrow_1 = (GenMethod)ObjectExtensions.operator_doubleArrow((Object)_copyFrom, (Procedures.Procedure1)_function_14);
                c.add(_doubleArrow_1);
            };
            customBehaviorMethods.forEach(_function_13);
            Consumer<GenMethod> _function_14 = it_1 -> {
                it_1.setVisibility(Modifier.PRIVATE);
                it_1.setAnnotationMirrors(CollectionLiterals.emptyList());
                Consumer<VariableElement> _function_15 = it_2 -> ((GenParameter)it_2).setAnnotationMirrors(CollectionLiterals.emptyList());
                it_1.getParameters().forEach(_function_15);
            };
            collidingBehaviorMethods.values().forEach(_function_14);
            _xblockexpression = null;
            return _xblockexpression;
        };
        this.inRule(_function);
    }

    private Modifier getVisibilityFromJavaLangObject(ExecutableElement method) {
        Modifier _xblockexpression = null;
        Functions.Function1 _function = it -> this._elementsExtensions.overrides(method, (ExecutableElement)it);
        ExecutableElement methodFromObject = (ExecutableElement)IterableExtensions.findFirst(this._elementsExtensions.declaredMethods(this._elementsExtensions.getTypeElement(Object.class.getName())), (Functions.Function1)_function);
        Set<Modifier> _modifiers = null;
        if (methodFromObject != null) {
            _modifiers = methodFromObject.getModifiers();
        }
        Modifier _findFirst = null;
        if (_modifiers != null) {
            Functions.Function1 _function_1 = it -> Objects.equal((Object)it, (Object)((Object)Modifier.PUBLIC)) || Objects.equal((Object)it, (Object)((Object)Modifier.PROTECTED));
            _findFirst = (Modifier)((Object)IterableExtensions.findFirst(_modifiers, (Functions.Function1)_function_1));
        }
        _xblockexpression = _findFirst;
        return _xblockexpression;
    }

    private CharSequence codeForDelegation(ExecutableElement m, String delegate) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isVoid = this._typesExtensions.isVoid(m.getReturnType());
        boolean bl = _not = !_isVoid;
        if (_not) {
            _builder.append("return ");
        }
        _builder.append(delegate);
        _builder.append(".");
        Name _simpleName = m.getSimpleName();
        _builder.append((Object)_simpleName);
        _builder.append("(");
        List<? extends VariableElement> _parametersWithSrcNames = this._elementsExtensions.parametersWithSrcNames(m);
        boolean _hasElements = false;
        for (VariableElement variableElement : _parametersWithSrcNames) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            Name _simpleName_1 = variableElement.getSimpleName();
            _builder.append((Object)_simpleName_1);
        }
        _builder.append(");");
        return _builder;
    }

    public Pair<GenClass, TypeElement> resolveTypeAndCreateProxy(TypeMirror selector) {
        try {
            Pair _xtrycatchfinallyexpression = null;
            try {
                Pair _xblockexpression = null;
                TypeMirror tm = this.typesResolver.resolveType(selector, false);
                TypeElementNotFoundException tenfe = null;
                TypeElement _xtrycatchfinallyexpression_1 = null;
                try {
                    _xtrycatchfinallyexpression_1 = this._typesRegistry.asTypeElement(tm);
                }
                catch (Throwable _t) {
                    if (_t instanceof TypeElementNotFoundException) {
                        TypeElementNotFoundException e = (TypeElementNotFoundException)_t;
                        Object _xblockexpression_1 = null;
                        tenfe = e;
                        _xblockexpression_1 = null;
                        _xtrycatchfinallyexpression_1 = _xblockexpression_1;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                TypeElement te = _xtrycatchfinallyexpression_1;
                Pair _xifexpression = null;
                if (te != null && !(tm instanceof GenUnresolvedType)) {
                    Pair _xblockexpression_2 = null;
                    Name _simpleName = te.getSimpleName();
                    GenClass proxy = new GenClass(_simpleName);
                    proxy.setEnclosingElement(te.getEnclosingElement());
                    _xifexpression = _xblockexpression_2 = Pair.of((Object)proxy, (Object)te);
                } else {
                    GenClass _xifexpression_2;
                    Pair _xblockexpression_3;
                    Pair _xifexpression_1 = null;
                    if (tm instanceof GenUnresolvedType) {
                        _xblockexpression_3 = null;
                        _xifexpression_2 = null;
                        boolean _isInnerClass = ((GenUnresolvedType)tm).isInnerClass();
                        if (_isInnerClass) {
                            String _simpleName = ((GenUnresolvedType)tm).simpleName();
                            TypeElement _findTypeElement = this._typesRegistry.findTypeElement(((GenUnresolvedType)tm).getEnclosingQualifiedName());
                            _xifexpression_2 = new GenClass(_simpleName, _findTypeElement);
                        } else {
                            String _simpleName_1 = ((GenUnresolvedType)tm).simpleName();
                            String _enclosingQualifiedName = ((GenUnresolvedType)tm).getEnclosingQualifiedName();
                            _xifexpression_2 = new GenClass(_simpleName_1, _enclosingQualifiedName);
                        }
                    } else {
                        throw tenfe;
                    }
                    GenClass proxy = _xifexpression_2;
                    _xifexpression_1 = _xblockexpression_3 = Pair.of((Object)proxy, null);
                    _xifexpression = _xifexpression_1;
                }
                _xtrycatchfinallyexpression = _xblockexpression = _xifexpression;
            }
            catch (Throwable _t) {
                if (_t instanceof TypeElementNotFoundException) {
                    TypeElementNotFoundException tenfe = (TypeElementNotFoundException)_t;
                    throw tenfe;
                }
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    this._messageCollector.reportRuleError(e);
                    throw e;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return _xtrycatchfinallyexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    @Pure
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.activationRule == null ? 0 : this.activationRule.hashCode());
        result = 31 * result + (this.behaviorClass == null ? 0 : this.behaviorClass.hashCode());
        result = 31 * result + (this.renamePrefix == null ? 0 : this.renamePrefix.hashCode());
        result = 31 * result + (this.internalInterfaceName == null ? 0 : this.internalInterfaceName.hashCode());
        result = 31 * result + (this.internalInterfaceIsInnerClass == null ? 0 : this.internalInterfaceIsInnerClass.hashCode());
        result = 31 * result + (this.internalInterfaceImplName == null ? 0 : this.internalInterfaceImplName.hashCode());
        result = 31 * result + (this.abstractBehaviorClassName == null ? 0 : this.abstractBehaviorClassName.hashCode());
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BehaviorDelegationRule other = (BehaviorDelegationRule)obj;
        if (this.activationRule == null ? other.activationRule != null : !this.activationRule.equals(other.activationRule)) {
            return false;
        }
        if (this.behaviorClass == null ? other.behaviorClass != null : !this.behaviorClass.equals(other.behaviorClass)) {
            return false;
        }
        if (this.renamePrefix == null ? other.renamePrefix != null : !this.renamePrefix.equals(other.renamePrefix)) {
            return false;
        }
        if (this.internalInterfaceName == null ? other.internalInterfaceName != null : !this.internalInterfaceName.equals(other.internalInterfaceName)) {
            return false;
        }
        if (this.internalInterfaceIsInnerClass == null ? other.internalInterfaceIsInnerClass != null : !this.internalInterfaceIsInnerClass.equals(other.internalInterfaceIsInnerClass)) {
            return false;
        }
        if (this.internalInterfaceImplName == null ? other.internalInterfaceImplName != null : !this.internalInterfaceImplName.equals(other.internalInterfaceImplName)) {
            return false;
        }
        return !(this.abstractBehaviorClassName == null ? other.abstractBehaviorClassName != null : !this.abstractBehaviorClassName.equals(other.abstractBehaviorClassName));
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public Functions.Function0<? extends Boolean> getActivationRule() {
        return this.activationRule;
    }

    @Pure
    public TypeMirror getBehaviorClass() {
        return this.behaviorClass;
    }

    @Pure
    public String getRenamePrefix() {
        return this.renamePrefix;
    }

    @Pure
    public String getInternalInterfaceName() {
        return this.internalInterfaceName;
    }

    @Pure
    public Boolean getInternalInterfaceIsInnerClass() {
        return this.internalInterfaceIsInnerClass;
    }

    @Pure
    public String getInternalInterfaceImplName() {
        return this.internalInterfaceImplName;
    }

    @Pure
    public String getAbstractBehaviorClassName() {
        return this.abstractBehaviorClassName;
    }
}

