/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import com.google.common.base.Objects;
import de.japkit.rules.AbstractRule;
import de.japkit.rules.CodeFragmentRule;
import de.japkit.rules.ExpressionOrFunctionCallRule;
import de.japkit.rules.ICodeFragmentRule;
import de.japkit.rules.IParameterlessFunctionRule;
import de.japkit.rules.Rule;
import de.japkit.services.RuleException;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class CaseRule<T>
extends AbstractRule
implements Functions.Function0<T>,
ICodeFragmentRule {
    private final Functions.Function0<? extends Boolean> conditionRule;
    private final ExpressionOrFunctionCallRule<T> valueRule;
    private final List<TypeElement> otherAnnotationTypes;

    public CaseRule(AnnotationMirror metaAnnotation, Element metaElement, Class<? extends T> type, boolean isDefaultCase) {
        super(metaAnnotation, metaElement);
        ExpressionOrFunctionCallRule<Boolean> _function;
        ExpressionOrFunctionCallRule<Boolean> _xifexpression = null;
        _xifexpression = isDefaultCase ? (_function = () -> true) : ExpressionOrFunctionCallRule.ruleOrNullIfUndefined(metaAnnotation, null, Boolean.class, "cond", "condLang", "condFun", null, null, false, ExpressionOrFunctionCallRule.AND_COMBINER);
        this.conditionRule = _xifexpression;
        ExpressionOrFunctionCallRule<? extends T> _expressionOrFunctionCallRule = new ExpressionOrFunctionCallRule<T>(metaAnnotation, metaElement, type, "value", "valueLang", "valueFun", null, null, false, null);
        this.valueRule = _expressionOrFunctionCallRule;
        List<? extends AnnotationMirror> _annotationMirrors = null;
        if (metaElement != null) {
            _annotationMirrors = metaElement.getAnnotationMirrors();
        }
        Iterable _filter = null;
        if (_annotationMirrors != null) {
            Functions.Function1 _function_1 = it -> !Objects.equal((Object)it, (Object)metaAnnotation);
            _filter = IterableExtensions.filter(_annotationMirrors, (Functions.Function1)_function_1);
        }
        Iterable _map = null;
        if (_filter != null) {
            Functions.Function1 _function_2 = it -> this._typesRegistry.asTypeElement(it.getAnnotationType());
            _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_2);
        }
        List _list = null;
        if (_map != null) {
            _list = IterableExtensions.toList(_map);
        }
        this.otherAnnotationTypes = _list;
    }

    public Boolean shallBeApplied() {
        Functions.Function1 _function = it -> {
            Functions.Function0 _function_1 = () -> false;
            Functions.Function0 _function_2 = () -> {
                Boolean _elvis = null;
                Boolean _apply = null;
                if (this.conditionRule != null) {
                    _apply = (Boolean)this.conditionRule.apply();
                }
                if (_apply != null) {
                    _elvis = _apply;
                } else {
                    Boolean _xblockexpression = null;
                    Pair typeAndFunction = null;
                    Boolean _xtrycatchfinallyexpression = null;
                    try {
                        Boolean _xblockexpression_1 = null;
                        Functions.Function1 _function_3 = it_1 -> {
                            IParameterlessFunctionRule<?> _createFunctionRule = this._ruleFactory.createFunctionRule((Element)it_1);
                            return Pair.of((Object)it_1, _createFunctionRule);
                        };
                        Functions.Function1 _function_4 = it_1 -> {
                            IParameterlessFunctionRule _value = (IParameterlessFunctionRule)it_1.getValue();
                            return _value != null;
                        };
                        typeAndFunction = (Pair)IterableExtensions.findFirst((Iterable)ListExtensions.map(this.otherAnnotationTypes, (Functions.Function1)_function_3), (Functions.Function1)_function_4);
                        IParameterlessFunctionRule _value = null;
                        if (typeAndFunction != null) {
                            _value = (IParameterlessFunctionRule)typeAndFunction.getValue();
                        }
                        Object _apply_1 = null;
                        if (_value != null) {
                            _apply_1 = _value.apply();
                        }
                        _xtrycatchfinallyexpression = _xblockexpression_1 = (Boolean)_apply_1;
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) {
                            Exception e = (Exception)_t;
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append("Error when evaluating condition function ");
                            TypeElement _key = null;
                            if (typeAndFunction != null) {
                                _key = (TypeElement)typeAndFunction.getKey();
                            }
                            Name _simpleName = _key.getSimpleName();
                            _builder.append((Object)_simpleName);
                            _builder.append(" : ");
                            String _message = e.getMessage();
                            String _plus = _builder.toString() + _message;
                            throw new RuleException(_plus);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    _elvis = _xblockexpression = _xtrycatchfinallyexpression;
                }
                Boolean condition = _elvis;
                Boolean _elvis_1 = null;
                _elvis_1 = condition != null ? condition : Boolean.valueOf(false);
                return _elvis_1;
            };
            return (Boolean)this._ruleUtils.handleException(_function_1, null, _function_2);
        };
        return (Boolean)this.inRule(_function);
    }

    public static <E> CaseRule<E> findFirstMatching(List<CaseRule<E>> caseRules) {
        CaseRule _findFirst = null;
        if (caseRules != null) {
            Functions.Function1 _function = it -> it.shallBeApplied();
            _findFirst = (CaseRule)IterableExtensions.findFirst(caseRules, (Functions.Function1)_function);
        }
        return _findFirst;
    }

    private Object getRuleToApply() {
        boolean _not;
        ExpressionOrFunctionCallRule<T> _xblockexpression = null;
        Rule _xifexpression = null;
        boolean _isUndefined = this.valueRule.isUndefined();
        boolean bl = _not = !_isUndefined;
        if (_not) {
            _xifexpression = this.valueRule;
        } else {
            IParameterlessFunctionRule<?> _elvis = null;
            Element _metaElement = this.getMetaElement();
            IParameterlessFunctionRule<?> _createFunctionRule = null;
            if (_metaElement != null) {
                _createFunctionRule = this._ruleFactory.createFunctionRule(_metaElement);
            }
            if (_createFunctionRule != null) {
                _elvis = _createFunctionRule;
            } else {
                Functions.Function0<? extends TypeMirror> _createTypeRule = this._ruleUtils.createTypeRule(null, this.getMetaElement().asType(), null);
                _elvis = _createTypeRule;
            }
            _xifexpression = _elvis;
        }
        ExpressionOrFunctionCallRule<T> rule = _xifexpression;
        if (rule == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Case rule ");
            Object _elvis_1 = null;
            Element _metaElement_1 = this.getMetaElement();
            Name _simpleName = null;
            if (_metaElement_1 != null) {
                _simpleName = _metaElement_1.getSimpleName();
            }
            if (_simpleName != null) {
                _elvis_1 = _simpleName;
            } else {
                AnnotationMirror _metaAnnotation = this.getMetaAnnotation();
                _elvis_1 = _metaAnnotation;
            }
            _builder.append(_elvis_1);
            _builder.append(" must either have a value or be put on an element that is a function.");
            throw new RuleException(_builder.toString());
        }
        _xblockexpression = rule;
        return _xblockexpression;
    }

    public T apply() {
        Functions.Function1 _function = it -> {
            Functions.Function0 _function_1 = () -> {
                Object _xblockexpression = null;
                Object rule = this.getRuleToApply();
                Object _xifexpression = null;
                if (rule instanceof Functions.Function0) {
                    Object _apply;
                    _xifexpression = _apply = ((Functions.Function0)rule).apply();
                }
                _xblockexpression = _xifexpression;
                return _xblockexpression;
            };
            return this._ruleUtils.handleException(null, null, _function_1);
        };
        return this.inRule(_function);
    }

    public CodeFragmentRule getCodeFragmentRule() {
        boolean _not;
        CodeFragmentRule _xblockexpression = null;
        Object _ruleToApply = this.getRuleToApply();
        boolean bl = _not = !(_ruleToApply instanceof ICodeFragmentRule);
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Case rule ");
            Object _elvis = null;
            Element _metaElement = this.getMetaElement();
            Name _simpleName = null;
            if (_metaElement != null) {
                _simpleName = _metaElement.getSimpleName();
            }
            if (_simpleName != null) {
                _elvis = _simpleName;
            } else {
                AnnotationMirror _metaAnnotation = this.getMetaAnnotation();
                _elvis = _metaAnnotation;
            }
            _builder.append(_elvis);
            _builder.append(" is not a code fragment");
            throw new RuleException(_builder.toString());
        }
        Object _ruleToApply_1 = this.getRuleToApply();
        _xblockexpression = (CodeFragmentRule)_ruleToApply_1;
        return _xblockexpression;
    }

    @Override
    public CharSequence code() {
        Functions.Function1 _function = it -> {
            Functions.Function0 _function_1 = () -> this.getCodeFragmentRule().code();
            return (CharSequence)this._ruleUtils.handleException(null, null, _function_1);
        };
        return (CharSequence)this.inRule(_function);
    }

    @Override
    public CharSequence surround(CharSequence surrounded) {
        Functions.Function1 _function = it -> {
            Functions.Function0 _function_1 = () -> this.getCodeFragmentRule().surround(surrounded);
            return (CharSequence)this._ruleUtils.handleException(null, null, _function_1);
        };
        return (CharSequence)this.inRule(_function);
    }

    @Override
    @Pure
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.conditionRule == null ? 0 : this.conditionRule.hashCode());
        result = 31 * result + (this.valueRule == null ? 0 : this.valueRule.hashCode());
        result = 31 * result + (this.otherAnnotationTypes == null ? 0 : this.otherAnnotationTypes.hashCode());
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CaseRule other = (CaseRule)obj;
        if (this.conditionRule == null ? other.conditionRule != null : !this.conditionRule.equals(other.conditionRule)) {
            return false;
        }
        if (this.valueRule == null ? other.valueRule != null : !this.valueRule.equals(other.valueRule)) {
            return false;
        }
        return !(this.otherAnnotationTypes == null ? other.otherAnnotationTypes != null : !this.otherAnnotationTypes.equals(other.otherAnnotationTypes));
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public Functions.Function0<? extends Boolean> getConditionRule() {
        return this.conditionRule;
    }

    @Pure
    public ExpressionOrFunctionCallRule<T> getValueRule() {
        return this.valueRule;
    }

    @Pure
    public List<TypeElement> getOtherAnnotationTypes() {
        return this.otherAnnotationTypes;
    }
}

