/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import de.japkit.rules.AbstractRule;
import de.japkit.rules.NameRule;
import de.japkit.services.ProcessingException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class ClassNameRule
extends AbstractRule {
    private final String classSuffixToAppend;
    private final String classSuffixToRemove;
    private final String classPrefixToPrepend;
    private final String classPrefixToRemove;
    private final NameRule classNameRule;
    private final NameRule packageNameRule;

    private String generateClassName(TypeElement orgClass) {
        boolean _isNullOrEmpty_3;
        boolean _not_6;
        boolean _isNullOrEmpty_2;
        boolean _not_5;
        boolean _isNullOrEmpty_1;
        boolean _not_3;
        boolean _not_1;
        boolean _not;
        String _xblockexpression = null;
        String orgName = orgClass.getSimpleName().toString();
        boolean _isEmpty = this.classNameRule.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return this.classNameRule.getName(orgName, orgClass);
        }
        String name = orgName;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.classSuffixToRemove);
        boolean bl2 = _not_1 = !_isNullOrEmpty;
        if (_not_1) {
            int _length_1;
            boolean _not_2;
            boolean _endsWith = name.endsWith(this.classSuffixToRemove);
            boolean bl3 = _not_2 = !_endsWith;
            if (_not_2) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Naming rule violated: Name \"");
                _builder.append(orgName);
                _builder.append("\" must end with ");
                _builder.append(this.classSuffixToRemove);
                throw new ProcessingException(_builder.toString(), orgClass);
            }
            int _length = name.length();
            int _minus = _length - (_length_1 = this.classSuffixToRemove.length());
            boolean _isEmpty_1 = (name = name.substring(0, _minus)).isEmpty();
            if (_isEmpty_1) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Naming rule violated: Name \"");
                _builder_1.append(orgName);
                _builder_1.append("\" must not be empty after removing suffix ");
                _builder_1.append(this.classSuffixToRemove);
                throw new ProcessingException(_builder_1.toString(), orgClass);
            }
        }
        boolean bl4 = _not_3 = !(_isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)this.classPrefixToRemove));
        if (_not_3) {
            boolean _not_4;
            boolean _startsWith = name.startsWith(this.classPrefixToRemove);
            boolean bl5 = _not_4 = !_startsWith;
            if (_not_4) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Naming rule violated: Name \"");
                _builder_2.append(orgName);
                _builder_2.append("\" must begin with ");
                _builder_2.append(this.classPrefixToRemove);
                throw new ProcessingException(_builder_2.toString(), orgClass);
            }
            boolean _isEmpty_2 = (name = name.substring(this.classPrefixToRemove.length())).isEmpty();
            if (_isEmpty_2) {
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("Naming rule violated: Name \"");
                _builder_3.append(orgName);
                _builder_3.append("\" must not be empty after removing prefix ");
                _builder_3.append(this.classPrefixToRemove);
                throw new ProcessingException(_builder_3.toString(), orgClass);
            }
        }
        boolean bl6 = _not_5 = !(_isNullOrEmpty_2 = StringExtensions.isNullOrEmpty((String)this.classSuffixToAppend));
        if (_not_5) {
            name = name + this.classSuffixToAppend;
        }
        boolean bl7 = _not_6 = !(_isNullOrEmpty_3 = StringExtensions.isNullOrEmpty((String)this.classPrefixToPrepend));
        if (_not_6) {
            name = this.classPrefixToPrepend + name;
        }
        _xblockexpression = name;
        return _xblockexpression;
    }

    private String generatePackageName(PackageElement orgPackage) {
        String _xblockexpression = null;
        String name = orgPackage.getQualifiedName().toString();
        _xblockexpression = this.packageNameRule.getName(name, orgPackage);
        return _xblockexpression;
    }

    public Pair<String, String> generateClassAndPackageName(TypeElement orgClass) {
        Functions.Function1 _function = it -> {
            String _generatePackageName = this.generatePackageName(this._elementsExtensions.getPackage(orgClass));
            String _generateClassName = this.generateClassName(orgClass);
            return Pair.of((Object)_generatePackageName, (Object)_generateClassName);
        };
        return (Pair)this.inRule(_function);
    }

    public String generateQualifiedName(TypeElement orgClass) {
        String _xblockexpression = null;
        Pair<String, String> names = this.generateClassAndPackageName(orgClass);
        StringConcatenation _builder = new StringConcatenation();
        String _key = (String)names.getKey();
        _builder.append(_key);
        _builder.append(".");
        String _value = (String)names.getValue();
        _builder.append(_value);
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public ClassNameRule(AnnotationMirror metaAnnotation) {
        super(metaAnnotation, null);
        NameRule _nameRule_1;
        NameRule _nameRule;
        this.classSuffixToAppend = this._elementsExtensions.value(metaAnnotation, "nameSuffixToAppend", String.class);
        this.classSuffixToRemove = this._elementsExtensions.value(metaAnnotation, "nameSuffixToRemove", String.class);
        this.classPrefixToPrepend = this._elementsExtensions.value(metaAnnotation, "namePrefixToPrepend", String.class);
        this.classPrefixToRemove = this._elementsExtensions.value(metaAnnotation, "namePrefixToRemove", String.class);
        this.classNameRule = _nameRule = new NameRule(metaAnnotation, "name");
        this.packageNameRule = _nameRule_1 = new NameRule(metaAnnotation, "packageName");
    }

    @Override
    @Pure
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.classSuffixToAppend == null ? 0 : this.classSuffixToAppend.hashCode());
        result = 31 * result + (this.classSuffixToRemove == null ? 0 : this.classSuffixToRemove.hashCode());
        result = 31 * result + (this.classPrefixToPrepend == null ? 0 : this.classPrefixToPrepend.hashCode());
        result = 31 * result + (this.classPrefixToRemove == null ? 0 : this.classPrefixToRemove.hashCode());
        result = 31 * result + (this.classNameRule == null ? 0 : this.classNameRule.hashCode());
        result = 31 * result + (this.packageNameRule == null ? 0 : this.packageNameRule.hashCode());
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ClassNameRule other = (ClassNameRule)obj;
        if (this.classSuffixToAppend == null ? other.classSuffixToAppend != null : !this.classSuffixToAppend.equals(other.classSuffixToAppend)) {
            return false;
        }
        if (this.classSuffixToRemove == null ? other.classSuffixToRemove != null : !this.classSuffixToRemove.equals(other.classSuffixToRemove)) {
            return false;
        }
        if (this.classPrefixToPrepend == null ? other.classPrefixToPrepend != null : !this.classPrefixToPrepend.equals(other.classPrefixToPrepend)) {
            return false;
        }
        if (this.classPrefixToRemove == null ? other.classPrefixToRemove != null : !this.classPrefixToRemove.equals(other.classPrefixToRemove)) {
            return false;
        }
        if (this.classNameRule == null ? other.classNameRule != null : !this.classNameRule.equals(other.classNameRule)) {
            return false;
        }
        return !(this.packageNameRule == null ? other.packageNameRule != null : !this.packageNameRule.equals(other.packageNameRule));
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public String getClassSuffixToAppend() {
        return this.classSuffixToAppend;
    }

    @Pure
    public String getClassSuffixToRemove() {
        return this.classSuffixToRemove;
    }

    @Pure
    public String getClassPrefixToPrepend() {
        return this.classPrefixToPrepend;
    }

    @Pure
    public String getClassPrefixToRemove() {
        return this.classPrefixToRemove;
    }

    @Pure
    public NameRule getClassNameRule() {
        return this.classNameRule;
    }

    @Pure
    public NameRule getPackageNameRule() {
        return this.packageNameRule;
    }
}

