/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import de.japkit.model.GenAnnotationMirror;
import de.japkit.model.GenAnnotationType;
import de.japkit.model.GenAnnotationValue;
import de.japkit.model.GenClass;
import de.japkit.model.GenElement;
import de.japkit.model.GenEnum;
import de.japkit.model.GenExecutableElement;
import de.japkit.model.GenExtensions;
import de.japkit.model.GenInterface;
import de.japkit.model.GenPackage;
import de.japkit.model.GenTypeElement;
import de.japkit.rules.AbstractRule;
import de.japkit.rules.AnnotationExtensions;
import de.japkit.rules.BehaviorDelegationRule;
import de.japkit.rules.ClassNameRule;
import de.japkit.rules.ELVariableRule;
import de.japkit.rules.MembersRule;
import de.japkit.rules.ScopeRule;
import de.japkit.rules.TemplateRule;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.ProcessingException;
import de.japkit.services.ReportedException;
import de.japkit.services.TypeElementNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class ClassRule
extends AbstractRule {
    @Extension
    protected final transient AnnotationExtensions _annotationExtensions = ExtensionRegistry.get(AnnotationExtensions.class);
    private final Functions.Function0<? extends Boolean> activationRule;
    private final TemplateRule templateRule;
    private final MembersRule membersRule;
    private final ElementKind kind;
    private final Functions.Function0<? extends Set<Modifier>> modifiersRule;
    private final boolean keepAbstract;
    private final Functions.Function1<? super GenElement, ? extends List<? extends AnnotationMirror>> annotationsRule;
    private final Functions.Function0<? extends CharSequence> commentRule;
    private final boolean isTopLevelClass;
    private final ClassNameRule nameRule;
    private final BehaviorDelegationRule behaviorRule;
    private final Functions.Function0<? extends TypeMirror> superclassRule;
    private final List<Functions.Function0<? extends TypeMirror>> interfaceRules;
    private final ScopeRule<GenTypeElement> scopeRule;
    private final boolean shallCreateShadowAnnotation;
    private final boolean isAuxClass;
    private final List<ELVariableRule> varRules;

    public ClassRule(AnnotationMirror metaAnnotation, TypeElement templateClass, boolean isTopLevelClass) {
        this(metaAnnotation, templateClass, isTopLevelClass, false);
    }

    public ClassRule(AnnotationMirror metaAnnotation, TypeElement templateClass, boolean isTopLevelClass, boolean isAuxClass) {
        super(metaAnnotation, templateClass);
        BehaviorDelegationRule _behaviorDelegationRule;
        this.activationRule = this._ruleUtils.createActivationRule(metaAnnotation, null);
        TemplateRule _createTemplateRule = null;
        if (templateClass != null) {
            _createTemplateRule = this._ruleFactory.createTemplateRule(templateClass, metaAnnotation);
        }
        this.templateRule = _createTemplateRule;
        MembersRule _xifexpression = null;
        _xifexpression = templateClass == null ? new MembersRule(metaAnnotation) : null;
        this.membersRule = _xifexpression;
        Functions.Function1<? super GenElement, ? extends List<? extends AnnotationMirror>> _xifexpression_1 = null;
        _xifexpression_1 = templateClass == null ? this._ruleUtils.createAnnotationMappingRules(metaAnnotation, null, null) : null;
        this.annotationsRule = _xifexpression_1;
        this.kind = this._elementsExtensions.value(metaAnnotation, "kind", ElementKind.class);
        this.modifiersRule = this._ruleUtils.createModifiersRule(metaAnnotation, templateClass, null);
        Boolean _elvis = null;
        Boolean _value = this._elementsExtensions.value(metaAnnotation, "keepAbstract", Boolean.class);
        _elvis = _value != null ? _value : Boolean.valueOf(false);
        this.keepAbstract = _elvis;
        this.commentRule = this._ruleUtils.createCommentRule(metaAnnotation, templateClass, null, null);
        Boolean _elvis_1 = null;
        Boolean _value_1 = this._elementsExtensions.value(metaAnnotation, "createShadowAnnotation", Boolean.class);
        _elvis_1 = _value_1 != null ? _value_1 : Boolean.valueOf(false);
        this.shallCreateShadowAnnotation = _elvis_1;
        this.isTopLevelClass = isTopLevelClass;
        this.isAuxClass = isAuxClass;
        ClassNameRule _xifexpression_2 = null;
        _xifexpression_2 = isTopLevelClass ? new ClassNameRule(metaAnnotation) : null;
        this.nameRule = _xifexpression_2;
        this.behaviorRule = _behaviorDelegationRule = new BehaviorDelegationRule(metaAnnotation);
        TypeMirror _superclass = null;
        if (templateClass != null) {
            _superclass = templateClass.getSuperclass();
        }
        this.superclassRule = this._ruleUtils.createTypeRule(metaAnnotation, _superclass, "superclass", null, null);
        Functions.Function1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("interface");
            _builder.append(it);
            return this._ruleUtils.createTypeRule(metaAnnotation, null, _builder.toString(), null, null);
        };
        this.interfaceRules = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)new IntegerRange(1, 2), (Functions.Function1)_function));
        ArrayList<ELVariableRule> _xifexpression_3 = null;
        _xifexpression_3 = isTopLevelClass ? this._ruleUtils.createELVariableRules(metaAnnotation, templateClass, null) : null;
        this.varRules = _xifexpression_3;
        ScopeRule _xifexpression_4 = null;
        _xifexpression_4 = isTopLevelClass ? this._ruleUtils.createScopeRule(metaAnnotation, templateClass, null) : this._ruleUtils.scopeWithCurrentSrc();
        this.scopeRule = _xifexpression_4;
    }

    public List<? extends GenTypeElement> generateClass(String name, Set<GenTypeElement> generatedTopLevelClasses) {
        Functions.Function1 _function = it -> {
            boolean _tripleEquals;
            GenTypeElement _currentGeneratedClass;
            boolean _not;
            List _xblockexpression = null;
            Boolean _apply = (Boolean)this.activationRule.apply();
            boolean bl = _not = _apply == false;
            if (_not) {
                return Collections.emptyList();
            }
            GenTypeElement _xifexpression = null;
            if (!this.isTopLevelClass) {
                GenTypeElement _xblockexpression_1 = null;
                _currentGeneratedClass = this._generateClassContext.getCurrentGeneratedClass();
                boolean bl2 = _tripleEquals = _currentGeneratedClass == null;
                if (_tripleEquals) {
                    throw new IllegalArgumentException("currentGeneratedClass must be available when it is a rule for an inner class.");
                }
                _xifexpression = _xblockexpression_1 = this._generateClassContext.getCurrentGeneratedClass();
            } else {
                _xifexpression = null;
            }
            GenTypeElement enclosingClass = _xifexpression;
            if (!this.isTopLevelClass && enclosingClass == null) {
                throw new IllegalArgumentException("enclosingClass must be available when it is a rule for an inner class.");
            }
            if (this.isAuxClass) {
                _currentGeneratedClass = this._generateClassContext.getCurrentGeneratedClass();
                boolean bl3 = _tripleEquals = _currentGeneratedClass == null;
                if (_tripleEquals) {
                    throw new IllegalArgumentException("currentGeneratedClass must be available when it is a rule for an aux class.");
                }
            }
            Procedures.Procedure1 _function_1 = it_1 -> {
                GenTypeElement generatedClass = this.createClass(enclosingClass, name);
                if (this.isAuxClass) {
                    this._generateClassContext.getCurrentPrimaryGenClass().getAuxTopLevelClasses().add(generatedClass);
                    generatedClass.setAuxClass(true);
                }
                TypeElement _currentAnnotatedClass = this._generateClassContext.currentAnnotatedClass();
                AnnotationMirror _xifexpression_1 = null;
                _xifexpression_1 = this.isTopLevelClass && !this.isAuxClass ? this._generateClassContext.getCurrentTriggerAnnotation() : null;
                this._typesRegistry.registerGeneratedTypeElement(generatedClass, _currentAnnotatedClass, _xifexpression_1);
                this._generateClassContext.setCurrentGeneratedClass(generatedClass);
                if (this.isTopLevelClass && !this.isAuxClass) {
                    this._generateClassContext.setCurrentPrimaryGenClass(generatedClass);
                }
            };
            Functions.Function1 _function_2 = it_1 -> {
                GenTypeElement generatedClass;
                GenTypeElement _xblockexpression_2;
                block18: {
                    _xblockexpression_2 = null;
                    generatedClass = this._generateClassContext.getCurrentGeneratedClass();
                    try {
                        TypeMirror superClass;
                        boolean _isVoid;
                        boolean _not_1;
                        if (this.varRules != null) {
                            Consumer<ELVariableRule> _function_3 = it_2 -> it_2.putELVariable();
                            this.varRules.forEach(_function_3);
                        }
                        generatedClass.setModifiers((Set)this.modifiersRule.apply());
                        if (this.templateRule != null && !this.keepAbstract) {
                            generatedClass.removeModifier(Modifier.ABSTRACT);
                        }
                        boolean bl = _not_1 = !(_isVoid = this._typesExtensions.isVoid(superClass = (TypeMirror)this.superclassRule.apply()));
                        if (_not_1) {
                            generatedClass.setSuperclass((TypeMirror)this.superclassRule.apply());
                        }
                        Functions.Function1 _function_4 = it_2 -> (TypeMirror)it_2.apply();
                        Functions.Function1 _function_5 = it_2 -> {
                            boolean _isVoid_1 = this._typesExtensions.isVoid((TypeMirror)it_2);
                            return !_isVoid_1;
                        };
                        Consumer<TypeMirror> _function_6 = it_2 -> generatedClass.addInterface((TypeMirror)it_2);
                        IterableExtensions.filter((Iterable)ListExtensions.map(this.interfaceRules, (Functions.Function1)_function_4), (Functions.Function1)_function_5).forEach(_function_6);
                        if (this.isTopLevelClass && !this.isAuxClass) {
                            this.createShadowAnnotation(generatedClass);
                        }
                        if (this.annotationsRule != null) {
                            generatedClass.setAnnotationMirrors((List)this.annotationsRule.apply((Object)generatedClass));
                        }
                        generatedClass.setComment((CharSequence)this.commentRule.apply());
                        if (this.membersRule != null) {
                            this.membersRule.apply(generatedClass);
                        }
                        if (this.templateRule != null) {
                            this.templateRule.apply(generatedClass);
                        }
                        this.behaviorRule.createBehaviorDelegation(generatedClass);
                    }
                    catch (Throwable _t) {
                        RuntimeException tenfe;
                        if (_t instanceof ProcessingException) {
                            ProcessingException pe = (ProcessingException)_t;
                            this._messageCollector.reportError(pe);
                            break block18;
                        }
                        if (_t instanceof TypeElementNotFoundException) {
                            tenfe = (TypeElementNotFoundException)_t;
                            this._typesRegistry.handleTypeElementNotFound((TypeElementNotFoundException)tenfe, this._generateClassContext.currentAnnotatedClass());
                            break block18;
                        }
                        if (_t instanceof ReportedException) {
                            tenfe = (ReportedException)_t;
                            break block18;
                        }
                        if (_t instanceof Exception) {
                            Exception e = (Exception)_t;
                            this._messageCollector.reportRuleError(e);
                            break block18;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    finally {
                        if (this.isTopLevelClass && !this.isAuxClass && generatedClass != null) {
                            HashSet generatedClasses = CollectionLiterals.newHashSet();
                            generatedClasses.add(generatedClass);
                            this.addAllAuxTopLevelClasses(generatedClasses, generatedClass);
                            Consumer<GenTypeElement> _function_7 = it_2 -> this._typesRegistry.markAsGenerated((GenTypeElement)it_2, this._generateClassContext.currentAnnotatedClass());
                            generatedClasses.forEach(_function_7);
                            Consumer<GenTypeElement> _function_8 = it_2 -> this.addOrderAnnotations((Element)it_2);
                            generatedClasses.forEach(_function_8);
                            Consumer<GenTypeElement> _function_9 = it_2 -> this.addParamNamesAnnotations((Element)it_2);
                            generatedClasses.forEach(_function_9);
                            if (generatedTopLevelClasses != null) {
                                generatedTopLevelClasses.addAll(generatedClasses);
                            }
                        }
                    }
                }
                _xblockexpression_2 = generatedClass;
                return _xblockexpression_2;
            };
            _xblockexpression = IterableExtensions.toList(this.scopeRule.apply((Procedures.Procedure1<Object>)_function_1, (Functions.Function1<Object, GenTypeElement>)_function_2));
            return _xblockexpression;
        };
        return (List)this.inRule(_function);
    }

    public void addAllAuxTopLevelClasses(Set<GenTypeElement> result, GenTypeElement typeElement) {
        result.addAll(typeElement.getAuxTopLevelClasses());
        Consumer<TypeElement> _function = it -> this.addAllAuxTopLevelClasses(result, (GenTypeElement)it);
        this._elementsExtensions.declaredTypes(typeElement).forEach(_function);
        Consumer<GenTypeElement> _function_1 = it -> this.addAllAuxTopLevelClasses(result, (GenTypeElement)it);
        typeElement.getAuxTopLevelClasses().forEach(_function_1);
    }

    public Object createShadowAnnotation(GenTypeElement generatedClass) {
        Object _xtrycatchfinallyexpression = null;
        try {
            Object _xifexpression = null;
            if (this.shallCreateShadowAnnotation) {
                Object _xblockexpression = null;
                GenAnnotationMirror shadowAnnotation = GenExtensions.copy(this._generateClassContext.getCurrentTriggerAnnotation());
                Consumer<Name> _function = avName -> {
                    Object valueFromStack = this._eLSupport.getValueStack().get(avName.toString());
                    if (valueFromStack != null && !this._elementsExtensions.isEmptyVar(valueFromStack)) {
                        Functions.Function1 _function_1 = t -> {
                            Object _coerceAnnotationValue = this._elementsExtensions.coerceAnnotationValue(valueFromStack, (TypeMirror)t);
                            return new GenAnnotationValue(_coerceAnnotationValue);
                        };
                        shadowAnnotation.setValue(avName.toString(), (Functions.Function1<? super TypeMirror, ? extends GenAnnotationValue>)_function_1);
                    }
                };
                this._elementsExtensions.annotationValueNames(shadowAnnotation).forEach(_function);
                this._annotationExtensions.setShadowIfAppropriate(shadowAnnotation);
                generatedClass.addAnnotationMirror(shadowAnnotation);
                _xifexpression = _xblockexpression = this._generateClassContext.putShadowAnnotation(shadowAnnotation);
            }
            _xtrycatchfinallyexpression = _xifexpression;
        }
        catch (Throwable _t) {
            if (_t instanceof TypeElementNotFoundException) {
                TypeElementNotFoundException tenfe = (TypeElementNotFoundException)_t;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Missing type when creating shadow annotation:");
                this._typesRegistry.handleTypeElementNotFound((CharSequence)_builder, tenfe.getFqn());
            }
            if (_t instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)_t;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Error when creating shadow annotation: ");
                _builder_1.append((Object)re);
                this._messageCollector.reportRuleError(_builder_1);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    private void addOrderAnnotations(Element e) {
        List<? extends Element> enclosed = e.getEnclosedElements();
        int _size = enclosed.size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
        for (Integer order : _doubleDotLessThan) {
            this.addOrderAnnotation(enclosed.get(order), order);
            this.addOrderAnnotations(enclosed.get(order));
        }
    }

    protected void _addOrderAnnotation(GenElement element, Integer order) {
        TypeMirror _asType = this._elementsExtensions.getTypeElement(this._elementsExtensions.ORDER_ANNOTATION_NAME).asType();
        GenAnnotationMirror _genAnnotationMirror = new GenAnnotationMirror((DeclaredType)_asType);
        Procedures.Procedure1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> new GenAnnotationValue(order);
            it.setValue("value", (Functions.Function1<? super TypeMirror, ? extends GenAnnotationValue>)_function_1);
        };
        GenAnnotationMirror _doubleArrow = (GenAnnotationMirror)ObjectExtensions.operator_doubleArrow((Object)_genAnnotationMirror, (Procedures.Procedure1)_function);
        element.addAnnotationMirror(_doubleArrow);
    }

    protected void _addOrderAnnotation(Element element, Integer integer) {
    }

    protected void _addParamNamesAnnotations(GenTypeElement typeElement) {
        Consumer<Element> _function = it -> this.addParamNamesAnnotations((Element)it);
        typeElement.getEnclosedElements().forEach(_function);
    }

    protected void _addParamNamesAnnotations(GenExecutableElement element) {
        boolean _not;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(element.getParameters());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            TypeMirror _asType = this._elementsExtensions.getTypeElement(this._elementsExtensions.PARAM_NAMES_ANNOTATION_NAME).asType();
            GenAnnotationMirror _genAnnotationMirror = new GenAnnotationMirror((DeclaredType)_asType);
            Procedures.Procedure1 _function = it -> {
                Functions.Function1 _function_1 = it_1 -> {
                    Functions.Function1 _function_2 = it_2 -> it_2.getSimpleName().toString();
                    Functions.Function1 _function_3 = it_2 -> new GenAnnotationValue(it_2);
                    List _list = IterableExtensions.toList((Iterable)ListExtensions.map((List)ListExtensions.map(element.getParameters(), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
                    return new GenAnnotationValue(_list);
                };
                it.setValue("value", (Functions.Function1<? super TypeMirror, ? extends GenAnnotationValue>)_function_1);
            };
            GenAnnotationMirror _doubleArrow = (GenAnnotationMirror)ObjectExtensions.operator_doubleArrow((Object)_genAnnotationMirror, (Procedures.Procedure1)_function);
            element.addAnnotationMirror(_doubleArrow);
        }
    }

    protected void _addParamNamesAnnotations(Element element) {
    }

    public GenTypeElement createClass(GenTypeElement enclosingClass, String name) {
        GenTypeElement generatedClass;
        String _value;
        GenTypeElement _xblockexpression = null;
        Pair _xifexpression = null;
        if (this.isTopLevelClass) {
            Pair _xblockexpression_1 = null;
            Pair<String, String> names = this.nameRule.generateClassAndPackageName(this._generateClassContext.currentAnnotatedClass());
            GenPackage _packageForName = GenPackage.packageForName((CharSequence)names.getKey());
            _value = (String)names.getValue();
            _xifexpression = _xblockexpression_1 = Pair.of((Object)_packageForName, (Object)_value);
        } else {
            _xifexpression = Pair.of((Object)enclosingClass, (Object)name);
        }
        Pair enclosingElAndClassName = _xifexpression;
        GenTypeElement _switchResult = null;
        ElementKind kind = this.kind;
        if (kind != null) {
            switch (kind) {
                case CLASS: {
                    _value = (String)enclosingElAndClassName.getValue();
                    GenElement _key = (GenElement)enclosingElAndClassName.getKey();
                    _switchResult = new GenClass(_value, _key);
                    break;
                }
                case ENUM: {
                    String _value_1 = (String)enclosingElAndClassName.getValue();
                    GenElement _key_1 = (GenElement)enclosingElAndClassName.getKey();
                    _switchResult = new GenEnum(_value_1, _key_1);
                    break;
                }
                case INTERFACE: {
                    String _value_2 = (String)enclosingElAndClassName.getValue();
                    GenElement _key_2 = (GenElement)enclosingElAndClassName.getKey();
                    _switchResult = new GenInterface(_value_2, _key_2);
                    break;
                }
                case ANNOTATION_TYPE: {
                    String _value_3 = (String)enclosingElAndClassName.getValue();
                    GenElement _key_3 = (GenElement)enclosingElAndClassName.getKey();
                    _switchResult = new GenAnnotationType(_value_3, _key_3);
                    break;
                }
                default: {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Invalid element kind in GenClass annotation: ");
                    _builder.append((Object)this.kind);
                    TypeElement _currentAnnotatedClass = this._generateClassContext.currentAnnotatedClass();
                    throw new ProcessingException(_builder.toString(), _currentAnnotatedClass);
                }
            }
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Invalid element kind in GenClass annotation: ");
            _builder.append((Object)this.kind);
            TypeElement _currentAnnotatedClass = this._generateClassContext.currentAnnotatedClass();
            throw new ProcessingException(_builder.toString(), _currentAnnotatedClass);
        }
        _xblockexpression = generatedClass = _switchResult;
        return _xblockexpression;
    }

    public String getGeneratedTypeElementFqn(TypeElement annotatedClass) {
        return this.nameRule.generateQualifiedName(annotatedClass);
    }

    public void addOrderAnnotation(Element element, Integer order) {
        if (element instanceof GenElement) {
            this._addOrderAnnotation((GenElement)element, order);
            return;
        }
        if (element != null) {
            this._addOrderAnnotation(element, order);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element, order).toString());
    }

    public void addParamNamesAnnotations(Element element) {
        if (element instanceof GenExecutableElement) {
            this._addParamNamesAnnotations((GenExecutableElement)element);
            return;
        }
        if (element instanceof GenTypeElement) {
            this._addParamNamesAnnotations((GenTypeElement)element);
            return;
        }
        if (element != null) {
            this._addParamNamesAnnotations(element);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }

    @Override
    @Pure
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.activationRule == null ? 0 : this.activationRule.hashCode());
        result = 31 * result + (this.templateRule == null ? 0 : this.templateRule.hashCode());
        result = 31 * result + (this.membersRule == null ? 0 : this.membersRule.hashCode());
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.modifiersRule == null ? 0 : this.modifiersRule.hashCode());
        result = 31 * result + (this.keepAbstract ? 1231 : 1237);
        result = 31 * result + (this.annotationsRule == null ? 0 : this.annotationsRule.hashCode());
        result = 31 * result + (this.commentRule == null ? 0 : this.commentRule.hashCode());
        result = 31 * result + (this.isTopLevelClass ? 1231 : 1237);
        result = 31 * result + (this.nameRule == null ? 0 : this.nameRule.hashCode());
        result = 31 * result + (this.behaviorRule == null ? 0 : this.behaviorRule.hashCode());
        result = 31 * result + (this.superclassRule == null ? 0 : this.superclassRule.hashCode());
        result = 31 * result + (this.interfaceRules == null ? 0 : this.interfaceRules.hashCode());
        result = 31 * result + (this.scopeRule == null ? 0 : this.scopeRule.hashCode());
        result = 31 * result + (this.shallCreateShadowAnnotation ? 1231 : 1237);
        result = 31 * result + (this.isAuxClass ? 1231 : 1237);
        result = 31 * result + (this.varRules == null ? 0 : this.varRules.hashCode());
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ClassRule other = (ClassRule)obj;
        if (this.activationRule == null ? other.activationRule != null : !this.activationRule.equals(other.activationRule)) {
            return false;
        }
        if (this.templateRule == null ? other.templateRule != null : !this.templateRule.equals(other.templateRule)) {
            return false;
        }
        if (this.membersRule == null ? other.membersRule != null : !this.membersRule.equals(other.membersRule)) {
            return false;
        }
        if (this.kind == null ? other.kind != null : !this.kind.equals((Object)other.kind)) {
            return false;
        }
        if (this.modifiersRule == null ? other.modifiersRule != null : !this.modifiersRule.equals(other.modifiersRule)) {
            return false;
        }
        if (other.keepAbstract != this.keepAbstract) {
            return false;
        }
        if (this.annotationsRule == null ? other.annotationsRule != null : !this.annotationsRule.equals(other.annotationsRule)) {
            return false;
        }
        if (this.commentRule == null ? other.commentRule != null : !this.commentRule.equals(other.commentRule)) {
            return false;
        }
        if (other.isTopLevelClass != this.isTopLevelClass) {
            return false;
        }
        if (this.nameRule == null ? other.nameRule != null : !this.nameRule.equals(other.nameRule)) {
            return false;
        }
        if (this.behaviorRule == null ? other.behaviorRule != null : !this.behaviorRule.equals(other.behaviorRule)) {
            return false;
        }
        if (this.superclassRule == null ? other.superclassRule != null : !this.superclassRule.equals(other.superclassRule)) {
            return false;
        }
        if (this.interfaceRules == null ? other.interfaceRules != null : !this.interfaceRules.equals(other.interfaceRules)) {
            return false;
        }
        if (this.scopeRule == null ? other.scopeRule != null : !this.scopeRule.equals(other.scopeRule)) {
            return false;
        }
        if (other.shallCreateShadowAnnotation != this.shallCreateShadowAnnotation) {
            return false;
        }
        if (other.isAuxClass != this.isAuxClass) {
            return false;
        }
        return !(this.varRules == null ? other.varRules != null : !this.varRules.equals(other.varRules));
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public Functions.Function0<? extends Boolean> getActivationRule() {
        return this.activationRule;
    }

    @Pure
    public TemplateRule getTemplateRule() {
        return this.templateRule;
    }

    @Pure
    public MembersRule getMembersRule() {
        return this.membersRule;
    }

    @Pure
    public ElementKind getKind() {
        return this.kind;
    }

    @Pure
    public Functions.Function0<? extends Set<Modifier>> getModifiersRule() {
        return this.modifiersRule;
    }

    @Pure
    public boolean isKeepAbstract() {
        return this.keepAbstract;
    }

    @Pure
    public Functions.Function1<? super GenElement, ? extends List<? extends AnnotationMirror>> getAnnotationsRule() {
        return this.annotationsRule;
    }

    @Pure
    public Functions.Function0<? extends CharSequence> getCommentRule() {
        return this.commentRule;
    }

    @Pure
    public boolean isTopLevelClass() {
        return this.isTopLevelClass;
    }

    @Pure
    public ClassNameRule getNameRule() {
        return this.nameRule;
    }

    @Pure
    public BehaviorDelegationRule getBehaviorRule() {
        return this.behaviorRule;
    }

    @Pure
    public Functions.Function0<? extends TypeMirror> getSuperclassRule() {
        return this.superclassRule;
    }

    @Pure
    public List<Functions.Function0<? extends TypeMirror>> getInterfaceRules() {
        return this.interfaceRules;
    }

    @Pure
    public ScopeRule<GenTypeElement> getScopeRule() {
        return this.scopeRule;
    }

    @Pure
    public boolean isShallCreateShadowAnnotation() {
        return this.shallCreateShadowAnnotation;
    }

    @Pure
    public boolean isAuxClass() {
        return this.isAuxClass;
    }

    @Pure
    public List<ELVariableRule> getVarRules() {
        return this.varRules;
    }
}

