/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import com.google.common.base.Objects;
import de.japkit.el.ELSupport;
import de.japkit.metaannotations.classselectors.ClassSelectorKind;
import de.japkit.model.GenTypeElement;
import de.japkit.model.GenUnresolvedType;
import de.japkit.rules.AbstractFunctionRule;
import de.japkit.rules.AnnotationExtensions;
import de.japkit.rules.ResolvedClassSelector;
import de.japkit.rules.RuleFactory;
import de.japkit.rules.TriggerAnnotationRule;
import de.japkit.rules.TypeResolver;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.TypeElementNotFoundException;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class ClassSelectorRule
extends AbstractFunctionRule<TypeMirror> {
    @Extension
    protected final transient TypeResolver typesResolver = ExtensionRegistry.get(TypeResolver.class);
    private final ClassSelectorKind kind;
    private final Set<TypeMirror> requiredTriggerAnnotation;
    private final TypeMirror enclosing;
    private final String expr;
    private final String lang;
    private final boolean isVarRef;

    public ClassSelectorRule(AnnotationMirror metaAnnotation, Element element) {
        super(metaAnnotation, element, TypeMirror.class);
        this.kind = this._elementsExtensions.value(metaAnnotation, "kind", ClassSelectorKind.class);
        this.requiredTriggerAnnotation = IterableExtensions.toSet((Iterable)((Iterable)Conversions.doWrapArray((Object)this._elementsExtensions.value(metaAnnotation, "requiredTriggerAnnotation", TypeMirror[].class))));
        this.enclosing = this._elementsExtensions.value(metaAnnotation, "enclosing", TypeMirror.class);
        this.lang = this._elementsExtensions.value(metaAnnotation, "lang", String.class);
        String exprFromAV = this._elementsExtensions.value(metaAnnotation, "expr", String.class);
        this.isVarRef = Objects.equal((Object)this.kind, (Object)ClassSelectorKind.EXPR) && StringExtensions.isNullOrEmpty((String)exprFromAV);
        String _xifexpression = null;
        _xifexpression = this.isVarRef ? StringExtensions.toFirstLower((String)element.getSimpleName().toString()) : exprFromAV;
        this.expr = _xifexpression;
    }

    @Override
    protected TypeMirror evalInternal() {
        ResolvedClassSelector resolvedSelector;
        TypeMirror _xblockexpression;
        block26: {
            block25: {
                _xblockexpression = null;
                resolvedSelector = new ResolvedClassSelector();
                resolvedSelector.kind = this.kind;
                ClassSelectorKind kind = this.kind;
                if (kind == null) break block25;
                switch (kind) {
                    case NONE: {
                        resolvedSelector.type = null;
                        break;
                    }
                    case ANNOTATED_CLASS: {
                        TypeElement _currentAnnotatedClass = this._generateClassContext.currentAnnotatedClass();
                        TypeMirror _asType = null;
                        if (_currentAnnotatedClass != null) {
                            _asType = _currentAnnotatedClass.asType();
                        }
                        resolvedSelector.type = _asType;
                        break;
                    }
                    case GENERATED_CLASS: {
                        GenTypeElement _currentGeneratedClass = this._generateClassContext.getCurrentGeneratedClass();
                        TypeMirror _asType_1 = null;
                        if (_currentGeneratedClass != null) {
                            _asType_1 = _currentGeneratedClass.asType();
                        }
                        resolvedSelector.type = _asType_1;
                        break;
                    }
                    case SRC_TYPE: {
                        resolvedSelector.type = this._elementsExtensions.srcType(this._eLSupport.getCurrentSrc());
                        break;
                    }
                    case SRC_SINGLE_VALUE_TYPE: {
                        TypeMirror _srcType = this._elementsExtensions.srcType(this._eLSupport.getCurrentSrc());
                        TypeMirror _singleValueType = null;
                        if (_srcType != null) {
                            _singleValueType = this._typesExtensions.singleValueType(_srcType);
                        }
                        resolvedSelector.type = _singleValueType;
                        break;
                    }
                    case INNER_CLASS_NAME: {
                        this.resolveInnerClassSelector(resolvedSelector);
                        break;
                    }
                    case EXPR: {
                        TypeMirror _xblockexpression_1 = null;
                        Object result = this.evalClassSelectorExpr(resolvedSelector, Object.class);
                        TypeMirror _xifexpression = null;
                        if (result instanceof TypeMirror) {
                            _xifexpression = (TypeMirror)result;
                        } else {
                            TypeMirror _xifexpression_1 = null;
                            if (result instanceof TypeElement) {
                                _xifexpression_1 = ((TypeElement)result).asType();
                            } else {
                                Object _xifexpression_2 = null;
                                if (result == null) {
                                    _xifexpression_2 = null;
                                } else {
                                    Object _xblockexpression_2 = null;
                                    StringConcatenation _builder = new StringConcatenation();
                                    _builder.append("The result of ");
                                    _builder.append(this.expr);
                                    _builder.append(" must be a TypeMirror or a TypeElement, but not ");
                                    Class<?> _class = result.getClass();
                                    _builder.append(_class);
                                    this._messageCollector.reportRuleError(_builder);
                                    _xifexpression_2 = _xblockexpression_2 = null;
                                }
                                _xifexpression_1 = _xifexpression_2;
                            }
                            _xifexpression = _xifexpression_1;
                        }
                        resolvedSelector.type = _xblockexpression_1 = _xifexpression;
                        break;
                    }
                    case FQN: {
                        String fqn = this.evalClassSelectorExpr(resolvedSelector, String.class);
                        TypeElement _findTypeElement = this._typesRegistry.findTypeElement(fqn);
                        TypeMirror _asType_2 = null;
                        if (_findTypeElement != null) {
                            _asType_2 = _findTypeElement.asType();
                        }
                        resolvedSelector.type = _asType_2;
                        if (resolvedSelector.type == null) {
                            GenUnresolvedType _genUnresolvedType = new GenUnresolvedType(fqn, false);
                            resolvedSelector.type = _genUnresolvedType;
                            break;
                        }
                        break block26;
                    }
                    case TEMPLATE: {
                        Element _metaElement = this.getMetaElement();
                        TypeMirror _asType_3 = null;
                        if (_metaElement != null) {
                            _asType_3 = _metaElement.asType();
                        }
                        TypeMirror _resolveType = null;
                        if (_asType_3 != null) {
                            _resolveType = this.typesResolver.resolveType(_asType_3);
                        }
                        resolvedSelector.type = _resolveType;
                        break;
                    }
                    default: {
                        resolvedSelector.type = null;
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Selector ");
                        _builder.append((Object)resolvedSelector.kind);
                        _builder.append(" not supported");
                        this._messageCollector.reportRuleError(_builder);
                        break;
                    }
                }
                break block26;
            }
            resolvedSelector.type = null;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Selector ");
            _builder.append((Object)resolvedSelector.kind);
            _builder.append(" not supported");
            this._messageCollector.reportRuleError(_builder);
        }
        if (!IterableExtensions.isNullOrEmpty(this.requiredTriggerAnnotation) && resolvedSelector.type != null) {
            resolvedSelector.type = this.generatedTypeAccordingToTriggerAnnotation(resolvedSelector.type, this.requiredTriggerAnnotation, true);
        }
        _xblockexpression = resolvedSelector.type;
        return _xblockexpression;
    }

    private TypeElement getEnclosingTypeElement() {
        TypeElement _xblockexpression = null;
        TypeResolver TypeResolver2 = ExtensionRegistry.get(TypeResolver.class);
        TypeMirror _resolveType = null;
        if (this.enclosing != null) {
            _resolveType = TypeResolver2.resolveType(this.enclosing);
        }
        TypeElement _asTypeElement = null;
        if (_resolveType != null) {
            _asTypeElement = this._typesRegistry.asTypeElement(_resolveType);
        }
        _xblockexpression = _asTypeElement;
        return _xblockexpression;
    }

    private void resolveInnerClassSelector(ResolvedClassSelector resolvedSelector) {
        resolvedSelector.enclosingTypeElement = this.getEnclosingTypeElement();
        if (resolvedSelector.enclosingTypeElement == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Could not determine enclosing type element for inner class.");
            this._messageCollector.reportRuleError(_builder);
            return;
        }
        resolvedSelector.innerClassName = this.evalClassSelectorExpr(resolvedSelector, String.class);
        if (resolvedSelector.innerClassName == null) {
            resolvedSelector.innerClassName = this.getMetaElement().getSimpleName().toString();
        }
        Functions.Function1 _function = it -> it.getSimpleName().contentEquals(resolvedSelector.innerClassName);
        resolvedSelector.typeElement = (TypeElement)IterableExtensions.findFirst(this._elementsExtensions.declaredTypes(resolvedSelector.enclosingTypeElement), (Functions.Function1)_function);
        TypeMirror _xifexpression = null;
        if (resolvedSelector.typeElement != null) {
            _xifexpression = resolvedSelector.typeElement.asType();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            Name _qualifiedName = resolvedSelector.enclosingTypeElement.getQualifiedName();
            _builder_1.append((Object)_qualifiedName);
            _builder_1.append(".");
            _builder_1.append(resolvedSelector.innerClassName);
            _xifexpression = new GenUnresolvedType(_builder_1.toString(), true);
        }
        resolvedSelector.type = _xifexpression;
    }

    private <T> T evalClassSelectorExpr(ResolvedClassSelector resolvedSelector, Class<T> targetType) {
        T _xblockexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.expr);
        if (_isNullOrEmpty) {
            return null;
        }
        ELSupport _get = ExtensionRegistry.get(ELSupport.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Error when evaluating class selector expression '");
        _builder.append(this.expr);
        _builder.append("'  ");
        _xblockexpression = _get.eval(this.expr, this.lang, targetType, (CharSequence)_builder, null);
        return _xblockexpression;
    }

    private TypeMirror generatedTypeAccordingToTriggerAnnotation(TypeMirror type, Iterable<TypeMirror> triggerAnnotationTypes, boolean mustHaveTrigger) {
        TypeMirror _xblockexpression = null;
        TypeMirror typeCandidate = type;
        if (this._typesExtensions.isDeclared(typeCandidate) && !this._typesExtensions.isError(typeCandidate)) {
            TypeElement typeElement = this._typesRegistry.asTypeElement(typeCandidate);
            TypeElement _generatedTypeElementAccordingToTriggerAnnotation = this.generatedTypeElementAccordingToTriggerAnnotation(typeElement, triggerAnnotationTypes, mustHaveTrigger);
            TypeMirror _asType = null;
            if (_generatedTypeElementAccordingToTriggerAnnotation != null) {
                _asType = _generatedTypeElementAccordingToTriggerAnnotation.asType();
            }
            typeCandidate = _asType;
        }
        TypeMirror result = typeCandidate;
        Functions.Function1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("generatedTypeAccordingToTriggerAnnotation: ");
            _builder.append((Object)type);
            _builder.append(" of ");
            Class<?> _class = null;
            if (type != null) {
                _class = type.getClass();
            }
            _builder.append(_class);
            _builder.append(". Result: ");
            _builder.append((Object)result);
            return _builder.toString();
        };
        this._messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function);
        _xblockexpression = result;
        return _xblockexpression;
    }

    private TypeElement generatedTypeElementAccordingToTriggerAnnotation(TypeElement typeElement, Iterable<TypeMirror> triggerAnnotationTypes, boolean mustHaveTrigger) {
        TypeElement _xblockexpression = null;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(triggerAnnotationTypes);
        if (_isNullOrEmpty) {
            return typeElement;
        }
        AnnotationExtensions AnnotationExtensions2 = ExtensionRegistry.get(AnnotationExtensions.class);
        Functions.Function1 _function = it -> AnnotationExtensions2.isTriggerAnnotation((AnnotationMirror)it);
        Iterable triggerAnnotations = IterableExtensions.filter(typeElement.getAnnotationMirrors(), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)triggerAnnotations);
        if (_isEmpty) {
            return typeElement;
        }
        Functions.Function1 _function_1 = it -> this._typesExtensions.qualifiedName((TypeMirror)it);
        Set triggerAnnotationTypeFqns = IterableExtensions.toSet((Iterable)IterableExtensions.map(triggerAnnotationTypes, (Functions.Function1)_function_1));
        Functions.Function1 _function_2 = it -> triggerAnnotationTypeFqns.contains(this._typesExtensions.qualifiedName(it.getAnnotationType()));
        Iterable annotations = IterableExtensions.filter(typeElement.getAnnotationMirrors(), (Functions.Function1)_function_2);
        TypeElement _xifexpression = null;
        boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)annotations);
        if (_isEmpty_1) {
            TypeElement _xifexpression_1 = null;
            if (mustHaveTrigger) {
                Object _xblockexpression_1 = null;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Related type ");
                Name _qualifiedName = typeElement.getQualifiedName();
                _builder.append((Object)_qualifiedName);
                _builder.append(" must have one of the trigger annotations ");
                _builder.append((Object)triggerAnnotationTypeFqns);
                _builder.append(".");
                this._messageCollector.reportRuleError(_builder);
                _xblockexpression_1 = null;
                _xifexpression_1 = _xblockexpression_1;
            } else {
                _xifexpression_1 = typeElement;
            }
            _xifexpression = _xifexpression_1;
        } else {
            boolean _greaterThan;
            TypeElement _xifexpression_2 = null;
            int _size = IterableExtensions.size((Iterable)annotations);
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                Object _xblockexpression_2 = null;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Related type ");
                Name _qualifiedName = typeElement.getQualifiedName();
                _builder.append((Object)_qualifiedName);
                _builder.append(" has more than one of the trigger annotations ");
                _builder.append((Object)triggerAnnotationTypeFqns);
                _builder.append(".");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t\t ");
                _builder.append("Thus, the generated type to use is not unique.");
                this._messageCollector.reportRuleError(_builder);
                _xblockexpression_2 = null;
                _xifexpression_2 = _xblockexpression_2;
            } else {
                TypeElement _xifexpression_3 = null;
                if (!this._typesRegistry.isGenerated(typeElement) && !AnnotationExtensions2.isShadowAnnotation((AnnotationMirror)IterableExtensions.head((Iterable)annotations))) {
                    TypeElement _xblockexpression_3 = null;
                    AnnotationMirror triggerAnnotation = (AnnotationMirror)IterableExtensions.head((Iterable)annotations);
                    TriggerAnnotationRule rule = ExtensionRegistry.get(RuleFactory.class).createTriggerAnnotationRule(this._elementsExtensions.annotationAsTypeElement(triggerAnnotation));
                    String fqn = rule.getGeneratedTypeElementFqn(typeElement);
                    TypeElement generatedTypeElement = this._typesRegistry.findTypeElement(fqn);
                    TypeElement _xifexpression_4 = null;
                    if (generatedTypeElement == null) {
                        throw new TypeElementNotFoundException(fqn, "");
                    }
                    _xifexpression_3 = _xblockexpression_3 = (_xifexpression_4 = generatedTypeElement);
                } else {
                    _xifexpression_3 = typeElement;
                }
                _xifexpression_2 = _xifexpression_3;
            }
            _xifexpression = _xifexpression_2;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    @Pure
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.requiredTriggerAnnotation == null ? 0 : this.requiredTriggerAnnotation.hashCode());
        result = 31 * result + (this.enclosing == null ? 0 : this.enclosing.hashCode());
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        result = 31 * result + (this.isVarRef ? 1231 : 1237);
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ClassSelectorRule other = (ClassSelectorRule)obj;
        if (this.kind == null ? other.kind != null : !this.kind.equals((Object)other.kind)) {
            return false;
        }
        if (this.requiredTriggerAnnotation == null ? other.requiredTriggerAnnotation != null : !this.requiredTriggerAnnotation.equals(other.requiredTriggerAnnotation)) {
            return false;
        }
        if (this.enclosing == null ? other.enclosing != null : !this.enclosing.equals(other.enclosing)) {
            return false;
        }
        if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
            return false;
        }
        if (this.lang == null ? other.lang != null : !this.lang.equals(other.lang)) {
            return false;
        }
        return other.isVarRef == this.isVarRef;
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public ClassSelectorKind getKind() {
        return this.kind;
    }

    @Pure
    public Set<TypeMirror> getRequiredTriggerAnnotation() {
        return this.requiredTriggerAnnotation;
    }

    @Pure
    public TypeMirror getEnclosing() {
        return this.enclosing;
    }

    @Pure
    public String getExpr() {
        return this.expr;
    }

    @Pure
    public String getLang() {
        return this.lang;
    }

    @Pure
    public boolean isVarRef() {
        return this.isVarRef;
    }
}

