/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import de.japkit.el.ELSupport;
import de.japkit.el.ValueStack;
import de.japkit.model.CodeBody;
import de.japkit.model.EmitterContext;
import de.japkit.model.GenElement;
import de.japkit.rules.AbstractRule;
import de.japkit.rules.AnnotationExtensions;
import de.japkit.rules.CaseRule;
import de.japkit.rules.CodeFragmentRules;
import de.japkit.rules.IParameterlessFunctionRule;
import de.japkit.rules.JavadocUtil;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.MessageCollector;
import de.japkit.services.TypeElementNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class CodeRule
extends AbstractRule
implements IParameterlessFunctionRule<CharSequence> {
    @Extension
    protected final transient AnnotationExtensions annotationExtensions = ExtensionRegistry.get(AnnotationExtensions.class);
    private final Element template;
    private final List<DeclaredType> imports;
    private final String iteratorExpr;
    private final String iteratorLang;
    private final String bodyExpr;
    private final List<CaseRule<String>> bodyCases;
    private final String lang;
    private final String beforeExpr;
    private final String afterExpr;
    private final String separator;
    private final String emptyExpr;
    private final String errorValue;
    private final Functions.Function1<? super CharSequence, ? extends CharSequence> defaultFragmentsRule;
    private final boolean linebreak;
    private final boolean indentAfterLinebreak;
    private final String LINE_DELIM = StringConcatenation.DEFAULT_LINE_DELIMITER;

    public CodeRule(AnnotationMirror metaAnnotation, String avPrefix) {
        this(metaAnnotation, null, avPrefix, "");
    }

    public CodeRule(AnnotationMirror metaAnnotation, Element template, String avPrefix, String errorValue) {
        super(metaAnnotation, template);
        List _emptyList_1;
        List _emptyList;
        this.template = template;
        String _docCommentUsingRuntimeMetadata = null;
        if (template != null) {
            _docCommentUsingRuntimeMetadata = this._elementsExtensions.getDocCommentUsingRuntimeMetadata(template);
        }
        Map<String, String> codeFromJavadoc = JavadocUtil.getCode(_docCommentUsingRuntimeMetadata);
        this.bodyExpr = this.stringFromAnnotationOrMap(metaAnnotation, codeFromJavadoc, CodeRule.withPrefix("code", avPrefix));
        String _value = null;
        if (metaAnnotation != null) {
            _value = this._elementsExtensions.value(metaAnnotation, CodeRule.withPrefix("lang", avPrefix), String.class);
        }
        this.lang = _value;
        AnnotationMirror[] _value_1 = null;
        if (metaAnnotation != null) {
            _value_1 = this._elementsExtensions.value(metaAnnotation, CodeRule.withPrefix("cases", avPrefix), AnnotationMirror[].class);
        }
        AnnotationMirror[] bodyCaseAnnotations = _value_1;
        List _elvis = null;
        List _map = null;
        if ((List)Conversions.doWrapArray(bodyCaseAnnotations) != null) {
            Functions.Function1 _function = it -> new CaseRule<String>((AnnotationMirror)it, null, String.class, false);
            _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)bodyCaseAnnotations)), (Functions.Function1)_function);
        }
        List _list = null;
        if (_map != null) {
            _list = IterableExtensions.toList(_map);
        }
        _elvis = _list != null ? _list : (_emptyList = CollectionLiterals.emptyList());
        this.bodyCases = _elvis;
        this.beforeExpr = this.stringFromAnnotationOrMap(metaAnnotation, codeFromJavadoc, CodeRule.withPrefix("beforeIteratorCode", avPrefix));
        this.afterExpr = this.stringFromAnnotationOrMap(metaAnnotation, codeFromJavadoc, CodeRule.withPrefix("afterIteratorCode", avPrefix));
        this.emptyExpr = this.stringFromAnnotationOrMap(metaAnnotation, codeFromJavadoc, CodeRule.withPrefix("emptyIteratorCode", avPrefix));
        this.separator = this.stringFromAnnotationOrMap(metaAnnotation, codeFromJavadoc, CodeRule.withPrefix("separator", avPrefix));
        this.errorValue = errorValue;
        String _value_2 = null;
        if (metaAnnotation != null) {
            _value_2 = this._elementsExtensions.value(metaAnnotation, CodeRule.withPrefix("iterator", avPrefix), String.class);
        }
        this.iteratorExpr = _value_2;
        String _value_3 = null;
        if (metaAnnotation != null) {
            _value_3 = this._elementsExtensions.value(metaAnnotation, CodeRule.withPrefix("iteratorLang", avPrefix), String.class);
        }
        this.iteratorLang = _value_3;
        List _elvis_1 = null;
        DeclaredType[] _value_4 = null;
        if (metaAnnotation != null) {
            _value_4 = this._elementsExtensions.value(metaAnnotation, "imports", DeclaredType[].class);
        }
        List _list_1 = null;
        if ((Iterable)Conversions.doWrapArray(_value_4) != null) {
            _list_1 = IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)_value_4)));
        }
        _elvis_1 = _list_1 != null ? _list_1 : (_emptyList_1 = CollectionLiterals.emptyList());
        this.imports = _elvis_1;
        Boolean _elvis_2 = null;
        Boolean _value_5 = null;
        if (metaAnnotation != null) {
            _value_5 = this._elementsExtensions.value(metaAnnotation, CodeRule.withPrefix("linebreak", avPrefix), Boolean.TYPE);
        }
        _elvis_2 = _value_5 != null ? _value_5 : Boolean.valueOf(false);
        this.linebreak = _elvis_2;
        Boolean _elvis_3 = null;
        Boolean _value_6 = null;
        if (metaAnnotation != null) {
            _value_6 = this._elementsExtensions.value(metaAnnotation, CodeRule.withPrefix("indentAfterLinebreak", avPrefix), Boolean.TYPE);
        }
        _elvis_3 = _value_6 != null ? _value_6 : Boolean.valueOf(false);
        this.indentAfterLinebreak = _elvis_3;
        this.defaultFragmentsRule = CodeFragmentRules.createDefaultFragmentsRule(metaAnnotation, avPrefix);
    }

    private String stringFromAnnotationOrMap(AnnotationMirror metaAnnotation, Map<String, String> map, String name) {
        String _xblockexpression = null;
        String _value = null;
        if (metaAnnotation != null) {
            _value = this._elementsExtensions.value(metaAnnotation, name, String.class);
        }
        String av = _value;
        String _elvis = null;
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)av);
        if (_isNullOrEmpty) {
            String _get = null;
            if (map != null) {
                _get = map.get(name);
            }
            _xifexpression = _get;
        } else {
            _xifexpression = av;
        }
        _elvis = _xifexpression != null ? _xifexpression : "";
        _xblockexpression = _elvis;
        return _xblockexpression;
    }

    private static String withPrefix(String name, String prefix) {
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)prefix);
        if (_isNullOrEmpty) {
            _xifexpression = name;
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(prefix);
            String _firstUpper = StringExtensions.toFirstUpper((String)name);
            _builder.append(_firstUpper);
            _xifexpression = _builder.toString();
        }
        return _xifexpression;
    }

    public static CodeBody getAsCodeBody(GenElement genElement, CodeRule cr) {
        CodeBody _function;
        CodeBody _xblockexpression = null;
        if (cr == null) {
            return null;
        }
        ELSupport ELSupport2 = ExtensionRegistry.get(ELSupport.class);
        ValueStack _valueStack = ELSupport2.getValueStack();
        ValueStack vs = new ValueStack(_valueStack);
        _xblockexpression = _function = ec -> {
            Functions.Function0 _function_1 = () -> {
                Functions.Function1 _function_2 = it -> {
                    CharSequence _xblockexpression_1 = null;
                    it.put("ec", (Object)ec);
                    it.put("genElement", (Object)genElement);
                    _xblockexpression_1 = cr.code();
                    return _xblockexpression_1;
                };
                return (CharSequence)ELSupport2.scope(_function_2);
            };
            return (CharSequence)ELSupport2.withValueStack(vs, _function_1);
        };
        return _xblockexpression;
    }

    public static CodeBody getAsCodeBody(GenElement genElement, Functions.Function1<? super GenElement, ? extends CharSequence> cr, Functions.Function1<? super CharSequence, ? extends CharSequence> defaultFragments) {
        CodeBody _function;
        CodeBody _xblockexpression = null;
        ELSupport ELSupport2 = ExtensionRegistry.get(ELSupport.class);
        ValueStack _valueStack = ELSupport2.getValueStack();
        ValueStack vs = new ValueStack(_valueStack);
        _xblockexpression = _function = ec -> {
            Functions.Function0 _function_1 = () -> {
                Functions.Function1 _function_2 = it -> {
                    CharSequence _xtrycatchfinallyexpression = null;
                    try {
                        CharSequence _xblockexpression_1 = null;
                        it.put("ec", (Object)ec);
                        it.put("genElement", (Object)genElement);
                        CharSequence result = (CharSequence)cr.apply((Object)genElement);
                        CharSequence _elvis = null;
                        CharSequence _apply = null;
                        if (defaultFragments != null) {
                            _apply = (CharSequence)defaultFragments.apply((Object)result);
                        }
                        _elvis = _apply != null ? _apply : result;
                        _xblockexpression_1 = _elvis;
                        _xtrycatchfinallyexpression = _xblockexpression_1;
                    }
                    catch (Throwable _t) {
                        if (_t instanceof TypeElementNotFoundException) {
                            TypeElementNotFoundException e = (TypeElementNotFoundException)_t;
                            throw e;
                        }
                        if (_t instanceof Exception) {
                            Exception e_1 = (Exception)_t;
                            String _xblockexpression_2 = null;
                            ExtensionRegistry.get(MessageCollector.class).reportRuleError(e_1.getMessage());
                            StringConcatenation _builder = new StringConcatenation();
                            _xtrycatchfinallyexpression = _xblockexpression_2 = _builder.toString();
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return _xtrycatchfinallyexpression;
                };
                return (CharSequence)ELSupport2.scope(_function_2);
            };
            return (CharSequence)ELSupport2.withValueStack(vs, _function_1);
        };
        return _xblockexpression;
    }

    public static Functions.Function1<? super GenElement, ? extends CodeBody> createCodeBodyRule(Functions.Function1<? super GenElement, ? extends CharSequence> codeRule, Functions.Function1<? super CharSequence, ? extends CharSequence> defaultFragments) {
        Functions.Function1 _function = genElement -> CodeRule.getAsCodeBody(genElement, codeRule, defaultFragments);
        return _function;
    }

    public CharSequence code() {
        Object _required = this._eLSupport.getValueStack().getRequired("ec");
        return this.code((EmitterContext)_required);
    }

    private CharSequence code(EmitterContext ec) {
        Functions.Function1 _function = it -> {
            Functions.Function0 _function_1 = () -> this.errorValue;
            Functions.Function0 _function_2 = () -> {
                CharSequence _xblockexpression = null;
                if (StringExtensions.isNullOrEmpty((String)this.bodyExpr) && this.bodyCases.isEmpty()) {
                    return null;
                }
                Consumer<DeclaredType> _function_3 = it_1 -> {
                    boolean _not;
                    boolean _importIfPossible = ec.importIfPossible((DeclaredType)it_1);
                    boolean bl = _not = !_importIfPossible;
                    if (_not) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Import for ");
                        _builder.append(it_1);
                        _builder.append(" not possible since it conflicts with existing import");
                        this._messageCollector.reportRuleError(_builder, "imports");
                    }
                };
                this.imports.forEach(_function_3);
                Functions.Function1 _function_4 = it_1 -> {
                    CharSequence _xblockexpression_1 = null;
                    CharSequence _xifexpression = null;
                    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.iteratorExpr);
                    if (_isNullOrEmpty) {
                        _xifexpression = this.code(this.bodyCases, this.bodyExpr, this.lang, this.errorValue);
                    } else {
                        boolean _not;
                        CharSequence _xblockexpression_2 = null;
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Error in code body iterator expression.");
                        Iterable bodyIterator = this._eLSupport.eval(this.iteratorExpr, this.iteratorLang, Iterable.class, (CharSequence)_builder, CollectionLiterals.emptyList());
                        CharSequence _xifexpression_1 = null;
                        boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)bodyIterator);
                        boolean bl = _not = !_isNullOrEmpty_1;
                        if (_not) {
                            String _xblockexpression_3 = null;
                            StringConcatenation _builder_1 = new StringConcatenation();
                            _builder_1.append("Error in code body before expression.");
                            CharSequence _withLinebreak = CodeRule.withLinebreak(this._eLSupport.eval(this.beforeExpr, this.lang, CharSequence.class, (CharSequence)_builder_1, ""), this.linebreak);
                            String _xifexpression_2 = null;
                            _xifexpression_2 = this.linebreak && this.indentAfterLinebreak ? "\t" : "";
                            String before = _withLinebreak + _xifexpression_2;
                            String _xifexpression_3 = null;
                            _xifexpression_3 = this.linebreak && !this.indentAfterLinebreak ? this.LINE_DELIM : "";
                            StringConcatenation _builder_2 = new StringConcatenation();
                            _builder_2.append("Error in code body after expression.");
                            CharSequence _withLinebreak_1 = CodeRule.withLinebreak(this._eLSupport.eval(this.afterExpr, this.lang, CharSequence.class, (CharSequence)_builder_2, ""), this.linebreak);
                            String after = _xifexpression_3 + _withLinebreak_1;
                            String _xifexpression_4 = null;
                            if (this.linebreak) {
                                String _xifexpression_5 = null;
                                _xifexpression_5 = this.indentAfterLinebreak ? "\t" : "";
                                _xifexpression_4 = this.LINE_DELIM + _xifexpression_5;
                            } else {
                                _xifexpression_4 = "";
                            }
                            String sep = this.separator + _xifexpression_4;
                            StringConcatenation _builder_3 = new StringConcatenation();
                            boolean _hasElements = false;
                            for (Object e : bodyIterator) {
                                if (!_hasElements) {
                                    _hasElements = true;
                                    _builder_3.append(before);
                                } else {
                                    _builder_3.appendImmediate((Object)sep, "");
                                }
                                Functions.Function1 _function_5 = it_2 -> this.code(this.bodyCases, this.bodyExpr, this.lang, "");
                                CharSequence _scope = (CharSequence)this._eLSupport.scope((Element)e, _function_5);
                                _builder_3.append((Object)_scope);
                            }
                            if (_hasElements) {
                                _builder_3.append(after);
                            }
                            _xblockexpression_3 = _builder_3.toString();
                            _xifexpression_1 = _xblockexpression_3;
                        } else {
                            StringConcatenation _builder_1 = new StringConcatenation();
                            _builder_1.append("Error in code body empty expression.");
                            _xifexpression_1 = this._eLSupport.eval(this.emptyExpr, this.lang, CharSequence.class, (CharSequence)_builder_1, this.errorValue);
                        }
                        _xifexpression = _xblockexpression_2 = _xifexpression_1;
                    }
                    CharSequence result = _xifexpression;
                    CharSequence _xtrycatchfinallyexpression = null;
                    try {
                        _xtrycatchfinallyexpression = (CharSequence)this.defaultFragmentsRule.apply((Object)result);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) {
                            Exception e = (Exception)_t;
                            CharSequence _xblockexpression_3 = null;
                            this._messageCollector.reportRuleError(e);
                            _xtrycatchfinallyexpression = _xblockexpression_3 = result;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    _xblockexpression_1 = _xtrycatchfinallyexpression;
                    return _xblockexpression_1;
                };
                _xblockexpression = this._typesRegistry.handleTypeElementNotFound(null, (CharSequence)this.errorValue, _function_4);
                return _xblockexpression;
            };
            return (CharSequence)this._ruleUtils.handleException(_function_1, null, _function_2);
        };
        return (CharSequence)this.inRule(_function);
    }

    private CharSequence code(List<CaseRule<String>> bodyCases, String bodyExpr, String lang, String errorResult) {
        CharSequence _elvis = null;
        CaseRule _findFirstMatching = CaseRule.findFirstMatching(bodyCases);
        String _apply = null;
        if (_findFirstMatching != null) {
            _apply = (String)_findFirstMatching.apply();
        }
        if (_apply != null) {
            _elvis = _apply;
        } else {
            CharSequence _eval = this._eLSupport.eval(bodyExpr, lang, CharSequence.class, "Error in code body expression.", errorResult);
            _elvis = _eval;
        }
        return _elvis;
    }

    public static CharSequence withLinebreak(CharSequence cs) {
        return CodeRule.withLinebreak(cs, true);
    }

    public static CharSequence withLinebreak(CharSequence cs, boolean linebreak) {
        CharSequence _xifexpression = null;
        if (linebreak && cs != null && cs.length() > 0) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)cs);
            _builder.newLineIfNotEmpty();
            _xifexpression = _builder;
        } else {
            _xifexpression = cs;
        }
        return _xifexpression;
    }

    public CharSequence apply() {
        return this.code();
    }

    public CharSequence apply(Object p) {
        Functions.Function1 _function = it -> this.code();
        return (CharSequence)this._eLSupport.scope(p, _function);
    }

    @Override
    @Pure
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.template == null ? 0 : this.template.hashCode());
        result = 31 * result + (this.imports == null ? 0 : this.imports.hashCode());
        result = 31 * result + (this.iteratorExpr == null ? 0 : this.iteratorExpr.hashCode());
        result = 31 * result + (this.iteratorLang == null ? 0 : this.iteratorLang.hashCode());
        result = 31 * result + (this.bodyExpr == null ? 0 : this.bodyExpr.hashCode());
        result = 31 * result + (this.bodyCases == null ? 0 : this.bodyCases.hashCode());
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        result = 31 * result + (this.beforeExpr == null ? 0 : this.beforeExpr.hashCode());
        result = 31 * result + (this.afterExpr == null ? 0 : this.afterExpr.hashCode());
        result = 31 * result + (this.separator == null ? 0 : this.separator.hashCode());
        result = 31 * result + (this.emptyExpr == null ? 0 : this.emptyExpr.hashCode());
        result = 31 * result + (this.errorValue == null ? 0 : this.errorValue.hashCode());
        result = 31 * result + (this.defaultFragmentsRule == null ? 0 : this.defaultFragmentsRule.hashCode());
        result = 31 * result + (this.linebreak ? 1231 : 1237);
        result = 31 * result + (this.indentAfterLinebreak ? 1231 : 1237);
        result = 31 * result + (this.LINE_DELIM == null ? 0 : this.LINE_DELIM.hashCode());
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CodeRule other = (CodeRule)obj;
        if (this.template == null ? other.template != null : !this.template.equals(other.template)) {
            return false;
        }
        if (this.imports == null ? other.imports != null : !this.imports.equals(other.imports)) {
            return false;
        }
        if (this.iteratorExpr == null ? other.iteratorExpr != null : !this.iteratorExpr.equals(other.iteratorExpr)) {
            return false;
        }
        if (this.iteratorLang == null ? other.iteratorLang != null : !this.iteratorLang.equals(other.iteratorLang)) {
            return false;
        }
        if (this.bodyExpr == null ? other.bodyExpr != null : !this.bodyExpr.equals(other.bodyExpr)) {
            return false;
        }
        if (this.bodyCases == null ? other.bodyCases != null : !this.bodyCases.equals(other.bodyCases)) {
            return false;
        }
        if (this.lang == null ? other.lang != null : !this.lang.equals(other.lang)) {
            return false;
        }
        if (this.beforeExpr == null ? other.beforeExpr != null : !this.beforeExpr.equals(other.beforeExpr)) {
            return false;
        }
        if (this.afterExpr == null ? other.afterExpr != null : !this.afterExpr.equals(other.afterExpr)) {
            return false;
        }
        if (this.separator == null ? other.separator != null : !this.separator.equals(other.separator)) {
            return false;
        }
        if (this.emptyExpr == null ? other.emptyExpr != null : !this.emptyExpr.equals(other.emptyExpr)) {
            return false;
        }
        if (this.errorValue == null ? other.errorValue != null : !this.errorValue.equals(other.errorValue)) {
            return false;
        }
        if (this.defaultFragmentsRule == null ? other.defaultFragmentsRule != null : !this.defaultFragmentsRule.equals(other.defaultFragmentsRule)) {
            return false;
        }
        if (other.linebreak != this.linebreak) {
            return false;
        }
        if (other.indentAfterLinebreak != this.indentAfterLinebreak) {
            return false;
        }
        return !(this.LINE_DELIM == null ? other.LINE_DELIM != null : !this.LINE_DELIM.equals(other.LINE_DELIM));
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public Element getTemplate() {
        return this.template;
    }

    @Pure
    public List<DeclaredType> getImports() {
        return this.imports;
    }

    @Pure
    public String getIteratorExpr() {
        return this.iteratorExpr;
    }

    @Pure
    public String getIteratorLang() {
        return this.iteratorLang;
    }

    @Pure
    public String getBodyExpr() {
        return this.bodyExpr;
    }

    @Pure
    public List<CaseRule<String>> getBodyCases() {
        return this.bodyCases;
    }

    @Pure
    public String getLang() {
        return this.lang;
    }

    @Pure
    public String getBeforeExpr() {
        return this.beforeExpr;
    }

    @Pure
    public String getAfterExpr() {
        return this.afterExpr;
    }

    @Pure
    public String getSeparator() {
        return this.separator;
    }

    @Pure
    public String getEmptyExpr() {
        return this.emptyExpr;
    }

    @Pure
    public String getErrorValue() {
        return this.errorValue;
    }

    @Pure
    public Functions.Function1<? super CharSequence, ? extends CharSequence> getDefaultFragmentsRule() {
        return this.defaultFragmentsRule;
    }

    @Pure
    public boolean isLinebreak() {
        return this.linebreak;
    }

    @Pure
    public boolean isIndentAfterLinebreak() {
        return this.indentAfterLinebreak;
    }

    @Pure
    public String getLINE_DELIM() {
        return this.LINE_DELIM;
    }
}

