/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import com.google.common.base.Objects;
import de.japkit.rules.AbstractRule;
import de.japkit.rules.IParameterlessFunctionRule;
import de.japkit.rules.JavadocUtil;
import de.japkit.rules.LibraryRule;
import de.japkit.rules.RuleUtils;
import de.japkit.services.RuleException;
import de.japkit.services.TypeElementNotFoundException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class ExpressionOrFunctionCallRule<T>
extends AbstractRule
implements Functions.Function0<T> {
    private final String exprAvName;
    private final String functionAvName;
    private final String expr;
    private final String lang;
    private final TypeElement[] functionClasses;
    private final Functions.Function0<? extends T> defaultValue;
    private final Functions.Function3<? super Boolean, ? super Object, ? super IParameterlessFunctionRule<?>, ?> combiner;
    private final boolean nullable;
    private final Class<? extends T> type;
    public static final Functions.Function3<? super Boolean, ? super Object, ? super IParameterlessFunctionRule<?>, ?> FLUENT_COMBINER = (isFirst, previous, function) -> {
        Object _xifexpression = null;
        _xifexpression = isFirst != false ? function.apply() : function.apply(previous);
        return _xifexpression;
    };
    public static final Functions.Function3<? super Boolean, ? super Object, ? super IParameterlessFunctionRule<?>, ?> AND_COMBINER = (isFirst, previous, function) -> {
        boolean _and = false;
        Boolean _xifexpression = null;
        _xifexpression = isFirst != false ? Boolean.valueOf(true) : (Boolean)previous;
        if (!_xifexpression.booleanValue()) {
            _and = false;
        } else {
            Boolean _xblockexpression = null;
            Object r = function.apply();
            if (!(r instanceof Boolean)) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("The function returned ");
                _builder.append(r);
                _builder.append(" of type ");
                Class<?> _class = null;
                if (r != null) {
                    _class = r.getClass();
                }
                _builder.append(_class);
                _builder.append(", but the required type is Boolean");
                throw new RuleException(_builder.toString());
            }
            _xblockexpression = (Boolean)r;
            _and = _xblockexpression;
        }
        return _and;
    };
    public static final Functions.Function3<? super Boolean, ? super Object, ? super IParameterlessFunctionRule<?>, ?> OR_COMBINER = (isFirst, previous, function) -> {
        boolean _or = false;
        Boolean _xifexpression = null;
        _xifexpression = isFirst != false ? Boolean.valueOf(false) : (Boolean)previous;
        if (_xifexpression.booleanValue()) {
            _or = true;
        } else {
            Boolean _xblockexpression = null;
            Object r = function.apply();
            if (!(r instanceof Boolean)) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("The function returned ");
                _builder.append(r);
                _builder.append(" of type ");
                Class<?> _class = null;
                if (r != null) {
                    _class = r.getClass();
                }
                _builder.append(_class);
                _builder.append(", but the required type is Boolean");
                throw new RuleException(_builder.toString());
            }
            _xblockexpression = (Boolean)r;
            _or = _xblockexpression;
        }
        return _or;
    };

    public ExpressionOrFunctionCallRule(AnnotationMirror metaAnnotation, Element metaElement, Class<? extends T> type, String exprAvName, String langAvName, String functionAvName, String avPrefix, Functions.Function0<? extends T> defaultValue, boolean nullable, Functions.Function3<? super Boolean, ? super Object, ? super IParameterlessFunctionRule<?>, ?> combiner) {
        super(metaAnnotation, metaElement);
        boolean _not;
        this.exprAvName = RuleUtils.withPrefix(exprAvName, avPrefix);
        this.functionAvName = RuleUtils.withPrefix(functionAvName, avPrefix);
        String _value = null;
        if (metaAnnotation != null) {
            _value = this._elementsExtensions.value(metaAnnotation, this.exprAvName, String.class);
        }
        String exprFromAv = _value;
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(exprFromAv);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _xifexpression = exprFromAv;
        } else {
            String _docCommentUsingRuntimeMetadata = null;
            if (metaElement != null) {
                _docCommentUsingRuntimeMetadata = this._elementsExtensions.getDocCommentUsingRuntimeMetadata(metaElement);
            }
            Map<String, String> _code = JavadocUtil.getCode(_docCommentUsingRuntimeMetadata);
            String _get = null;
            if (_code != null) {
                _get = _code.get(exprAvName);
            }
            _xifexpression = _get;
        }
        this.expr = _xifexpression;
        String _value_1 = null;
        if (metaAnnotation != null) {
            _value_1 = this._elementsExtensions.value(metaAnnotation, RuleUtils.withPrefix(langAvName, avPrefix), String.class);
        }
        this.lang = _value_1;
        TypeElement[] _value_2 = null;
        if (metaAnnotation != null) {
            _value_2 = this._elementsExtensions.value(metaAnnotation, this.functionAvName, TypeElement[].class);
        }
        this.functionClasses = _value_2;
        this.defaultValue = defaultValue;
        this.nullable = nullable;
        Functions.Function3<? super Boolean, ? super Object, ? super IParameterlessFunctionRule<?>, ?> _elvis = null;
        _elvis = combiner != null ? combiner : FLUENT_COMBINER;
        this.combiner = _elvis;
        this.type = type;
    }

    public static <T> ExpressionOrFunctionCallRule<T> ruleOrNullIfUndefined(AnnotationMirror metaAnnotation, Element metaElement, Class<? extends T> type, String exprAvName, String langAvName, String functionAvName, String avPrefix, Functions.Function0<? extends T> defaultValue, boolean nullable, Functions.Function3<? super Boolean, ? super Object, ? super IParameterlessFunctionRule<?>, ?> combiner) {
        ExpressionOrFunctionCallRule<T> rule = new ExpressionOrFunctionCallRule<T>(metaAnnotation, metaElement, type, exprAvName, langAvName, functionAvName, avPrefix, defaultValue, nullable, combiner);
        ExpressionOrFunctionCallRule<T> _xifexpression = null;
        boolean _isUndefined = rule.isUndefined();
        _xifexpression = _isUndefined ? null : rule;
        return _xifexpression;
    }

    public boolean isUndefined() {
        return StringExtensions.isNullOrEmpty((String)this.expr) && IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)this.functionClasses))) && this.defaultValue == null;
    }

    public T apply() {
        Functions.Function1 _function = it -> {
            boolean _not_2;
            boolean _not_1;
            boolean _not;
            Object _xblockexpression = null;
            boolean _isUndefined = this.isUndefined();
            if (_isUndefined) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Either ");
                _builder.append(this.exprAvName);
                _builder.append(" or ");
                _builder.append(this.functionAvName);
                _builder.append(" must be set.");
                throw new RuleException(_builder.toString());
            }
            Object UNDEFINED = new Object();
            Object _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.expr);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                Functions.Function0 _function_1 = () -> this.checkNotNull(this._eLSupport.eval(this.expr, this.lang, this.type, true, LibraryRule.findELImports(this.getMetaElement())));
                _xifexpression = this._ruleUtils.handleException(null, this.exprAvName, _function_1);
            } else {
                _xifexpression = UNDEFINED;
            }
            Object exprResult = _xifexpression;
            if (exprResult == null) {
                return null;
            }
            List _xifexpression_1 = null;
            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)this.functionClasses)));
            boolean bl2 = _not_1 = !_isNullOrEmpty_1;
            if (_not_1) {
                Functions.Function1 _function_2 = it_1 -> {
                    IParameterlessFunctionRule<?> _xblockexpression_1 = null;
                    IParameterlessFunctionRule<?> function = this._ruleFactory.createFunctionRule((Element)it_1);
                    if (function == null) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append(it_1);
                        _builder_1.append(" is not a function.");
                        throw new RuleException(_builder_1.toString());
                    }
                    _xblockexpression_1 = function;
                    return _xblockexpression_1;
                };
                _xifexpression_1 = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)this.functionClasses)), (Functions.Function1)_function_2);
            } else {
                _xifexpression_1 = CollectionLiterals.emptyList();
            }
            List functionRules = _xifexpression_1;
            Object _xifexpression_2 = null;
            boolean _isNullOrEmpty_2 = IterableExtensions.isNullOrEmpty((Iterable)functionRules);
            boolean bl3 = _not_2 = !_isNullOrEmpty_2;
            if (_not_2) {
                Functions.Function0 _function_3 = () -> {
                    boolean _not_3;
                    Object _xblockexpression_1 = null;
                    Object r = exprResult;
                    for (IParameterlessFunctionRule function : functionRules) {
                        try {
                            boolean _equals = Objects.equal((Object)r, (Object)UNDEFINED);
                            if ((r = this.checkNotNull(this.combiner.apply((Object)_equals, r, (Object)function))) != null) continue;
                            return null;
                        }
                        catch (Throwable _t) {
                            if (_t instanceof TypeElementNotFoundException) {
                                TypeElementNotFoundException tenfe = (TypeElementNotFoundException)_t;
                                throw tenfe;
                            }
                            if (_t instanceof Exception) {
                                Exception e = (Exception)_t;
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append("Error when calling function ");
                                Element _metaElement = null;
                                if (function != null) {
                                    _metaElement = function.getMetaElement();
                                }
                                Name _simpleName = null;
                                if (_metaElement != null) {
                                    _simpleName = _metaElement.getSimpleName();
                                }
                                _builder_1.append((Object)_simpleName);
                                _builder_1.append(": ");
                                String _message = e.getMessage();
                                _builder_1.append(_message);
                                throw new RuleException(_builder_1.toString());
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                    boolean _isInstance = this.type.isInstance(r);
                    boolean bl = _not_3 = !_isInstance;
                    if (_not_3) {
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("The function ");
                        IParameterlessFunctionRule _last = (IParameterlessFunctionRule)IterableExtensions.last((Iterable)functionRules);
                        Element _metaElement_1 = null;
                        if (_last != null) {
                            _metaElement_1 = _last.getMetaElement();
                        }
                        Name _simpleName_1 = null;
                        if (_metaElement_1 != null) {
                            _simpleName_1 = _metaElement_1.getSimpleName();
                        }
                        _builder_2.append((Object)_simpleName_1);
                        _builder_2.append(" returned ");
                        _builder_2.append(r);
                        _builder_2.append(" of type ");
                        Class<?> _class = null;
                        if (r != null) {
                            _class = r.getClass();
                        }
                        _builder_2.append(_class);
                        _builder_2.append(", but the required type is ");
                        _builder_2.append(this.type);
                        throw new RuleException(_builder_2.toString());
                    }
                    _xblockexpression_1 = r;
                    return _xblockexpression_1;
                };
                _xifexpression_2 = this._ruleUtils.handleException(null, this.functionAvName, _function_3);
            } else {
                _xifexpression_2 = exprResult;
            }
            Object result = _xifexpression_2;
            boolean _equals = Objects.equal((Object)result, (Object)UNDEFINED);
            if (_equals) {
                return this.defaultValue.apply();
            }
            _xblockexpression = result;
            return _xblockexpression;
        };
        return this.inRule(_function);
    }

    public <V> V checkNotNull(V value) {
        V _xblockexpression = null;
        if (value == null && !this.nullable) {
            throw new RuleException("The result is null. This is not allowed here.");
        }
        _xblockexpression = value;
        return _xblockexpression;
    }

    @Override
    @Pure
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.exprAvName == null ? 0 : this.exprAvName.hashCode());
        result = 31 * result + (this.functionAvName == null ? 0 : this.functionAvName.hashCode());
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        result = 31 * result + (this.functionClasses == null ? 0 : Arrays.deepHashCode(this.functionClasses));
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.combiner == null ? 0 : this.combiner.hashCode());
        result = 31 * result + (this.nullable ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ExpressionOrFunctionCallRule other = (ExpressionOrFunctionCallRule)obj;
        if (this.exprAvName == null ? other.exprAvName != null : !this.exprAvName.equals(other.exprAvName)) {
            return false;
        }
        if (this.functionAvName == null ? other.functionAvName != null : !this.functionAvName.equals(other.functionAvName)) {
            return false;
        }
        if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
            return false;
        }
        if (this.lang == null ? other.lang != null : !this.lang.equals(other.lang)) {
            return false;
        }
        if (this.functionClasses == null ? other.functionClasses != null : !Arrays.deepEquals(this.functionClasses, other.functionClasses)) {
            return false;
        }
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.combiner == null ? other.combiner != null : !this.combiner.equals(other.combiner)) {
            return false;
        }
        if (other.nullable != this.nullable) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public String getExprAvName() {
        return this.exprAvName;
    }

    @Pure
    public String getFunctionAvName() {
        return this.functionAvName;
    }

    @Pure
    public String getExpr() {
        return this.expr;
    }

    @Pure
    public String getLang() {
        return this.lang;
    }

    @Pure
    public TypeElement[] getFunctionClasses() {
        return this.functionClasses;
    }

    @Pure
    public Functions.Function0<? extends T> getDefaultValue() {
        return this.defaultValue;
    }

    @Pure
    public Functions.Function3<? super Boolean, ? super Object, ? super IParameterlessFunctionRule<?>, ?> getCombiner() {
        return this.combiner;
    }

    @Pure
    public boolean isNullable() {
        return this.nullable;
    }

    @Pure
    public Class<? extends T> getType() {
        return this.type;
    }
}

