/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class JavadocUtil {
    private static final Pattern paramPattern = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("@param\\s*(\\S+)\\s*([^@]*)");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private static final Pattern returnPattern = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("@return\\s*([^@]*)");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private static final Pattern codePattern1 = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(?:@|<li>)japkit\\.(\\S+)\\s*<pre>\\s*\\{@code\\s*([\\s\\S]*?)\\}\\s*</pre>");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private static final Pattern codePattern2 = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(?:@|<li>)japkit\\.(\\S+)\\s*<pre>\\s*<code>\\s*([\\s\\S]*?)</code>\\s*</pre>");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private static final Pattern codePattern3 = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(?:@|<li>)japkit\\.(\\S+)\\s*<code>\\s*([\\s\\S]*?)</code>");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private static final Pattern codePattern4 = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(?:@|<li>)japkit\\.(\\S+)\\s*<pre>\\s*([\\s\\S]*?)</pre>");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private static final Pattern codePattern5 = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(?:@|<li>)japkit\\.(\\S+)[\\t\\f ]*([\\s\\S]*?)(?:$|[\\r\\n])");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private static final Pattern emptyUL = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<ul>\\s*</ul>");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private static final Pattern leadingWhiteSpaceAfterLinebreak = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("\\n ");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();

    public static Map<String, String> getParams(CharSequence javadoc) {
        return JavadocUtil.getMapFromTwoGroups(javadoc, paramPattern);
    }

    public static String getReturn(CharSequence javadoc) {
        String _xblockexpression = null;
        Pattern pattern = returnPattern;
        _xblockexpression = JavadocUtil.getFirstGroup(javadoc, pattern);
        return _xblockexpression;
    }

    public static String getFirstGroup(CharSequence javadoc, Pattern pattern) {
        String _xblockexpression = null;
        if (javadoc == null) {
            return "";
        }
        Matcher matcher = pattern.matcher(javadoc);
        String _xifexpression = null;
        boolean _find = matcher.find();
        if (_find) {
            String _group = matcher.group(1);
            String _trim = null;
            if (_group != null) {
                _trim = _group.trim();
            }
            _xifexpression = _trim;
        } else {
            _xifexpression = "";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static Map<String, String> getCode(CharSequence javadoc) {
        Functions.Function1 _function = it -> leadingWhiteSpaceAfterLinebreak.matcher((CharSequence)it).replaceAll("\n");
        return MapExtensions.mapValues(JavadocUtil.getMapFromTwoGroups(javadoc, codePattern1, codePattern2, codePattern3, codePattern4, codePattern5), (Functions.Function1)_function);
    }

    public static String removeCode(CharSequence javadoc) {
        return JavadocUtil.remove(javadoc, codePattern1, codePattern2, codePattern3, codePattern4, codePattern5, emptyUL);
    }

    public static Map<String, String> getMapFromTwoGroups(CharSequence javadoc, Pattern ... patterns) {
        Map _xifexpression = null;
        if (javadoc == null) {
            _xifexpression = CollectionLiterals.emptyMap();
        } else {
            HashMap _xblockexpression = null;
            HashMap map = CollectionLiterals.newHashMap();
            Consumer<Pattern> _function = it -> {
                Matcher matcher = it.matcher(javadoc);
                Procedures.Procedure1 _function_1 = it_1 -> {
                    while (it_1.find()) {
                        boolean _containsKey = map.containsKey(it_1.group(1));
                        boolean _not = !_containsKey;
                        if (!_not) continue;
                        String _group = it_1.group(1);
                        String _group_1 = it_1.group(2);
                        String _trim = null;
                        if (_group_1 != null) {
                            _trim = _group_1.trim();
                        }
                        map.put(_group, _trim);
                    }
                };
                ObjectExtensions.operator_doubleArrow((Object)matcher, (Procedures.Procedure1)_function_1);
            };
            ((List)Conversions.doWrapArray((Object)patterns)).forEach(_function);
            _xblockexpression = map;
            _xifexpression = _xblockexpression;
        }
        return _xifexpression;
    }

    public static String remove(CharSequence javadoc, Pattern ... patterns) {
        String _xifexpression = null;
        if (javadoc == null) {
            _xifexpression = null;
        } else {
            String _xblockexpression = null;
            CharSequence result = javadoc;
            for (Pattern p : patterns) {
                result = p.matcher(result).replaceAll("");
            }
            _xifexpression = _xblockexpression = result.toString().trim();
        }
        return _xifexpression;
    }

    public static void main(String[] params) {
        System.out.println(JavadocUtil.getCode("@japkit.code1 \n <code>testbar1</code> @japkit.code2 \n <pre><code>testbar2</code></pre>"));
    }
}

