/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import de.japkit.el.ELSupport;
import de.japkit.model.GenElement;
import de.japkit.rules.AnnotationExtensions;
import de.japkit.rules.MatcherRule;
import de.japkit.rules.RuleFactory;
import de.japkit.rules.TypeResolver;
import de.japkit.services.ElementsExtensions;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.MessageCollector;
import de.japkit.services.TypesRegistry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class ManualOverrideRule {
    @Extension
    private final transient ElementsExtensions _elementsExtensions = ExtensionRegistry.get(ElementsExtensions.class);
    @Extension
    private final transient TypeResolver _typeResolver = ExtensionRegistry.get(TypeResolver.class);
    @Extension
    private final transient RuleFactory _ruleFactory = ExtensionRegistry.get(RuleFactory.class);
    @Extension
    private final transient TypesRegistry _typesRegistry = ExtensionRegistry.get(TypesRegistry.class);
    @Extension
    private final transient MessageCollector _messageCollector = ExtensionRegistry.get(MessageCollector.class);
    @Extension
    private final transient ELSupport _eLSupport = ExtensionRegistry.get(ELSupport.class);
    @Extension
    protected final transient AnnotationExtensions annotationExtensions = ExtensionRegistry.get(AnnotationExtensions.class);
    private final TypeMirror manualOverrides;
    private final Functions.Function1<? super Element, ? extends Boolean> manualOverridesMatcher;

    public ManualOverrideRule(AnnotationMirror metaAnnotation) {
        TypeMirror _value = null;
        if (metaAnnotation != null) {
            _value = this._elementsExtensions.value(metaAnnotation, "manualOverrides", TypeMirror.class);
        }
        this.manualOverrides = _value;
        AnnotationMirror _value_1 = null;
        if (metaAnnotation != null) {
            _value_1 = this._elementsExtensions.value(metaAnnotation, "manualOverridesMatcher", AnnotationMirror.class);
        }
        MatcherRule _createMatcherRule = null;
        if (_value_1 != null) {
            _createMatcherRule = this._ruleFactory.createMatcherRule(_value_1);
        }
        this.manualOverridesMatcher = _createMatcherRule;
    }

    public void apply(Iterable<? extends GenElement> elementsToOverride) {
        List _emptyList;
        TypeElement overridesSource;
        TypeMirror _resolveType = null;
        if (this.manualOverrides != null) {
            _resolveType = this._typeResolver.resolveType(this.manualOverrides);
        }
        TypeElement _asTypeElement = null;
        if (_resolveType != null) {
            _asTypeElement = this._typesRegistry.asTypeElement(_resolveType);
        }
        if ((overridesSource = _asTypeElement) == null) {
            return;
        }
        Iterable _elvis = null;
        List<? extends Element> _enclosedElements = null;
        if (overridesSource != null) {
            _enclosedElements = overridesSource.getEnclosedElements();
        }
        Iterable _filter = null;
        if (_enclosedElements != null) {
            Functions.Function1 _function = it -> (Boolean)this.manualOverridesMatcher.apply(it);
            _filter = IterableExtensions.filter(_enclosedElements, (Functions.Function1)_function);
        }
        _elvis = _filter != null ? _filter : (_emptyList = CollectionLiterals.emptyList());
        Functions.Function1 _function_1 = it -> it.getSimpleName().toString();
        Map overrideElementsByName = IterableExtensions.toMap((Iterable)_elvis, (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> it.getSimpleName().toString();
        Set elementsToOverrideNames = IterableExtensions.toSet((Iterable)IterableExtensions.map(elementsToOverride, (Functions.Function1)_function_2));
        BiConsumer<String, Element> _function_3 = (oeName, oe) -> {
            boolean _not;
            boolean _contains = elementsToOverrideNames.contains(oeName);
            boolean bl = _not = !_contains;
            if (_not) {
                Functions.Function1 _function_4 = it -> {
                    Object _xblockexpression = null;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("No generated element exists with name ");
                    _builder.append(oeName);
                    _builder.append(". Generated elements are: ");
                    _builder.append((Object)elementsToOverrideNames);
                    this._messageCollector.reportRuleError(_builder);
                    _xblockexpression = null;
                    return _xblockexpression;
                };
                this._eLSupport.scope(oe, _function_4);
            }
        };
        overrideElementsByName.forEach(_function_3);
        Consumer<GenElement> _function_4 = it -> {
            Element overrideElement = (Element)overrideElementsByName.get(it.getSimpleName().toString());
            if (overrideElement != null) {
                List<? extends AnnotationMirror> _annotationMirrors = it.getAnnotationMirrors();
                it.setAnnotationMirrors(this.annotationExtensions.overrideAnnotations(overrideElement, _annotationMirrors));
            }
        };
        elementsToOverride.forEach(_function_4);
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.manualOverrides == null ? 0 : this.manualOverrides.hashCode());
        result = 31 * result + (this.manualOverridesMatcher == null ? 0 : this.manualOverridesMatcher.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ManualOverrideRule other = (ManualOverrideRule)obj;
        if (this.manualOverrides == null ? other.manualOverrides != null : !this.manualOverrides.equals(other.manualOverrides)) {
            return false;
        }
        return !(this.manualOverridesMatcher == null ? other.manualOverridesMatcher != null : !this.manualOverridesMatcher.equals(other.manualOverridesMatcher));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("manualOverrides", (Object)this.manualOverrides);
        b.add("manualOverridesMatcher", this.manualOverridesMatcher);
        return b.toString();
    }

    @Pure
    public TypeMirror getManualOverrides() {
        return this.manualOverrides;
    }

    @Pure
    public Functions.Function1<? super Element, ? extends Boolean> getManualOverridesMatcher() {
        return this.manualOverridesMatcher;
    }
}

