/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import com.google.common.base.Objects;
import de.japkit.metaannotations.TypeCategory;
import de.japkit.rules.AbstractFunctionRule;
import de.japkit.rules.ConstraintRule;
import de.japkit.services.RuleException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class MatcherRule
extends AbstractFunctionRule<Boolean> {
    private final String srcExpr;
    private final String srcLang;
    private final String name;
    private final Modifier[] modifiers;
    private final Modifier[] modifiersNot;
    private final Set<ElementKind> kind;
    private final DeclaredType[] annotations;
    private final DeclaredType[] annotationsNot;
    private final DeclaredType[] enclosingAnnotations;
    private final DeclaredType[] enclosingAnnotationsNot;
    private final Set<String> notDeclaredBy;
    private final TypeMirror elementType;
    private final TypeCategory[] typeCategory;
    private final TypeCategory[] typeCategoryNot;
    private final DeclaredType[] typeAnnotations;
    private final TypeMirror singleValueType;
    private final TypeCategory[] singleValueTypeCategory;
    private final TypeCategory[] singleValueTypeCategoryNot;
    private final DeclaredType[] singleValueTypeAnnotations;
    private final DeclaredType[] typeArg0Annotations;
    private final DeclaredType[] typeArg1Annotations;
    private final String condition;
    private final String conditionLang;
    private final ConstraintRule[] constraints;
    private final Functions.Function1<? super CharSequence, ? extends Boolean> nameIn;
    private final Functions.Function1<? super CharSequence, ? extends Boolean> nameNotIn;

    public Iterable<?> filter(Iterable<?> elements) {
        Functions.Function1 _function = it -> {
            Boolean _xblockexpression = null;
            if (!(it instanceof Element)) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Matcher can only be applied to elements, but not to ");
                _builder.append(it);
                throw new IllegalArgumentException(_builder.toString());
            }
            _xblockexpression = this.matches((Element)it);
            return _xblockexpression;
        };
        return IterableExtensions.filter(elements, (Functions.Function1)_function);
    }

    public Boolean matches(Element originalSrcElement) {
        return (Boolean)this.apply(originalSrcElement);
    }

    @Override
    public Boolean evalInternal() {
        Boolean _xblockexpression = null;
        Object src = this.srcElementOrType(this._eLSupport.getCurrentSrc());
        Functions.Function1 _function = it -> {
            boolean result;
            boolean _xblockexpression_1 = false;
            Element _xifexpression = null;
            if (src instanceof Element) {
                _xifexpression = (Element)src;
            }
            Element e = _xifexpression;
            TypeMirror _xifexpression_1 = null;
            if (src instanceof TypeMirror) {
                _xifexpression_1 = (TypeMirror)src;
            } else {
                TypeMirror _srcType = null;
                if (e != null) {
                    _srcType = this._elementsExtensions.srcType(e);
                }
                _xifexpression_1 = _srcType;
            }
            TypeMirror type = _xifexpression_1;
            if (e == null && type == null) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("For a Matcher, the source must be an Element or a TypeMirror, but src ");
                _builder.append(src);
                _builder.append(" is of type ");
                Class<?> _class = null;
                if (src != null) {
                    _class = src.getClass();
                }
                _builder.append(_class);
                throw new RuleException(_builder.toString());
            }
            if (e == null && this.hasAnyElementConditions()) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("The Matcher has conditions that apply to an Element, but src ");
                _builder_1.append(src);
                _builder_1.append(" is a TypeMirror.");
                throw new RuleException(_builder_1.toString());
            }
            boolean bl = result = !(e != null && !this.fulfillsElementConditions(e) || type != null && !this.fulfillsTypeConditions(type) || !this.fulfillsConditionExpression());
            if (result) {
                Consumer<ConstraintRule> _function_1 = it_1 -> it_1.validate();
                ((List)Conversions.doWrapArray((Object)this.constraints)).forEach(_function_1);
            }
            _xblockexpression_1 = result;
            return _xblockexpression_1;
        };
        _xblockexpression = (Boolean)this._eLSupport.scope(src, _function);
        return _xblockexpression;
    }

    private boolean fulfillsTypeConditions(TypeMirror type) {
        return !(!this.hasAllAnnotations(type, this.typeAnnotations) || !this.isSubtype(type, this.elementType) || !IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)this.typeCategory))) && !this.belongsToOneOfCategories(type, this.typeCategory) || this.belongsToOneOfCategories(type, this.typeCategoryNot) || !this.hasAllAnnotations(this._typesExtensions.singleValueType(type), this.singleValueTypeAnnotations) || !this.isSubtype(this._typesExtensions.singleValueType(type), this.singleValueType) || !IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)this.singleValueTypeCategory))) && !this.belongsToOneOfCategories(this._typesExtensions.singleValueType(type), this.singleValueTypeCategory) || this.belongsToOneOfCategories(this._typesExtensions.singleValueType(type), this.singleValueTypeCategoryNot) || !this.typeArgHasAllAnnotations(type, this.typeArg0Annotations, 0) || !this.typeArgHasAllAnnotations(type, this.typeArg1Annotations, 1));
    }

    private boolean fulfillsElementConditions(Element e) {
        boolean _isNotDeclaredBy;
        boolean _hasNotAnnotations_1;
        boolean _hasAllAnnotations_1;
        boolean _hasNotAnnotations;
        boolean _hasAllAnnotations;
        boolean _hasAnyKind;
        boolean _hasNotModifiers;
        boolean _hasAllModifiers;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        boolean _and_3 = false;
        boolean _and_4 = false;
        boolean _and_5 = false;
        boolean _and_6 = false;
        boolean _and_7 = false;
        boolean _and_8 = false;
        boolean _and_9 = false;
        if (!StringExtensions.isNullOrEmpty((String)this.name) && !this.name.contentEquals(e.getSimpleName())) {
            _and_9 = false;
        } else {
            Boolean _elvis = null;
            Boolean _apply = null;
            if (this.nameIn != null) {
                _apply = (Boolean)this.nameIn.apply((Object)e.getSimpleName());
            }
            _elvis = _apply != null ? _apply : Boolean.valueOf(true);
            _and_9 = _elvis;
        }
        if (!_and_9) {
            _and_8 = false;
        } else {
            boolean _not;
            Boolean _elvis_1 = null;
            Boolean _apply_1 = null;
            if (this.nameNotIn != null) {
                _apply_1 = (Boolean)this.nameNotIn.apply((Object)e.getSimpleName());
            }
            _elvis_1 = _apply_1 != null ? _apply_1 : Boolean.valueOf(false);
            _and_8 = _not = _elvis_1 == false;
        }
        _and_7 = !_and_8 ? false : (_hasAllModifiers = this.hasAllModifiers(e, this.modifiers));
        _and_6 = !_and_7 ? false : (_hasNotModifiers = this.hasNotModifiers(e, this.modifiersNot));
        _and_5 = !_and_6 ? false : (_hasAnyKind = this.hasAnyKind(e, (ElementKind[])Conversions.unwrapArray(this.kind, ElementKind.class)));
        _and_4 = !_and_5 ? false : (_hasAllAnnotations = this.hasAllAnnotations(e, this.annotations));
        _and_3 = !_and_4 ? false : (_hasNotAnnotations = this.hasNotAnnotations(e, this.annotationsNot));
        _and_2 = !_and_3 ? false : (_hasAllAnnotations_1 = this.hasAllAnnotations(e.getEnclosingElement(), this.enclosingAnnotations));
        _and_1 = !_and_2 ? false : (_hasNotAnnotations_1 = this.hasNotAnnotations(e.getEnclosingElement(), this.enclosingAnnotationsNot));
        _and = !_and_1 ? false : (_isNotDeclaredBy = this.isNotDeclaredBy(e, this.notDeclaredBy));
        return _and;
    }

    private boolean hasAnyElementConditions() {
        return !StringExtensions.isNullOrEmpty((String)this.name) || this.nameIn != null || this.nameNotIn != null || !((List)Conversions.doWrapArray((Object)this.modifiers)).isEmpty() || !((List)Conversions.doWrapArray((Object)this.modifiersNot)).isEmpty() || !this.kind.isEmpty() || !((List)Conversions.doWrapArray((Object)this.annotations)).isEmpty() || !((List)Conversions.doWrapArray((Object)this.annotationsNot)).isEmpty() || !((List)Conversions.doWrapArray((Object)this.enclosingAnnotations)).isEmpty() || !((List)Conversions.doWrapArray((Object)this.enclosingAnnotationsNot)).isEmpty() || !this.notDeclaredBy.isEmpty();
    }

    private Object srcElementOrType(Object src) {
        Object _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.srcExpr);
        if (_isNullOrEmpty) {
            _xifexpression = src;
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Could not evaluate source element expression '");
            _builder.append(this.srcExpr);
            _builder.append("' in element matcher. ");
            _xifexpression = this._eLSupport.eval(this.srcExpr, this.srcLang, Object.class, (CharSequence)_builder, null);
        }
        return _xifexpression;
    }

    private boolean isNotDeclaredBy(Element element, Set<String> notDeclaredByFqns) {
        return IterableExtensions.isNullOrEmpty(notDeclaredByFqns) || !notDeclaredByFqns.contains(((TypeElement)element.getEnclosingElement()).getQualifiedName().toString());
    }

    private boolean hasAnyKind(Element element, ElementKind[] kinds) {
        return IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)kinds))) || ((List)Conversions.doWrapArray((Object)kinds)).contains((Object)element.getKind());
    }

    private boolean hasAllModifiers(Element e, Modifier[] modifiers) {
        return IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)modifiers))) || IterableExtensions.forall((Iterable)((Iterable)Conversions.doWrapArray((Object)modifiers)), it -> e.getModifiers().contains(it));
    }

    private boolean hasNotModifiers(Element e, Modifier[] modifiers) {
        return IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)modifiers))) || IterableExtensions.forall((Iterable)((Iterable)Conversions.doWrapArray((Object)modifiers)), it -> {
            boolean _contains = e.getModifiers().contains(it);
            return !_contains;
        });
    }

    private boolean isSubtype(TypeMirror t1, TypeMirror type) {
        return this._typesExtensions.isJavaLangObject(type) || this._typesExtensions.isSubtype(t1, type);
    }

    private boolean belongsToOneOfCategories(TypeMirror type, TypeCategory[] categories) {
        Functions.Function1 _function = it -> this.belongsToCategory(type, (TypeCategory)it);
        return IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)categories)), (Functions.Function1)_function);
    }

    private Boolean belongsToCategory(TypeMirror type, TypeCategory category) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Could not determine type category of type ");
        _builder.append((Object)type);
        Functions.Function1 _function = it -> {
            boolean _switchResult = false;
            if (category != null) {
                switch (category) {
                    case PRIMITIVE: {
                        _switchResult = this._typesExtensions.isPrimitive(type) || this._typesExtensions.isBoxed(type);
                        break;
                    }
                    case STRING: {
                        _switchResult = this._typesExtensions.isString(type);
                        break;
                    }
                    case TEMPORAL: {
                        _switchResult = this._typesExtensions.isTemporal(type);
                        break;
                    }
                    case MATH: {
                        _switchResult = this._typesExtensions.isMath(type);
                        break;
                    }
                    case ARRAY: {
                        TypeKind _kind = type.getKind();
                        _switchResult = Objects.equal((Object)((Object)_kind), (Object)((Object)TypeKind.ARRAY));
                        break;
                    }
                    case COLLECTION: {
                        _switchResult = this._typesExtensions.isCollection(type);
                        break;
                    }
                    case MAP: {
                        _switchResult = this._typesExtensions.isMap(type);
                        break;
                    }
                    case LIST: {
                        _switchResult = this._typesExtensions.isList(type);
                        break;
                    }
                    case SET: {
                        _switchResult = this._typesExtensions.isSet(type);
                        break;
                    }
                    case ENUM: {
                        _switchResult = this._typesExtensions.isEnum(type);
                        break;
                    }
                    default: {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("Unknown type category ");
                        _builder_1.append((Object)category);
                        throw new IllegalArgumentException(_builder_1.toString());
                    }
                }
            } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Unknown type category ");
                _builder_1.append((Object)category);
                throw new IllegalArgumentException(_builder_1.toString());
            }
            return _switchResult;
        };
        return this._typesRegistry.handleTypeElementNotFound(false, (CharSequence)_builder, _function);
    }

    private boolean fulfillsConditionExpression() {
        boolean _or = false;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.condition);
        if (_isNullOrEmpty) {
            _or = true;
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Could not evaluate condition '");
            _builder.append(this.condition);
            _builder.append("' in element matcher. ");
            Boolean _eval = this._eLSupport.eval(this.condition, this.conditionLang, Boolean.class, (CharSequence)_builder, false);
            _or = _eval;
        }
        return _or;
    }

    private boolean hasAllAnnotations(TypeMirror type, DeclaredType[] annotations) {
        return IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)annotations))) || this.typeElementHasAllAnnotations(type, annotations);
    }

    private boolean typeArgHasAllAnnotations(TypeMirror type, DeclaredType[] annotations, int argIndex) {
        return IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)annotations))) || this.typeElementHasAllAnnotations(this._typesExtensions.getTypeArg(type, argIndex), annotations);
    }

    private boolean typeElementHasAllAnnotations(TypeMirror type, DeclaredType[] annotations) {
        boolean _not;
        Boolean _xblockexpression = null;
        boolean _isDeclaredOrError = this._typesExtensions.isDeclaredOrError(type);
        boolean bl = _not = !_isDeclaredOrError;
        if (_not) {
            return IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)annotations)));
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Matcher cannot determine annotations of type ");
        _builder.append((Object)type);
        Functions.Function1 _function = it -> type != null && this.hasAllAnnotations(this._typesRegistry.asTypeElement(type), annotations);
        _xblockexpression = this._typesRegistry.handleTypeElementNotFound(true, (CharSequence)_builder, _function);
        return _xblockexpression;
    }

    private boolean hasAllAnnotations(Element e, DeclaredType[] annotations) {
        Functions.Function1 _function = it -> this.hasAnnotation(e, (DeclaredType)it);
        return IterableExtensions.forall((Iterable)((Iterable)Conversions.doWrapArray((Object)annotations)), (Functions.Function1)_function);
    }

    private boolean hasNotAnnotations(Element e, DeclaredType[] annotations) {
        Functions.Function1 _function = it -> {
            boolean _hasAnnotation = this.hasAnnotation(e, (DeclaredType)it);
            return !_hasAnnotation;
        };
        return IterableExtensions.forall((Iterable)((Iterable)Conversions.doWrapArray((Object)annotations)), (Functions.Function1)_function);
    }

    private boolean hasAnnotation(Element e, DeclaredType annotationType) {
        Functions.Function1 _function = am -> this._elementsExtensions.hasFqn((AnnotationMirror)am, (CharSequence)this._typesExtensions.qualifiedName(annotationType));
        return IterableExtensions.exists(e.getAnnotationMirrors(), (Functions.Function1)_function);
    }

    public MatcherRule(AnnotationMirror am) {
        this(am, null);
    }

    public MatcherRule(AnnotationMirror am, Element element) {
        super(am, element, Boolean.TYPE);
        this.srcExpr = this._elementsExtensions.value(am, "src", String.class);
        this.srcLang = this._elementsExtensions.value(am, "srcLang", String.class);
        this.name = this._elementsExtensions.value(am, "name", String.class);
        this.modifiers = this._elementsExtensions.value(am, "modifiers", Modifier[].class);
        this.modifiersNot = this._elementsExtensions.value(am, "modifiersNot", Modifier[].class);
        ElementKind[] _value = this._elementsExtensions.value(am, "kind", ElementKind[].class);
        Set _set = null;
        if ((Iterable)Conversions.doWrapArray((Object)_value) != null) {
            _set = IterableExtensions.toSet((Iterable)((Iterable)Conversions.doWrapArray((Object)_value)));
        }
        this.kind = _set;
        this.annotations = this._elementsExtensions.value(am, "annotations", DeclaredType[].class);
        this.annotationsNot = this._elementsExtensions.value(am, "annotationsNot", DeclaredType[].class);
        this.enclosingAnnotations = this._elementsExtensions.value(am, "enclosingAnnotations", DeclaredType[].class);
        this.enclosingAnnotationsNot = this._elementsExtensions.value(am, "enclosingAnnotationsNot", DeclaredType[].class);
        DeclaredType[] _value_1 = this._elementsExtensions.value(am, "notDeclaredBy", DeclaredType[].class);
        List _map = null;
        if ((List)Conversions.doWrapArray((Object)_value_1) != null) {
            Functions.Function1 _function = it -> this._typesRegistry.asTypeElement((TypeMirror)it).getQualifiedName().toString();
            _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_value_1)), (Functions.Function1)_function);
        }
        this.notDeclaredBy = IterableExtensions.toSet(_map);
        this.elementType = this._elementsExtensions.value(am, "type", TypeMirror.class);
        this.typeCategory = this._elementsExtensions.value(am, "typeCategory", TypeCategory[].class);
        this.typeCategoryNot = this._elementsExtensions.value(am, "typeCategoryNot", TypeCategory[].class);
        this.typeAnnotations = this._elementsExtensions.value(am, "typeAnnotations", DeclaredType[].class);
        this.singleValueType = this._elementsExtensions.value(am, "singleValueType", TypeMirror.class);
        this.singleValueTypeCategory = this._elementsExtensions.value(am, "singleValueTypeCategory", TypeCategory[].class);
        this.singleValueTypeCategoryNot = this._elementsExtensions.value(am, "singleValueTypeCategoryNot", TypeCategory[].class);
        this.singleValueTypeAnnotations = this._elementsExtensions.value(am, "singleValueTypeAnnotations", DeclaredType[].class);
        this.typeArg0Annotations = this._elementsExtensions.value(am, "typeArg0Annotations", DeclaredType[].class);
        this.typeArg1Annotations = this._elementsExtensions.value(am, "typeArg1Annotations", DeclaredType[].class);
        this.condition = this._elementsExtensions.value(am, "condition", String.class);
        this.conditionLang = this._elementsExtensions.value(am, "conditionLang", String.class);
        Functions.Function1 _function_1 = it -> new ConstraintRule((AnnotationMirror)it);
        this.constraints = (ConstraintRule[])Conversions.unwrapArray((Object)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)this._elementsExtensions.value(am, "constraints", AnnotationMirror[].class))), (Functions.Function1)_function_1), ConstraintRule.class);
        this.nameIn = this._ruleUtils.createNameInSetRule(am, "nameIn");
        this.nameNotIn = this._ruleUtils.createNameInSetRule(am, "nameNotIn");
    }

    @Override
    @Pure
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.srcExpr == null ? 0 : this.srcExpr.hashCode());
        result = 31 * result + (this.srcLang == null ? 0 : this.srcLang.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.modifiers == null ? 0 : Arrays.deepHashCode((Object[])this.modifiers));
        result = 31 * result + (this.modifiersNot == null ? 0 : Arrays.deepHashCode((Object[])this.modifiersNot));
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.annotations == null ? 0 : Arrays.deepHashCode(this.annotations));
        result = 31 * result + (this.annotationsNot == null ? 0 : Arrays.deepHashCode(this.annotationsNot));
        result = 31 * result + (this.enclosingAnnotations == null ? 0 : Arrays.deepHashCode(this.enclosingAnnotations));
        result = 31 * result + (this.enclosingAnnotationsNot == null ? 0 : Arrays.deepHashCode(this.enclosingAnnotationsNot));
        result = 31 * result + (this.notDeclaredBy == null ? 0 : this.notDeclaredBy.hashCode());
        result = 31 * result + (this.elementType == null ? 0 : this.elementType.hashCode());
        result = 31 * result + (this.typeCategory == null ? 0 : Arrays.deepHashCode(this.typeCategory));
        result = 31 * result + (this.typeCategoryNot == null ? 0 : Arrays.deepHashCode(this.typeCategoryNot));
        result = 31 * result + (this.typeAnnotations == null ? 0 : Arrays.deepHashCode(this.typeAnnotations));
        result = 31 * result + (this.singleValueType == null ? 0 : this.singleValueType.hashCode());
        result = 31 * result + (this.singleValueTypeCategory == null ? 0 : Arrays.deepHashCode(this.singleValueTypeCategory));
        result = 31 * result + (this.singleValueTypeCategoryNot == null ? 0 : Arrays.deepHashCode(this.singleValueTypeCategoryNot));
        result = 31 * result + (this.singleValueTypeAnnotations == null ? 0 : Arrays.deepHashCode(this.singleValueTypeAnnotations));
        result = 31 * result + (this.typeArg0Annotations == null ? 0 : Arrays.deepHashCode(this.typeArg0Annotations));
        result = 31 * result + (this.typeArg1Annotations == null ? 0 : Arrays.deepHashCode(this.typeArg1Annotations));
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        result = 31 * result + (this.conditionLang == null ? 0 : this.conditionLang.hashCode());
        result = 31 * result + (this.constraints == null ? 0 : Arrays.deepHashCode(this.constraints));
        result = 31 * result + (this.nameIn == null ? 0 : this.nameIn.hashCode());
        result = 31 * result + (this.nameNotIn == null ? 0 : this.nameNotIn.hashCode());
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MatcherRule other = (MatcherRule)obj;
        if (this.srcExpr == null ? other.srcExpr != null : !this.srcExpr.equals(other.srcExpr)) {
            return false;
        }
        if (this.srcLang == null ? other.srcLang != null : !this.srcLang.equals(other.srcLang)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.modifiers == null ? other.modifiers != null : !Arrays.deepEquals((Object[])this.modifiers, (Object[])other.modifiers)) {
            return false;
        }
        if (this.modifiersNot == null ? other.modifiersNot != null : !Arrays.deepEquals((Object[])this.modifiersNot, (Object[])other.modifiersNot)) {
            return false;
        }
        if (this.kind == null ? other.kind != null : !this.kind.equals(other.kind)) {
            return false;
        }
        if (this.annotations == null ? other.annotations != null : !Arrays.deepEquals(this.annotations, other.annotations)) {
            return false;
        }
        if (this.annotationsNot == null ? other.annotationsNot != null : !Arrays.deepEquals(this.annotationsNot, other.annotationsNot)) {
            return false;
        }
        if (this.enclosingAnnotations == null ? other.enclosingAnnotations != null : !Arrays.deepEquals(this.enclosingAnnotations, other.enclosingAnnotations)) {
            return false;
        }
        if (this.enclosingAnnotationsNot == null ? other.enclosingAnnotationsNot != null : !Arrays.deepEquals(this.enclosingAnnotationsNot, other.enclosingAnnotationsNot)) {
            return false;
        }
        if (this.notDeclaredBy == null ? other.notDeclaredBy != null : !this.notDeclaredBy.equals(other.notDeclaredBy)) {
            return false;
        }
        if (this.elementType == null ? other.elementType != null : !this.elementType.equals(other.elementType)) {
            return false;
        }
        if (this.typeCategory == null ? other.typeCategory != null : !Arrays.deepEquals(this.typeCategory, other.typeCategory)) {
            return false;
        }
        if (this.typeCategoryNot == null ? other.typeCategoryNot != null : !Arrays.deepEquals(this.typeCategoryNot, other.typeCategoryNot)) {
            return false;
        }
        if (this.typeAnnotations == null ? other.typeAnnotations != null : !Arrays.deepEquals(this.typeAnnotations, other.typeAnnotations)) {
            return false;
        }
        if (this.singleValueType == null ? other.singleValueType != null : !this.singleValueType.equals(other.singleValueType)) {
            return false;
        }
        if (this.singleValueTypeCategory == null ? other.singleValueTypeCategory != null : !Arrays.deepEquals(this.singleValueTypeCategory, other.singleValueTypeCategory)) {
            return false;
        }
        if (this.singleValueTypeCategoryNot == null ? other.singleValueTypeCategoryNot != null : !Arrays.deepEquals(this.singleValueTypeCategoryNot, other.singleValueTypeCategoryNot)) {
            return false;
        }
        if (this.singleValueTypeAnnotations == null ? other.singleValueTypeAnnotations != null : !Arrays.deepEquals(this.singleValueTypeAnnotations, other.singleValueTypeAnnotations)) {
            return false;
        }
        if (this.typeArg0Annotations == null ? other.typeArg0Annotations != null : !Arrays.deepEquals(this.typeArg0Annotations, other.typeArg0Annotations)) {
            return false;
        }
        if (this.typeArg1Annotations == null ? other.typeArg1Annotations != null : !Arrays.deepEquals(this.typeArg1Annotations, other.typeArg1Annotations)) {
            return false;
        }
        if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
            return false;
        }
        if (this.conditionLang == null ? other.conditionLang != null : !this.conditionLang.equals(other.conditionLang)) {
            return false;
        }
        if (this.constraints == null ? other.constraints != null : !Arrays.deepEquals(this.constraints, other.constraints)) {
            return false;
        }
        if (this.nameIn == null ? other.nameIn != null : !this.nameIn.equals(other.nameIn)) {
            return false;
        }
        return !(this.nameNotIn == null ? other.nameNotIn != null : !this.nameNotIn.equals(other.nameNotIn));
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public String getSrcExpr() {
        return this.srcExpr;
    }

    @Pure
    public String getSrcLang() {
        return this.srcLang;
    }

    @Pure
    public String getName() {
        return this.name;
    }

    @Pure
    public Modifier[] getModifiers() {
        return this.modifiers;
    }

    @Pure
    public Modifier[] getModifiersNot() {
        return this.modifiersNot;
    }

    @Pure
    public Set<ElementKind> getKind() {
        return this.kind;
    }

    @Pure
    public DeclaredType[] getAnnotations() {
        return this.annotations;
    }

    @Pure
    public DeclaredType[] getAnnotationsNot() {
        return this.annotationsNot;
    }

    @Pure
    public DeclaredType[] getEnclosingAnnotations() {
        return this.enclosingAnnotations;
    }

    @Pure
    public DeclaredType[] getEnclosingAnnotationsNot() {
        return this.enclosingAnnotationsNot;
    }

    @Pure
    public Set<String> getNotDeclaredBy() {
        return this.notDeclaredBy;
    }

    @Pure
    public TypeMirror getElementType() {
        return this.elementType;
    }

    @Pure
    public TypeCategory[] getTypeCategory() {
        return this.typeCategory;
    }

    @Pure
    public TypeCategory[] getTypeCategoryNot() {
        return this.typeCategoryNot;
    }

    @Pure
    public DeclaredType[] getTypeAnnotations() {
        return this.typeAnnotations;
    }

    @Pure
    public TypeMirror getSingleValueType() {
        return this.singleValueType;
    }

    @Pure
    public TypeCategory[] getSingleValueTypeCategory() {
        return this.singleValueTypeCategory;
    }

    @Pure
    public TypeCategory[] getSingleValueTypeCategoryNot() {
        return this.singleValueTypeCategoryNot;
    }

    @Pure
    public DeclaredType[] getSingleValueTypeAnnotations() {
        return this.singleValueTypeAnnotations;
    }

    @Pure
    public DeclaredType[] getTypeArg0Annotations() {
        return this.typeArg0Annotations;
    }

    @Pure
    public DeclaredType[] getTypeArg1Annotations() {
        return this.typeArg1Annotations;
    }

    @Pure
    public String getCondition() {
        return this.condition;
    }

    @Pure
    public String getConditionLang() {
        return this.conditionLang;
    }

    @Pure
    public ConstraintRule[] getConstraints() {
        return this.constraints;
    }

    @Pure
    public Functions.Function1<? super CharSequence, ? extends Boolean> getNameIn() {
        return this.nameIn;
    }

    @Pure
    public Functions.Function1<? super CharSequence, ? extends Boolean> getNameNotIn() {
        return this.nameNotIn;
    }
}

