/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import com.google.common.collect.Iterables;
import de.japkit.model.GenElement;
import de.japkit.model.GenExtensions;
import de.japkit.model.GenTypeElement;
import de.japkit.rules.AbstractRule;
import de.japkit.rules.DelegateMethodsRule;
import de.japkit.rules.ManualOverrideRule;
import de.japkit.rules.RuleUtils;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.ReportedException;
import de.japkit.services.TypeElementNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public abstract class MemberRuleSupport<E extends Element, T extends GenElement>
extends AbstractRule
implements Functions.Function1<GenTypeElement, List<? extends GenElement>> {
    private final E template;
    private final String avPrefix;
    private final Functions.Function0<? extends Boolean> activationRule;
    private final Functions.Function1<? super Functions.Function1<? super Object, ? extends Iterable<? extends GenElement>>, ? extends Iterable<Iterable<? extends GenElement>>> scopeRule;
    private final Functions.Function0<?> srcRule;
    private final Functions.Function0<? extends String> nameRule;
    private final Functions.Function0<? extends Set<Modifier>> modifiersRule;
    private final Functions.Function1<? super GenElement, ? extends List<? extends AnnotationMirror>> annotationsRule;
    private final Functions.Function0<? extends CharSequence> commentRule;
    private final boolean genElementIsSrcForDependentRules;
    private final ManualOverrideRule manualOverrideRule;
    private final List<Functions.Function1<? super GenTypeElement, ? extends List<? extends GenElement>>> dependentMemberRules = CollectionLiterals.newArrayList();

    public MemberRuleSupport(AnnotationMirror metaAnnotation, E template) {
        this(metaAnnotation, template, null);
    }

    public MemberRuleSupport(AnnotationMirror metaAnnotation, E template, String avPrefix) {
        super(metaAnnotation, (Element)template);
        ManualOverrideRule _manualOverrideRule;
        this.template = template;
        this.avPrefix = avPrefix;
        this.activationRule = this.createActivationRule();
        this.srcRule = this.createSrcRule();
        this.scopeRule = this.createScopeRule(this.srcRule);
        this.nameRule = this.createNameRule();
        this.modifiersRule = this.createModifiersRule();
        this.annotationsRule = this.createAnnotationsRule();
        this.commentRule = this.createCommentRule();
        this.genElementIsSrcForDependentRules = this.genElementIsSrcForDependentRulesAV();
        this.createAndAddDelegateMethodRules();
        this.manualOverrideRule = _manualOverrideRule = new ManualOverrideRule(metaAnnotation);
    }

    public MemberRuleSupport(AnnotationMirror metaAnnotation, String avPrefix, Functions.Function0<? extends Iterable<?>> srcRule, Functions.Function0<? extends String> nameRule, Functions.Function0<? extends CharSequence> commentRule) {
        super(metaAnnotation, null);
        ManualOverrideRule _manualOverrideRule;
        this.template = null;
        this.avPrefix = avPrefix;
        this.activationRule = this.createActivationRule();
        Functions.Function0<? extends Iterable<?>> _elvis = null;
        _elvis = srcRule != null ? srcRule : RuleUtils.SINGLE_SRC_ELEMENT;
        this.srcRule = _elvis;
        this.scopeRule = this.createScopeRule(srcRule);
        this.nameRule = nameRule;
        this.modifiersRule = this.createModifiersRule();
        this.annotationsRule = this.createAnnotationsRule();
        Functions.Function0<? extends CharSequence> _elvis_1 = null;
        if (commentRule != null) {
            _elvis_1 = commentRule;
        } else {
            Functions.Function0<CharSequence> _createCommentRule = this.createCommentRule();
            _elvis_1 = _createCommentRule;
        }
        this.commentRule = _elvis_1;
        this.genElementIsSrcForDependentRules = this.genElementIsSrcForDependentRulesAV();
        this.createAndAddDelegateMethodRules();
        this.manualOverrideRule = _manualOverrideRule = new ManualOverrideRule(metaAnnotation);
    }

    public MemberRuleSupport(Functions.Function0<? extends Boolean> activationRule, Functions.Function0<? extends Iterable<?>> srcRule, Functions.Function0<? extends String> nameRule, Functions.Function0<? extends Set<Modifier>> modifiersRule, Functions.Function1<? super GenElement, ? extends List<? extends AnnotationMirror>> annotationsRule, Functions.Function0<? extends CharSequence> commentRule) {
        super(null, null);
        Functions.Function0 _function_2;
        Functions.Function1 _function_1;
        Functions.Function0 _function;
        this.template = null;
        this.avPrefix = null;
        Object _elvis = null;
        _elvis = activationRule != null ? activationRule : RuleUtils.ALWAYS_ACTIVE;
        this.activationRule = _elvis;
        Functions.Function0<? extends Iterable<?>> _elvis_1 = null;
        _elvis_1 = srcRule != null ? srcRule : RuleUtils.SINGLE_SRC_ELEMENT;
        this.srcRule = _elvis_1;
        this.scopeRule = this.createScopeRule(srcRule);
        this.nameRule = nameRule;
        Functions.Function0 _elvis_2 = null;
        _elvis_2 = modifiersRule != null ? modifiersRule : (_function = () -> CollectionLiterals.emptySet());
        this.modifiersRule = _elvis_2;
        Functions.Function1 _elvis_3 = null;
        _elvis_3 = annotationsRule != null ? annotationsRule : (_function_1 = g -> CollectionLiterals.emptyList());
        this.annotationsRule = _elvis_3;
        Functions.Function0 _elvis_4 = null;
        _elvis_4 = commentRule != null ? commentRule : (_function_2 = () -> "");
        this.commentRule = _elvis_4;
        this.genElementIsSrcForDependentRules = true;
        this.manualOverrideRule = null;
    }

    protected Boolean genElementIsSrcForDependentRulesAV() {
        Boolean _elvis = null;
        AnnotationMirror _metaAnnotation = this.getMetaAnnotation();
        Boolean _value = null;
        if (_metaAnnotation != null) {
            _value = this._elementsExtensions.value(_metaAnnotation, "genElementIsSrcForDependentRules", Boolean.class);
        }
        _elvis = _value != null ? _value : Boolean.valueOf(true);
        return _elvis;
    }

    protected void addDependentMemberRule(MemberRuleSupport<?, ?> mr) {
        if (mr == null) {
            return;
        }
        Functions.Function1 _function = g -> mr.apply((GenTypeElement)g);
        this.dependentMemberRules.add((Functions.Function1<? super GenTypeElement, ? extends List<? extends GenElement>>)_function);
    }

    protected Functions.Function0<? extends Boolean> createActivationRule() {
        return this._ruleUtils.createActivationRule(this.getMetaAnnotation(), this.avPrefix);
    }

    protected Functions.Function0<?> createSrcRule() {
        return this._ruleUtils.createSrcRule(this.getMetaAnnotation(), this.avPrefix);
    }

    protected Functions.Function1<? super Functions.Function1<? super Object, ? extends Iterable<? extends GenElement>>, ? extends Iterable<Iterable<? extends GenElement>>> createScopeRule(Functions.Function0<?> srcRule) {
        return this._ruleUtils.createScopeRule(this.getMetaAnnotation(), (Element)this.template, this.avPrefix, srcRule);
    }

    protected Functions.Function0<? extends Set<Modifier>> createModifiersRule() {
        return this._ruleUtils.createModifiersRule(this.getMetaAnnotation(), (Element)this.template, this.avPrefix);
    }

    protected Functions.Function1<? super GenElement, ? extends List<? extends AnnotationMirror>> createAnnotationsRule() {
        return this._ruleUtils.createAnnotationMappingRules(this.getMetaAnnotation(), (Element)this.template, this.avPrefix);
    }

    protected Functions.Function0<? extends String> createNameRule() {
        return this._ruleUtils.createNameExprRule(this.getMetaAnnotation(), (Element)this.template, this.avPrefix);
    }

    protected Functions.Function0<? extends CharSequence> createCommentRule() {
        return this._ruleUtils.createCommentRule(this.getMetaAnnotation(), (Element)this.template, this.avPrefix, null);
    }

    protected GenExtensions getGenExtensions() {
        return ExtensionRegistry.get(GenExtensions.class);
    }

    public List<? extends GenElement> apply(GenTypeElement generatedClass) {
        Functions.Function1 _function = it -> {
            boolean _not;
            List _xblockexpression = null;
            Functions.Function1 _function_1 = it_1 -> {
                Boolean _xblockexpression_1 = null;
                this._eLSupport.getValueStack().put("template", this.template);
                _xblockexpression_1 = (Boolean)this.activationRule.apply();
                return _xblockexpression_1;
            };
            Boolean _scope = (Boolean)this._eLSupport.scope(_function_1);
            boolean bl = _not = _scope == false;
            if (_not) {
                return CollectionLiterals.emptyList();
            }
            List _xtrycatchfinallyexpression = null;
            try {
                List _xblockexpression_1 = null;
                Functions.Function1 _function_2 = it_1 -> {
                    ArrayList _xblockexpression_2 = null;
                    this._eLSupport.getValueStack().put("template", this.template);
                    ArrayList generatedMembers = CollectionLiterals.newArrayList();
                    T member = this.createMember();
                    generatedClass.add(new GenElement[]{member});
                    generatedMembers.add(member);
                    Functions.Function1 _function_3 = it_2 -> {
                        Object _xblockexpression_3 = null;
                        this._eLSupport.getValueStack().put("genElement", (Object)member);
                        Consumer<Functions.Function1> _function_4 = r -> {
                            List elements = (List)r.apply((Object)generatedClass);
                        };
                        this.dependentMemberRules.forEach(_function_4);
                        _xblockexpression_3 = null;
                        return _xblockexpression_3;
                    };
                    this._eLSupport.scope(this.getSrcElementForDependentRules((GenElement)member), _function_3);
                    _xblockexpression_2 = generatedMembers;
                    return _xblockexpression_2;
                };
                Iterable result = (Iterable)this.scopeRule.apply((Object)_function_2);
                if (this.manualOverrideRule != null) {
                    Functions.Function1 _function_3 = it_1 -> (GenElement)IterableExtensions.head((Iterable)it_1);
                    this.manualOverrideRule.apply(IterableExtensions.map((Iterable)result, (Functions.Function1)_function_3));
                }
                _xtrycatchfinallyexpression = _xblockexpression_1 = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)result));
            }
            catch (Throwable _t) {
                if (_t instanceof TypeElementNotFoundException) {
                    TypeElementNotFoundException tenfe = (TypeElementNotFoundException)_t;
                    List _xblockexpression_2 = null;
                    this._typesRegistry.handleTypeElementNotFound(tenfe, this._generateClassContext.currentAnnotatedClass());
                    _xtrycatchfinallyexpression = _xblockexpression_2 = CollectionLiterals.emptyList();
                }
                if (_t instanceof ReportedException) {
                    ReportedException re = (ReportedException)_t;
                    _xtrycatchfinallyexpression = CollectionLiterals.emptyList();
                }
                if (_t instanceof Exception) {
                    Exception re_1 = (Exception)_t;
                    List _xblockexpression_3 = null;
                    this._messageCollector.reportRuleError(re_1);
                    _xtrycatchfinallyexpression = _xblockexpression_3 = CollectionLiterals.emptyList();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        };
        return (List)this.inRule(_function);
    }

    protected Element getSrcElementForDependentRules(GenElement genElement) {
        Element _xifexpression = null;
        _xifexpression = this.genElementIsSrcForDependentRules ? genElement : this._eLSupport.getCurrentSrcElement();
        return _xifexpression;
    }

    protected T createMember() {
        T _xblockexpression = null;
        String memberName = (String)this.nameRule.apply();
        T member = this.createMember(memberName);
        this.applyRulesAfterCreation(member);
        _xblockexpression = member;
        return _xblockexpression;
    }

    protected abstract T createMember(String var1);

    protected void applyRulesAfterCreation(T member) {
        ((GenElement)member).setModifiers((Set)this.modifiersRule.apply());
        ((GenElement)member).setAnnotationMirrors((List)this.annotationsRule.apply(member));
        ((GenElement)member).setComment((CharSequence)this.commentRule.apply());
    }

    protected void createAndAddDelegateMethodRules() {
        boolean _tripleEquals;
        AnnotationMirror _metaAnnotation = this.getMetaAnnotation();
        boolean bl = _tripleEquals = _metaAnnotation == null;
        if (_tripleEquals) {
            return;
        }
        AnnotationMirror[] _value = this._elementsExtensions.value(this.getMetaAnnotation(), "delegateMethods", AnnotationMirror[].class);
        if ((List)Conversions.doWrapArray((Object)_value) != null) {
            Consumer<AnnotationMirror> _function = it -> {
                DelegateMethodsRule dmr = new DelegateMethodsRule((AnnotationMirror)it, null);
                this.addDependentMemberRule(dmr);
            };
            ((List)Conversions.doWrapArray((Object)_value)).forEach(_function);
        }
    }

    @Override
    @Pure
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.template == null ? 0 : this.template.hashCode());
        result = 31 * result + (this.avPrefix == null ? 0 : this.avPrefix.hashCode());
        result = 31 * result + (this.activationRule == null ? 0 : this.activationRule.hashCode());
        result = 31 * result + (this.scopeRule == null ? 0 : this.scopeRule.hashCode());
        result = 31 * result + (this.srcRule == null ? 0 : this.srcRule.hashCode());
        result = 31 * result + (this.nameRule == null ? 0 : this.nameRule.hashCode());
        result = 31 * result + (this.modifiersRule == null ? 0 : this.modifiersRule.hashCode());
        result = 31 * result + (this.annotationsRule == null ? 0 : this.annotationsRule.hashCode());
        result = 31 * result + (this.commentRule == null ? 0 : this.commentRule.hashCode());
        result = 31 * result + (this.genElementIsSrcForDependentRules ? 1231 : 1237);
        result = 31 * result + (this.manualOverrideRule == null ? 0 : this.manualOverrideRule.hashCode());
        result = 31 * result + (this.dependentMemberRules == null ? 0 : this.dependentMemberRules.hashCode());
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MemberRuleSupport other = (MemberRuleSupport)obj;
        if (this.template == null ? other.template != null : !this.template.equals(other.template)) {
            return false;
        }
        if (this.avPrefix == null ? other.avPrefix != null : !this.avPrefix.equals(other.avPrefix)) {
            return false;
        }
        if (this.activationRule == null ? other.activationRule != null : !this.activationRule.equals(other.activationRule)) {
            return false;
        }
        if (this.scopeRule == null ? other.scopeRule != null : !this.scopeRule.equals(other.scopeRule)) {
            return false;
        }
        if (this.srcRule == null ? other.srcRule != null : !this.srcRule.equals(other.srcRule)) {
            return false;
        }
        if (this.nameRule == null ? other.nameRule != null : !this.nameRule.equals(other.nameRule)) {
            return false;
        }
        if (this.modifiersRule == null ? other.modifiersRule != null : !this.modifiersRule.equals(other.modifiersRule)) {
            return false;
        }
        if (this.annotationsRule == null ? other.annotationsRule != null : !this.annotationsRule.equals(other.annotationsRule)) {
            return false;
        }
        if (this.commentRule == null ? other.commentRule != null : !this.commentRule.equals(other.commentRule)) {
            return false;
        }
        if (other.genElementIsSrcForDependentRules != this.genElementIsSrcForDependentRules) {
            return false;
        }
        if (this.manualOverrideRule == null ? other.manualOverrideRule != null : !this.manualOverrideRule.equals(other.manualOverrideRule)) {
            return false;
        }
        return !(this.dependentMemberRules == null ? other.dependentMemberRules != null : !this.dependentMemberRules.equals(other.dependentMemberRules));
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public E getTemplate() {
        return this.template;
    }

    @Pure
    public String getAvPrefix() {
        return this.avPrefix;
    }

    @Pure
    public Functions.Function0<? extends Boolean> getActivationRule() {
        return this.activationRule;
    }

    @Pure
    public Functions.Function1<? super Functions.Function1<? super Object, ? extends Iterable<? extends GenElement>>, ? extends Iterable<Iterable<? extends GenElement>>> getScopeRule() {
        return this.scopeRule;
    }

    @Pure
    public Functions.Function0<?> getSrcRule() {
        return this.srcRule;
    }

    @Pure
    public Functions.Function0<? extends String> getNameRule() {
        return this.nameRule;
    }

    @Pure
    public Functions.Function0<? extends Set<Modifier>> getModifiersRule() {
        return this.modifiersRule;
    }

    @Pure
    public Functions.Function1<? super GenElement, ? extends List<? extends AnnotationMirror>> getAnnotationsRule() {
        return this.annotationsRule;
    }

    @Pure
    public Functions.Function0<? extends CharSequence> getCommentRule() {
        return this.commentRule;
    }

    @Pure
    public boolean isGenElementIsSrcForDependentRules() {
        return this.genElementIsSrcForDependentRules;
    }

    @Pure
    public ManualOverrideRule getManualOverrideRule() {
        return this.manualOverrideRule;
    }

    @Pure
    public List<Functions.Function1<? super GenTypeElement, ? extends List<? extends GenElement>>> getDependentMemberRules() {
        return this.dependentMemberRules;
    }
}

