/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import de.japkit.el.ELSupport;
import de.japkit.rules.AbstractRule;
import de.japkit.services.ElementsExtensions;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.ProcessingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class NameRule
extends AbstractRule {
    private final Pattern regEx;
    private final String regExReplace;
    private final String expr;
    private final String lang;
    @Extension
    private final transient ElementsExtensions _elementsExtensions = ExtensionRegistry.get(ElementsExtensions.class);
    @Extension
    private final transient ELSupport _eLSupport = ExtensionRegistry.get(ELSupport.class);

    public NameRule(AnnotationMirror metaAnnotation, String avPrefix) {
        super(metaAnnotation, null);
        String _xifexpression = null;
        _xifexpression = avPrefix == null ? "name" : avPrefix;
        String prefix = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(prefix);
        _builder.append("RegEx");
        this.regEx = this._elementsExtensions.value(metaAnnotation, (CharSequence)_builder, Pattern.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(prefix);
        _builder_1.append("RegExReplace");
        this.regExReplace = this._elementsExtensions.value(metaAnnotation, (CharSequence)_builder_1, String.class);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append(prefix);
        _builder_2.append("Expr");
        this.expr = this._elementsExtensions.value(metaAnnotation, (CharSequence)_builder_2, String.class);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append(prefix);
        _builder_3.append("Lang");
        this.lang = this._elementsExtensions.value(metaAnnotation, (CharSequence)_builder_3, String.class);
    }

    public boolean isEmpty() {
        return this.regEx == null && this.expr == null;
    }

    public String getName(CharSequence orgName, Element orgElement) {
        Functions.Function1 _function = it -> {
            boolean _not_1;
            String _xifexpression = null;
            if (this.regEx != null) {
                boolean _not;
                Matcher matcher = this.regEx.matcher(orgName);
                boolean _matches = matcher.matches();
                boolean bl = _not = !_matches;
                if (_not) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Naming rule violated: Name \"");
                    _builder.append((Object)orgName);
                    _builder.append("\" must match pattern \"");
                    String _pattern = this.regEx.pattern();
                    _builder.append(_pattern);
                    _builder.append("\"");
                    throw new ProcessingException(_builder.toString(), orgElement);
                }
                try {
                    String name = matcher.replaceFirst(this.regExReplace);
                    boolean _isEmpty = name.isEmpty();
                    if (_isEmpty) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("Naming rule violated: Name \"");
                        _builder_1.append((Object)orgName);
                        _builder_1.append("\" must not be empty after replacing with \"");
                        _builder_1.append(this.regExReplace);
                        _builder_1.append("\"");
                        throw new ProcessingException(_builder_1.toString(), orgElement);
                    }
                    return name;
                }
                catch (Throwable _t) {
                    if (_t instanceof RuntimeException) {
                        RuntimeException e = (RuntimeException)_t;
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("Exception when replacing RegEx \"");
                        String _pattern_1 = this.regEx.pattern();
                        _builder_2.append(_pattern_1);
                        _builder_2.append("\" with \"");
                        _builder_2.append(this.regExReplace);
                        _builder_2.append("\": ");
                        String _message = e.getMessage();
                        _builder_2.append(_message);
                        throw new ProcessingException(_builder_2.toString(), orgElement);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            String _xifexpression_1 = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.expr);
            boolean bl = _not_1 = !_isNullOrEmpty;
            if (_not_1) {
                Functions.Function1 _function_1 = it_1 -> this._eLSupport.eval(this.expr, this.lang, String.class);
                _xifexpression_1 = (String)this._eLSupport.scope(orgElement, _function_1);
            } else {
                _xifexpression_1 = orgName.toString();
            }
            _xifexpression = _xifexpression_1;
            return _xifexpression;
        };
        return (String)this.inRule(_function);
    }

    @Override
    @Pure
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.regEx == null ? 0 : this.regEx.hashCode());
        result = 31 * result + (this.regExReplace == null ? 0 : this.regExReplace.hashCode());
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        NameRule other = (NameRule)obj;
        if (this.regEx == null ? other.regEx != null : !this.regEx.equals(other.regEx)) {
            return false;
        }
        if (this.regExReplace == null ? other.regExReplace != null : !this.regExReplace.equals(other.regExReplace)) {
            return false;
        }
        if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
            return false;
        }
        return !(this.lang == null ? other.lang != null : !this.lang.equals(other.lang));
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public Pattern getRegEx() {
        return this.regEx;
    }

    @Pure
    public String getRegExReplace() {
        return this.regExReplace;
    }

    @Pure
    public String getExpr() {
        return this.expr;
    }

    @Pure
    public String getLang() {
        return this.lang;
    }
}

