/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import de.japkit.metaannotations.ResourceLocation;
import de.japkit.rules.AbstractRule;
import de.japkit.rules.NameRule;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.FileExtensions;
import de.japkit.services.ReportedException;
import de.japkit.services.TypeElementNotFoundException;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.PackageElement;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class ResourceRule
extends AbstractRule {
    @Extension
    private final transient ProcessingEnvironment _processingEnvironment = ExtensionRegistry.get(ProcessingEnvironment.class);
    @Extension
    private final transient FileExtensions _fileExtensions = ExtensionRegistry.get(FileExtensions.class);
    private final String templateName;
    private final String templateLang;
    private final Functions.Function1<? super Functions.Function1<? super Object, ?>, ? extends List<Object>> scopeRule;
    private final NameRule resoureNameRule;
    private final NameRule resourePathNameRule;
    private final ResourceLocation resourceLocation;
    private final URL templateURL;
    private final Long templateLastModified;

    public ResourceRule(AnnotationMirror resourceTemplateAnnotation, PackageElement templatePackage) {
        super(resourceTemplateAnnotation, null);
        try {
            boolean _tripleNotEquals;
            NameRule _nameRule_1;
            NameRule _nameRule;
            this.templateName = this._elementsExtensions.value(resourceTemplateAnnotation, "templateName", String.class);
            this.templateLang = this._elementsExtensions.value(resourceTemplateAnnotation, "templateLang", String.class);
            this.resoureNameRule = _nameRule = new NameRule(resourceTemplateAnnotation, "name");
            this.resourePathNameRule = _nameRule_1 = new NameRule(resourceTemplateAnnotation, "path");
            this.resourceLocation = this._elementsExtensions.value(resourceTemplateAnnotation, "location", ResourceLocation.class);
            this.scopeRule = this._ruleUtils.createScopeRule(resourceTemplateAnnotation, null, null);
            String templatePackagePath = templatePackage.getQualifiedName().toString().replace(".", "/");
            Long lastModified = null;
            URL _xifexpression = null;
            String _resourceTemplateDir = this.getResourceTemplateDir();
            boolean bl = _tripleNotEquals = _resourceTemplateDir != null;
            if (_tripleNotEquals) {
                URL _xblockexpression = null;
                String _resourceTemplateDir_1 = this.getResourceTemplateDir();
                File templateDir = new File(_resourceTemplateDir_1, templatePackagePath);
                File file = new File(templateDir, this.templateName);
                lastModified = file.lastModified();
                _xifexpression = _xblockexpression = file.toURI().toURL();
            } else {
                _xifexpression = this.getClass().getClassLoader().getResource(templatePackagePath + "/" + this.templateName);
            }
            this.templateURL = _xifexpression;
            this.templateLastModified = lastModified;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private String getResourceTemplateDir() {
        return this._processingEnvironment.getOptions().get("templateDir");
    }

    public void generateResource() {
        Functions.Function1 _function = it -> {
            Object _xblockexpression = null;
            try {
                Functions.Function1 _function_1 = it_1 -> {
                    try {
                        Object _xblockexpression_1 = null;
                        Functions.Function1 _function_2 = it_2 -> {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append("Resoure template ");
                            _builder.append(this.templateName);
                            _builder.append(" ");
                            _builder.append((Object)this.templateURL);
                            return _builder.toString();
                        };
                        this._messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_2);
                        String resourceName = this.resoureNameRule.getName(this.templateName, this._generateClassContext.currentAnnotatedClass());
                        String resourcePathName = this.resourePathNameRule.getName(this._elementsExtensions.getPackage(this._generateClassContext.currentAnnotatedClass()).getQualifiedName().toString().replace(".", "/"), this._generateClassContext.currentAnnotatedClass());
                        File resourceFile = this.resourceLocation.getFile(this._processingEnvironment.getOptions(), resourcePathName, resourceName);
                        this._fileExtensions.ensureParentDirectoriesExist(resourceFile);
                        FileWriter writer = new FileWriter(resourceFile);
                        long start = System.currentTimeMillis();
                        try {
                            this._eLSupport.write(writer, this.templateURL, this.templateLang, this.templateLastModified);
                        }
                        finally {
                            writer.flush();
                            writer.close();
                            Functions.Function1 _function_3 = it_2 -> {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append("Resource file written ");
                                _builder.append((Object)resourceFile);
                                _builder.append(". Duration: ");
                                long _currentTimeMillis = System.currentTimeMillis();
                                long _minus = _currentTimeMillis - start;
                                _builder.append((Object)_minus);
                                return _builder.toString();
                            };
                            this._messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_3);
                        }
                        _xblockexpression_1 = null;
                        return _xblockexpression_1;
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                this.scopeRule.apply((Object)_function_1);
            }
            catch (Throwable _t) {
                if (_t instanceof TypeElementNotFoundException) {
                    TypeElementNotFoundException tenfe = (TypeElementNotFoundException)_t;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Type element not found when processing resource template ");
                    _builder.append(this.templateName);
                    _builder.append(".");
                    this._typesRegistry.handleTypeElementNotFound((CharSequence)_builder, tenfe.getFqn());
                }
                if (_t instanceof ReportedException) {
                    ReportedException e = (ReportedException)_t;
                    Functions.Function1 _function_2 = it_1 -> e.getMessage();
                    this._messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_2);
                }
                if (_t instanceof Exception) {
                    Exception e_1 = (Exception)_t;
                    Functions.Function1 _function_3 = it_1 -> {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("Error when processing resource template ");
                        _builder_1.append(this.templateName);
                        _builder_1.append(". ");
                        _builder_1.append((Object)e_1);
                        return _builder_1.toString();
                    };
                    this._messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_3);
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Error when processing resource template  ");
                    _builder_1.append(this.templateName);
                    _builder_1.append(": ");
                    _builder_1.append((Object)e_1);
                    this._messageCollector.reportRuleError(_builder_1);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            _xblockexpression = null;
            return _xblockexpression;
        };
        this.inRule(_function);
    }

    @Override
    @Pure
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.templateName == null ? 0 : this.templateName.hashCode());
        result = 31 * result + (this.templateLang == null ? 0 : this.templateLang.hashCode());
        result = 31 * result + (this.scopeRule == null ? 0 : this.scopeRule.hashCode());
        result = 31 * result + (this.resoureNameRule == null ? 0 : this.resoureNameRule.hashCode());
        result = 31 * result + (this.resourePathNameRule == null ? 0 : this.resourePathNameRule.hashCode());
        result = 31 * result + (this.resourceLocation == null ? 0 : this.resourceLocation.hashCode());
        result = 31 * result + (this.templateURL == null ? 0 : this.templateURL.hashCode());
        result = 31 * result + (this.templateLastModified == null ? 0 : this.templateLastModified.hashCode());
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ResourceRule other = (ResourceRule)obj;
        if (this.templateName == null ? other.templateName != null : !this.templateName.equals(other.templateName)) {
            return false;
        }
        if (this.templateLang == null ? other.templateLang != null : !this.templateLang.equals(other.templateLang)) {
            return false;
        }
        if (this.scopeRule == null ? other.scopeRule != null : !this.scopeRule.equals(other.scopeRule)) {
            return false;
        }
        if (this.resoureNameRule == null ? other.resoureNameRule != null : !this.resoureNameRule.equals(other.resoureNameRule)) {
            return false;
        }
        if (this.resourePathNameRule == null ? other.resourePathNameRule != null : !this.resourePathNameRule.equals(other.resourePathNameRule)) {
            return false;
        }
        if (this.resourceLocation == null ? other.resourceLocation != null : !this.resourceLocation.equals((Object)other.resourceLocation)) {
            return false;
        }
        if (this.templateURL == null ? other.templateURL != null : !this.templateURL.equals(other.templateURL)) {
            return false;
        }
        return !(this.templateLastModified == null ? other.templateLastModified != null : !this.templateLastModified.equals(other.templateLastModified));
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public String getTemplateName() {
        return this.templateName;
    }

    @Pure
    public String getTemplateLang() {
        return this.templateLang;
    }

    @Pure
    public Functions.Function1<? super Functions.Function1<? super Object, ?>, ? extends List<Object>> getScopeRule() {
        return this.scopeRule;
    }

    @Pure
    public NameRule getResoureNameRule() {
        return this.resoureNameRule;
    }

    @Pure
    public NameRule getResourePathNameRule() {
        return this.resourePathNameRule;
    }

    @Pure
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    @Pure
    public URL getTemplateURL() {
        return this.templateURL;
    }

    @Pure
    public Long getTemplateLastModified() {
        return this.templateLastModified;
    }
}

