/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.japkit.annotations.AnnotationTemplate;
import de.japkit.el.ELSupport;
import de.japkit.el.ValueStack;
import de.japkit.metaannotations.Param;
import de.japkit.metaannotations.Var;
import de.japkit.model.AnnotationAndParent;
import de.japkit.model.GenAnnotationMirror;
import de.japkit.model.GenElement;
import de.japkit.model.GenExtensions;
import de.japkit.model.GenParameter;
import de.japkit.model.GenUnresolvedType;
import de.japkit.rules.AnnotationExtensions;
import de.japkit.rules.AnnotationMappingRule;
import de.japkit.rules.ELVariableRule;
import de.japkit.rules.ExpressionOrFunctionCallRule;
import de.japkit.rules.JavadocUtil;
import de.japkit.rules.LibraryRule;
import de.japkit.rules.MatcherRule;
import de.japkit.rules.ParamRule;
import de.japkit.rules.RuleFactory;
import de.japkit.rules.ScopeRule;
import de.japkit.rules.TypeResolver;
import de.japkit.services.ElementsExtensions;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.GenerateClassContext;
import de.japkit.services.MessageCollector;
import de.japkit.services.ReportedException;
import de.japkit.services.RuleException;
import de.japkit.services.TypeElementNotFoundException;
import de.japkit.services.TypesExtensions;
import de.japkit.services.TypesRegistry;
import de.japkit.util.MoreCollectionExtensions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class RuleUtils {
    @Extension
    protected final transient ElementsExtensions _elementsExtensions = ExtensionRegistry.get(ElementsExtensions.class);
    @Extension
    protected final transient ELSupport _eLSupport = ExtensionRegistry.get(ELSupport.class);
    @Extension
    protected final transient MessageCollector _messageCollector = ExtensionRegistry.get(MessageCollector.class);
    @Extension
    protected final transient AnnotationExtensions _annotationExtensions = ExtensionRegistry.get(AnnotationExtensions.class);
    @Extension
    protected final transient GenExtensions _genExtensions = ExtensionRegistry.get(GenExtensions.class);
    @Extension
    protected final transient TypeResolver typesResolver = ExtensionRegistry.get(TypeResolver.class);
    @Extension
    protected final transient GenerateClassContext _generateClassContext = ExtensionRegistry.get(GenerateClassContext.class);
    @Extension
    protected final transient TypesExtensions _typesExtensions = ExtensionRegistry.get(TypesExtensions.class);
    @Extension
    protected final transient RuleFactory _ruleFactory = ExtensionRegistry.get(RuleFactory.class);
    @Extension
    protected final transient TypesRegistry typesRegistry = ExtensionRegistry.get(TypesRegistry.class);
    public static final Functions.Function0<? extends Iterable<?>> SINGLE_SRC_ELEMENT = () -> Collections.singleton(ExtensionRegistry.get(ELSupport.class).getCurrentSrc());
    private ScopeRule<Object> SCOPE_WITH_CURRENT_SRC;
    public static final Functions.Function0<Boolean> ALWAYS_ACTIVE = () -> true;
    public static final Functions.Function0<String> NO_NAME = () -> null;
    private static final Pattern expressionInTemplate = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("\\$(.+?)\\$");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    public static final Functions.Function1<? super Object, ?> templateAnnotationValueTransformer = it -> {
        Object _xifexpression = null;
        if (it instanceof TypeMirror) {
            _xifexpression = ExtensionRegistry.get(TypeResolver.class).resolveType((TypeMirror)it);
        } else {
            Object _xifexpression_1 = null;
            if (it instanceof String) {
                StringBuffer _replaceExpressionInTemplate = ExtensionRegistry.get(RuleUtils.class).replaceExpressionInTemplate((CharSequence)it, true, null, false);
                String _string = null;
                if (_replaceExpressionInTemplate != null) {
                    _string = _replaceExpressionInTemplate.toString();
                }
                _xifexpression_1 = _string;
            } else {
                _xifexpression_1 = it;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    };

    public static String withPrefix(CharSequence name, String prefix) {
        CharSequence _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)prefix);
        if (_isNullOrEmpty) {
            _xifexpression = name;
        } else {
            String _xifexpression_1 = null;
            int _length = prefix.length();
            int _minus = _length - 1;
            boolean _isLowerCase = Character.isLowerCase(prefix.charAt(_minus));
            if (_isLowerCase) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(prefix);
                String _firstUpper = StringExtensions.toFirstUpper((String)name.toString());
                _builder.append(_firstUpper);
                _xifexpression_1 = _builder.toString();
            } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(prefix);
                _builder_1.append((Object)name);
                _xifexpression_1 = _builder_1.toString();
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression.toString();
    }

    public Functions.Function0<?> createSrcRule(AnnotationMirror metaAnnotation, String avPrefix) {
        Functions.Function0 _function = () -> this._eLSupport.getCurrentSrc();
        return this.createExpressionOrFunctionCallAndFilterRule(metaAnnotation, null, "src", "srcFun", "srcLang", "srcFilter", "srcFilterFun", "srcCollect", "srcCollectFun", "srcToSet", "srcGroupBy", "srcGroupByFun", "srcType", avPrefix, _function, false, "srcUnique");
    }

    public Functions.Function0<?> createExpressionOrFunctionCallAndFilterRule(AnnotationMirror metaAnnotation, Element metaElement, String exprAV, String funAV, String langAV, String filterExprAV, String filterFunAV, String collectExprAV, String collectFunAV, String toSetAV, String groupByAV, String groupByFunAV, String typeAV, String avPrefix, Functions.Function0<?> defaultValue, boolean nullable, String uniqueAV) {
        try {
            Functions.Function0 _function;
            Functions.Function0 _xblockexpression = null;
            if (metaAnnotation == null) {
                return SINGLE_SRC_ELEMENT;
            }
            TypeMirror _value = null;
            if (metaAnnotation != null) {
                String _withPrefix = null;
                if (typeAV != null) {
                    _withPrefix = RuleUtils.withPrefix(typeAV, avPrefix);
                }
                _value = this._elementsExtensions.value(metaAnnotation, _withPrefix, TypeMirror.class);
            }
            TypeMirror type = _value;
            Class _xifexpression = null;
            _xifexpression = type != null ? Class.forName(this._typesExtensions.asElement(type).getQualifiedName().toString()) : Object.class;
            Class<Object> typeClass = _xifexpression;
            ExpressionOrFunctionCallRule<Object> collectExprOrFunction = new ExpressionOrFunctionCallRule<Object>(metaAnnotation, metaElement, Object.class, collectExprAV, langAV, collectFunAV, avPrefix, null, nullable, null);
            ExpressionOrFunctionCallRule<Object> groupByExprOrFunction = new ExpressionOrFunctionCallRule<Object>(metaAnnotation, metaElement, Object.class, groupByAV, langAV, groupByFunAV, avPrefix, null, false, null);
            ExpressionOrFunctionCallRule<Object> srcExprOrFunction = new ExpressionOrFunctionCallRule<Object>(metaAnnotation, metaElement, typeClass, exprAV, langAV, funAV, avPrefix, defaultValue, nullable, null);
            ExpressionOrFunctionCallRule<Boolean> srcFilterExprOrFunction = new ExpressionOrFunctionCallRule<Boolean>(metaAnnotation, metaElement, Boolean.class, filterExprAV, langAV, filterFunAV, avPrefix, null, false, ExpressionOrFunctionCallRule.AND_COMBINER);
            Boolean _elvis = null;
            Boolean _value_1 = null;
            if (metaAnnotation != null) {
                _value_1 = this._elementsExtensions.value(metaAnnotation, toSetAV, Boolean.class);
            }
            _elvis = _value_1 != null ? _value_1 : Boolean.valueOf(false);
            Boolean toSet = _elvis;
            Boolean _elvis_1 = null;
            Boolean _value_2 = null;
            if (metaAnnotation != null) {
                _value_2 = this._elementsExtensions.value(metaAnnotation, uniqueAV, Boolean.class);
            }
            _elvis_1 = _value_2 != null ? _value_2 : Boolean.valueOf(false);
            Boolean unique = _elvis_1;
            _xblockexpression = _function = () -> {
                Iterable _xblockexpression_1 = null;
                Iterable _xblockexpression_2 = null;
                Object elements = srcExprOrFunction.apply();
                Iterable _xifexpression_1 = null;
                if (elements instanceof Iterable) {
                    _xifexpression_1 = (Iterable)elements;
                } else {
                    List<Object> _xifexpression_2 = null;
                    _xifexpression_2 = elements != null && elements.getClass().isArray() ? Arrays.asList(elements) : (List<Object>)elements;
                    _xifexpression_1 = _xifexpression_2;
                }
                _xblockexpression_2 = _xifexpression_1;
                Object srcElements = _xblockexpression_2;
                if (srcElements instanceof Iterable) {
                    boolean _isUndefined_2;
                    boolean _not_2;
                    boolean _isUndefined_1;
                    boolean _not_1;
                    boolean _not;
                    boolean _isUndefined = srcFilterExprOrFunction.isUndefined();
                    boolean bl = _not = !_isUndefined;
                    if (_not) {
                        Functions.Function1 _function_1 = it -> {
                            Functions.Function1 _function_2 = it_1 -> {
                                Boolean _elvis_2 = null;
                                Boolean _apply = (Boolean)srcFilterExprOrFunction.apply();
                                _elvis_2 = _apply != null ? _apply : Boolean.valueOf(false);
                                return _elvis_2;
                            };
                            return (Boolean)this._eLSupport.scope(it, _function_2);
                        };
                        srcElements = IterableExtensions.filter((Iterable)srcElements, (Functions.Function1)_function_1);
                    }
                    boolean bl2 = _not_1 = !(_isUndefined_1 = collectExprOrFunction.isUndefined());
                    if (_not_1) {
                        Functions.Function1 _function_2 = it -> {
                            Functions.Function1 _function_3 = it_1 -> collectExprOrFunction.apply();
                            return this._eLSupport.scope(it, _function_3);
                        };
                        srcElements = IterableExtensions.map((Iterable)srcElements, (Functions.Function1)_function_2);
                    }
                    if (toSet.booleanValue()) {
                        srcElements = IterableExtensions.toSet((Iterable)srcElements);
                    }
                    if (unique.booleanValue()) {
                        srcElements = MoreCollectionExtensions.singleValue(srcElements);
                    }
                    boolean bl3 = _not_2 = !(_isUndefined_2 = groupByExprOrFunction.isUndefined());
                    if (_not_2) {
                        Functions.Function1 _function_3 = it -> {
                            Functions.Function1 _function_4 = it_1 -> groupByExprOrFunction.apply();
                            return this._eLSupport.scope(it, _function_4);
                        };
                        srcElements = IterableExtensions.groupBy((Iterable)srcElements, (Functions.Function1)_function_3);
                    }
                }
                _xblockexpression_1 = srcElements;
                return _xblockexpression_1;
            };
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public <T> ScopeRule<T> createScopeRule(AnnotationMirror metaAnnotation, Element metaElement, String avPrefix) {
        return this.createScopeRule(metaAnnotation, metaElement, false, avPrefix, true);
    }

    public <T> ScopeRule<T> createScopeRule(AnnotationMirror metaAnnotation, Element metaElement, boolean isLibrary, String avPrefix) {
        return this.createScopeRule(metaAnnotation, metaElement, isLibrary, avPrefix, true);
    }

    public <T> ScopeRule<T> createScopeRule(AnnotationMirror metaAnnotation, Element metaElement, String avPrefix, Functions.Function0<?> srcRule) {
        return this.createScopeRule(metaAnnotation, metaElement, false, avPrefix, true);
    }

    public <T> ScopeRule<T> createScopeRule(AnnotationMirror metaAnnotation, Element metaElement, boolean isLibrary, String avPrefix, boolean createSrcRule) {
        return new ScopeRule(metaAnnotation, metaElement, isLibrary, avPrefix, createSrcRule);
    }

    public ArrayList<LibraryRule> createLibraryRules(AnnotationMirror metaAnnotation, String avPrefix) {
        List _emptyList;
        List _elvis = null;
        TypeMirror[] _value = null;
        if (metaAnnotation != null) {
            _value = this._elementsExtensions.value(metaAnnotation, RuleUtils.withPrefix("libraries", avPrefix), TypeMirror[].class);
        }
        List _map = null;
        if ((List)Conversions.doWrapArray(_value) != null) {
            Functions.Function1 _function = it -> this._ruleFactory.createLibraryRule(this._typesExtensions.asElement((TypeMirror)it));
            _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_value)), (Functions.Function1)_function);
        }
        _elvis = _map != null ? _map : (_emptyList = CollectionLiterals.emptyList());
        return new ArrayList<LibraryRule>(_elvis);
    }

    public ScopeRule scopeWithCurrentSrc() {
        ScopeRule<Object> _xblockexpression = null;
        if (this.SCOPE_WITH_CURRENT_SRC == null) {
            this.SCOPE_WITH_CURRENT_SRC = this.createScopeRule(null, null, null);
        }
        _xblockexpression = this.SCOPE_WITH_CURRENT_SRC;
        return _xblockexpression;
    }

    public ArrayList<ELVariableRule> createELVariableRules(AnnotationMirror metaAnnotation, Element metaElement, String avPrefix) {
        List _emptyList;
        ArrayList _xblockexpression = null;
        ArrayList rules = CollectionLiterals.newArrayList();
        List _elvis = null;
        AnnotationMirror[] _value = null;
        if (metaAnnotation != null) {
            _value = this._elementsExtensions.value(metaAnnotation, RuleUtils.withPrefix("vars", avPrefix), AnnotationMirror[].class);
        }
        List _map = null;
        if ((List)Conversions.doWrapArray(_value) != null) {
            Functions.Function1 _function = it -> new ELVariableRule((AnnotationMirror)it, null);
            _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_value)), (Functions.Function1)_function);
        }
        _elvis = _map != null ? _map : (_emptyList = CollectionLiterals.emptyList());
        Iterables.addAll((Collection)rules, (Iterable)_elvis);
        if (metaElement instanceof TypeElement) {
            Functions.Function1 _function_1 = it -> this.isVariable((Element)it);
            Functions.Function1 _function_2 = it -> this._ruleFactory.createFunctionRule((Element)it);
            Functions.Function1 _function_3 = it -> it instanceof ELVariableRule;
            Functions.Function1 _function_4 = it -> (ELVariableRule)it;
            Iterables.addAll((Collection)rules, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this._elementsExtensions.enclosedElementsOrdered((TypeElement)metaElement), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4));
        }
        _xblockexpression = rules;
        return _xblockexpression;
    }

    public boolean isVariable(Element memberElement) {
        AnnotationMirror _annotationMirror = this._elementsExtensions.annotationMirror(memberElement, Var.class);
        return _annotationMirror != null;
    }

    public Functions.Function0<? extends Boolean> createActivationRule(AnnotationMirror metaAnnotation, String avPrefix) {
        Functions.Function0 _function = () -> true;
        return this.createActivationRule(metaAnnotation, avPrefix, (Functions.Function0<? extends Boolean>)_function);
    }

    public Functions.Function0<? extends Boolean> createActivationRule(AnnotationMirror metaAnnotation, String avPrefix, Functions.Function0<? extends Boolean> defaultValue) {
        ExpressionOrFunctionCallRule<? extends Boolean> _xblockexpression = null;
        ExpressionOrFunctionCallRule<? extends Boolean> rule = new ExpressionOrFunctionCallRule<Boolean>(metaAnnotation, null, Boolean.class, "cond", "condLang", "condFun", avPrefix, defaultValue, false, ExpressionOrFunctionCallRule.AND_COMBINER);
        ExpressionOrFunctionCallRule<? extends Boolean> _xifexpression = null;
        boolean _isUndefined = rule.isUndefined();
        _xifexpression = _isUndefined ? null : rule;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public StringBuffer replaceExpressionInTemplate(CharSequence template, boolean noSyntaxRestrictions, String lang, boolean autoCamelCase) {
        StringBuffer _xblockexpression = null;
        ValueStack vs = ExtensionRegistry.get(ELSupport.class).getValueStack();
        Matcher matcher = expressionInTemplate.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String expr = matcher.group(1);
            String _xifexpression = null;
            boolean _equals = Objects.equal((Object)expr, (Object)"srcElementName");
            if (_equals) {
                _xifexpression = this._eLSupport.getCurrentSrcElement().getSimpleName().toString();
            } else {
                String _xblockexpression_1 = null;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("#{");
                String _xifexpression_1 = null;
                _xifexpression_1 = noSyntaxRestrictions ? expr : expr.replace("_", ".");
                _builder.append(_xifexpression_1);
                _builder.append("}");
                String exprToEvaluate = _builder.toString();
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Expression ");
                _builder_1.append(expr);
                _builder_1.append(" in \"");
                _builder_1.append((Object)template);
                _builder_1.append("\"\" could not be resolved.");
                CharSequence _eval = this._eLSupport.eval(exprToEvaluate, lang, CharSequence.class, (CharSequence)_builder_1, expr);
                String _string = null;
                if (_eval != null) {
                    _string = _eval.toString();
                }
                _xifexpression = _xblockexpression_1 = _string;
            }
            String value = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = autoCamelCase && matcher.start() > 0 && Character.isLowerCase(template.charAt(matcher.start() - 1)) ? StringExtensions.toFirstUpper((String)value) : value;
            matcher.appendReplacement(sb, _xifexpression_1);
        }
        _xblockexpression = matcher.appendTail(sb);
        return _xblockexpression;
    }

    public Functions.Function0<? extends String> createNameExprRule(AnnotationMirror metaAnnotation, Element template, String avPrefix) {
        Functions.Function0 _function;
        Functions.Function0 _xblockexpression = null;
        Name _simpleName = null;
        if (template != null) {
            _simpleName = template.getSimpleName();
        }
        Name nameFromTemplate = _simpleName;
        String _value = null;
        if (metaAnnotation != null) {
            _value = this._elementsExtensions.value(metaAnnotation, RuleUtils.withPrefix("name", avPrefix), String.class);
        }
        String name = _value;
        String _value_1 = null;
        if (metaAnnotation != null) {
            _value_1 = this._elementsExtensions.value(metaAnnotation, RuleUtils.withPrefix("nameExpr", avPrefix), String.class);
        }
        String nameExpr = _value_1;
        String _value_2 = null;
        if (metaAnnotation != null) {
            _value_2 = this._elementsExtensions.value(metaAnnotation, RuleUtils.withPrefix("nameLang", avPrefix), String.class);
        }
        String nameLang = _value_2;
        _xblockexpression = _function = () -> {
            boolean _not;
            String _xblockexpression_1 = null;
            StringBuffer _replaceExpressionInTemplate = null;
            if (nameFromTemplate != null) {
                _replaceExpressionInTemplate = this.replaceExpressionInTemplate(nameFromTemplate, false, null, true);
            }
            String _string = null;
            if (_replaceExpressionInTemplate != null) {
                _string = _replaceExpressionInTemplate.toString();
            }
            String nameFromTemplateResolved = _string;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)nameExpr);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Member name could not be generated");
                String _elvis = null;
                _elvis = nameFromTemplateResolved != null ? nameFromTemplateResolved : "invalidMemberName";
                _xifexpression = this._eLSupport.eval(nameExpr, nameLang, String.class, (CharSequence)_builder, _elvis);
            } else {
                String _xifexpression_1 = null;
                boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)name);
                boolean _not_1 = !_isNullOrEmpty_1;
                _xifexpression_1 = _not_1 ? name : nameFromTemplateResolved;
                _xifexpression = _xifexpression_1;
            }
            String result = _xifexpression;
            String _xifexpression_2 = null;
            boolean _isNullOrEmpty_2 = StringExtensions.isNullOrEmpty((String)result);
            _xifexpression_2 = _isNullOrEmpty_2 ? this._eLSupport.getCurrentSrcElement().getSimpleName().toString() : result;
            _xblockexpression_1 = _xifexpression_2;
            return _xblockexpression_1;
        };
        return _xblockexpression;
    }

    public Functions.Function1<? super GenElement, ? extends List<? extends AnnotationMirror>> createAnnotationMappingRules(AnnotationMirror metaAnnotation, Element template, String avPrefix) {
        Functions.Function1 _function;
        ArrayList _newArrayList;
        Functions.Function1 _xblockexpression = null;
        List<Object> _elvis = null;
        List<Object> _annotationMappingRulesFromMetaAnnotation = null;
        if (metaAnnotation != null) {
            _annotationMappingRulesFromMetaAnnotation = this.annotationMappingRulesFromMetaAnnotation(metaAnnotation, RuleUtils.withPrefix("annotations", avPrefix));
        }
        _elvis = _annotationMappingRulesFromMetaAnnotation != null ? _annotationMappingRulesFromMetaAnnotation : (_newArrayList = CollectionLiterals.newArrayList());
        ArrayList mappings = _elvis;
        mappings.addAll(this.annotationMappingRulesFromAnnotationTemplates(template));
        _xblockexpression = _function = genElement -> {
            ArrayList<GenAnnotationMirror> _emptyList;
            ArrayList<GenAnnotationMirror> _xblockexpression_1 = null;
            Functions.Function1 _function_1 = it -> (GenAnnotationMirror)it;
            List _map = ListExtensions.map(genElement.getAnnotationMirrors(), (Functions.Function1)_function_1);
            ArrayList<GenAnnotationMirror> annotations = new ArrayList<GenAnnotationMirror>(_map);
            ArrayList<GenAnnotationMirror> _elvis_1 = null;
            ArrayList<GenAnnotationMirror> _copyAnnotations = null;
            if (template != null) {
                Functions.Function1 _function_2 = am -> !this._genExtensions.isJapkitAnnotation((AnnotationMirror)am) && !this._elementsExtensions.hasMetaAnnotation((AnnotationMirror)am, AnnotationTemplate.class.getName());
                _copyAnnotations = this._genExtensions.copyAnnotations(template, (Functions.Function1<? super AnnotationMirror, ? extends Boolean>)_function_2, templateAnnotationValueTransformer);
            }
            _elvis_1 = _copyAnnotations != null ? _copyAnnotations : (_emptyList = CollectionLiterals.emptyList());
            annotations.addAll(_elvis_1);
            if (mappings != null) {
                Consumer<AnnotationMappingRule> _function_3 = it -> it.mapOrCopyAnnotations(annotations);
                mappings.forEach(_function_3);
            }
            _xblockexpression_1 = annotations;
            return _xblockexpression_1;
        };
        return _xblockexpression;
    }

    private List<AnnotationMappingRule> annotationMappingRulesFromAnnotationTemplates(Element templateElement) {
        List _emptyList;
        List _elvis = null;
        List<? extends AnnotationMirror> _annotationMirrors = null;
        if (templateElement != null) {
            _annotationMirrors = templateElement.getAnnotationMirrors();
        }
        Iterable _filter = null;
        if (_annotationMirrors != null) {
            Functions.Function1 _function = it -> this._elementsExtensions.hasMetaAnnotation((AnnotationMirror)it, AnnotationTemplate.class.getName());
            _filter = IterableExtensions.filter(_annotationMirrors, (Functions.Function1)_function);
        }
        Iterable _map = null;
        if (_filter != null) {
            Functions.Function1 _function_1 = it -> {
                AnnotationAndParent _annotationAndParent = new AnnotationAndParent((AnnotationMirror)it, null, null, templateElement);
                return new AnnotationMappingRule((AnnotationMirror)_annotationAndParent, templateElement);
            };
            _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        }
        List _list = null;
        if (_map != null) {
            _list = IterableExtensions.toList(_map);
        }
        _elvis = _list != null ? _list : (_emptyList = CollectionLiterals.emptyList());
        return _elvis;
    }

    private List<AnnotationMappingRule> annotationMappingRulesFromMetaAnnotation(AnnotationMirror metaAnnotation, CharSequence avName) {
        ArrayList _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList();
        HashMap annotationMappingsById = CollectionLiterals.newHashMap();
        AnnotationMirror[] _value = this._elementsExtensions.value(metaAnnotation, avName, AnnotationMirror[].class);
        if ((List)Conversions.doWrapArray((Object)_value) != null) {
            Consumer<AnnotationMirror> _function = it -> {
                AnnotationMappingRule amr = new AnnotationMappingRule((AnnotationMirror)it, annotationMappingsById);
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)amr.getId());
                if (_isNullOrEmpty) {
                    result.add(amr);
                } else {
                    annotationMappingsById.put(amr.getId(), amr);
                }
            };
            ((List)Conversions.doWrapArray((Object)_value)).forEach(_function);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    private List<GenAnnotationMirror> mapAnnotations(Iterable<? extends AnnotationMappingRule> mappings, List<GenAnnotationMirror> existingAnnotations) {
        List<GenAnnotationMirror> _xblockexpression = null;
        List<GenAnnotationMirror> annotations = existingAnnotations;
        Consumer<AnnotationMappingRule> _function = it -> it.mapOrCopyAnnotations(annotations);
        mappings.forEach(_function);
        _xblockexpression = annotations;
        return _xblockexpression;
    }

    public Functions.Function0<? extends Set<Modifier>> createModifiersRule(AnnotationMirror metaAnnotation, Element template, String avPrefix) {
        Functions.Function0 _function_1;
        Set _emptySet;
        Functions.Function0 _xblockexpression = null;
        Set _elvis = null;
        Set _modifiers = null;
        if (template != null) {
            _modifiers = template.getModifiers();
        }
        _elvis = _modifiers != null ? _modifiers : (_emptySet = CollectionLiterals.emptySet());
        Set templateModifiers = _elvis;
        if (metaAnnotation == null) {
            Functions.Function0 _function = () -> {
                Set<Modifier> _modifiers_1 = null;
                if (template != null) {
                    _modifiers_1 = template.getModifiers();
                }
                return _modifiers_1;
            };
            return _function;
        }
        Modifier[] modi = this._elementsExtensions.value(metaAnnotation, RuleUtils.withPrefix("modifiers", avPrefix), Modifier[].class);
        Boolean _elvis_1 = null;
        Boolean _value = this._elementsExtensions.value(metaAnnotation, RuleUtils.withPrefix("modifiersFromSrc", avPrefix), Boolean.class);
        _elvis_1 = _value != null ? _value : Boolean.valueOf(false);
        Boolean modifiersFromSrc = _elvis_1;
        _xblockexpression = _function_1 = () -> {
            HashSet<Modifier> _xblockexpression_1 = null;
            Set _xifexpression = null;
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)modi)));
            boolean _not = !_isNullOrEmpty;
            _xifexpression = _not ? IterableExtensions.toSet((Iterable)((Iterable)Conversions.doWrapArray((Object)modi))) : templateModifiers;
            HashSet<Modifier> modifiers = new HashSet<Modifier>(_xifexpression);
            if (modifiersFromSrc.booleanValue()) {
                modifiers.addAll(this._eLSupport.getCurrentSrcElement().getModifiers());
            }
            _xblockexpression_1 = modifiers;
            return _xblockexpression_1;
        };
        return _xblockexpression;
    }

    public Functions.Function0<? extends TypeMirror> createTypeRule(AnnotationMirror metaAnnotation, TypeMirror template, String avPrefix) {
        Functions.Function0 _function = () -> {
            TypeMirror _srcType = this._elementsExtensions.srcType(this._eLSupport.getCurrentSrcElement());
            TypeMirror _resolveType = null;
            if (_srcType != null) {
                _resolveType = this.typesResolver.resolveType(_srcType);
            }
            return _resolveType;
        };
        return this.createTypeRule(metaAnnotation, template, "type", avPrefix, (Functions.Function0<? extends TypeMirror>)_function);
    }

    public Functions.Function0<? extends TypeMirror> createTypeRule(AnnotationMirror metaAnnotation, TypeMirror template, String avName, String avPrefix, Functions.Function0<? extends TypeMirror> defaultValue) {
        Functions.Function0 _function = () -> {
            TypeMirror _xtrycatchfinallyexpression = null;
            try {
                boolean _not;
                TypeMirror _xblockexpression = null;
                TypeMirror _resolveTypeFromAnnotationValues = null;
                if (metaAnnotation != null) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append(avName);
                    _builder.append("Args");
                    _resolveTypeFromAnnotationValues = this.typesResolver.resolveTypeFromAnnotationValues(metaAnnotation, RuleUtils.withPrefix(avName, avPrefix), RuleUtils.withPrefix((CharSequence)_builder, avPrefix));
                }
                TypeMirror type = _resolveTypeFromAnnotationValues;
                TypeMirror _xifexpression = null;
                boolean _isVoid = this._typesExtensions.isVoid(type);
                boolean bl = _not = !_isVoid;
                if (_not) {
                    _xifexpression = type;
                } else {
                    TypeMirror _xifexpression_1 = null;
                    if (template != null) {
                        TypeMirror _elvis = null;
                        TypeMirror _resolveType = this.typesResolver.resolveType(template);
                        if (_resolveType != null) {
                            _elvis = _resolveType;
                        } else {
                            NoType _noType = this._typesExtensions.getNoType(TypeKind.NONE);
                            _elvis = _noType;
                        }
                        _xifexpression_1 = _elvis;
                    } else {
                        TypeMirror _apply = null;
                        if (defaultValue != null) {
                            _apply = (TypeMirror)defaultValue.apply();
                        }
                        _xifexpression_1 = _apply;
                    }
                    _xifexpression = _xifexpression_1;
                }
                _xtrycatchfinallyexpression = _xblockexpression = _xifexpression;
            }
            catch (Throwable _t) {
                if (_t instanceof TypeElementNotFoundException) {
                    TypeElementNotFoundException tenfe = (TypeElementNotFoundException)_t;
                    GenUnresolvedType _xblockexpression_1 = null;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("TypeElement not found for ");
                    String _elvis = null;
                    String _simpleName = null;
                    if (template != null) {
                        _simpleName = this._typesExtensions.simpleName(template);
                    }
                    _elvis = _simpleName != null ? _simpleName : avName;
                    _builder.append(_elvis);
                    _builder.append(".");
                    this.typesRegistry.handleTypeElementNotFound((CharSequence)_builder, tenfe.getFqn());
                    String _fqn = tenfe.getFqn();
                    _xblockexpression_1 = new GenUnresolvedType(_fqn, false);
                    _xtrycatchfinallyexpression = _xblockexpression_1;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return _xtrycatchfinallyexpression;
        };
        return _function;
    }

    protected Functions.Function0<? extends List<? extends GenParameter>> createParamRules(AnnotationMirror paramsAnnotation, ExecutableElement template, String avPrefix) {
        Functions.Function0 _function_2;
        Functions.Function0 _xblockexpression = null;
        List _xifexpression = null;
        if (template != null) {
            Functions.Function1 _function = it -> this.createParamRule(this._elementsExtensions.annotationMirror((Element)it, Param.class), (VariableElement)it, null);
            _xifexpression = IterableExtensions.toList((Iterable)ListExtensions.map(this._elementsExtensions.parametersWithSrcNames(template), (Functions.Function1)_function));
        } else {
            Functions.Function1 _function_1 = it -> this.createParamRule((AnnotationMirror)it, null, null);
            _xifexpression = IterableExtensions.toList((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)this._elementsExtensions.value(paramsAnnotation, RuleUtils.withPrefix("parameters", avPrefix), AnnotationMirror[].class))), (Functions.Function1)_function_1));
        }
        List rules = _xifexpression;
        _xblockexpression = _function_2 = () -> {
            Functions.Function1 _function_3 = it -> (List)it.apply();
            return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)rules, (Functions.Function1)_function_3)));
        };
        return _xblockexpression;
    }

    public Functions.Function0<? extends List<? extends GenParameter>> createParamRule(AnnotationMirror paramAnnotation, VariableElement template, String avPrefix) {
        return new ParamRule(paramAnnotation, template, avPrefix);
    }

    public Functions.Function0<? extends CharSequence> createCommentRule(AnnotationMirror metaAnnotation, Element template, String avPrefix, Functions.Function0<? extends CharSequence> defaultComment) {
        Functions.Function0 _function;
        Functions.Function0 _xblockexpression = null;
        Boolean _elvis = null;
        Boolean _value = null;
        if (metaAnnotation != null) {
            _value = this._elementsExtensions.value(metaAnnotation, RuleUtils.withPrefix("commentFromSrc", avPrefix), Boolean.class);
        }
        _elvis = _value != null ? _value : Boolean.valueOf(false);
        Boolean copyFromSrc = _elvis;
        String _value_1 = null;
        if (metaAnnotation != null) {
            _value_1 = this._elementsExtensions.value(metaAnnotation, RuleUtils.withPrefix("commentExpr", avPrefix), String.class);
        }
        String commentExpr = _value_1;
        String _value_2 = null;
        if (metaAnnotation != null) {
            _value_2 = this._elementsExtensions.value(metaAnnotation, RuleUtils.withPrefix("commentLang", avPrefix), String.class);
        }
        String commentLang = _value_2;
        String _docCommentUsingRuntimeMetadata = null;
        if (template != null) {
            _docCommentUsingRuntimeMetadata = this._elementsExtensions.getDocCommentUsingRuntimeMetadata(template);
        }
        String commentFromTemplate = JavadocUtil.removeCode(_docCommentUsingRuntimeMetadata);
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)commentExpr);
        _xifexpression = _isNullOrEmpty ? commentFromTemplate : commentExpr;
        String expr = _xifexpression;
        _xblockexpression = _function = () -> {
            CharSequence _xifexpression_1 = null;
            if (copyFromSrc.booleanValue()) {
                _xifexpression_1 = this._elementsExtensions.getDocComment(this._eLSupport.getCurrentSrcElement());
            } else {
                boolean _not;
                CharSequence _xifexpression_2 = null;
                boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)expr);
                boolean bl = _not = !_isNullOrEmpty_1;
                if (_not) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Comment could not be generated");
                    _xifexpression_2 = this._eLSupport.eval(expr, commentLang, CharSequence.class, (CharSequence)_builder, "invalidComment");
                } else {
                    CharSequence _apply = null;
                    if (defaultComment != null) {
                        _apply = (CharSequence)defaultComment.apply();
                    }
                    _xifexpression_2 = _apply;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            return _xifexpression_1;
        };
        return _xblockexpression;
    }

    public Functions.Function1<? super CharSequence, ? extends Boolean> createNameInSetRule(AnnotationMirror metaAnnotation, String avName) {
        Functions.Function1 _function;
        Functions.Function1 _xblockexpression = null;
        String _value = null;
        if (metaAnnotation != null) {
            _value = this._elementsExtensions.value(metaAnnotation, avName, String.class);
        }
        String expr = _value;
        String _value_1 = null;
        if (metaAnnotation != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(avName);
            _builder.append("Lang");
            _value_1 = this._elementsExtensions.value(metaAnnotation, (CharSequence)_builder, String.class);
        }
        String lang = _value_1;
        Functions.Function1 _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)expr);
        _xifexpression = _isNullOrEmpty ? null : (_function = it -> {
            boolean _xblockexpression_1 = false;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Name set expression could not be evaluated.");
            Functions.Function1 _function_1 = it_1 -> {
                String _xifexpression_1 = null;
                _xifexpression_1 = it_1 instanceof Element ? ((Element)it_1).getSimpleName().toString() : it_1.toString();
                return _xifexpression_1;
            };
            Set nameSet = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)this._eLSupport.eval(expr, lang, Iterable.class, (CharSequence)_builder_1, CollectionLiterals.emptySet()), (Functions.Function1)_function_1));
            _xblockexpression_1 = nameSet.contains(it.toString());
            return _xblockexpression_1;
        });
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public List<MatcherRule> createMatcherRules(AnnotationMirror annotation, CharSequence avName) {
        List _xblockexpression = null;
        AnnotationMirror[] av = this._elementsExtensions.value(annotation, avName, AnnotationMirror[].class);
        List _xifexpression = null;
        if (av != null) {
            Functions.Function1 _function = it -> this._ruleFactory.createMatcherRule((AnnotationMirror)it);
            _xifexpression = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)av)), (Functions.Function1)_function);
        } else {
            _xifexpression = CollectionLiterals.emptyList();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public <T> T handleException(Functions.Function0<? extends T> errorResult, String avName, Functions.Function0<? extends T> closure) {
        Object _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = closure.apply();
        }
        catch (Throwable _t) {
            if (_t instanceof TypeElementNotFoundException) {
                TypeElementNotFoundException tenfe = (TypeElementNotFoundException)_t;
                throw tenfe;
            }
            if (_t instanceof ReportedException) {
                ReportedException e = (ReportedException)_t;
                if (errorResult != null) {
                    return (T)errorResult.apply();
                }
                throw e;
            }
            if (_t instanceof RuleException) {
                String _avName;
                RuleException e_1 = (RuleException)_t;
                String _elvis = null;
                _elvis = avName != null ? avName : (_avName = e_1.getAvName());
                this._messageCollector.reportRuleError(e_1, _elvis);
                if (errorResult != null) {
                    return (T)errorResult.apply();
                }
                throw new ReportedException(e_1);
            }
            if (_t instanceof Exception) {
                Exception e_2 = (Exception)_t;
                this._messageCollector.reportRuleError(e_2, avName);
                if (errorResult != null) {
                    return (T)errorResult.apply();
                }
                throw new ReportedException(e_2);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return (T)_xtrycatchfinallyexpression;
    }
}

