/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.rules;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.japkit.metaannotations.Clazz;
import de.japkit.metaannotations.Constructor;
import de.japkit.metaannotations.Field;
import de.japkit.metaannotations.InnerClass;
import de.japkit.metaannotations.Method;
import de.japkit.metaannotations.Template;
import de.japkit.model.AnnotationWithDefaultAnnotation;
import de.japkit.model.GenElement;
import de.japkit.model.GenTypeElement;
import de.japkit.rules.AbstractRule;
import de.japkit.rules.ClassRule;
import de.japkit.rules.ConstructorRule;
import de.japkit.rules.FieldRule;
import de.japkit.rules.IParameterlessFunctionRule;
import de.japkit.rules.InnerClassRule;
import de.japkit.rules.MembersRule;
import de.japkit.rules.MethodRule;
import de.japkit.rules.TypeResolver;
import de.japkit.services.ExtensionRegistry;
import de.japkit.util.MoreCollectionExtensions;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class TemplateRule
extends AbstractRule
implements Functions.Function1<GenTypeElement, List<? extends GenElement>> {
    @Extension
    private final transient TypeResolver _typeResolver = ExtensionRegistry.get(TypeResolver.class);
    private final TypeElement templateClass;
    private final Functions.Function1<? super GenElement, ? extends List<? extends AnnotationMirror>> annotationsRule;
    private final List<Functions.Function1<? super GenTypeElement, ? extends List<? extends GenElement>>> memberRules;
    private final Functions.Function0<? extends Boolean> activationRule;
    private final Functions.Function1<? super Functions.Function1<? super Object, ? extends Iterable<? extends GenElement>>, ? extends Iterable<Iterable<? extends GenElement>>> scopeRule;
    private final AnnotationMirror fieldDefaults;
    private final AnnotationMirror methodDefaults;
    private final AnnotationMirror constructorDefaults;
    private final boolean allFieldsAreTemplates;
    private final boolean allMethodsAreTemplates;
    private final boolean allConstructorsAreTemplates;

    public TemplateRule(TypeElement templateClass, AnnotationMirror metaAnnotation, Procedures.Procedure1<? super TemplateRule> registrationCallback) {
        super(metaAnnotation, templateClass);
        boolean _equals;
        registrationCallback.apply((Object)this);
        this.templateClass = templateClass;
        AnnotationMirror[] _value = null;
        if (metaAnnotation != null) {
            _value = this._elementsExtensions.value(metaAnnotation, "methodDefaults", AnnotationMirror[].class);
        }
        AnnotationMirror _singleValue = null;
        if ((Iterable)Conversions.doWrapArray(_value) != null) {
            _singleValue = (AnnotationMirror)MoreCollectionExtensions.singleValue((Iterable)Conversions.doWrapArray((Object)_value));
        }
        this.methodDefaults = _singleValue;
        AnnotationMirror[] _value_1 = null;
        if (metaAnnotation != null) {
            _value_1 = this._elementsExtensions.value(metaAnnotation, "fieldDefaults", AnnotationMirror[].class);
        }
        AnnotationMirror _singleValue_1 = null;
        if ((Iterable)Conversions.doWrapArray(_value_1) != null) {
            _singleValue_1 = (AnnotationMirror)MoreCollectionExtensions.singleValue((Iterable)Conversions.doWrapArray((Object)_value_1));
        }
        this.fieldDefaults = _singleValue_1;
        AnnotationMirror[] _value_2 = null;
        if (metaAnnotation != null) {
            _value_2 = this._elementsExtensions.value(metaAnnotation, "constructorDefaults", AnnotationMirror[].class);
        }
        AnnotationMirror _singleValue_2 = null;
        if ((Iterable)Conversions.doWrapArray(_value_2) != null) {
            _singleValue_2 = (AnnotationMirror)MoreCollectionExtensions.singleValue((Iterable)Conversions.doWrapArray((Object)_value_2));
        }
        this.constructorDefaults = _singleValue_2;
        Boolean _elvis = null;
        Boolean _value_3 = null;
        if (metaAnnotation != null) {
            _value_3 = this._elementsExtensions.value(metaAnnotation, "allFieldsAreTemplates", Boolean.TYPE);
        }
        _elvis = _value_3 != null ? _value_3 : Boolean.valueOf(true);
        this.allFieldsAreTemplates = _elvis;
        Boolean _elvis_1 = null;
        Boolean _value_4 = null;
        if (metaAnnotation != null) {
            _value_4 = this._elementsExtensions.value(metaAnnotation, "allMethodsAreTemplates", Boolean.TYPE);
        }
        _elvis_1 = _value_4 != null ? _value_4 : Boolean.valueOf(true);
        this.allMethodsAreTemplates = _elvis_1;
        Boolean _elvis_2 = null;
        Boolean _value_5 = null;
        if (metaAnnotation != null) {
            _value_5 = this._elementsExtensions.value(metaAnnotation, "allConstructorsAreTemplates", Boolean.TYPE);
        }
        _elvis_2 = _value_5 != null ? _value_5 : Boolean.valueOf(true);
        this.allConstructorsAreTemplates = _elvis_2;
        this.memberRules = CollectionLiterals.newArrayList();
        if (metaAnnotation != null) {
            MembersRule _membersRule = new MembersRule(metaAnnotation);
            this.memberRules.add(_membersRule);
        }
        Functions.Function1 _function = it -> {
            boolean _isVariable = this._ruleUtils.isVariable((Element)it);
            return !_isVariable;
        };
        Functions.Function1 _function_1 = it -> this.createRuleForMember((Element)it);
        Functions.Function1 _function_2 = it -> it != null;
        this.memberRules.addAll(IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this._elementsExtensions.enclosedElementsOrdered(templateClass), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2)));
        this.annotationsRule = this._ruleUtils.createAnnotationMappingRules(metaAnnotation, templateClass, null);
        String _name = Template.class.getName();
        DeclaredType _annotationType = null;
        if (metaAnnotation != null) {
            _annotationType = metaAnnotation.getAnnotationType();
        }
        String _qualifiedName = null;
        if (_annotationType != null) {
            _qualifiedName = this._typesExtensions.qualifiedName(_annotationType);
        }
        if (_equals = Objects.equal((Object)_name, _qualifiedName)) {
            this.activationRule = this._ruleUtils.createActivationRule(metaAnnotation, null);
            this.scopeRule = this._ruleUtils.createScopeRule(metaAnnotation, (Element)templateClass, true, null);
        } else {
            Functions.Function0 _function_3;
            this.activationRule = _function_3 = () -> true;
            this.scopeRule = this._ruleUtils.createScopeRule(metaAnnotation, templateClass, true, null, false);
        }
    }

    private Functions.Function1<? super GenTypeElement, ? extends List<? extends GenElement>> _createRuleForMember(TypeElement member) {
        AnnotationMirror innerClassAnnotation = this._elementsExtensions.annotationMirror((Element)member, InnerClass.class);
        if (innerClassAnnotation != null) {
            return new InnerClassRule(innerClassAnnotation, member);
        }
        AnnotationMirror clazzAnnotation = this._elementsExtensions.annotationMirror((Element)member, Clazz.class);
        if (clazzAnnotation != null) {
            ClassRule cr = new ClassRule(clazzAnnotation, member, true, true);
            Functions.Function1 _function = it -> cr.generateClass(null, null);
            return _function;
        }
        AnnotationMirror templateAnnotation = this._elementsExtensions.annotationMirror((Element)member, Template.class);
        if (templateAnnotation != null && !this._elementsExtensions.isStatic(member)) {
            return this._ruleFactory.createTemplateRule(member);
        }
        return null;
    }

    private Functions.Function1<? super GenTypeElement, ? extends List<? extends GenElement>> _createRuleForMember(VariableElement member) {
        FieldRule _xblockexpression = null;
        AnnotationMirror annotation = this._elementsExtensions.annotationMirror((Element)member, Field.class);
        FieldRule _xifexpression = null;
        if (annotation != null || this.allFieldsAreTemplates) {
            AnnotationMirror _createIfNecessary = AnnotationWithDefaultAnnotation.createIfNecessary(annotation, this.fieldDefaults);
            _xifexpression = new FieldRule(_createIfNecessary, member);
        } else {
            _xifexpression = null;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private Functions.Function1<? super GenTypeElement, ? extends List<? extends GenElement>> _createRuleForMember(ExecutableElement member) {
        AnnotationMirror annotation_1;
        Object annotation;
        IParameterlessFunctionRule<?> _createFunctionRule = this._ruleFactory.createFunctionRule(member);
        boolean isNoFunction = _createFunctionRule == null;
        ElementKind _kind = member.getKind();
        boolean _equals = Objects.equal((Object)((Object)_kind), (Object)((Object)ElementKind.METHOD));
        if (_equals) {
            annotation = this._elementsExtensions.annotationMirror((Element)member, Method.class);
            if (annotation != null || this.allMethodsAreTemplates && isNoFunction) {
                AnnotationMirror _createIfNecessary = AnnotationWithDefaultAnnotation.createIfNecessary((AnnotationMirror)annotation, this.methodDefaults);
                return new MethodRule(_createIfNecessary, member);
            }
        } else {
            annotation = member.getKind();
        }
        if ((annotation_1 = this._elementsExtensions.annotationMirror((Element)member, Constructor.class)) != null || this.allConstructorsAreTemplates && !this.isDefaultConstructor(member) && isNoFunction) {
            AnnotationMirror _createIfNecessary_1 = AnnotationWithDefaultAnnotation.createIfNecessary(annotation_1, this.constructorDefaults);
            return new ConstructorRule(_createIfNecessary_1, member);
        }
        return null;
    }

    private Functions.Function1<? super GenTypeElement, ? extends List<? extends GenElement>> _createRuleForMember(Element member) {
        return null;
    }

    private boolean isDefaultConstructor(ExecutableElement ctor) {
        return IterableExtensions.isNullOrEmpty(ctor.getParameters());
    }

    public List<? extends GenElement> apply(GenTypeElement generatedClass) {
        Functions.Function1 _function = it -> {
            boolean _not;
            List _xblockexpression = null;
            Boolean _apply = (Boolean)this.activationRule.apply();
            boolean bl = _not = _apply == false;
            if (_not) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function1 _function_1 = it_1 -> {
                List _xblockexpression_1 = null;
                generatedClass.setAnnotationMirrors((List)this.annotationsRule.apply((Object)generatedClass));
                this.addInterfaces(generatedClass);
                Functions.Function1 _function_2 = it_2 -> (List)it_2.apply((Object)generatedClass);
                _xblockexpression_1 = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map(this.memberRules, (Functions.Function1)_function_2)));
                return _xblockexpression_1;
            };
            _xblockexpression = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)((Iterable)this.scopeRule.apply((Object)_function_1))));
            return _xblockexpression;
        };
        return (List)this.inRule(_function);
    }

    private void addInterfaces(GenTypeElement generatedClass) {
        Functions.Function1 _function = it -> this._typeResolver.resolveType((TypeMirror)it);
        Functions.Function1 _function_1 = it -> {
            boolean _isVoid = this._typesExtensions.isVoid((TypeMirror)it);
            return !_isVoid;
        };
        Consumer<TypeMirror> _function_2 = it -> generatedClass.addInterface((TypeMirror)it);
        IterableExtensions.filter((Iterable)ListExtensions.map(this.templateClass.getInterfaces(), (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
    }

    private Functions.Function1<? super GenTypeElement, ? extends List<? extends GenElement>> createRuleForMember(Element member) {
        if (member instanceof ExecutableElement) {
            return this._createRuleForMember((ExecutableElement)member);
        }
        if (member instanceof TypeElement) {
            return this._createRuleForMember((TypeElement)member);
        }
        if (member instanceof VariableElement) {
            return this._createRuleForMember((VariableElement)member);
        }
        if (member != null) {
            return this._createRuleForMember(member);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(member).toString());
    }

    @Override
    @Pure
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.templateClass == null ? 0 : this.templateClass.hashCode());
        result = 31 * result + (this.annotationsRule == null ? 0 : this.annotationsRule.hashCode());
        result = 31 * result + (this.memberRules == null ? 0 : this.memberRules.hashCode());
        result = 31 * result + (this.activationRule == null ? 0 : this.activationRule.hashCode());
        result = 31 * result + (this.scopeRule == null ? 0 : this.scopeRule.hashCode());
        result = 31 * result + (this.fieldDefaults == null ? 0 : this.fieldDefaults.hashCode());
        result = 31 * result + (this.methodDefaults == null ? 0 : this.methodDefaults.hashCode());
        result = 31 * result + (this.constructorDefaults == null ? 0 : this.constructorDefaults.hashCode());
        result = 31 * result + (this.allFieldsAreTemplates ? 1231 : 1237);
        result = 31 * result + (this.allMethodsAreTemplates ? 1231 : 1237);
        result = 31 * result + (this.allConstructorsAreTemplates ? 1231 : 1237);
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TemplateRule other = (TemplateRule)obj;
        if (this.templateClass == null ? other.templateClass != null : !this.templateClass.equals(other.templateClass)) {
            return false;
        }
        if (this.annotationsRule == null ? other.annotationsRule != null : !this.annotationsRule.equals(other.annotationsRule)) {
            return false;
        }
        if (this.memberRules == null ? other.memberRules != null : !this.memberRules.equals(other.memberRules)) {
            return false;
        }
        if (this.activationRule == null ? other.activationRule != null : !this.activationRule.equals(other.activationRule)) {
            return false;
        }
        if (this.scopeRule == null ? other.scopeRule != null : !this.scopeRule.equals(other.scopeRule)) {
            return false;
        }
        if (this.fieldDefaults == null ? other.fieldDefaults != null : !this.fieldDefaults.equals(other.fieldDefaults)) {
            return false;
        }
        if (this.methodDefaults == null ? other.methodDefaults != null : !this.methodDefaults.equals(other.methodDefaults)) {
            return false;
        }
        if (this.constructorDefaults == null ? other.constructorDefaults != null : !this.constructorDefaults.equals(other.constructorDefaults)) {
            return false;
        }
        if (other.allFieldsAreTemplates != this.allFieldsAreTemplates) {
            return false;
        }
        if (other.allMethodsAreTemplates != this.allMethodsAreTemplates) {
            return false;
        }
        return other.allConstructorsAreTemplates == this.allConstructorsAreTemplates;
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public TypeElement getTemplateClass() {
        return this.templateClass;
    }

    @Pure
    public Functions.Function1<? super GenElement, ? extends List<? extends AnnotationMirror>> getAnnotationsRule() {
        return this.annotationsRule;
    }

    @Pure
    public List<Functions.Function1<? super GenTypeElement, ? extends List<? extends GenElement>>> getMemberRules() {
        return this.memberRules;
    }

    @Pure
    public Functions.Function0<? extends Boolean> getActivationRule() {
        return this.activationRule;
    }

    @Pure
    public Functions.Function1<? super Functions.Function1<? super Object, ? extends Iterable<? extends GenElement>>, ? extends Iterable<Iterable<? extends GenElement>>> getScopeRule() {
        return this.scopeRule;
    }

    @Pure
    public AnnotationMirror getFieldDefaults() {
        return this.fieldDefaults;
    }

    @Pure
    public AnnotationMirror getMethodDefaults() {
        return this.methodDefaults;
    }

    @Pure
    public AnnotationMirror getConstructorDefaults() {
        return this.constructorDefaults;
    }

    @Pure
    public boolean isAllFieldsAreTemplates() {
        return this.allFieldsAreTemplates;
    }

    @Pure
    public boolean isAllMethodsAreTemplates() {
        return this.allMethodsAreTemplates;
    }

    @Pure
    public boolean isAllConstructorsAreTemplates() {
        return this.allConstructorsAreTemplates;
    }
}

