/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.services;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.japkit.annotations.Order;
import de.japkit.annotations.ParamNames;
import de.japkit.annotations.RuntimeMetadata;
import de.japkit.metaannotations.SingleValue;
import de.japkit.model.AnnotationAndParent;
import de.japkit.model.AnnotationWithDefaultAnnotation;
import de.japkit.model.AnnotationWrapper;
import de.japkit.model.GenAnnotationMirror;
import de.japkit.model.GenAnnotationValue;
import de.japkit.model.GenElement;
import de.japkit.model.GenName;
import de.japkit.model.GenTypeElement;
import de.japkit.model.ParameterWrapper;
import de.japkit.model.Path;
import de.japkit.model.Property;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.MessageCollector;
import de.japkit.services.ProcessingException;
import de.japkit.services.RuleException;
import de.japkit.services.TypeElementFromCompilerCache;
import de.japkit.services.TypeElementNotFoundException;
import de.japkit.services.TypesExtensions;
import de.japkit.services.TypesRegistry;
import de.japkit.util.MoreCollectionExtensions;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ElementsExtensions {
    @Extension
    private final transient TypesExtensions _typesExtensions = ExtensionRegistry.get(TypesExtensions.class);
    @Extension
    private final transient TypesRegistry _typesRegistry = ExtensionRegistry.get(TypesRegistry.class);
    private final MessageCollector mc = ExtensionRegistry.get(MessageCollector.class);
    private final Elements elementUtils = ExtensionRegistry.get(Elements.class);
    private final TypeElementFromCompilerCache typeElementCache = ExtensionRegistry.get(TypeElementFromCompilerCache.class);
    public final String ORDER_ANNOTATION_NAME = Order.class.getName();
    public final String PARAM_NAMES_ANNOTATION_NAME = ParamNames.class.getName();
    private final HashMap<String, Map<String, ExecutableElement>> annotationValueMethodsCache = new HashMap();
    private final IdentityHashMap<AnnotationMirror, Map<String, AnnotationValue>> annotationValuesCache = new IdentityHashMap();
    private static Map<Class<?>, Method> bindingMethod = CollectionLiterals.newHashMap();
    public static final Set<Modifier> VISIBILITY_MODIFIERS = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Modifier[]{Modifier.PRIVATE, Modifier.PUBLIC, Modifier.PROTECTED}));
    private Map<String, String> commentsFromRuntimeMetadata = CollectionLiterals.newHashMap();
    private Map<String, List<String>> paramNamesFromRuntimeMetadata = CollectionLiterals.newHashMap();
    private Map<String, Integer> orderFromRuntimeMetadata = CollectionLiterals.newHashMap();
    private Map<String, TypeElement> runtimeMetadataByFqn = new HashMap<String, TypeElement>();

    public boolean hasType(Element e, TypeMirror type) {
        TypeMirror _asType = e.asType();
        return this._typesExtensions.operator_equals(_asType, type);
    }

    protected TypeMirror _srcType(VariableElement e) {
        return e.asType();
    }

    protected TypeMirror _srcType(ExecutableElement e) {
        return e.getReturnType();
    }

    protected TypeMirror _srcType(Element e) {
        return e.asType();
    }

    protected TypeMirror _srcType(TypeMirror t) {
        return t;
    }

    protected TypeMirror _srcType(Object o) {
        TypeMirror _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Cannot determine type for source ");
        _builder.append(o);
        _builder.append(", since it is neither a type nor an element.");
        this.mc.reportRuleError(_builder);
        _xblockexpression = null;
        return _xblockexpression;
    }

    public List<VariableElement> declaredFields(TypeElement type) {
        Functions.Function1 _function = it -> this.getOrdinalNumber((Element)it);
        return IterableExtensions.sortBy(ElementFilter.fieldsIn(type.getEnclosedElements()), (Functions.Function1)_function);
    }

    public List<ExecutableElement> declaredMethods(TypeElement type) {
        Functions.Function1 _function = it -> this.getOrdinalNumber((Element)it);
        return IterableExtensions.sortBy(ElementFilter.methodsIn(type.getEnclosedElements()), (Functions.Function1)_function);
    }

    public List<ExecutableElement> declaredConstructors(TypeElement type) {
        Functions.Function1 _function = it -> this.getOrdinalNumber((Element)it);
        return IterableExtensions.sortBy(ElementFilter.constructorsIn(type.getEnclosedElements()), (Functions.Function1)_function);
    }

    public List<TypeElement> declaredTypes(TypeElement type) {
        Functions.Function1 _function = it -> this.getOrdinalNumber((Element)it);
        return IterableExtensions.sortBy(ElementFilter.typesIn(type.getEnclosedElements()), (Functions.Function1)_function);
    }

    public List<? extends Element> enclosedElementsOrdered(TypeElement type) {
        List _xblockexpression = null;
        List elements = type.getEnclosedElements();
        List _xifexpression = null;
        Functions.Function1 _function = it -> {
            AnnotationMirror _annotationMirror = this.annotationMirror((Element)it, this.ORDER_ANNOTATION_NAME);
            return _annotationMirror != null;
        };
        boolean _exists = IterableExtensions.exists(elements, (Functions.Function1)_function);
        if (_exists) {
            Functions.Function1 _function_1 = it -> this.getOrdinalNumber((Element)it);
            _xifexpression = IterableExtensions.sortBy(elements, (Functions.Function1)_function_1);
        } else {
            List _xblockexpression_1 = null;
            Functions.Function1<? super Element, ? extends Integer> orderFromRuntimeMetadata = this.getOrderFromRuntimeMetadata(type);
            List _xifexpression_1 = null;
            _xifexpression_1 = orderFromRuntimeMetadata != null ? IterableExtensions.sortBy(elements, orderFromRuntimeMetadata) : elements;
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public Integer getOrdinalNumber(Element e) {
        Integer _xblockexpression = null;
        AnnotationMirror am = this.annotationMirror(e, this.ORDER_ANNOTATION_NAME);
        Integer _xifexpression = null;
        _xifexpression = am == null ? Integer.valueOf(Integer.MAX_VALUE) : this.requiredValue(am, e, "value", Integer.class);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public List<VariableElement> allFields(TypeElement type) {
        return ElementFilter.fieldsIn(this.getAllMembers(type));
    }

    public List<ExecutableElement> allMethods(TypeElement type) {
        List<ExecutableElement> _xifexpression = null;
        _xifexpression = type instanceof GenTypeElement ? ((GenTypeElement)type).allMethods() : ElementFilter.methodsIn(this.getAllMembers(type));
        return _xifexpression;
    }

    public boolean notDeclaredBy(Element e, CharSequence name) {
        return this.notDeclaredBy(e, this.elementUtils.getTypeElement(name));
    }

    public boolean notDeclaredBy(Element e, TypeElement type) {
        Element _enclosingElement = e.getEnclosingElement();
        return !Objects.equal((Object)_enclosingElement, (Object)type);
    }

    public List<ExecutableElement> allMethods(TypeElement type, String stopSuperclass) {
        Functions.Function2 _function = (m1, m2) -> this.overrides((ExecutableElement)m1, (ExecutableElement)m2);
        Functions.Function1 _function_1 = it -> {
            Functions.Function1 _function_2 = m -> Objects.equal((Object)m.getEnclosingElement(), (Object)type) || this.isPublic((Element)m) || this.isProtected((Element)m) || this.isDefaultAccess((Element)m) && this.samePackage((Element)m, type);
            return IterableExtensions.toList((Iterable)IterableExtensions.filter(this.declaredMethods((TypeElement)it), (Functions.Function1)_function_2));
        };
        return this.collectInTypeAndSuperclasses(type, stopSuperclass, _function, _function_1);
    }

    public List<? extends VariableElement> parametersWithSrcNames(ExecutableElement e) {
        List<? extends VariableElement> _xblockexpression = null;
        AnnotationMirror am = this.annotationMirror((Element)e, ParamNames.class);
        List<? extends VariableElement> params = e.getParameters();
        List<? extends VariableElement> _xifexpression = null;
        if (am != null) {
            boolean _notEquals;
            boolean _equals;
            List<ParameterWrapper> _xblockexpression_1 = null;
            String[] namesAv = this.value(am, "value", String[].class);
            List _xifexpression_1 = null;
            int _size = ((List)Conversions.doWrapArray((Object)namesAv)).size();
            boolean bl = _equals = _size == 1;
            if (_equals) {
                Functions.Function1 _function = it -> it.trim();
                _xifexpression_1 = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)namesAv[0].split(","))), (Functions.Function1)_function);
            } else {
                _xifexpression_1 = IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)namesAv)));
            }
            List names = _xifexpression_1;
            List<VariableElement> _xifexpression_2 = null;
            int _size_1 = params.size();
            int _size_2 = names.size();
            boolean bl2 = _notEquals = _size_1 != _size_2;
            if (_notEquals) {
                List<? extends VariableElement> _xblockexpression_2 = null;
                this.mc.reportRuleError("Then number of parameter names must match the number of parameters: " + e);
                _xblockexpression_2 = params;
                _xifexpression_2 = _xblockexpression_2;
            } else {
                _xifexpression_2 = this.wrapParams(e, names);
            }
            _xblockexpression_1 = _xifexpression_2;
            _xifexpression = _xblockexpression_1;
        } else {
            List<? extends VariableElement> _xblockexpression_2 = null;
            List<String> names = this.getParamNamesFromRuntimeMetadata(e);
            List<? extends VariableElement> _xifexpression_1 = null;
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(names);
            boolean _not = !_isNullOrEmpty;
            _xifexpression_1 = _not ? this.wrapParams(e, names) : params;
            _xifexpression = _xblockexpression_2 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private List<ParameterWrapper> wrapParams(ExecutableElement e, List<String> names) {
        List _xblockexpression = null;
        List<? extends VariableElement> params = e.getParameters();
        int _size = params.size();
        Functions.Function1 _function = i -> {
            VariableElement _get = (VariableElement)params.get((int)i);
            String _get_1 = (String)names.get((int)i);
            GenName _genName = new GenName(_get_1);
            return new ParameterWrapper(e, (int)i, _get, _genName);
        };
        _xblockexpression = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)new ExclusiveRange(0, _size, true), (Functions.Function1)_function));
        return _xblockexpression;
    }

    public boolean overrides(ExecutableElement m1, ExecutableElement m2) {
        return this.isVisibleFromSubclass(m2, m1) && this.isSubSignature(m1, m2);
    }

    public boolean isVisibleFromSubclass(Element e, Element subclassOrMemberOfIt) {
        return this.isPublic(e) || this.isProtected(e) || this.isDefaultAccess(e) && this.samePackage(subclassOrMemberOfIt, e);
    }

    public boolean isSubSignature(ExecutableElement m1, ExecutableElement m2) {
        boolean result;
        boolean _xblockexpression = false;
        _xblockexpression = result = m1.getSimpleName().contentEquals(m2.getSimpleName()) && m1.getParameters().size() == m2.getParameters().size() && IterableExtensions.forall((Iterable)new ExclusiveRange(0, ((Object[])Conversions.unwrapArray(m1.getParameters(), Object.class)).length, true), i -> {
            boolean _xblockexpression_1 = false;
            TypeMirror t1 = m1.getParameters().get((int)i).asType();
            TypeMirror t2 = m2.getParameters().get((int)i).asType();
            boolean _or = false;
            boolean _isSameType = this._typesExtensions.isSameType(t1, t2);
            if (_isSameType) {
                _or = true;
            } else {
                boolean _isSameType_1;
                TypeMirror _erasure = null;
                if (t2 != null) {
                    _erasure = this._typesExtensions.erasure(t2);
                }
                _or = _isSameType_1 = this._typesExtensions.isSameType(t1, _erasure);
            }
            _xblockexpression_1 = _or;
            return _xblockexpression_1;
        });
        return _xblockexpression;
    }

    public boolean isOverrideEquivalent(ExecutableElement m1, ExecutableElement m2) {
        return this.isSubSignature(m1, m2) || this.isSubSignature(m2, m1);
    }

    public Iterable<TypeElement> typeElements(Iterable<? extends Element> elements) {
        Functions.Function1 _function = it -> it instanceof TypeElement;
        Functions.Function1 _function_1 = it -> (TypeElement)it;
        return IterableExtensions.map((Iterable)IterableExtensions.filter(elements, (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    public <T> T findFirstInTypeAndSuperclasses(TypeElement typeElement, String stopSuperclass, Functions.Function1<? super TypeElement, ? extends T> query) {
        TypeMirror sup;
        Object _xblockexpression = null;
        Object v = query.apply((Object)typeElement);
        if (v == null && !Objects.equal((Object)((Object)(sup = typeElement.getSuperclass()).getKind()), (Object)((Object)TypeKind.NONE)) && !Objects.equal((Object)stopSuperclass, (Object)this._typesRegistry.asTypeElement(sup).getQualifiedName().toString())) {
            v = this.findFirstInTypeAndSuperclasses(this._typesRegistry.asTypeElement(sup), stopSuperclass, query);
        }
        _xblockexpression = v;
        return (T)_xblockexpression;
    }

    public <T> List<T> collectInTypeAndSuperclasses(TypeElement typeElement, String stopSuperclass, Functions.Function2<? super T, ? super T, ? extends Boolean> isDuplicate, Functions.Function1<? super TypeElement, ? extends List<T>> query) {
        ArrayList _xblockexpression = null;
        ArrayList list = CollectionLiterals.newArrayList();
        list.addAll((Collection)query.apply((Object)typeElement));
        TypeMirror sup = typeElement.getSuperclass();
        if (!Objects.equal((Object)((Object)sup.getKind()), (Object)((Object)TypeKind.NONE)) && !Objects.equal((Object)this._typesRegistry.asTypeElement(sup).getQualifiedName().toString(), (Object)stopSuperclass)) {
            List<? super T> supList = this.collectInTypeAndSuperclasses(this._typesRegistry.asTypeElement(sup), stopSuperclass, isDuplicate, query);
            Functions.Function1 _function = e -> {
                Functions.Function1 _function_1 = it -> {
                    Boolean _apply = (Boolean)isDuplicate.apply(it, e);
                    return _apply == false;
                };
                return IterableExtensions.forall((Iterable)list, (Functions.Function1)_function_1);
            };
            Iterable supListWithoutDuplicates = IterableExtensions.filter(supList, (Functions.Function1)_function);
            Iterables.addAll((Collection)list, (Iterable)supListWithoutDuplicates);
        }
        _xblockexpression = list;
        return _xblockexpression;
    }

    public AnnotationMirror annotationMirror(Element annotatedElement, CharSequence annotationFqn) {
        AnnotationAndParent _xblockexpression = null;
        Functions.Function1 _function = it -> this.hasFqn((AnnotationMirror)it, annotationFqn);
        AnnotationMirror am = (AnnotationMirror)IterableExtensions.findFirst(annotatedElement.getAnnotationMirrors(), (Functions.Function1)_function);
        AnnotationAndParent _xifexpression = null;
        _xifexpression = am == null ? null : new AnnotationAndParent(am, null, null, annotatedElement);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public AnnotationMirror annotationMirror(Element annotatedElement, Class<? extends Annotation> annotationClass) {
        return this.annotationMirror(annotatedElement, annotationClass.getCanonicalName());
    }

    public List<AnnotationMirror> annotationMirrors(Element annotatedElement, Class<? extends Annotation> annotationClass) {
        return this.annotationMirrors(annotatedElement, annotationClass.getCanonicalName());
    }

    public List<AnnotationMirror> annotationMirrors(Element annotatedElement, CharSequence annotationFqn) {
        AnnotationMirror listAnnotation;
        Functions.Function1 _function = it -> it.getSimpleName().contentEquals("List");
        TypeElement listAnnotationType = (TypeElement)IterableExtensions.findFirst(this.declaredTypes(this._typesRegistry.findTypeElement(annotationFqn.toString())), (Functions.Function1)_function);
        if (listAnnotationType != null && (listAnnotation = this.annotationMirror(annotatedElement, listAnnotationType.getQualifiedName())) != null) {
            return (List)Conversions.doWrapArray((Object)this.value(listAnnotation, "value", AnnotationMirror[].class));
        }
        AnnotationMirror singleAnnotation = this.annotationMirror(annotatedElement, annotationFqn);
        List<AnnotationMirror> _xifexpression = null;
        _xifexpression = singleAnnotation == null ? CollectionLiterals.emptyList() : Collections.singletonList(singleAnnotation);
        return _xifexpression;
    }

    public boolean hasMetaAnnotation(AnnotationMirror am, CharSequence metaAnnotationFqn) {
        Functions.Function1 _function = it -> this.hasFqn((AnnotationMirror)it, metaAnnotationFqn);
        return IterableExtensions.exists(this.metaAnnotations(am), (Functions.Function1)_function);
    }

    public List<? extends AnnotationMirror> metaAnnotations(AnnotationMirror annotationMirror) {
        return this.annotationAsTypeElement(annotationMirror).getAnnotationMirrors();
    }

    public AnnotationMirror metaAnnotation(AnnotationMirror annotationMirror, CharSequence metaAnnotationFqn) {
        return this.annotationMirror((Element)this.annotationAsTypeElement(annotationMirror), metaAnnotationFqn);
    }

    public List<AnnotationMirror> metaAnnotations(AnnotationMirror annotationMirror, CharSequence metaAnnotationFqn) {
        return this.annotationMirrors((Element)this.annotationAsTypeElement(annotationMirror), metaAnnotationFqn);
    }

    public AnnotationMirror metaAnnotation(AnnotationMirror annotationMirror, Class<? extends Annotation> annotationClass) {
        return this.metaAnnotation(annotationMirror, annotationClass.getName());
    }

    public List<AnnotationMirror> metaAnnotations(AnnotationMirror annotationMirror, Class<? extends Annotation> annotationClass) {
        return this.metaAnnotations(annotationMirror, annotationClass.getName());
    }

    public String fqn(AnnotationMirror annotationMirror) {
        return this._typesExtensions.qualifiedName(annotationMirror.getAnnotationType());
    }

    public TypeElement annotationAsTypeElement(AnnotationMirror annotationMirror) {
        return this._typesRegistry.asTypeElement(annotationMirror.getAnnotationType());
    }

    public boolean hasFqn(AnnotationMirror annotationMirror, CharSequence annotationFqn) {
        return this.fqn(annotationMirror).equals(annotationFqn.toString());
    }

    public boolean hasFqn(QualifiedNameable element, CharSequence fqn) {
        return element.getQualifiedName().contentEquals(fqn);
    }

    public boolean hasSameName(Element e1, Element e2) {
        return e1.getSimpleName().contentEquals(e2.getSimpleName());
    }

    public void clearCaches() {
        this.annotationValuesCache.clear();
        this.annotationValueMethodsCache.clear();
        this.runtimeMetadataByFqn.clear();
        this.commentsFromRuntimeMetadata.clear();
        this.orderFromRuntimeMetadata.clear();
        this.paramNamesFromRuntimeMetadata.clear();
    }

    public ExecutableElement getAVMethod(AnnotationMirror annotationMirror, String name) {
        ExecutableElement _xblockexpression = null;
        Element _asElement = annotationMirror.getAnnotationType().asElement();
        TypeElement annotationTypeElement = (TypeElement)_asElement;
        String annotationTypeElementFqn = annotationTypeElement.getQualifiedName().toString();
        ExecutableElement _elvis = null;
        Map<String, ExecutableElement> _get = this.annotationValueMethodsCache.get(annotationTypeElementFqn);
        ExecutableElement _get_1 = null;
        if (_get != null) {
            _get_1 = _get.get(name);
        }
        if (_get_1 != null) {
            _elvis = _get_1;
        } else {
            ExecutableElement _xblockexpression_1 = null;
            HashMap map = CollectionLiterals.newHashMap();
            Functions.Function1 _function = it -> {
                ElementKind _kind = it.getKind();
                return Objects.equal((Object)((Object)_kind), (Object)((Object)ElementKind.METHOD));
            };
            Functions.Function1 _function_1 = it -> (ExecutableElement)it;
            Consumer<ExecutableElement> _function_2 = e -> map.put(e.getSimpleName().toString(), e);
            IterableExtensions.map((Iterable)IterableExtensions.filter(annotationTypeElement.getEnclosedElements(), (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
            this.annotationValueMethodsCache.put(annotationTypeElementFqn, map);
            _elvis = _xblockexpression_1 = (ExecutableElement)map.get(name);
        }
        _xblockexpression = _elvis;
        return _xblockexpression;
    }

    private AnnotationValue value(AnnotationMirror annotationMirror, CharSequence name) {
        return this.loadAnnotationValues(annotationMirror).get(name.toString());
    }

    private Map<String, AnnotationValue> _loadAnnotationValues(AnnotationWrapper wrapper) {
        return this.loadAnnotationValues(wrapper.getAnnotation());
    }

    private Map<String, AnnotationValue> _loadAnnotationValues(AnnotationMirror annotationMirror) {
        Map<String, AnnotationValue> _xblockexpression = null;
        Map<String, AnnotationValue> valuesMap = this.annotationValuesCache.get(annotationMirror);
        if (valuesMap == null) {
            valuesMap = this.loadAnnotationValuesCacheMiss(annotationMirror);
        }
        _xblockexpression = valuesMap;
        return _xblockexpression;
    }

    private Map<String, AnnotationValue> loadAnnotationValuesCacheMiss(AnnotationMirror annotationMirror) {
        HashMap _xblockexpression = null;
        HashMap map = CollectionLiterals.newHashMap();
        BiConsumer<ExecutableElement, AnnotationValue> _function = (k, v) -> {
            AnnotationValue _xifexpression = null;
            if (v.getValue() instanceof List && this.annotationMirror((Element)k, SingleValue.class) != null) {
                AnnotationValue _xblockexpression_1 = null;
                Object _value = v.getValue();
                List list = (List)_value;
                _xifexpression = _xblockexpression_1 = (AnnotationValue)IterableExtensions.head((Iterable)list);
            } else {
                _xifexpression = v;
            }
            AnnotationValue v2 = _xifexpression;
            map.put(k.getSimpleName().toString(), v2);
        };
        this.getElementValuesWithDefaults(annotationMirror).forEach(_function);
        this.annotationValuesCache.put(annotationMirror, map);
        _xblockexpression = map;
        return _xblockexpression;
    }

    public Object getValueWithErrorHandling(AnnotationValue av) {
        Object v;
        boolean _equals_1;
        boolean _equals;
        Object _xblockexpression = null;
        Class<?> _class = null;
        if (av != null) {
            _class = av.getClass();
        }
        if (_equals = _class.getCanonicalName().equals("com.sun.tools.javac.code.Attribute.UnresolvedClass")) {
            TypeMirror _xtrycatchfinallyexpression = null;
            try {
                Object _get = av.getClass().getField("classType").get(av);
                _xtrycatchfinallyexpression = (TypeMirror)_get;
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    throw new TypeElementNotFoundException(e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            TypeMirror errorType = _xtrycatchfinallyexpression;
            return errorType;
        }
        Object _value = null;
        if (av != null) {
            _value = av.getValue();
        }
        if (_equals_1 = Objects.equal((Object)(v = _value), (Object)"<error>")) {
            throw new TypeElementNotFoundException("<unknown>", "Error in annotation value: " + av + ". Could not determine the missing type.");
        }
        if (v instanceof DeclaredType && this._typesExtensions.isDeclared((DeclaredType)v) && v.getClass().getCanonicalName().startsWith("org.eclipse.jdt")) {
            try {
                if (this.eclipseGetBindingMethod(v.getClass()) != null && this.eclipseGetBindingMethod(v.getClass()).invoke(v, new Object[0]).getClass().getCanonicalName().contains("Unresolved")) {
                    TypeElement te = this._typesRegistry.asTypeElement((DeclaredType)v);
                    int dollar = 36;
                    String teFqn = te.getQualifiedName().toString().replace('$', '.');
                    TypeElement teResolved = this.getTypeElement(teFqn);
                    return teResolved.asType();
                }
            }
            catch (Throwable _t_1) {
                if (_t_1 instanceof Exception) {
                    Exception exception = (Exception)_t_1;
                }
                throw Exceptions.sneakyThrow((Throwable)_t_1);
            }
        }
        _xblockexpression = v;
        return _xblockexpression;
    }

    public Method eclipseGetBindingMethod(Class<?> clazz) {
        Method _elvis = null;
        Method _get = bindingMethod.get(clazz);
        if (_get != null) {
            _elvis = _get;
        } else {
            Method _xblockexpression = null;
            Method m = this.searchEclipseBindingMethod(clazz);
            bindingMethod.put(clazz, m);
            _elvis = _xblockexpression = m;
        }
        return _elvis;
    }

    protected Method searchEclipseBindingMethod(Class<?> clazz) {
        Method _xtrycatchfinallyexpression = null;
        try {
            Method _xblockexpression = null;
            Method m = clazz.getDeclaredMethod("binding", new Class[0]);
            m.setAccessible(true);
            _xtrycatchfinallyexpression = _xblockexpression = m;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                Class<?> _superclass = clazz.getSuperclass();
                Method _eclipseGetBindingMethod = null;
                if (_superclass != null) {
                    _eclipseGetBindingMethod = this.eclipseGetBindingMethod(_superclass);
                }
                return _eclipseGetBindingMethod;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    public Set<Name> annotationValueNames(AnnotationMirror annotationMirror) {
        Functions.Function1 _function = it -> it.getSimpleName();
        return IterableExtensions.toSet((Iterable)ListExtensions.map(this.declaredMethods(this.annotationAsTypeElement(annotationMirror)), (Functions.Function1)_function));
    }

    public <T> T value(AnnotationMirror annotationMirror, Element annotatedElement, CharSequence name, Class<T> avType, boolean isRequired) {
        Object value;
        boolean _isNullOrEmptyAV;
        T _xblockexpression = null;
        AnnotationValue av = this.value(annotationMirror, name);
        Object _valueWithErrorHandling = null;
        if (av != null) {
            _valueWithErrorHandling = this.getValueWithErrorHandling(av);
        }
        if (_isNullOrEmptyAV = this.isNullOrEmptyAV(value = _valueWithErrorHandling)) {
            if (isRequired) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Required Annotation value ");
                _builder.append((Object)name);
                _builder.append(" is missing.");
                throw new ProcessingException(_builder.toString(), annotatedElement, annotationMirror, name, av);
            }
            return null;
        }
        _xblockexpression = this.mapAs(av, this.getValueWithErrorHandling(av), annotationMirror, annotatedElement, name, null, avType);
        return _xblockexpression;
    }

    public boolean isNullOrEmptyAV(Object value) {
        return value == null || this.isEmptyAV(value);
    }

    protected boolean _isEmptyAV(String s) {
        return s.isEmpty();
    }

    protected boolean _isEmptyAV(Object o) {
        return false;
    }

    public boolean isVoidValue(Object value, Class<?> clazz) {
        boolean _not;
        boolean _xblockexpression = false;
        boolean _isInstance = clazz.isInstance(value);
        boolean bl = _not = !_isInstance;
        if (_not) {
            return false;
        }
        boolean _switchResult = false;
        boolean _matched = false;
        if (Objects.equal(clazz, String.class)) {
            _matched = true;
            _switchResult = StringExtensions.isNullOrEmpty((String)((String)value));
        }
        if (!_matched) {
            _switchResult = false;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private <T> T mapAs(AnnotationValue av, Object value, AnnotationMirror annotationMirror, Element annotatedElement, CharSequence name, Integer index, Class<T> avType) {
        TypeElement _xblockexpression = null;
        if (value == null) {
            return null;
        }
        if (!avType.isArray() && value instanceof Iterable) {
            return this.mapAs(av, this.singleAV((Iterable)value), annotationMirror, annotatedElement, name, 0, avType);
        }
        TypeElement _xifexpression = null;
        boolean _equals = Objects.equal(avType, TypeElement.class);
        if (_equals) {
            TypeElement _xblockexpression_1 = null;
            TypeMirror tm = this.cast(av, value, annotationMirror, annotatedElement, name, TypeMirror.class);
            TypeElement _asTypeElement = null;
            if (tm != null) {
                _asTypeElement = this._typesRegistry.asTypeElement(tm);
            }
            _xifexpression = _xblockexpression_1 = _asTypeElement;
        } else {
            Object _xifexpression_1 = null;
            boolean _equals_1 = Objects.equal(avType, Pattern.class);
            if (_equals_1) {
                Object _xtrycatchfinallyexpression = null;
                try {
                    Object _xblockexpression_2 = null;
                    String patternString = this.cast(av, value, annotationMirror, annotatedElement, name, String.class);
                    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)patternString);
                    if (_isNullOrEmpty) {
                        return null;
                    }
                    Pattern pattern = Pattern.compile(patternString);
                    _xtrycatchfinallyexpression = _xblockexpression_2 = (Object)avType.cast(pattern);
                }
                catch (Throwable _t) {
                    if (_t instanceof PatternSyntaxException) {
                        PatternSyntaxException pse = (PatternSyntaxException)_t;
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Exception when compiling regular expression: ");
                        String _message = pse.getMessage();
                        _builder.append(_message);
                        throw new ProcessingException(_builder.toString(), annotatedElement, annotationMirror, name, av);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                _xifexpression_1 = _xtrycatchfinallyexpression;
            } else {
                Object _xifexpression_2 = null;
                boolean _isEnum = avType.isEnum();
                if (_isEnum) {
                    Object _xblockexpression_3 = null;
                    VariableElement ve = this.cast(av, value, annotationMirror, annotatedElement, name, VariableElement.class);
                    T _valueOf = Enum.valueOf(avType, ve.getSimpleName().toString());
                    _xifexpression_2 = _xblockexpression_3 = (Object)_valueOf;
                } else {
                    Object _xifexpression_3 = null;
                    boolean _isArray = avType.isArray();
                    if (_isArray) {
                        Object _xblockexpression_4 = null;
                        Object arr = Array.newInstance(avType.getComponentType(), ((List)value).size());
                        Procedures.Procedure2 _function = (avInList, i) -> Array.set(arr, i, this.mapAs((AnnotationValue)avInList, this.getValueWithErrorHandling((AnnotationValue)avInList), annotationMirror, annotatedElement, name, (Integer)i, avType.getComponentType()));
                        IterableExtensions.forEach((Iterable)((List)value), (Procedures.Procedure2)_function);
                        _xifexpression_3 = _xblockexpression_4 = arr;
                    } else {
                        Object _xifexpression_4 = null;
                        boolean _equals_2 = Objects.equal(avType, AnnotationMirror.class);
                        if (_equals_2) {
                            AnnotationMirror _createAnnotationAndParent;
                            AnnotationMirror _xblockexpression_5 = null;
                            AnnotationMirror avAsAnnotation = this.cast(av, value, annotationMirror, annotatedElement, name, AnnotationMirror.class);
                            _xblockexpression_5 = _createAnnotationAndParent = this.createAnnotationAndParent(annotationMirror, avAsAnnotation, name, index);
                            _xifexpression_4 = _xblockexpression_5;
                        } else {
                            _xifexpression_4 = this.cast(av, value, annotationMirror, annotatedElement, name, avType);
                        }
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return (T)_xblockexpression;
    }

    private AnnotationMirror _createAnnotationAndParent(AnnotationAndParent annotationMirror, AnnotationMirror avAsAnnotation, CharSequence name, Integer index) {
        String _string = name.toString();
        Path.Segment _segment = new Path.Segment(_string, index);
        return new AnnotationAndParent(avAsAnnotation, _segment, annotationMirror, null);
    }

    private AnnotationMirror _createAnnotationAndParent(AnnotationWithDefaultAnnotation annotationMirror, AnnotationMirror avAsAnnotation, CharSequence name, Integer index) {
        return this.createAnnotationAndParent(annotationMirror.getAnnotation(), avAsAnnotation, name, index);
    }

    private AnnotationMirror _createAnnotationAndParent(AnnotationMirror annotationMirror, AnnotationMirror avAsAnnotation, CharSequence name, Integer index) {
        return avAsAnnotation;
    }

    private Object singleAV(Iterable<AnnotationValue> values) {
        AnnotationValue _singleValue = MoreCollectionExtensions.singleValue(values);
        Object _valueWithErrorHandling = null;
        if (_singleValue != null) {
            _valueWithErrorHandling = this.getValueWithErrorHandling(_singleValue);
        }
        return _valueWithErrorHandling;
    }

    private <T> T cast(AnnotationValue av, Object value, AnnotationMirror annotationMirror, Element annotatedElement, CharSequence name, Class<T> avType) {
        T _xblockexpression = null;
        Class<Object> targetType = avType;
        boolean _isPrimitive = avType.isPrimitive();
        if (_isPrimitive) {
            targetType = this._typesExtensions.boxedType(avType);
        }
        T _xtrycatchfinallyexpression = null;
        try {
            T _cast = targetType.cast(value);
            _xtrycatchfinallyexpression = _cast;
        }
        catch (Throwable _t) {
            if (_t instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)_t;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Exception when casting annotation value '");
                _builder.append((Object)name);
                _builder.append("' (value : '");
                _builder.append(value);
                _builder.append("'): ");
                String _message = re.getMessage();
                _builder.append(_message);
                throw new ProcessingException(_builder.toString(), annotatedElement, annotationMirror, name, av);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    public CharSequence getPrefixedAvName(AnnotationMirror metaAnnotation, CharSequence name) {
        CharSequence prefixedAvName;
        CharSequence _xblockexpression = null;
        if (metaAnnotation == null) {
            return name;
        }
        String prefix = this.value(metaAnnotation, "_prefix", String.class);
        CharSequence _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)prefix);
        if (_isNullOrEmpty) {
            _xifexpression = name;
        } else {
            String _firstUpper = StringExtensions.toFirstUpper((String)name.toString());
            _xifexpression = prefix + _firstUpper;
        }
        _xblockexpression = prefixedAvName = _xifexpression;
        return _xblockexpression;
    }

    public <T> T value(AnnotationMirror annotationMirror, Element annotatedElement, CharSequence name, Class<T> avType) {
        return this.value(annotationMirror, annotatedElement, name, avType, false);
    }

    public <T> T value(AnnotationMirror annotationMirror, CharSequence name, Class<T> avType) {
        return this.value(annotationMirror, null, name, avType, false);
    }

    public <T> T requiredValue(AnnotationMirror annotationMirror, Element annotatedElement, CharSequence name, Class<T> avType) {
        return this.value(annotationMirror, annotatedElement, name, avType, true);
    }

    public Functions.Function1<String, Functions.Function1<CharSequence, Object>> annotationsByName(Element e, String packageForShortNames) {
        Functions.Function1 _function = fqnOrShortname -> {
            Functions.Function1<CharSequence, Object> _xblockexpression = null;
            AnnotationMirror _xifexpression = null;
            if (fqnOrShortname.contains(".") || StringExtensions.isNullOrEmpty((String)packageForShortNames)) {
                _xifexpression = this.annotationMirror(e, (CharSequence)fqnOrShortname);
            } else {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(packageForShortNames);
                _builder.append(".");
                _builder.append(fqnOrShortname);
                _xifexpression = this.annotationMirror(e, (CharSequence)_builder);
            }
            AnnotationMirror am = _xifexpression;
            Functions.Function1<CharSequence, Object> _annotationValuesByNameUnwrapped = null;
            if (am != null) {
                _annotationValuesByNameUnwrapped = this.annotationValuesByNameUnwrapped(am);
            }
            _xblockexpression = _annotationValuesByNameUnwrapped;
            return _xblockexpression;
        };
        return _function;
    }

    public Map<String, Object> annotationValuesByNameUnwrappedAsMap(AnnotationMirror am) {
        Functions.Function1 _function = it -> this.unwrapAnnotationValue(it);
        return MapExtensions.mapValues(this.loadAnnotationValues(am), (Functions.Function1)_function);
    }

    public Functions.Function1<CharSequence, Object> annotationValuesByNameUnwrapped(AnnotationMirror am) {
        Functions.Function1 _function = avName -> {
            AnnotationValue _get = this.loadAnnotationValues(am).get(avName.toString());
            Object _unwrapAnnotationValue = null;
            if (_get != null) {
                _unwrapAnnotationValue = this.unwrapAnnotationValue(_get);
            }
            return _unwrapAnnotationValue;
        };
        return _function;
    }

    private Object _unwrapAnnotationValue(AnnotationValue av) {
        Object _valueWithErrorHandling = null;
        if (av != null) {
            _valueWithErrorHandling = this.getValueWithErrorHandling(av);
        }
        return this.unwrapAnnotationValue(_valueWithErrorHandling);
    }

    private Object _unwrapAnnotationValue(List<? extends AnnotationValue> values) {
        Functions.Function1 _function = it -> this.getValueWithErrorHandling((AnnotationValue)it);
        return ListExtensions.map(values, (Functions.Function1)_function);
    }

    private Object _unwrapAnnotationValue(Object value) {
        return value;
    }

    private Object _unwrapAnnotationValue(Void value) {
        return null;
    }

    protected Class<?> _toAnnotationValueClass(PrimitiveType type) {
        Class _switchResult = null;
        TypeKind _kind = type.getKind();
        if (_kind != null) {
            switch (_kind) {
                case BOOLEAN: {
                    _switchResult = Boolean.class;
                    break;
                }
                case BYTE: {
                    _switchResult = Byte.class;
                    break;
                }
                case CHAR: {
                    _switchResult = Character.class;
                    break;
                }
                case DOUBLE: {
                    _switchResult = Double.class;
                    break;
                }
                case FLOAT: {
                    _switchResult = Float.class;
                    break;
                }
                case INT: {
                    _switchResult = Integer.class;
                    break;
                }
                case LONG: {
                    _switchResult = Long.class;
                    break;
                }
                case SHORT: {
                    _switchResult = Short.class;
                    break;
                }
                default: {
                    TypeKind _kind_1 = type.getKind();
                    String _plus = "Unsupported primitive type kind " + (Object)((Object)_kind_1);
                    throw new IllegalArgumentException(_plus);
                }
            }
        } else {
            TypeKind _kind_1 = type.getKind();
            String _plus = "Unsupported primitive type kind " + (Object)((Object)_kind_1);
            throw new IllegalArgumentException(_plus);
        }
        return _switchResult;
    }

    protected Class<?> _toAnnotationValueClass(ArrayType type) {
        return List.class;
    }

    protected Class<?> _toAnnotationValueClass(DeclaredType type) {
        ElementKind _kind_1;
        boolean _equals_1;
        ElementKind _kind;
        boolean _equals;
        boolean _hasFqn_1;
        Class<String> _xblockexpression = null;
        TypeElement e = this._typesRegistry.asTypeElement(type);
        Class _switchResult = null;
        boolean _matched = false;
        boolean _hasFqn = this.hasFqn(e, (CharSequence)"java.lang.String");
        if (_hasFqn) {
            _matched = true;
            _switchResult = String.class;
        }
        if (!_matched && (_hasFqn_1 = this.hasFqn(e, (CharSequence)"java.lang.Class"))) {
            _matched = true;
            _switchResult = TypeMirror.class;
        }
        if (!_matched && (_equals = Objects.equal((Object)((Object)(_kind = e.getKind())), (Object)((Object)ElementKind.ANNOTATION_TYPE)))) {
            _matched = true;
            _switchResult = AnnotationMirror.class;
        }
        if (!_matched && (_equals_1 = Objects.equal((Object)((Object)(_kind_1 = e.getKind())), (Object)((Object)ElementKind.ENUM)))) {
            _matched = true;
            _switchResult = VariableElement.class;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected Object _toAnnotationValue(PrimitiveType type, String s) {
        Comparable<Boolean> _switchResult;
        block11: {
            block10: {
                _switchResult = null;
                TypeKind _kind = type.getKind();
                if (_kind == null) break block10;
                switch (_kind) {
                    case BOOLEAN: {
                        _switchResult = Boolean.valueOf(s);
                        break block11;
                    }
                    case BYTE: {
                        _switchResult = Byte.valueOf(s);
                        break block11;
                    }
                    case CHAR: {
                        _switchResult = Character.valueOf(s.charAt(0));
                        break block11;
                    }
                    case DOUBLE: {
                        _switchResult = Double.valueOf(s);
                        break block11;
                    }
                    case FLOAT: {
                        _switchResult = Float.valueOf(s);
                        break block11;
                    }
                    case INT: {
                        _switchResult = Integer.valueOf(s);
                        break block11;
                    }
                    case LONG: {
                        _switchResult = Long.valueOf(s);
                        break block11;
                    }
                    case SHORT: {
                        _switchResult = Short.valueOf(s);
                        break block11;
                    }
                    default: {
                        throw ElementsExtensions.unsupportedAVType(type, s);
                    }
                }
            }
            throw ElementsExtensions.unsupportedAVType(type, s);
        }
        return _switchResult;
    }

    public Object coerceAnnotationValue(Object value, TypeMirror avType) {
        boolean _tripleEquals;
        Object _xifexpression = null;
        TypeKind _kind = avType.getKind();
        boolean bl = _tripleEquals = _kind == TypeKind.ARRAY;
        if (_tripleEquals) {
            List _xblockexpression = null;
            TypeMirror compType = ((ArrayType)avType).getComponentType();
            List _xifexpression_1 = null;
            if (value instanceof Iterable) {
                Functions.Function1 _function = it -> {
                    Object _coerceSingleValue = this.coerceSingleValue(it, compType);
                    return new GenAnnotationValue(_coerceSingleValue);
                };
                _xifexpression_1 = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)((Iterable)value), (Functions.Function1)_function));
            } else {
                List _xifexpression_2 = null;
                if (value == null) {
                    _xifexpression_2 = CollectionLiterals.emptyList();
                } else {
                    Object _coerceSingleValue = this.coerceSingleValue(value, compType);
                    GenAnnotationValue _genAnnotationValue = new GenAnnotationValue(_coerceSingleValue);
                    _xifexpression_2 = CollectionLiterals.newArrayList((Object[])new GenAnnotationValue[]{_genAnnotationValue});
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xblockexpression = _xifexpression_1;
            _xifexpression = _xblockexpression;
        } else {
            _xifexpression = this.coerceSingleValue(value, avType);
        }
        return _xifexpression;
    }

    protected Object _coerceSingleValue(Iterable<?> value, TypeMirror avType) {
        boolean _greaterThan;
        Object _xblockexpression = null;
        int _size = IterableExtensions.size(value);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("'");
            _builder.append(value);
            _builder.append("' is not a valid value or element value for type ");
            _builder.append((Object)avType);
            _builder.append(", since it contains multiple elements");
            throw new RuleException(_builder.toString());
        }
        _xblockexpression = this.coerceSingleValue(IterableExtensions.head(value), avType);
        return _xblockexpression;
    }

    protected Object _coerceSingleValue(Object value, TypeMirror avType) {
        boolean _not;
        Object _xblockexpression = null;
        Object v = this.toAnnotationValue(avType, value);
        boolean _isInstance = this.toAnnotationValueClass(avType).isInstance(v);
        boolean bl = _not = !_isInstance;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("'");
            _builder.append(v);
            _builder.append("' of type ");
            Class<?> _class = null;
            if (v != null) {
                _class = v.getClass();
            }
            _builder.append(_class);
            _builder.append(" is not a valid value or element value for type ");
            _builder.append((Object)avType);
            throw new RuleException(_builder.toString());
        }
        _xblockexpression = v;
        return _xblockexpression;
    }

    protected Object _coerceSingleValue(Void value, TypeMirror avType) {
        return null;
    }

    protected Object _toAnnotationValue(DeclaredType avType, Object o) {
        ElementKind _kind_1;
        boolean _equals_1;
        ElementKind _kind;
        boolean _equals;
        boolean _hasFqn_2;
        String _xblockexpression = null;
        TypeElement e = this._typesRegistry.asTypeElement(avType);
        boolean _hasFqn = this.hasFqn(e, (CharSequence)"java.lang.String");
        if (_hasFqn) {
            return o.toString();
        }
        if (!(o instanceof CharSequence)) {
            return o;
        }
        String s = o.toString();
        Object _switchResult = null;
        boolean _matched = false;
        boolean _hasFqn_1 = this.hasFqn(e, (CharSequence)"java.lang.String");
        if (_hasFqn_1) {
            _matched = true;
            String _string = null;
            if (s != null) {
                _string = s.toString();
            }
            _switchResult = _string;
        }
        if (!_matched && (_hasFqn_2 = this.hasFqn(e, (CharSequence)"java.lang.Class"))) {
            TypeMirror typeMirror;
            _matched = true;
            TypeMirror _xblockexpression_1 = null;
            TypeElement _typeElement = this.getTypeElement(s);
            TypeMirror _asType = null;
            if (_typeElement != null) {
                _asType = _typeElement.asType();
            }
            if ((typeMirror = _asType) == null) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Class ");
                _builder.append(s);
                _builder.append(" could not be found.");
                throw new IllegalArgumentException(_builder.toString());
            }
            _xblockexpression_1 = typeMirror;
            _switchResult = _xblockexpression_1;
        }
        if (!_matched && (_equals = Objects.equal((Object)((Object)(_kind = e.getKind())), (Object)((Object)ElementKind.ANNOTATION_TYPE)))) {
            _matched = true;
            throw ElementsExtensions.unsupportedAVType(avType, s);
        }
        if (!_matched && (_equals_1 = Objects.equal((Object)((Object)(_kind_1 = e.getKind())), (Object)((Object)ElementKind.ENUM)))) {
            _matched = true;
            VariableElement _xblockexpression_2 = null;
            Functions.Function1 _function = it -> it.getSimpleName().contentEquals(s);
            VariableElement enumConst = (VariableElement)IterableExtensions.findFirst(this.declaredFields(this._typesRegistry.asTypeElement(avType)), (Functions.Function1)_function);
            if (enumConst == null) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(s);
                _builder.append(" is not a valid enum constant for enum type ");
                _builder.append((Object)avType);
                throw new RuleException(_builder.toString());
            }
            _xblockexpression_2 = enumConst;
            _switchResult = _xblockexpression_2;
        }
        if (!_matched) {
            throw ElementsExtensions.unsupportedAVType(avType, s);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected Object _toAnnotationValue(PrimitiveType type, Object o) {
        return o;
    }

    protected Object _toAnnotationValue(TypeMirror type, Object o) {
        throw ElementsExtensions.unsupportedAVType(type, o);
    }

    public static RuleException unsupportedAVType(TypeMirror type, Object o) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("An annotation value of type ");
        _builder.append((Object)type);
        _builder.append(" cannot be created from value \"");
        _builder.append(o);
        _builder.append("\" of type ");
        Class<?> _class = null;
        if (o != null) {
            _class = o.getClass();
        }
        _builder.append(_class);
        return new RuleException(_builder.toString());
    }

    public boolean isAbstract(Element e) {
        return e.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isAbstractOrInInterface(Element e) {
        return e.getModifiers().contains((Object)Modifier.ABSTRACT) || Objects.equal((Object)((Object)e.getEnclosingElement().getKind()), (Object)((Object)ElementKind.INTERFACE));
    }

    public boolean isStatic(Element e) {
        return e.getModifiers().contains((Object)Modifier.STATIC);
    }

    public boolean isPublic(Element e) {
        return e.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public boolean isProtected(Element e) {
        return e.getModifiers().contains((Object)Modifier.PROTECTED);
    }

    public boolean isPrivate(Element e) {
        return e.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    public Modifier getVisibility(Element e) {
        Functions.Function1 _function = it -> VISIBILITY_MODIFIERS.contains(it);
        return (Modifier)((Object)IterableExtensions.head((Iterable)IterableExtensions.filter(e.getModifiers(), (Functions.Function1)_function)));
    }

    public boolean isDefaultAccess(Element e) {
        return !this.isPrivate(e) && !this.isProtected(e) && !this.isPrivate(e);
    }

    protected PackageElement _getPackage(Element e) {
        return this.getPackage(e.getEnclosingElement());
    }

    protected PackageElement _getPackage(PackageElement e) {
        return e;
    }

    protected PackageElement _getPackage(Void e) {
        return null;
    }

    public boolean samePackage(Element e1, Element e2) {
        PackageElement _package = this.getPackage(e1);
        Name _qualifiedName = null;
        if (_package != null) {
            _qualifiedName = _package.getQualifiedName();
        }
        String _string = null;
        if (_qualifiedName != null) {
            _string = _qualifiedName.toString();
        }
        PackageElement _package_1 = this.getPackage(e2);
        Name _qualifiedName_1 = null;
        if (_package_1 != null) {
            _qualifiedName_1 = _package_1.getQualifiedName();
        }
        String _string_1 = null;
        if (_qualifiedName_1 != null) {
            _string_1 = _qualifiedName_1.toString();
        }
        return Objects.equal((Object)_string, (Object)_string_1);
    }

    private String _docComment(GenElement e, boolean useRuntimeMetadata) {
        CharSequence _comment = e.getComment();
        String _string = null;
        if (_comment != null) {
            _string = _comment.toString();
        }
        String _trim = null;
        if (_string != null) {
            _trim = _string.trim();
        }
        return _trim;
    }

    private String _docComment(Property p, boolean useRuntimeMetadata) {
        Element _fieldOrGetter = p.fieldOrGetter();
        String _docComment = null;
        if (_fieldOrGetter != null) {
            _docComment = this.docComment(_fieldOrGetter, useRuntimeMetadata);
        }
        return _docComment;
    }

    private String _docComment(Element e, boolean useRuntimeMetadata) {
        String _xblockexpression = null;
        String _docComment = this.elementUtils.getDocComment(e);
        String _trim = null;
        if (_docComment != null) {
            _trim = _docComment.trim();
        }
        String result = _trim;
        String _xifexpression = null;
        _xifexpression = StringExtensions.isNullOrEmpty((String)result) && useRuntimeMetadata ? this.getCommentFromRuntimeMetadata(e) : result;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getDocComment(Element e) {
        return this.docComment(e, false);
    }

    public String getDocCommentUsingRuntimeMetadata(Element e) {
        return this.docComment(e, true);
    }

    public String getCommentFromRuntimeMetadata(Element element) {
        String _xblockexpression = null;
        this.loadRuntimeMetadata(element);
        _xblockexpression = this.commentsFromRuntimeMetadata.get(this.uniqueNameWithinTopLevelEnclosingTypeElement(element));
        return _xblockexpression;
    }

    public List<String> getParamNamesFromRuntimeMetadata(Element element) {
        List<String> _xblockexpression = null;
        this.loadRuntimeMetadata(element);
        _xblockexpression = this.paramNamesFromRuntimeMetadata.get(this.uniqueNameWithinTopLevelEnclosingTypeElement(element));
        return _xblockexpression;
    }

    public Functions.Function1<? super Element, ? extends Integer> getOrderFromRuntimeMetadata(Element someParent) {
        Functions.Function1 _function;
        boolean _not;
        Functions.Function1 _xblockexpression = null;
        boolean _loadRuntimeMetadata = this.loadRuntimeMetadata(someParent);
        boolean bl = _not = !_loadRuntimeMetadata;
        if (_not) {
            return null;
        }
        _xblockexpression = _function = element -> {
            Integer _elvis = null;
            Integer _get = this.orderFromRuntimeMetadata.get(this.uniqueNameWithinTopLevelEnclosingTypeElement((Element)element));
            _elvis = _get != null ? _get : Integer.valueOf(0);
            return _elvis;
        };
        return _xblockexpression;
    }

    public boolean loadRuntimeMetadata(Element element) {
        boolean _tripleEquals;
        TypeElement topLevelEnclosingTypeElement = this.getTopLevelEnclosingTypeElement(element);
        String typeElementFqn = topLevelEnclosingTypeElement.getQualifiedName().toString();
        AnnotationMirror _annotationMirror = this.annotationMirror((Element)topLevelEnclosingTypeElement, RuntimeMetadata.class);
        boolean bl = _tripleEquals = _annotationMirror == null;
        if (_tripleEquals) {
            return false;
        }
        String runtimemetadataFqn = typeElementFqn + "_RuntimeMetadata";
        TypeElement runtimeMetadataTypeElement = this._typesRegistry.findTypeElement(runtimemetadataFqn);
        if (runtimeMetadataTypeElement != null) {
            boolean _notEquals;
            TypeElement _get = this.runtimeMetadataByFqn.get(runtimemetadataFqn);
            boolean bl2 = _notEquals = !Objects.equal((Object)runtimeMetadataTypeElement, (Object)_get);
            if (_notEquals) {
                this.loadCommentsAndParamNames(runtimeMetadataTypeElement);
                this.runtimeMetadataByFqn.put(runtimemetadataFqn, runtimeMetadataTypeElement);
            }
            this._typesRegistry.registerTypeDependencyForCurrentAnnotatedClass(runtimeMetadataTypeElement.asType());
            return true;
        }
        return false;
    }

    public void loadCommentsAndParamNames(TypeElement runtimeMetadataTypeElement) {
        AnnotationMirror _annotationMirror = this.annotationMirror((Element)runtimeMetadataTypeElement, RuntimeMetadata.List.class);
        AnnotationMirror[] _value = null;
        if (_annotationMirror != null) {
            _value = this.value(_annotationMirror, "value", AnnotationMirror[].class);
        }
        if ((Iterable)Conversions.doWrapArray(_value) != null) {
            Procedures.Procedure2 _function = (am, index) -> {
                String uniqueName = this.value((AnnotationMirror)am, "id", (Class)String.class);
                String comment = this.value((AnnotationMirror)am, "comment", (Class)String.class);
                String[] paramNames = this.value((AnnotationMirror)am, "paramNames", (Class)String[].class);
                this.commentsFromRuntimeMetadata.put(uniqueName, comment);
                this.paramNamesFromRuntimeMetadata.put(uniqueName, (List)Conversions.doWrapArray((Object)paramNames));
                this.orderFromRuntimeMetadata.put(uniqueName, (Integer)index);
            };
            IterableExtensions.forEach((Iterable)((Iterable)Conversions.doWrapArray((Object)_value)), (Procedures.Procedure2)_function);
        }
    }

    protected TypeElement _getTopLevelEnclosingTypeElement(TypeElement e) {
        boolean _equals;
        TypeElement _xifexpression = null;
        Element _enclosingElement = e.getEnclosingElement();
        ElementKind _kind = null;
        if (_enclosingElement != null) {
            _kind = _enclosingElement.getKind();
        }
        if (_equals = Objects.equal((Object)((Object)_kind), (Object)((Object)ElementKind.PACKAGE))) {
            _xifexpression = e;
        } else {
            Element _enclosingElement_1 = e.getEnclosingElement();
            TypeElement _topLevelEnclosingTypeElement = null;
            if (_enclosingElement_1 != null) {
                _topLevelEnclosingTypeElement = this.getTopLevelEnclosingTypeElement(_enclosingElement_1);
            }
            _xifexpression = _topLevelEnclosingTypeElement;
        }
        return _xifexpression;
    }

    protected TypeElement _getTopLevelEnclosingTypeElement(Element e) {
        Element _enclosingElement = e.getEnclosingElement();
        TypeElement _topLevelEnclosingTypeElement = null;
        if (_enclosingElement != null) {
            _topLevelEnclosingTypeElement = this.getTopLevelEnclosingTypeElement(_enclosingElement);
        }
        return _topLevelEnclosingTypeElement;
    }

    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element e) {
        return this.elementUtils.getAllAnnotationMirrors(e);
    }

    public List<? extends Element> getAllMembers(TypeElement type) {
        return this.elementUtils.getAllMembers(type);
    }

    public Name getBinaryName(TypeElement type) {
        return this.elementUtils.getBinaryName(type);
    }

    public String getConstantExpression(Object value) {
        return this.elementUtils.getConstantExpression(value);
    }

    protected Map<? extends ExecutableElement, ? extends AnnotationValue> _getElementValuesWithDefaults(AnnotationWithDefaultAnnotation a) {
        HashMap<? extends ExecutableElement, ? extends AnnotationValue> _xblockexpression = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> _elementValuesWithDefaults = this.getElementValuesWithDefaults(a.getAnnotation());
        HashMap<? extends ExecutableElement, ? extends AnnotationValue> result = new HashMap<ExecutableElement, AnnotationValue>(_elementValuesWithDefaults);
        result.putAll(a.getElementValues());
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected Map<? extends ExecutableElement, ? extends AnnotationValue> _getElementValuesWithDefaults(GenAnnotationMirror am) {
        Map _xblockexpression = null;
        Functions.Function1 _function = it -> {
            AnnotationValue _defaultValue = it.getDefaultValue();
            return _defaultValue != null;
        };
        Functions.Function1 _function_1 = it -> it.getDefaultValue();
        Map result = IterableExtensions.toInvertedMap((Iterable)IterableExtensions.filter(this.declaredMethods(this._typesRegistry.asTypeElement(am.getAnnotationType())), (Functions.Function1)_function), (Functions.Function1)_function_1);
        result.putAll(am.getElementValues());
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected Map<? extends ExecutableElement, ? extends AnnotationValue> _getElementValuesWithDefaults(AnnotationWrapper annotationWrapper) {
        return this.getElementValuesWithDefaults(annotationWrapper.getAnnotation());
    }

    protected Map<? extends ExecutableElement, ? extends AnnotationValue> _getElementValuesWithDefaults(AnnotationMirror a) {
        return this.elementUtils.getElementValuesWithDefaults(a);
    }

    public Name getName(CharSequence cs) {
        return this.elementUtils.getName(cs);
    }

    public PackageElement getPackageElement(CharSequence name) {
        return this.elementUtils.getPackageElement(name);
    }

    public PackageElement getPackageOf(Element type) {
        return this.elementUtils.getPackageOf(type);
    }

    public TypeElement getTypeElement(CharSequence name) {
        String _string = null;
        if (name != null) {
            _string = name.toString();
        }
        return this.typeElementCache.getTypeElement(_string);
    }

    public boolean hides(Element hider, Element hidden) {
        return this.elementUtils.hides(hider, hidden);
    }

    public boolean isDeprecated(Element e) {
        return this.elementUtils.isDeprecated(e);
    }

    public boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement type) {
        if (type != null) {
            throw new UnsupportedOperationException("Method overrides with type parameter currently not supported");
        }
        return this.overrides(overrider, overridden);
    }

    public void printElements(Writer w, Element ... elements) {
        this.elementUtils.printElements(w, elements);
    }

    protected CharSequence _uniqueSimpleName(ExecutableElement e) {
        StringConcatenation _builder = new StringConcatenation();
        Name _simpleName = e.getSimpleName();
        _builder.append((Object)_simpleName);
        _builder.append("(");
        List<? extends VariableElement> _parameters = e.getParameters();
        boolean _hasElements = false;
        for (VariableElement variableElement : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            String _qualifiedName = this._typesExtensions.qualifiedName(variableElement.asType());
            _builder.append(_qualifiedName);
        }
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _uniqueSimpleName(Element e) {
        return e.getSimpleName();
    }

    protected String _uniqueName(QualifiedNameable e) {
        return e.getQualifiedName().toString();
    }

    protected String _uniqueName(Element e) {
        StringConcatenation _builder = new StringConcatenation();
        String _uniqueName = this.uniqueName(e.getEnclosingElement());
        _builder.append(_uniqueName);
        _builder.append(".");
        CharSequence _uniqueSimpleName = this.uniqueSimpleName(e);
        _builder.append((Object)_uniqueSimpleName);
        return _builder.toString();
    }

    public String uniqueNameWithin(Element e, TypeElement enclosing) {
        String _xifexpression = null;
        boolean _equals = Objects.equal((Object)e, (Object)enclosing);
        if (_equals) {
            _xifexpression = "";
        } else {
            String _xifexpression_1 = null;
            Element _enclosingElement = e.getEnclosingElement();
            boolean _equals_1 = Objects.equal((Object)_enclosingElement, (Object)enclosing);
            if (_equals_1) {
                _xifexpression_1 = this.uniqueSimpleName(e).toString();
            } else {
                boolean _tripleEquals;
                String _xblockexpression = null;
                Element _enclosingElement_1 = null;
                if (e != null) {
                    _enclosingElement_1 = e.getEnclosingElement();
                }
                boolean bl = _tripleEquals = _enclosingElement_1 == null;
                if (_tripleEquals) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)e);
                    _builder.append(" is not enclosed by element ");
                    _builder.append((Object)enclosing);
                    throw new IllegalArgumentException(_builder.toString());
                }
                StringConcatenation _builder_1 = new StringConcatenation();
                String _uniqueNameWithin = this.uniqueNameWithin(e.getEnclosingElement(), enclosing);
                _builder_1.append(_uniqueNameWithin);
                _builder_1.append(".");
                String _string = this.uniqueSimpleName(e).toString();
                _builder_1.append(_string);
                _xifexpression_1 = _xblockexpression = _builder_1.toString();
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public String uniqueNameWithinTopLevelEnclosingTypeElement(Element element) {
        return this.uniqueNameWithin(element, this.getTopLevelEnclosingTypeElement(element));
    }

    public Iterable<? extends Element> elementAndAllEnclosedElements(Element e) {
        return this.elementAndAllEnclosedElements(e, false);
    }

    public Iterable<? extends Element> elementAndAllEnclosedElements(Element e, boolean withMethodParams) {
        ArrayList _xblockexpression = null;
        ArrayList list = CollectionLiterals.newArrayList();
        list.add(e);
        if (withMethodParams && e instanceof ExecutableElement) {
            list.addAll(this.parametersWithSrcNames((ExecutableElement)e));
        }
        Functions.Function1 _function = it -> this.elementAndAllEnclosedElements((Element)it, withMethodParams);
        Iterables.addAll((Collection)list, (Iterable)Iterables.concat((Iterable)ListExtensions.map(e.getEnclosedElements(), (Functions.Function1)_function)));
        _xblockexpression = list;
        return _xblockexpression;
    }

    protected boolean _isEmptyVar(String string) {
        return string.isEmpty();
    }

    protected boolean _isEmptyVar(CharSequence cs) {
        int _length = cs.length();
        return _length == 0;
    }

    protected boolean _isEmptyVar(Collection<?> c) {
        return c.isEmpty();
    }

    protected boolean _isEmptyVar(Map<?, ?> m) {
        return m.isEmpty();
    }

    protected boolean _isEmptyVar(Iterable<?> i) {
        return IterableExtensions.isEmpty(i);
    }

    protected boolean _isEmptyVar(Object object) {
        int _length;
        boolean _xifexpression = false;
        boolean _isArray = object.getClass().isArray();
        _xifexpression = _isArray ? (_length = Array.getLength(object)) == 0 : false;
        return _xifexpression;
    }

    public TypeMirror srcType(Object e) {
        if (e instanceof ExecutableElement) {
            return this._srcType((ExecutableElement)e);
        }
        if (e instanceof VariableElement) {
            return this._srcType((VariableElement)e);
        }
        if (e instanceof Element) {
            return this._srcType((Element)e);
        }
        if (e instanceof TypeMirror) {
            return this._srcType((TypeMirror)e);
        }
        if (e != null) {
            return this._srcType(e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }

    private Map<String, AnnotationValue> loadAnnotationValues(AnnotationMirror wrapper) {
        if (wrapper instanceof AnnotationWrapper) {
            return this._loadAnnotationValues((AnnotationWrapper)wrapper);
        }
        if (wrapper != null) {
            return this._loadAnnotationValues(wrapper);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(wrapper).toString());
    }

    public boolean isEmptyAV(Object s) {
        if (s instanceof String) {
            return this._isEmptyAV((String)s);
        }
        if (s != null) {
            return this._isEmptyAV(s);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(s).toString());
    }

    private AnnotationMirror createAnnotationAndParent(AnnotationMirror annotationMirror, AnnotationMirror avAsAnnotation, CharSequence name, Integer index) {
        if (annotationMirror instanceof AnnotationAndParent) {
            return this._createAnnotationAndParent((AnnotationAndParent)annotationMirror, avAsAnnotation, name, index);
        }
        if (annotationMirror instanceof AnnotationWithDefaultAnnotation) {
            return this._createAnnotationAndParent((AnnotationWithDefaultAnnotation)annotationMirror, avAsAnnotation, name, index);
        }
        if (annotationMirror != null) {
            return this._createAnnotationAndParent(annotationMirror, avAsAnnotation, name, index);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(annotationMirror, avAsAnnotation, name, index).toString());
    }

    private Object unwrapAnnotationValue(Object values) {
        if (values instanceof List) {
            return this._unwrapAnnotationValue((List)values);
        }
        if (values == null) {
            return this._unwrapAnnotationValue((Void)null);
        }
        if (values instanceof AnnotationValue) {
            return this._unwrapAnnotationValue((AnnotationValue)values);
        }
        if (values != null) {
            return this._unwrapAnnotationValue(values);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(values).toString());
    }

    public Class<?> toAnnotationValueClass(TypeMirror type) {
        if (type instanceof ArrayType) {
            return this._toAnnotationValueClass((ArrayType)type);
        }
        if (type instanceof DeclaredType) {
            return this._toAnnotationValueClass((DeclaredType)type);
        }
        if (type instanceof PrimitiveType) {
            return this._toAnnotationValueClass((PrimitiveType)type);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type).toString());
    }

    public Object toAnnotationValue(TypeMirror avType, Object o) {
        if (avType instanceof DeclaredType && o != null) {
            return this._toAnnotationValue((DeclaredType)avType, o);
        }
        if (avType instanceof PrimitiveType && o instanceof String) {
            return this._toAnnotationValue((PrimitiveType)avType, (String)o);
        }
        if (avType instanceof PrimitiveType && o != null) {
            return this._toAnnotationValue((PrimitiveType)avType, o);
        }
        if (avType != null && o != null) {
            return this._toAnnotationValue(avType, o);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(avType, o).toString());
    }

    public Object coerceSingleValue(Object value, TypeMirror avType) {
        if (value instanceof Iterable) {
            return this._coerceSingleValue((Iterable)value, avType);
        }
        if (value == null) {
            return this._coerceSingleValue((Void)null, avType);
        }
        if (value != null) {
            return this._coerceSingleValue(value, avType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(value, avType).toString());
    }

    public PackageElement getPackage(Element e) {
        if (e instanceof PackageElement) {
            return this._getPackage((PackageElement)e);
        }
        if (e != null) {
            return this._getPackage(e);
        }
        if (e == null) {
            return this._getPackage((Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }

    private String docComment(Element p, boolean useRuntimeMetadata) {
        if (p instanceof Property) {
            return this._docComment((Property)p, useRuntimeMetadata);
        }
        if (p instanceof GenElement) {
            return this._docComment((GenElement)p, useRuntimeMetadata);
        }
        if (p != null) {
            return this._docComment(p, useRuntimeMetadata);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(p, useRuntimeMetadata).toString());
    }

    public TypeElement getTopLevelEnclosingTypeElement(Element e) {
        if (e instanceof TypeElement) {
            return this._getTopLevelEnclosingTypeElement((TypeElement)e);
        }
        if (e != null) {
            return this._getTopLevelEnclosingTypeElement(e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }

    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror a) {
        if (a instanceof AnnotationWithDefaultAnnotation) {
            return this._getElementValuesWithDefaults((AnnotationWithDefaultAnnotation)a);
        }
        if (a instanceof AnnotationWrapper) {
            return this._getElementValuesWithDefaults((AnnotationWrapper)a);
        }
        if (a instanceof GenAnnotationMirror) {
            return this._getElementValuesWithDefaults((GenAnnotationMirror)a);
        }
        if (a != null) {
            return this._getElementValuesWithDefaults(a);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(a).toString());
    }

    public CharSequence uniqueSimpleName(Element e) {
        if (e instanceof ExecutableElement) {
            return this._uniqueSimpleName((ExecutableElement)e);
        }
        if (e != null) {
            return this._uniqueSimpleName(e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }

    public String uniqueName(Element e) {
        if (e instanceof QualifiedNameable) {
            return this._uniqueName((QualifiedNameable)e);
        }
        if (e != null) {
            return this._uniqueName(e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }

    public boolean isEmptyVar(Object string) {
        if (string instanceof String) {
            return this._isEmptyVar((String)string);
        }
        if (string instanceof Collection) {
            return this._isEmptyVar((Collection)string);
        }
        if (string instanceof CharSequence) {
            return this._isEmptyVar((CharSequence)string);
        }
        if (string instanceof Iterable) {
            return this._isEmptyVar((Iterable)string);
        }
        if (string instanceof Map) {
            return this._isEmptyVar((Map)string);
        }
        if (string != null) {
            return this._isEmptyVar(string);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(string).toString());
    }
}

