/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.services;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.xtext.xbase.lib.Functions;

public final class ExtensionRegistry {
    private static final ThreadLocal<Map<Class<?>, Object>> extensions = new ThreadLocal<Map<Class<?>, Object>>(){

        @Override
        protected Map<Class<?>, Object> initialValue() {
            return new HashMap();
        }
    };

    private ExtensionRegistry() {
    }

    public static <T> T get(Class<T> clazz) {
        return ExtensionRegistry.get(clazz, null);
    }

    public static <T> T get(Class<T> clazz, Functions.Function0<T> factory) {
        Object t = extensions.get().get(clazz);
        if (t == null) {
            t = ExtensionRegistry.createInstance(clazz, factory, t);
            ExtensionRegistry.register(clazz, t);
        }
        return (T)t;
    }

    private static <T> T createInstance(Class<T> clazz, Functions.Function0<T> factory, T t) {
        if (factory == null) {
            try {
                t = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Extension " + clazz + " not available. Extensions: " + extensions.get() + " Thread: " + Thread.currentThread(), e);
            }
        } else {
            t = factory.apply();
        }
        return t;
    }

    public static void register(Class<?> clazz, Object extension) {
        extensions.get().put(clazz, extension);
    }

    public static void cleanup() {
        extensions.remove();
    }
}

