/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.services;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.japkit.el.ELProviderException;
import de.japkit.el.ELSupport;
import de.japkit.model.AnnotationAndParent;
import de.japkit.model.ParameterWrapper;
import de.japkit.model.Path;
import de.japkit.rules.Rule;
import de.japkit.services.ElementsExtensions;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.GenerateClassContext;
import de.japkit.services.Message;
import de.japkit.services.ProcessingException;
import de.japkit.services.RuleException;
import de.japkit.util.MoreCollectionExtensions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class MessageCollector {
    @Extension
    private ProcessingEnvironment processingEnvironment = ExtensionRegistry.get(ProcessingEnvironment.class);
    @Extension
    private GenerateClassContext _generateClassContext = ExtensionRegistry.get(GenerateClassContext.class);
    @Accessors
    private boolean diagnosticLogging = false;
    private Map<String, Set<Message>> messagesPerAnnotatedClass = CollectionLiterals.newHashMap();

    public void addMessage(Message m) {
        boolean _tripleEquals;
        TypeElement _currentAnnotatedClass = this._generateClassContext.currentAnnotatedClass();
        boolean bl = _tripleEquals = _currentAnnotatedClass == null;
        if (_tripleEquals) {
            throw new IllegalStateException("Currently processed annotated class must be set to report errors!");
        }
        String currentAnnotatedClassFqn = this._generateClassContext.currentAnnotatedClass().getQualifiedName().toString();
        MoreCollectionExtensions.getOrCreateSet(this.messagesPerAnnotatedClass, currentAnnotatedClassFqn).add(m);
    }

    public void addMessage(Diagnostic.Kind kind, String msg, Element element, AnnotationMirror annotation, String annotationValueName) {
        ElementsExtensions ElementsExtensions2 = ExtensionRegistry.get(ElementsExtensions.class);
        TypeElement _nextEnclosingTypeElement = null;
        if (element != null) {
            _nextEnclosingTypeElement = this.nextEnclosingTypeElement(element);
        }
        TypeElement typeElement = _nextEnclosingTypeElement;
        String _xifexpression = null;
        boolean _equals = Objects.equal((Object)typeElement, (Object)element);
        if (_equals) {
            _xifexpression = null;
        } else {
            String _uniqueNameWithin = null;
            if (element != null) {
                _uniqueNameWithin = ElementsExtensions2.uniqueNameWithin(element, typeElement);
            }
            _xifexpression = _uniqueNameWithin;
        }
        String uniqueElementName = _xifexpression;
        AnnotationMirror _xifexpression_1 = null;
        if (annotation instanceof AnnotationAndParent) {
            AnnotationMirror _rootAnnotation = null;
            if ((AnnotationAndParent)annotation != null) {
                _rootAnnotation = ((AnnotationAndParent)annotation).getRootAnnotation();
            }
            _xifexpression_1 = _rootAnnotation;
        } else {
            _xifexpression_1 = annotation;
        }
        AnnotationMirror rootAnnotation = _xifexpression_1;
        Path _xifexpression_2 = null;
        if (annotation instanceof AnnotationAndParent) {
            Path _pathFromRootAnnotation = null;
            if ((AnnotationAndParent)annotation != null) {
                _pathFromRootAnnotation = ((AnnotationAndParent)annotation).getPathFromRootAnnotation();
            }
            _xifexpression_2 = _pathFromRootAnnotation;
        } else {
            _xifexpression_2 = null;
        }
        Path nestedAnnotationPath = _xifexpression_2;
        Name _qualifiedName = null;
        if (typeElement != null) {
            _qualifiedName = typeElement.getQualifiedName();
        }
        String _string = null;
        if (_qualifiedName != null) {
            _string = _qualifiedName.toString();
        }
        String _string_1 = null;
        if (uniqueElementName != null) {
            _string_1 = uniqueElementName.toString();
        }
        DeclaredType _annotationType = null;
        if (rootAnnotation != null) {
            _annotationType = rootAnnotation.getAnnotationType();
        }
        Element _asElement = null;
        if (_annotationType != null) {
            _asElement = _annotationType.asElement();
        }
        Name _qualifiedName_1 = null;
        if ((TypeElement)_asElement != null) {
            _qualifiedName_1 = ((TypeElement)_asElement).getQualifiedName();
        }
        String _string_2 = null;
        if (_qualifiedName_1 != null) {
            _string_2 = _qualifiedName_1.toString();
        }
        Message m = new Message(kind, msg, _string, _string_1, _string_2, nestedAnnotationPath, annotationValueName);
        this.addMessage(m);
    }

    private TypeElement _nextEnclosingTypeElement(TypeElement e) {
        return e;
    }

    private TypeElement _nextEnclosingTypeElement(Element e) {
        return this.nextEnclosingTypeElement(e.getEnclosingElement());
    }

    public void printAllMessages() {
        ElementsExtensions ElementsExtensions2 = ExtensionRegistry.get(ElementsExtensions.class);
        Functions.Function1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Print Messages: ");
            _builder.append(this.messagesPerAnnotatedClass);
            return _builder.toString();
        };
        this.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function);
        Functions.Function1 _function_1 = it -> it != null;
        Consumer<Message> _function_2 = m -> {
            Element element = null;
            AnnotationMirror annotation = null;
            AnnotationValue annotationValue = null;
            Element enclosingExecutableElement = null;
            String paramName = null;
            try {
                boolean _tripleNotEquals;
                String _typeElementFqn = m.getTypeElementFqn();
                boolean bl = _tripleNotEquals = _typeElementFqn != null;
                if (_tripleNotEquals) {
                    boolean _tripleNotEquals_1;
                    TypeElement typeElement = ElementsExtensions2.getTypeElement(m.getTypeElementFqn());
                    String _uniqueMemberName = m.getUniqueMemberName();
                    boolean bl2 = _tripleNotEquals_1 = _uniqueMemberName != null;
                    if (_tripleNotEquals_1) {
                        Functions.Function1 _function_3;
                        Iterable<? extends Element> enclosedElementsAndParams = ElementsExtensions2.elementAndAllEnclosedElements(typeElement, true);
                        element = (Element)IterableExtensions.findFirst(enclosedElementsAndParams, (Functions.Function1)(_function_3 = it -> ElementsExtensions2.uniqueNameWithin((Element)it, typeElement).contentEquals(m.getUniqueMemberName())));
                        if (element instanceof ParameterWrapper) {
                            enclosingExecutableElement = ((ParameterWrapper)element).getEnclosingElement();
                            Name _name = ((ParameterWrapper)element).getName();
                            String _string = null;
                            if (_name != null) {
                                _string = _name.toString();
                            }
                            paramName = _string;
                            element = ((ParameterWrapper)element).getDelegate();
                        }
                    } else {
                        element = typeElement;
                    }
                    if (element != null && m.getAnnotationFqn() != null) {
                        Functions.Function1 _function_4 = it -> {
                            Element _asElement = it.getAnnotationType().asElement();
                            return ((TypeElement)_asElement).getQualifiedName().contentEquals(m.getAnnotationFqn());
                        };
                        AnnotationMirror rootAnnotation = (AnnotationMirror)IterableExtensions.findFirst(element.getAnnotationMirrors(), (Functions.Function1)_function_4);
                        AnnotationMirror _xifexpression = null;
                        boolean _supportsNestedAnnotations = this.supportsNestedAnnotations();
                        _xifexpression = _supportsNestedAnnotations ? this.getNestedAnnotation(rootAnnotation, m.getNestedAnnotationPath()) : rootAnnotation;
                        annotation = _xifexpression;
                        AnnotationValue _value = null;
                        if (annotation != null) {
                            String _xifexpression_1 = null;
                            boolean _supportsNestedAnnotations_1 = this.supportsNestedAnnotations();
                            if (_supportsNestedAnnotations_1) {
                                _xifexpression_1 = m.getAvName();
                            } else {
                                String _avName;
                                String _elvis = null;
                                Path _nestedAnnotationPath = m.getNestedAnnotationPath();
                                List<Path.Segment> _segments = null;
                                if (_nestedAnnotationPath != null) {
                                    _segments = _nestedAnnotationPath.getSegments();
                                }
                                Path.Segment _get = null;
                                if (_segments != null) {
                                    _get = _segments.get(0);
                                }
                                String _name_1 = null;
                                if (_get != null) {
                                    _name_1 = _get.getName();
                                }
                                _elvis = _name_1 != null ? _name_1 : (_avName = m.getAvName());
                                _xifexpression_1 = _elvis;
                            }
                            _value = this.getValue(annotation, _xifexpression_1, null);
                        }
                        annotationValue = _value;
                    }
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    Messager _messager = this.processingEnvironment.getMessager();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Error during error reporting: ");
                    _builder.append((Object)e);
                    _builder.append(", cause: ");
                    String _message = this.getRootCause(e).getMessage();
                    _builder.append(_message);
                    _builder.append(" ");
                    _builder.newLineIfNotEmpty();
                    List _subList = ((List)Conversions.doWrapArray((Object)e.getStackTrace())).subList(0, Math.min(20, e.getStackTrace().length));
                    for (StackTraceElement ste : _subList) {
                        _builder.append("\t\t\t\t\t");
                        _builder.append((Object)ste, "\t\t\t\t\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t\t\t\t");
                    }
                    _messager.printMessage(Diagnostic.Kind.ERROR, (CharSequence)_builder);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            this.processingEnvironment.getMessager().printMessage(m.getKind(), m.getMsg(), element, annotation, annotationValue);
            if (enclosingExecutableElement != null) {
                Messager _messager_1 = this.processingEnvironment.getMessager();
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Error in parameter ");
                _builder_1.append(paramName);
                _builder_1.append(" (Annotation: ");
                String _annotationFqn = m.getAnnotationFqn();
                _builder_1.append(_annotationFqn);
                _builder_1.append(", AnnotationValue: ");
                String _avName_1 = m.getAvName();
                _builder_1.append(_avName_1);
                _builder_1.append("): ");
                CharSequence _msg = m.getMsg();
                String _plus = _builder_1.toString() + _msg;
                _messager_1.printMessage(m.getKind(), _plus, enclosingExecutableElement, null, null);
            }
            Messager _messager_2 = this.processingEnvironment.getMessager();
            StringConcatenation _builder_2 = new StringConcatenation();
            CharSequence _msg_1 = m.getMsg();
            _builder_2.append((Object)_msg_1);
            _builder_2.append(" ");
            String _typeElementFqn_1 = m.getTypeElementFqn();
            _builder_2.append(_typeElementFqn_1);
            _builder_2.append(" ");
            String _annotationFqn_1 = m.getAnnotationFqn();
            _builder_2.append(_annotationFqn_1);
            _builder_2.append(" ");
            Path _nestedAnnotationPath_1 = m.getNestedAnnotationPath();
            _builder_2.append((Object)_nestedAnnotationPath_1);
            _messager_2.printMessage(m.getKind(), (CharSequence)_builder_2);
        };
        Iterables.concat((Iterable)IterableExtensions.filter(this.messagesPerAnnotatedClass.values(), (Functions.Function1)_function_1)).forEach(_function_2);
        this.messagesPerAnnotatedClass.clear();
    }

    public boolean supportsNestedAnnotations() {
        return true;
    }

    public boolean isEclipse() {
        return this.processingEnvironment.getMessager().getClass().getPackage().getName().startsWith("org.eclipse");
    }

    public AnnotationMirror getNestedAnnotation(AnnotationMirror rootAnnotation, Path path) {
        AnnotationMirror _xblockexpression = null;
        if (rootAnnotation == null) {
            return null;
        }
        List<Path.Segment> _segments = null;
        if (path != null) {
            _segments = path.getSegments();
        }
        List<Path.Segment> pathSegments = _segments;
        AnnotationMirror annotation = rootAnnotation;
        if (pathSegments != null) {
            for (Path.Segment s : pathSegments) {
                AnnotationValue av = this.getValue(annotation, s.getName(), s.getIndex());
                Object _value = av.getValue();
                annotation = (AnnotationMirror)_value;
            }
        }
        _xblockexpression = annotation;
        return _xblockexpression;
    }

    public AnnotationValue getValue(AnnotationMirror am, String avName, Integer index) {
        AnnotationValue _xblockexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)avName);
        if (_isNullOrEmpty) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> _elementValues = null;
        if (am != null) {
            _elementValues = am.getElementValues();
        }
        Functions.Function2 _function = (k, v) -> k.getSimpleName().contentEquals(avName);
        AnnotationValue av = (AnnotationValue)IterableExtensions.head(MapExtensions.filter(_elementValues, (Functions.Function2)_function).values());
        AnnotationValue _xifexpression = null;
        if (index != null) {
            Object _value = null;
            if (av != null) {
                _value = av.getValue();
            }
            _xifexpression = (AnnotationValue)((List)_value).get(index);
        } else {
            _xifexpression = av;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public Set<Message> removeMessagesForAnnotatedClass(String annotatedClassFqn) {
        return this.messagesPerAnnotatedClass.remove(annotatedClassFqn);
    }

    private Throwable getRootCause(Throwable t) {
        Throwable _elvis = null;
        Throwable _cause = t.getCause();
        Throwable _rootCause = null;
        if (_cause != null) {
            _rootCause = this.getRootCause(_cause);
        }
        _elvis = _rootCause != null ? _rootCause : t;
        return _elvis;
    }

    protected void _reportRuleError(CharSequence msg) {
        this.reportRuleError(msg, null);
    }

    protected void _reportRuleError(Exception e) {
        this.reportRuleError(e, null);
    }

    protected void _reportRuleError(ELProviderException e, CharSequence metaAnnotationValueName) {
        StringConcatenation _builder = new StringConcatenation();
        String _message = this.getRootCause(e).getMessage();
        _builder.append(_message);
        this.reportRuleError(_builder, metaAnnotationValueName);
    }

    protected void _reportRuleError(RuleException e, CharSequence metaAnnotationValueName) {
        StringConcatenation _builder = new StringConcatenation();
        String _message = e.getMessage();
        _builder.append(_message);
        this.reportRuleError(_builder, metaAnnotationValueName);
    }

    protected void _reportRuleError(Exception e, CharSequence metaAnnotationValueName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)e);
        _builder.append(", cause: ");
        String _message = this.getRootCause(e).getMessage();
        _builder.append(_message);
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        List _subList = ((List)Conversions.doWrapArray((Object)e.getStackTrace())).subList(0, Math.min(20, e.getStackTrace().length));
        for (StackTraceElement ste : _subList) {
            _builder.append("\t\t");
            _builder.append((Object)ste, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
        }
        this.reportRuleError(_builder, metaAnnotationValueName);
    }

    protected void _reportRuleError(CharSequence msg, CharSequence metaAnnotationValueName) {
        this.reportRuleError(this._generateClassContext.getCurrentRule(), msg, metaAnnotationValueName);
    }

    public void reportRuleError(Rule rule, CharSequence msg, CharSequence metaAnnotationValueName) {
        ELSupport ELSupport2 = ExtensionRegistry.get(ELSupport.class);
        AnnotationMirror _metaAnnotation = null;
        if (rule != null) {
            _metaAnnotation = rule.getMetaAnnotation();
        }
        AnnotationMirror metaAnnotation = _metaAnnotation;
        Element _xifexpression = null;
        if (metaAnnotation instanceof AnnotationAndParent) {
            Element _rootAnnotatedElement = null;
            if ((AnnotationAndParent)metaAnnotation != null) {
                _rootAnnotatedElement = ((AnnotationAndParent)metaAnnotation).getRootAnnotatedElement();
            }
            _xifexpression = _rootAnnotatedElement;
        } else {
            Element _metaElement = null;
            if (rule != null) {
                _metaElement = rule.getMetaElement();
            }
            _xifexpression = _metaElement;
        }
        Element metaElement = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        String _string = null;
        if (msg != null) {
            _string = msg.toString();
        }
        _builder.append(_string);
        _builder.append(" MetaElement: ");
        _builder.append((Object)metaElement);
        _builder.append(", MetaAnnotation: ");
        _builder.append((Object)metaAnnotation);
        _builder.append(", Src: ");
        Object _currentSrcOptional = ELSupport2.getCurrentSrcOptional();
        _builder.append(_currentSrcOptional);
        this.addMessage(Diagnostic.Kind.ERROR, _builder.toString(), this._generateClassContext.currentAnnotatedClass(), null, null);
        String _string_1 = null;
        if (msg != null) {
            _string_1 = msg.toString();
        }
        String _string_2 = null;
        if (metaAnnotationValueName != null) {
            _string_2 = metaAnnotationValueName.toString();
        }
        this.addMessage(Diagnostic.Kind.ERROR, _string_1, metaElement, metaAnnotation, _string_2);
    }

    public void reportError(CharSequence msg, Exception ex, Element element, AnnotationMirror annotation, CharSequence annotationValueName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)msg);
        _builder.append(" Cause: ");
        _builder.append((Object)ex);
        _builder.append(": ");
        String _message = ex.getMessage();
        _builder.append(_message);
        _builder.append("\\n at ");
        String _join = IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)ex.getStackTrace())), (CharSequence)"\n at ");
        _builder.append(_join);
        ProcessingException _processingException = new ProcessingException(_builder.toString(), element, annotation, annotationValueName, null);
        this.reportError(_processingException);
    }

    public void reportError(CharSequence msg, Element element, AnnotationMirror annotation, CharSequence annotationValueName) {
        String _string = null;
        if (msg != null) {
            _string = msg.toString();
        }
        ProcessingException _processingException = new ProcessingException(_string, element, annotation, annotationValueName, null);
        this.reportError(_processingException);
    }

    public void reportError(ProcessingException pe) {
        boolean _tripleNotEquals_4;
        AnnotationMirror annotation;
        boolean _tripleNotEquals_2;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        String _xifexpression = null;
        Element _element = pe.getElement();
        boolean bl = _tripleNotEquals = _element != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Element: ");
            Element _element_1 = pe.getElement();
            _builder.append((Object)_element_1);
            _builder.append(", ");
            _xifexpression = _builder.toString();
        } else {
            _xifexpression = "";
        }
        String elementStr = _xifexpression;
        String _xifexpression_1 = null;
        AnnotationMirror _annotationMirror = pe.getAnnotationMirror();
        boolean bl2 = _tripleNotEquals_1 = _annotationMirror != null;
        if (_tripleNotEquals_1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Annotation: ");
            AnnotationMirror _annotationMirror_1 = pe.getAnnotationMirror();
            _builder_1.append((Object)_annotationMirror_1);
            _builder_1.append(", ");
            _xifexpression_1 = _builder_1.toString();
        } else {
            _xifexpression_1 = "";
        }
        String annotationStr = _xifexpression_1;
        String _xifexpression_2 = null;
        CharSequence _annotationValueName = pe.getAnnotationValueName();
        boolean bl3 = _tripleNotEquals_2 = _annotationValueName != null;
        if (_tripleNotEquals_2) {
            boolean _tripleNotEquals_3;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Annotation Value: ");
            CharSequence _annotationValueName_1 = pe.getAnnotationValueName();
            _builder_2.append((Object)_annotationValueName_1);
            AnnotationValue _annotationValue = pe.getAnnotationValue();
            boolean bl4 = _tripleNotEquals_3 = _annotationValue != null;
            if (_tripleNotEquals_3) {
                _builder_2.append(" =\"");
                Object _value = pe.getAnnotationValue().getValue();
                _builder_2.append(_value);
                _builder_2.append("\"");
            }
            _builder_2.append(", ");
            _xifexpression_2 = _builder_2.toString();
        } else {
            _xifexpression_2 = "";
        }
        String annotationValueStr = _xifexpression_2;
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append(elementStr);
        _builder_3.append(annotationStr);
        _builder_3.append(annotationValueStr);
        String _message = pe.getMessage();
        _builder_3.append(_message);
        String msg = _builder_3.toString();
        Element element = pe.getElement();
        if (element == null) {
            element = this._generateClassContext.currentAnnotatedClass();
        }
        if ((annotation = pe.getAnnotationMirror()) == null) {
            annotation = this._generateClassContext.getCurrentTriggerAnnotation();
        }
        CharSequence _annotationValueName_2 = pe.getAnnotationValueName();
        String _string = null;
        if (_annotationValueName_2 != null) {
            _string = _annotationValueName_2.toString();
        }
        this.addMessage(Diagnostic.Kind.ERROR, msg, element, annotation, _string);
        TypeElement _currentAnnotatedClass = this._generateClassContext.currentAnnotatedClass();
        boolean bl5 = _tripleNotEquals_4 = _currentAnnotatedClass != null;
        if (_tripleNotEquals_4) {
            this.addMessage(Diagnostic.Kind.ERROR, msg, this._generateClassContext.currentAnnotatedClass(), this._generateClassContext.getCurrentTriggerAnnotation(), null);
        }
    }

    public void reportMessage(String msg, Element element, Diagnostic.Kind kind) {
        this.addMessage(kind, msg, element, this._generateClassContext.getCurrentTriggerAnnotation(), null);
        if (this._generateClassContext.currentAnnotatedClass() != null && !Objects.equal((Object)this.enclosingTopLevelElement(element), (Object)this._generateClassContext.currentAnnotatedClass())) {
            this.addMessage(kind, msg, this._generateClassContext.currentAnnotatedClass(), this._generateClassContext.getCurrentTriggerAnnotation(), null);
        }
    }

    private Element enclosingTopLevelElement(Element element) {
        Element _xblockexpression = null;
        Element _enclosingElement = null;
        if (element != null) {
            _enclosingElement = element.getEnclosingElement();
        }
        Element enclosing = _enclosingElement;
        Element _xifexpression = null;
        _xifexpression = enclosing == null || enclosing instanceof PackageElement ? element : this.enclosingTopLevelElement(enclosing);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void printDiagnosticMessage(Functions.Function1<? super Object, ? extends CharSequence> cs) {
        if (this.diagnosticLogging) {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.NOTE, (CharSequence)cs.apply(null));
        }
    }

    public void printDiagnosticMessage(Element e, Functions.Function1<? super Object, ? extends CharSequence> cs) {
        if (this.diagnosticLogging) {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.NOTE, (CharSequence)cs.apply(null), e);
        }
    }

    private TypeElement nextEnclosingTypeElement(Element e) {
        if (e instanceof TypeElement) {
            return this._nextEnclosingTypeElement((TypeElement)e);
        }
        if (e != null) {
            return this._nextEnclosingTypeElement(e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }

    public void reportRuleError(Object e) {
        if (e instanceof Exception) {
            this._reportRuleError((Exception)e);
            return;
        }
        if (e instanceof CharSequence) {
            this._reportRuleError((CharSequence)e);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }

    public void reportRuleError(Object e, CharSequence metaAnnotationValueName) {
        if (e instanceof ELProviderException) {
            this._reportRuleError((ELProviderException)e, metaAnnotationValueName);
            return;
        }
        if (e instanceof RuleException) {
            this._reportRuleError((RuleException)e, metaAnnotationValueName);
            return;
        }
        if (e instanceof Exception) {
            this._reportRuleError((Exception)e, metaAnnotationValueName);
            return;
        }
        if (e instanceof CharSequence) {
            this._reportRuleError((CharSequence)e, metaAnnotationValueName);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e, metaAnnotationValueName).toString());
    }

    @Pure
    public boolean isDiagnosticLogging() {
        return this.diagnosticLogging;
    }

    public void setDiagnosticLogging(boolean diagnosticLogging) {
        this.diagnosticLogging = diagnosticLogging;
    }
}

