/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.services;

import com.google.common.base.Objects;
import de.japkit.model.GenDeclaredType;
import de.japkit.model.GenTypeElement;
import de.japkit.model.GenTypeMirror;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.RuleException;
import de.japkit.services.TypesRegistry;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TypesExtensions {
    private final Types typeUtils = ExtensionRegistry.get(Types.class);
    @Extension
    private final transient Elements elementUtils = ExtensionRegistry.get(Elements.class);
    @Extension
    private final transient TypesRegistry typesRegistry = ExtensionRegistry.get(TypesRegistry.class);
    private static final Set<String> BOXED_TYPES = IterableExtensions.toSet((Iterable)IterableExtensions.map(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Character.class, Float.class, Double.class})), it -> it.getName()));
    private static final Set<String> TEMPORAL_TYPES = IterableExtensions.toSet((Iterable)IterableExtensions.map(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Class[]{Calendar.class, Date.class})), it -> it.getName()));
    private static final Set<String> MATH_TYPES = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{BigDecimal.class.getName(), BigInteger.class.getName()}));
    private static final Set<String> COLLECTION_TYPES = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{Collection.class.getName(), Set.class.getName(), List.class.getName(), SortedSet.class.getName()}));

    public TypeMirror getJavaLangObject() {
        return this.typesRegistry.findTypeElement(Object.class.getName()).asType();
    }

    public TypeMirror boxed(TypeKind typeKind) {
        return this.boxedClass(this.getPrimitiveType(typeKind)).asType();
    }

    public boolean isPrimitive(TypeMirror type) {
        TypeKind _kind = null;
        if (type != null) {
            _kind = type.getKind();
        }
        return _kind.isPrimitive();
    }

    public boolean isDeclared(TypeMirror type) {
        TypeKind _kind = null;
        if (type != null) {
            _kind = type.getKind();
        }
        return Objects.equal((Object)((Object)_kind), (Object)((Object)TypeKind.DECLARED));
    }

    public boolean isError(TypeMirror type) {
        TypeKind _kind = null;
        if (type != null) {
            _kind = type.getKind();
        }
        return Objects.equal((Object)((Object)_kind), (Object)((Object)TypeKind.ERROR));
    }

    public boolean isDeclaredOrErasureIsDeclared(TypeMirror type) {
        return this.isDeclared(type) || this.isError(type) && this.isDeclared(this.erasure((DeclaredType)type));
    }

    public boolean isDeclaredOrError(TypeMirror type) {
        return this.isDeclared(type) || this.isError(type);
    }

    public boolean isBoxed(TypeMirror type) {
        boolean _xifexpression = false;
        boolean _isDeclared = this.isDeclared(type);
        _xifexpression = _isDeclared ? BOXED_TYPES.contains(this.qualifiedName(type)) : false;
        return _xifexpression;
    }

    public boolean isString(TypeMirror type) {
        boolean _xifexpression = false;
        boolean _isDeclared = this.isDeclared(type);
        if (_isDeclared) {
            String _name = String.class.getName();
            String _qualifiedName = this.qualifiedName(type);
            _xifexpression = Objects.equal((Object)_name, (Object)_qualifiedName);
        } else {
            _xifexpression = false;
        }
        return _xifexpression;
    }

    public boolean isTemporal(TypeMirror type) {
        boolean _xifexpression = false;
        boolean _isDeclared = this.isDeclared(type);
        _xifexpression = _isDeclared ? TEMPORAL_TYPES.contains(this.qualifiedName(type)) : false;
        return _xifexpression;
    }

    public boolean isMath(TypeMirror type) {
        boolean _xifexpression = false;
        boolean _isDeclared = this.isDeclared(type);
        _xifexpression = _isDeclared ? MATH_TYPES.contains(this.qualifiedName(type)) : false;
        return _xifexpression;
    }

    public boolean collectionOrMap(TypeMirror type) {
        return this.isCollection(type) || this.isMap(type);
    }

    public boolean isCollection(TypeMirror type) {
        boolean _xifexpression = false;
        boolean _isDeclaredOrErasureIsDeclared = this.isDeclaredOrErasureIsDeclared(type);
        if (_isDeclaredOrErasureIsDeclared) {
            String _qualifiedName = null;
            if (type != null) {
                _qualifiedName = this.qualifiedName(type);
            }
            _xifexpression = COLLECTION_TYPES.contains(_qualifiedName);
        } else {
            _xifexpression = false;
        }
        return _xifexpression;
    }

    public boolean isMap(TypeMirror type) {
        boolean _xifexpression = false;
        boolean _isDeclaredOrErasureIsDeclared = this.isDeclaredOrErasureIsDeclared(type);
        if (_isDeclaredOrErasureIsDeclared) {
            String _name = Map.class.getName();
            String _qualifiedName = this.qualifiedName(type);
            _xifexpression = Objects.equal((Object)_name, (Object)_qualifiedName);
        } else {
            _xifexpression = false;
        }
        return _xifexpression;
    }

    public boolean isSet(TypeMirror type) {
        boolean _xifexpression = false;
        boolean _isDeclaredOrErasureIsDeclared = this.isDeclaredOrErasureIsDeclared(type);
        if (_isDeclaredOrErasureIsDeclared) {
            String _name = Set.class.getName();
            String _qualifiedName = this.qualifiedName(type);
            _xifexpression = Objects.equal((Object)_name, (Object)_qualifiedName);
        } else {
            _xifexpression = false;
        }
        return _xifexpression;
    }

    public boolean isList(TypeMirror type) {
        boolean _xifexpression = false;
        boolean _isDeclaredOrErasureIsDeclared = this.isDeclaredOrErasureIsDeclared(type);
        if (_isDeclaredOrErasureIsDeclared) {
            String _name = List.class.getName();
            String _qualifiedName = this.qualifiedName(type);
            _xifexpression = Objects.equal((Object)_name, (Object)_qualifiedName);
        } else {
            _xifexpression = false;
        }
        return _xifexpression;
    }

    public boolean isEnum(TypeMirror type) {
        boolean _xifexpression = false;
        boolean _isDeclared = this.isDeclared(type);
        if (_isDeclared) {
            ElementKind _kind = this.typesRegistry.asTypeElement(type).getKind();
            _xifexpression = Objects.equal((Object)((Object)_kind), (Object)((Object)ElementKind.ENUM));
        } else {
            _xifexpression = false;
        }
        return _xifexpression;
    }

    public boolean isBoolean(TypeMirror type) {
        return this.isPrimitive(type) && this.operator_equals(type, this.getPrimitiveType(TypeKind.BOOLEAN)) || this.isDeclared(type) && this.operator_equals(type, this.boxed(TypeKind.BOOLEAN));
    }

    protected TypeMirror _getTypeArg(DeclaredType type, int argIndex) {
        TypeMirror _xifexpression = null;
        _xifexpression = !this.isDeclaredOrError(type) || argIndex >= type.getTypeArguments().size() ? null : type.getTypeArguments().get(argIndex);
        return _xifexpression;
    }

    protected TypeMirror _getTypeArg(TypeMirror type, int argIndex) {
        return null;
    }

    private TypeMirror getRequiredTypeArg(TypeMirror type, int argIndex) {
        TypeMirror _xblockexpression = null;
        TypeMirror typeArg = this.getTypeArg(type, argIndex);
        boolean _equals = Objects.equal((Object)typeArg, (Object)0);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Type argument (pos.: ");
            _builder.append((Object)argIndex);
            _builder.append(") required but not found: ");
            _builder.append((Object)type);
            throw new IllegalArgumentException(_builder.toString());
        }
        _xblockexpression = typeArg;
        return _xblockexpression;
    }

    public TypeMirror singleValueType(TypeMirror type) {
        TypeMirror _accept = null;
        if (type != null) {
            _accept = type.accept(new SimpleTypeVisitor8<TypeMirror, Void>(type){

                @Override
                public TypeMirror visitDeclared(DeclaredType type, Void v) {
                    TypeMirror _xifexpression = null;
                    boolean _isCollection = TypesExtensions.this.isCollection(type);
                    if (_isCollection) {
                        _xifexpression = TypesExtensions.this.uppertBoundIfTypeVarOrWildcard(TypesExtensions.this.getRequiredTypeArg(type, 0));
                    } else {
                        TypeMirror _xifexpression_1 = null;
                        boolean _isMap = TypesExtensions.this.isMap(type);
                        _xifexpression_1 = _isMap ? TypesExtensions.this.uppertBoundIfTypeVarOrWildcard(TypesExtensions.this.getRequiredTypeArg(type, 1)) : type;
                        _xifexpression = _xifexpression_1;
                    }
                    return _xifexpression;
                }

                @Override
                public TypeMirror visitError(ErrorType type, Void v) {
                    return this.visitDeclared((DeclaredType)type, v);
                }

                @Override
                public TypeMirror visitArray(ArrayType type, Void v) {
                    return TypesExtensions.this.singleValueType(type.getComponentType());
                }

                @Override
                public TypeMirror visitTypeVariable(TypeVariable type, Void v) {
                    return TypesExtensions.this.uppertBoundIfTypeVarOrWildcard(type);
                }
            }, null);
        }
        return _accept;
    }

    public TypeMirror uppertBoundIfTypeVarOrWildcard(TypeMirror type) {
        TypeMirror _accept = null;
        if (type != null) {
            _accept = type.accept(new SimpleTypeVisitor8<TypeMirror, Void>(type){

                @Override
                public TypeMirror visitWildcard(WildcardType type, Void v) {
                    return type.getExtendsBound();
                }

                @Override
                public TypeMirror visitTypeVariable(TypeVariable type, Void v) {
                    return type.getUpperBound();
                }
            }, null);
        }
        return _accept;
    }

    public DeclaredType declaredType(Class<?> clazz, TypeMirror ... typeArgs) {
        return this.declaredType(clazz.getName(), typeArgs);
    }

    public DeclaredType declaredType(String fqn, TypeMirror ... typeArgs) {
        return this.typeUtils.getDeclaredType(this.elementUtils.getTypeElement(fqn), typeArgs);
    }

    public boolean isJavaLangObject(TypeMirror type) {
        boolean _xblockexpression = false;
        String typeFqn = type.toString();
        String _name = Object.class.getName();
        _xblockexpression = Objects.equal((Object)typeFqn, (Object)_name);
        return _xblockexpression;
    }

    protected TypeMirror _erasure(GenDeclaredType type) {
        GenDeclaredType _xifexpression = null;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(type.getTypeArguments());
        if (_isNullOrEmpty) {
            _xifexpression = type;
        } else {
            Element _asElement = type.asElement();
            _xifexpression = new GenDeclaredType((TypeElement)_asElement);
        }
        return _xifexpression;
    }

    protected TypeMirror _erasure(TypeMirror type) {
        return this.typeUtils.erasure(type);
    }

    public boolean isSameType(TypeMirror t1, TypeMirror t2) {
        Boolean _xblockexpression = null;
        if (t1 == null || t2 == null) {
            return false;
        }
        if (this.isVoid(t1) || this.isVoid(t2)) {
            return this.isVoid(t2) && this.isVoid(t1);
        }
        TypeKind _xifexpression = null;
        TypeKind _kind = t1.getKind();
        boolean _equals = Objects.equal((Object)((Object)_kind), (Object)((Object)TypeKind.ERROR));
        _xifexpression = _equals ? TypeKind.DECLARED : t1.getKind();
        TypeKind t1Kind = _xifexpression;
        TypeKind _xifexpression_1 = null;
        TypeKind _kind_1 = t2.getKind();
        boolean _equals_1 = Objects.equal((Object)((Object)_kind_1), (Object)((Object)TypeKind.ERROR));
        _xifexpression_1 = _equals_1 ? TypeKind.DECLARED : t2.getKind();
        TypeKind t2Kind = _xifexpression_1;
        if (t1Kind != t2Kind) {
            return false;
        }
        _xblockexpression = t1.accept(new SimpleTypeVisitor8<Boolean, TypeMirror>(){

            @Override
            public Boolean defaultAction(TypeMirror t1, TypeMirror t2) {
                return TypesExtensions.this.typeUtils.isSameType(t1, t2);
            }

            @Override
            public Boolean visitDeclared(DeclaredType t1, TypeMirror t2) {
                boolean _xblockexpression = false;
                String fqn1 = TypesExtensions.this.qualifiedName(t1);
                String fqn2 = TypesExtensions.this.qualifiedName(t2);
                boolean _or = false;
                boolean _equals = fqn1.equals(fqn2);
                _or = _equals ? true : !(!TypesExtensions.this.containsErrorType(t1) && !TypesExtensions.this.containsErrorType(t2) || fqn1.contains(".") && fqn2.contains(".") || !TypesExtensions.this.simpleName(t1).equals(TypesExtensions.this.simpleName(t2)));
                _xblockexpression = _or;
                return _xblockexpression;
            }

            @Override
            public Boolean visitError(ErrorType t1, TypeMirror t2) {
                return this.visitDeclared((DeclaredType)t1, t2);
            }

            @Override
            public Boolean visitArray(ArrayType t1, TypeMirror t2) {
                return TypesExtensions.this.isSameType(t1.getComponentType(), ((ArrayType)t2).getComponentType());
            }
        }, t2);
        return _xblockexpression;
    }

    private boolean containsErrorType(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<Boolean, Void>(Boolean.valueOf(false)){

            @Override
            public Boolean visitError(ErrorType t, Void v) {
                return true;
            }

            @Override
            public Boolean visitDeclared(DeclaredType t, Void v) {
                Functions.Function1 _function = it -> TypesExtensions.this.containsErrorType(it);
                return IterableExtensions.exists(t.getTypeArguments(), (Functions.Function1)_function);
            }

            @Override
            public Boolean visitWildcard(WildcardType t, Void v) {
                return t.getExtendsBound() != null && TypesExtensions.this.containsErrorType(t.getExtendsBound()) || t.getSuperBound() != null && TypesExtensions.this.containsErrorType(t.getSuperBound());
            }
        }, null);
    }

    public DeclaredType enclosingTopLevelType(DeclaredType declType) {
        boolean _equals;
        DeclaredType _xifexpression = null;
        TypeMirror _enclosingType = declType.getEnclosingType();
        TypeKind _kind = null;
        if (_enclosingType != null) {
            _kind = _enclosingType.getKind();
        }
        if (_equals = Objects.equal((Object)((Object)_kind), (Object)((Object)TypeKind.NONE))) {
            _xifexpression = declType;
        } else {
            TypeMirror _enclosingType_1 = declType.getEnclosingType();
            _xifexpression = this.enclosingTopLevelType((DeclaredType)_enclosingType_1);
        }
        return _xifexpression;
    }

    public String qualifiedName(TypeMirror type) {
        String _accept = null;
        if (type != null) {
            _accept = type.accept(new SimpleTypeVisitor8<String, Void>(){

                @Override
                public String defaultAction(TypeMirror type, Void p) {
                    throw new RuleException("Unsupported Type: " + type);
                }

                @Override
                public String visitPrimitive(PrimitiveType type, Void p) {
                    return type.getKind().toString().toLowerCase();
                }

                @Override
                public String visitNoType(NoType type, Void p) {
                    return type.getKind().toString().toLowerCase();
                }

                @Override
                public String visitDeclared(DeclaredType declType, Void v) {
                    String _xblockexpression = null;
                    if (declType instanceof GenDeclaredType) {
                        return ((GenDeclaredType)declType).qualifiedName();
                    }
                    _xblockexpression = TypesExtensions.this.typesRegistry.asTypeElement(declType).getQualifiedName().toString();
                    return _xblockexpression;
                }

                @Override
                public String visitError(ErrorType declType, Void v) {
                    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(declType.getTypeArguments());
                    if (_isNullOrEmpty) {
                        String _guessTypeNameFromToString = TypesExtensions.this.typesRegistry.guessTypeNameFromToString(declType);
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Cannot determine qualified name for error type ");
                        String _guessTypeNameFromToString_1 = TypesExtensions.this.typesRegistry.guessTypeNameFromToString(declType);
                        _builder.append(_guessTypeNameFromToString_1);
                        Functions.Function1 _function = it -> TypesExtensions.this.typesRegistry.tryToGetFqnForErrorType(declType);
                        return TypesExtensions.this.typesRegistry.handleTypeElementNotFound(_guessTypeNameFromToString, (CharSequence)_builder, _function);
                    }
                    return TypesExtensions.this.qualifiedName(TypesExtensions.this.erasure(declType));
                }

                @Override
                public String visitArray(ArrayType type, Void v) {
                    StringConcatenation _builder = new StringConcatenation();
                    String _qualifiedName = TypesExtensions.this.qualifiedName(type.getComponentType());
                    _builder.append(_qualifiedName);
                    _builder.append("[]");
                    return _builder.toString();
                }
            }, null);
        }
        return _accept;
    }

    public String simpleName(TypeMirror type) {
        String _accept = null;
        if (type != null) {
            _accept = type.accept(new SimpleTypeVisitor8<String, Void>(){

                @Override
                public String defaultAction(TypeMirror type, Void p) {
                    throw new RuleException("Unsupported Type: " + type);
                }

                @Override
                public String visitPrimitive(PrimitiveType type, Void p) {
                    return type.getKind().toString().toLowerCase();
                }

                @Override
                public String visitNoType(NoType type, Void p) {
                    return type.getKind().toString().toLowerCase();
                }

                @Override
                public String visitDeclared(DeclaredType declType, Void v) {
                    String _xblockexpression = null;
                    if (declType instanceof GenDeclaredType) {
                        return ((GenDeclaredType)declType).simpleName();
                    }
                    _xblockexpression = TypesExtensions.this.typesRegistry.asTypeElement(declType).getSimpleName().toString();
                    return _xblockexpression;
                }

                @Override
                public String visitError(ErrorType declType, Void v) {
                    String _xifexpression = null;
                    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(declType.getTypeArguments());
                    _xifexpression = _isNullOrEmpty ? TypesExtensions.this.typesRegistry.getSimpleNameForErrorType(declType) : TypesExtensions.this.simpleName(TypesExtensions.this.erasure(declType));
                    return _xifexpression;
                }

                @Override
                public String visitArray(ArrayType type, Void v) {
                    StringConcatenation _builder = new StringConcatenation();
                    String _simpleName = TypesExtensions.this.simpleName(type.getComponentType());
                    _builder.append(_simpleName);
                    _builder.append("[]");
                    return _builder.toString();
                }
            }, null);
        }
        return _accept;
    }

    public boolean operator_equals(TypeMirror t1, TypeMirror t2) {
        boolean _xifexpression = false;
        _xifexpression = t1 == null || t2 == null ? t1 == t2 : this.isSameType(t1, t2);
        return _xifexpression;
    }

    public boolean operator_notEquals(TypeMirror t1, TypeMirror t2) {
        boolean _equals = this.operator_equals(t1, t2);
        return !_equals;
    }

    public Class<?> boxedType(Class<?> primititveType) {
        try {
            String _firstUpper = StringExtensions.toFirstUpper((String)primititveType.getSimpleName());
            String _plus = "java.lang." + _firstUpper;
            return Class.forName(_plus);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean isVoid(TypeMirror type) {
        return type == null || Objects.equal((Object)((Object)type.getKind()), (Object)((Object)TypeKind.VOID)) || Objects.equal((Object)((Object)type.getKind()), (Object)((Object)TypeKind.NONE));
    }

    public NoType getVoid() {
        return this.getNoType(TypeKind.VOID);
    }

    public TypeElement asElement(TypeMirror t) {
        return this.typesRegistry.asTypeElement(t);
    }

    public TypeMirror asMemberOf(DeclaredType containing, Element element) {
        return this.typeUtils.asMemberOf(containing, element);
    }

    public TypeElement boxedClass(PrimitiveType p) {
        return this.typeUtils.boxedClass(p);
    }

    public TypeMirror capture(TypeMirror t) {
        return this.typeUtils.capture(t);
    }

    public boolean contains(TypeMirror t1, TypeMirror t2) {
        return this.typeUtils.contains(t1, t2);
    }

    public List<? extends TypeMirror> directSupertypes(TypeMirror t) {
        return this.typeUtils.directSupertypes(t);
    }

    public ArrayType getArrayType(TypeMirror componentType) {
        return this.typeUtils.getArrayType(componentType);
    }

    public DeclaredType getDeclaredType(TypeElement typeElem, TypeMirror ... args) {
        DeclaredType _xifexpression = null;
        if (typeElem instanceof GenTypeElement || IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)args)), it -> it instanceof GenTypeMirror || this.isVoid((TypeMirror)it))) {
            Procedures.Procedure1 _function = it -> it.setTypeArguments((List)Conversions.doWrapArray((Object)args));
            _xifexpression = new GenDeclaredType(typeElem, (Procedures.Procedure1<? super GenDeclaredType>)_function);
        } else {
            _xifexpression = this.typeUtils.getDeclaredType(typeElem, args);
        }
        return _xifexpression;
    }

    public DeclaredType getDeclaredType(DeclaredType containing, TypeElement typeElem, TypeMirror ... typeArgs) {
        return this.typeUtils.getDeclaredType(containing, typeElem, typeArgs);
    }

    public NoType getNoType(TypeKind kind) {
        return this.typeUtils.getNoType(kind);
    }

    public NullType getNullType() {
        return this.typeUtils.getNullType();
    }

    public PrimitiveType getPrimitiveType(TypeKind kind) {
        return this.typeUtils.getPrimitiveType(kind);
    }

    public WildcardType getWildcardType(TypeMirror extendsBound, TypeMirror superBound) {
        return this.typeUtils.getWildcardType(extendsBound, superBound);
    }

    public boolean isAssignable(TypeMirror t1, TypeMirror t2) {
        return this.typeUtils.isAssignable(t1, t2);
    }

    public boolean isSubsignature(ExecutableType m1, ExecutableType m2) {
        return this.typeUtils.isSubsignature(m1, m2);
    }

    public boolean isSubtype(TypeMirror t1, TypeMirror t2) {
        return this.isSubtypeInternal(this.resolveIfErrorType(t1), this.resolveIfErrorType(t2));
    }

    private boolean isSubtypeInternal(TypeMirror t1, TypeMirror t2) {
        boolean _xifexpression = false;
        _xifexpression = t1 instanceof GenTypeMirror || t2 instanceof GenTypeMirror ? this.isSameType(t1, t2) || this.isDeclared(t1) && this.isDeclared(t2) && this.isSubtypeInternal(this.typesRegistry.asTypeElement(t1).getSuperclass(), t2) : this.typeUtils.isSubtype(t1, t2);
        return _xifexpression;
    }

    public PrimitiveType unboxedType(TypeMirror t) {
        return this.typeUtils.unboxedType(t);
    }

    private TypeMirror resolveIfErrorType(TypeMirror t) {
        boolean _equals;
        TypeMirror _xifexpression = null;
        TypeKind _kind = null;
        if (t != null) {
            _kind = t.getKind();
        }
        _xifexpression = (_equals = Objects.equal((Object)((Object)_kind), (Object)((Object)TypeKind.ERROR))) ? this.typesRegistry.asTypeElement(t).asType() : t;
        return _xifexpression;
    }

    public TypeMirror getTypeArg(TypeMirror type, int argIndex) {
        if (type instanceof DeclaredType) {
            return this._getTypeArg((DeclaredType)type, argIndex);
        }
        if (type != null) {
            return this._getTypeArg(type, argIndex);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type, argIndex).toString());
    }

    public TypeMirror erasure(TypeMirror type) {
        if (type instanceof GenDeclaredType) {
            return this._erasure((GenDeclaredType)type);
        }
        if (type != null) {
            return this._erasure(type);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type).toString());
    }
}

