/*
 * Decompiled with CFR 0.152.
 */
package de.japkit.services;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import de.japkit.annotations.Generated;
import de.japkit.model.GenAnnotationMirror;
import de.japkit.model.GenAnnotationValue;
import de.japkit.model.GenDeclaredType;
import de.japkit.model.GenTypeElement;
import de.japkit.model.GenTypeMirror;
import de.japkit.model.GenUnresolvedType;
import de.japkit.model.GenUnresolvedTypeElement;
import de.japkit.services.ElementsExtensions;
import de.japkit.services.ExtensionRegistry;
import de.japkit.services.GenerateClassContext;
import de.japkit.services.MessageCollector;
import de.japkit.services.TypeElementFromCompilerCache;
import de.japkit.services.TypeElementNotFoundException;
import de.japkit.util.MoreCollectionExtensions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import javax.tools.StandardLocation;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.StrongConnectivityInspector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class TypesRegistry {
    @Extension
    private final transient Types _types = ExtensionRegistry.get(Types.class);
    @Extension
    private final transient ProcessingEnvironment _processingEnvironment = ExtensionRegistry.get(ProcessingEnvironment.class);
    private final MessageCollector messageCollector = ExtensionRegistry.get(MessageCollector.class);
    @Extension
    private final transient GenerateClassContext _generateClassContext = ExtensionRegistry.get(GenerateClassContext.class);
    private final TypeElementFromCompilerCache typeElementCache = ExtensionRegistry.get(TypeElementFromCompilerCache.class);
    private final Map<String, List<Pair<String, Boolean>>> allAnnotatedClasses = CollectionLiterals.newHashMap();
    private final Map<Pair<String, Boolean>, Set<String>> allAnnotatedClassesByTrigger = CollectionLiterals.newHashMap();
    private final Map<String, Set<String>> annotatedClassesThatDependOnThatType = CollectionLiterals.newHashMap();
    private final Map<String, Set<Pair<String, String>>> typesOnWhichThatAnnotatedClassDependsOn = CollectionLiterals.newHashMap();
    private final Map<String, String> annotatedClassForGenTypeElement = CollectionLiterals.newHashMap();
    private final Map<String, GenTypeElement> genTypeElementInCurrentRoundByFqn = CollectionLiterals.newHashMap();
    private final Map<String, String> typeElementSimpleNameToFqn = CollectionLiterals.newHashMap();
    private final Set<String> commitedGenTypeElements = CollectionLiterals.newHashSet();
    @Accessors
    private boolean throwTypeElementNotFoundExceptionWhenResolvingSimpleTypeNames = true;
    private boolean returnUncommitedGenTypes = false;
    private final Map<Pair<String, Boolean>, Set<String>> genericTriggerDependencies = CollectionLiterals.newHashMap();
    private final Multimap<GenTypeElement, String> typesNotFoundInGenClass = HashMultimap.create();
    private final Map<String, Set<String>> metaTypeElementsToTriggerAnnotations = CollectionLiterals.newHashMap();

    public TypesRegistry() {
        this.load();
    }

    public String getGenAnnotationFqn() {
        return Generated.class.getName();
    }

    public void markAsGenerated(GenTypeElement typeElement, TypeElement original) {
        TypeMirror _asType = this.typeElementCache.getTypeElement(this.getGenAnnotationFqn()).asType();
        GenAnnotationMirror _genAnnotationMirror = new GenAnnotationMirror((DeclaredType)_asType);
        Procedures.Procedure1 _function = it -> {
            String _string = original.getQualifiedName().toString();
            GenAnnotationValue _genAnnotationValue = new GenAnnotationValue(_string);
            it.setValue("src", _genAnnotationValue);
        };
        GenAnnotationMirror genAnno = (GenAnnotationMirror)ObjectExtensions.operator_doubleArrow((Object)_genAnnotationMirror, (Procedures.Procedure1)_function);
        typeElement.addAnnotationMirror(genAnno);
    }

    public boolean isGenerated(TypeElement typeElement) {
        return typeElement instanceof GenTypeElement || typeElement instanceof GenUnresolvedTypeElement || this.findGenAnnotation(typeElement) != null;
    }

    public AnnotationMirror findGenAnnotation(TypeElement typeElement) {
        AnnotationMirror _xblockexpression = null;
        ElementsExtensions ElementsExtensions2 = ExtensionRegistry.get(ElementsExtensions.class);
        _xblockexpression = ElementsExtensions2.annotationMirror((Element)typeElement, this.getGenAnnotationFqn());
        return _xblockexpression;
    }

    public TypeElement getAnnotatedClassForGenClassOnDisk(TypeElement typeElement) {
        TypeElement _xblockexpression = null;
        AnnotationMirror am = this.findGenAnnotation(typeElement);
        if (am == null) {
            return null;
        }
        ElementsExtensions ElementsExtensions2 = ExtensionRegistry.get(ElementsExtensions.class);
        String fqn = ElementsExtensions2.value(am, "src", String.class);
        _xblockexpression = this.typeElementCache.getTypeElement(fqn);
        return _xblockexpression;
    }

    public void clearCaches() {
        this.typesNotFoundInGenClass.clear();
    }

    public void persist() {
        this.persistAnnotatedClasses();
        this.persistGenericDependencies();
        Functions.Function2 _function = (k, v) -> Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{k, v}));
        this.persistMultiMap(this.metaTypeElementsToTriggerAnnotations, ".japkitMetaDependencies", _function);
    }

    public void load() {
        this.loadAnnotatedClasses();
        this.loadGenericDependencies();
        Functions.Function1 _function = line -> {
            String _get = (String)line.get(0);
            String _get_1 = (String)line.get(1);
            return Pair.of((Object)_get, (Object)_get_1);
        };
        this.loadMultiMap(this.metaTypeElementsToTriggerAnnotations, ".japkitMetaDependencies", _function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAnnotatedClasses() {
        try {
            Writer _openWriter = this._processingEnvironment.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", ".japkitClasses", new Element[0]).openWriter();
            try (BufferedWriter writer = new BufferedWriter(_openWriter);){
                BiConsumer<String, List> _function = (ac, triggers) -> {
                    Consumer<Pair> _function_1 = trigger -> {
                        try {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append(ac);
                            _builder.append(",");
                            String _key = (String)trigger.getKey();
                            _builder.append(_key);
                            _builder.append(",");
                            Boolean _value = (Boolean)trigger.getValue();
                            _builder.append((Object)_value);
                            writer.append((CharSequence)_builder);
                            writer.newLine();
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    };
                    triggers.forEach(_function_1);
                };
                this.allAnnotatedClasses.forEach(_function);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAnnotatedClasses() {
        block11: {
            try {
                BufferedReader reader = null;
                this.allAnnotatedClasses.clear();
                this.allAnnotatedClassesByTrigger.clear();
                try {
                    BufferedReader _bufferedReader;
                    Reader _openReader = this._processingEnvironment.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "", ".japkitClasses").openReader(true);
                    reader = _bufferedReader = new BufferedReader(_openReader);
                    String[] line = null;
                    do {
                        String _readLine = reader.readLine();
                        String[] _split = null;
                        if (_readLine != null) {
                            _split = _readLine.split(",");
                        }
                        if ((line = _split) == null) continue;
                        String acFqn = line[0];
                        String _get = line[1];
                        Boolean _valueOf = Boolean.valueOf(line[2]);
                        Pair trigger = Pair.of((Object)_get, (Object)_valueOf);
                        MoreCollectionExtensions.getOrCreateList(this.allAnnotatedClasses, acFqn).add((Pair<String, Boolean>)trigger);
                        MoreCollectionExtensions.getOrCreateSet(this.allAnnotatedClassesByTrigger, trigger).add(acFqn);
                    } while (line != null);
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception e = (Exception)_t;
                        Functions.Function1 _function = it -> {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append("Loading .japkitClasses failed: ");
                            _builder.append((Object)e);
                            return _builder.toString();
                        };
                        ExtensionRegistry.get(MessageCollector.class).printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function);
                        break block11;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistGenericDependencies() {
        try {
            Writer _openWriter = this._processingEnvironment.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", ".japkitGenericDependencies", new Element[0]).openWriter();
            try (BufferedWriter writer = new BufferedWriter(_openWriter);){
                BiConsumer<Pair, Set> _function = (trigger, annotatedClasses) -> {
                    Consumer<String> _function_1 = ac -> {
                        try {
                            StringConcatenation _builder = new StringConcatenation();
                            String _key = (String)trigger.getKey();
                            _builder.append(_key);
                            _builder.append(",");
                            Boolean _value = (Boolean)trigger.getValue();
                            _builder.append((Object)_value);
                            _builder.append(",");
                            _builder.append(ac);
                            writer.append((CharSequence)_builder);
                            writer.newLine();
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    };
                    annotatedClasses.forEach(_function_1);
                };
                this.genericTriggerDependencies.forEach(_function);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGenericDependencies() {
        block11: {
            try {
                this.genericTriggerDependencies.clear();
                try (BufferedReader reader = null;){
                    BufferedReader _bufferedReader;
                    Reader _openReader = this._processingEnvironment.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "", ".japkitGenericDependencies").openReader(true);
                    reader = _bufferedReader = new BufferedReader(_openReader);
                    String[] line = null;
                    do {
                        String _readLine = reader.readLine();
                        String[] _split = null;
                        if (_readLine != null) {
                            _split = _readLine.split(",");
                        }
                        if ((line = _split) == null) continue;
                        String triggerFqn = line[0];
                        Boolean shadow = Boolean.valueOf(line[1]);
                        Pair _mappedTo = Pair.of((Object)triggerFqn, (Object)shadow);
                        MoreCollectionExtensions.getOrCreateSet(this.genericTriggerDependencies, _mappedTo).add(line[2]);
                    } while (line != null);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    public void registerAnnotatedClass(TypeElement annotatedClass, List<Pair<AnnotationMirror, Boolean>> triggers) {
        Functions.Function1 _function = trigger -> {
            Element _asElement = ((AnnotationMirror)trigger.getKey()).getAnnotationType().asElement();
            String _string = ((TypeElement)_asElement).getQualifiedName().toString();
            Boolean _value = (Boolean)trigger.getValue();
            return Pair.of((Object)_string, (Object)_value);
        };
        List triggerFqns = ListExtensions.map(triggers, (Functions.Function1)_function);
        String acFqn = annotatedClass.getQualifiedName().toString();
        this.allAnnotatedClasses.put(acFqn, triggerFqns);
        Consumer<Pair> _function_1 = it -> MoreCollectionExtensions.getOrCreateSet(this.allAnnotatedClassesByTrigger, it).add(acFqn);
        triggerFqns.forEach(_function_1);
    }

    public Map<String, GenTypeElement> getTypeElementInCurrentRoundByFqn() {
        return ImmutableMap.copyOf(this.genTypeElementInCurrentRoundByFqn);
    }

    public Set<String> annotatedClassesOnWhichThatOneDependsOn(String annotatedClassFqn) {
        Functions.Function1 _function = it -> this.annotatedClassForGenTypeElement.get(it);
        Functions.Function1 _function_1 = it -> it != null && !it.equals(annotatedClassFqn);
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map(this.getTypesOnWhichThatAnnotatedClassDependsOn(annotatedClassFqn), (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    public Iterable<Set<String>> findCyclesInAnnotatedClasses(Set<String> annotatedClasses) {
        Iterable _xblockexpression = null;
        DefaultDirectedGraph g = new DefaultDirectedGraph(DefaultEdge.class);
        Consumer<String> _function = it -> g.addVertex(it);
        annotatedClasses.forEach(_function);
        Consumer<String> _function_1 = v1 -> {
            Functions.Function1 _function_2 = it -> annotatedClasses.contains(it);
            Consumer<String> _function_3 = v2 -> g.addEdge(v1, v2);
            IterableExtensions.filter(this.annotatedClassesOnWhichThatOneDependsOn((String)v1), (Functions.Function1)_function_2).forEach(_function_3);
        };
        annotatedClasses.forEach(_function_1);
        StrongConnectivityInspector ci = new StrongConnectivityInspector((DirectedGraph)g);
        Functions.Function1 _function_2 = it -> {
            boolean _greaterThan;
            boolean _or = false;
            int _size = it.size();
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                _or = true;
            } else {
                boolean _equals;
                boolean _and = false;
                int _size_1 = it.size();
                boolean bl2 = _equals = _size_1 == 1;
                if (!_equals) {
                    _and = false;
                } else {
                    boolean _xblockexpression_1 = false;
                    String v = (String)IterableExtensions.head((Iterable)it);
                    _and = _xblockexpression_1 = g.containsEdge((Object)v, (Object)v);
                }
                _or = _and;
            }
            return _or;
        };
        _xblockexpression = IterableExtensions.filter((Iterable)ci.stronglyConnectedSets(), (Functions.Function1)_function_2);
        return _xblockexpression;
    }

    public boolean dependsOnOtherAnnotatedClasses(String annotatedClassFqn) {
        Functions.Function1 _function = it -> {
            boolean _xblockexpression = false;
            String other = this.annotatedClassForGenTypeElement.get(it);
            _xblockexpression = other != null && !other.equals(annotatedClassFqn);
            return _xblockexpression;
        };
        return IterableExtensions.exists(this.getTypesOnWhichThatAnnotatedClassDependsOn(annotatedClassFqn), (Functions.Function1)_function);
    }

    public boolean dependOnOtherAnnotatedClasses(Set<String> annotatedClassesFqn) {
        Functions.Function1 _function = it -> {
            boolean _containsAll = annotatedClassesFqn.containsAll(this.annotatedClassesOnWhichThatOneDependsOn((String)it));
            return !_containsAll;
        };
        return IterableExtensions.exists(annotatedClassesFqn, (Functions.Function1)_function);
    }

    public Iterable<String> unresolvableTypesOnWhichThatAnnotatedClassDependsOn(String annotatedClassFqn, boolean ignoreUnknownTypes) {
        Functions.Function1 _function = it -> {
            boolean _xifexpression = false;
            boolean _equals = Objects.equal((Object)it, (Object)"<unknown>");
            _xifexpression = _equals ? !ignoreUnknownTypes : !this.annotatedClassForGenTypeElement.containsKey(it) && this._processingEnvironment.getElementUtils().getTypeElement((CharSequence)it) == null;
            return _xifexpression;
        };
        return IterableExtensions.filter(this.getTypesOnWhichThatAnnotatedClassDependsOn(annotatedClassFqn), (Functions.Function1)_function);
    }

    public boolean dependsOnUnknownTypes(CharSequence annotatedClassFqn) {
        return this.getTypesOnWhichThatAnnotatedClassDependsOn(annotatedClassFqn).contains("<unknown>");
    }

    public boolean dependsOnUnknownTypes(CharSequence annotatedClassFqn, CharSequence genClassFqn) {
        Set _emptySet;
        Set _elvis = null;
        Set _get = this.typesOnWhichThatAnnotatedClassDependsOn.get(annotatedClassFqn);
        _elvis = _get != null ? _get : (_emptySet = CollectionLiterals.emptySet());
        Functions.Function1 _function = it -> Objects.equal((Object)it.getValue(), (Object)"<unknown>") && (StringExtensions.isNullOrEmpty((String)((String)it.getKey())) || Objects.equal((Object)it.getKey(), (Object)genClassFqn) || ((String)it.getKey()).startsWith(genClassFqn + "."));
        return IterableExtensions.exists((Iterable)_elvis, (Functions.Function1)_function);
    }

    public boolean dependOnUnknownTypes(Set<String> annotatedClassesFqn) {
        Functions.Function1 _function = it -> this.dependsOnUnknownTypes((CharSequence)it);
        return IterableExtensions.exists(annotatedClassesFqn, (Functions.Function1)_function);
    }

    public void registerGeneratedTypeElement(GenTypeElement genTypeElement) {
        this.registerGeneratedTypeElement(genTypeElement, this._generateClassContext.currentAnnotatedClass(), this._generateClassContext.getCurrentTriggerAnnotation());
    }

    public void registerGeneratedTypeElement(GenTypeElement genTypeElement, TypeElement annotatedClass, AnnotationMirror trigger) {
        String genTypeFqn = genTypeElement.getQualifiedName().toString();
        String genTypeSimpleName = this.getSimpleOrPartiallyQualifiedName(genTypeElement).toString();
        String acFqn = annotatedClass.getQualifiedName().toString();
        this.annotatedClassForGenTypeElement.put(genTypeFqn, acFqn);
        Functions.Function1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Register generated Type Element ");
            _builder.append(genTypeFqn);
            _builder.append(" ");
            _builder.append((Object)genTypeElement);
            _builder.append(".");
            return _builder.toString();
        };
        this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function);
        this.genTypeElementInCurrentRoundByFqn.put(genTypeFqn, genTypeElement);
        String exisitingFqn = this.typeElementSimpleNameToFqn.get(genTypeSimpleName);
        if (exisitingFqn != null && !exisitingFqn.equals(genTypeFqn)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The simple names of generated classes must be unique. Found ");
            _builder.append(exisitingFqn);
            _builder.append(" and ");
            _builder.append(genTypeFqn);
            this.messageCollector.reportRuleError(_builder);
        } else if (exisitingFqn == null) {
            Functions.Function1 _function_1 = it -> {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Register fqn for simple name: ");
                _builder_1.append(genTypeSimpleName);
                _builder_1.append(" -> ");
                _builder_1.append(genTypeFqn);
                return _builder_1.toString();
            };
            this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_1);
            this.typeElementSimpleNameToFqn.put(genTypeSimpleName, genTypeFqn);
        }
        this.rectifyTypeDependencies(genTypeSimpleName, genTypeFqn);
        if (trigger != null) {
            Pair _mappedTo = Pair.of((Object)trigger, (Object)true);
            this.registerAnnotatedClass(genTypeElement, Collections.singletonList(_mappedTo));
            String triggerFqn = this.asTypeElement(trigger.getAnnotationType()).getQualifiedName().toString();
            Pair _mappedTo_1 = Pair.of((Object)triggerFqn, (Object)true);
            Set<String> _get = this.genericTriggerDependencies.get(_mappedTo_1);
            if (_get != null) {
                Consumer<String> _function_2 = it -> {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Generic dependency on trigger annotation ");
                    _builder_1.append(triggerFqn);
                    this.registerTypeDependencyForAnnotatedClassByFqn((String)it, genTypeFqn, (CharSequence)_builder_1);
                };
                _get.forEach(_function_2);
            }
        }
    }

    protected CharSequence _getSimpleOrPartiallyQualifiedName(TypeElement typeElement) {
        Name _xblockexpression = null;
        Element _enclosingElement = typeElement.getEnclosingElement();
        CharSequence _simpleOrPartiallyQualifiedName = null;
        if (_enclosingElement != null) {
            _simpleOrPartiallyQualifiedName = this.getSimpleOrPartiallyQualifiedName(_enclosingElement);
        }
        CharSequence enclosingName = _simpleOrPartiallyQualifiedName;
        Name _xifexpression = null;
        if (enclosingName != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)enclosingName);
            _builder.append(".");
            Name _simpleName = typeElement.getSimpleName();
            _builder.append((Object)_simpleName);
            _xifexpression = _builder;
        } else {
            _xifexpression = typeElement.getSimpleName();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected CharSequence _getSimpleOrPartiallyQualifiedName(Element element) {
        return null;
    }

    protected String _tryToGetFqnForErrorType(GenDeclaredType errorType) {
        return errorType.qualifiedName();
    }

    protected String _tryToGetFqnForErrorType(TypeMirror errorType) {
        return this.tryToGetFqnForErrorTypeSimpleName(this.getSimpleNameForErrorType(errorType));
    }

    protected String _getSimpleNameForErrorType(GenDeclaredType errorType) {
        return errorType.simpleName();
    }

    protected String _getSimpleNameForErrorType(TypeMirror errorType) {
        return this.guessTypeNameFromToString(errorType);
    }

    public String guessTypeNameFromToString(TypeMirror errorType) {
        String _xblockexpression = null;
        String name = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)errorType.toString().trim().split("\\s+"))));
        String _xifexpression = null;
        boolean _startsWith = name.startsWith("<any?>.");
        _xifexpression = _startsWith ? name.substring(7) : name;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String tryToGetFqnForErrorTypeSimpleName(String simpleName) {
        String _xblockexpression = null;
        String fqn = this.typeElementSimpleNameToFqn.get(simpleName);
        if (fqn == null) {
            if (this.throwTypeElementNotFoundExceptionWhenResolvingSimpleTypeNames) {
                throw new TypeElementNotFoundException(simpleName);
            }
            return simpleName;
        }
        _xblockexpression = fqn;
        return _xblockexpression;
    }

    private void rectifyTypeDependencies(String genTypeSimpleName, String genTypeFqn) {
        boolean _not;
        Set _emptySet_1;
        Set _emptySet;
        HashSet annotatedClasses = CollectionLiterals.newHashSet();
        Set _elvis = null;
        Set _remove = this.annotatedClassesThatDependOnThatType.remove(genTypeSimpleName);
        _elvis = _remove != null ? _remove : (_emptySet = CollectionLiterals.emptySet());
        Iterables.addAll((Collection)annotatedClasses, (Iterable)_elvis);
        Set _elvis_1 = null;
        Set _remove_1 = this.annotatedClassesThatDependOnThatType.remove(genTypeFqn);
        _elvis_1 = _remove_1 != null ? _remove_1 : (_emptySet_1 = CollectionLiterals.emptySet());
        annotatedClasses.addAll(_elvis_1);
        boolean _isEmpty = annotatedClasses.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            this.annotatedClassesThatDependOnThatType.put(genTypeFqn, annotatedClasses);
            Consumer<String> _function = it -> {
                Set<Pair<String, String>> dependentTypes = this.typesOnWhichThatAnnotatedClassDependsOn.get(it);
                if (dependentTypes != null) {
                    Functions.Function1 _function_1 = it_1 -> {
                        String _value = (String)it_1.getValue();
                        return Objects.equal((Object)_value, (Object)genTypeSimpleName);
                    };
                    Set simpleTypeNameDependencies = IterableExtensions.toSet((Iterable)IterableExtensions.filter(dependentTypes, (Functions.Function1)_function_1));
                    Functions.Function1 _function_2 = it_1 -> {
                        String _key = (String)it_1.getKey();
                        return Pair.of((Object)_key, (Object)genTypeFqn);
                    };
                    Iterables.addAll(dependentTypes, (Iterable)IterableExtensions.map((Iterable)simpleTypeNameDependencies, (Functions.Function1)_function_2));
                    dependentTypes.removeAll(simpleTypeNameDependencies);
                }
            };
            annotatedClasses.forEach(_function);
        }
    }

    public void commitGeneratedTypeElement(GenTypeElement genTypeElement) {
        Functions.Function1 _function;
        Set _emptySet;
        String typeFqn = genTypeElement.getQualifiedName().toString();
        Set _elvis = null;
        Set _remove = this.annotatedClassesThatDependOnThatType.remove(typeFqn);
        _elvis = _remove != null ? _remove : (_emptySet = CollectionLiterals.emptySet());
        Set annotatedClasses = _elvis;
        Iterable _map = IterableExtensions.map((Iterable)annotatedClasses, (Functions.Function1)(_function = it -> this.typesOnWhichThatAnnotatedClassDependsOn.get(it)));
        if (_map != null) {
            Consumer<Set> _function_1 = it -> {
                Functions.Function1 _function_2 = it_1 -> Objects.equal((Object)it_1.getValue(), (Object)typeFqn) || Objects.equal((Object)it_1.getValue(), (Object)genTypeElement.getSimpleName());
                Set dependenciesOnType = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)it, (Functions.Function1)_function_2));
                it.removeAll(dependenciesOnType);
            };
            _map.forEach(_function_1);
        }
        this.commitedGenTypeElements.add(typeFqn);
        Consumer<GenTypeElement> _function_2 = it -> this.commitGeneratedTypeElement((GenTypeElement)it);
        MoreCollectionExtensions.filterInstanceOf(genTypeElement.getEnclosedElements(), GenTypeElement.class).forEach(_function_2);
    }

    public void removeDependenciesForAnnotatedClass(String annotatedClassFqn) {
        Set types;
        Set<Pair<String, String>> _remove = this.typesOnWhichThatAnnotatedClassDependsOn.remove(annotatedClassFqn);
        Iterable _map = null;
        if (_remove != null) {
            Functions.Function1 _function = it -> (String)it.getValue();
            _map = IterableExtensions.map(_remove, (Functions.Function1)_function);
        }
        Set _set = null;
        if (_map != null) {
            _set = IterableExtensions.toSet((Iterable)_map);
        }
        if ((types = _set) != null) {
            Consumer<String> _function_1 = it -> {
                Set<String> ac = this.annotatedClassesThatDependOnThatType.get(it);
                if (ac != null) {
                    ac.remove(annotatedClassFqn);
                    boolean _isEmpty = ac.isEmpty();
                    if (_isEmpty) {
                        this.annotatedClassesThatDependOnThatType.remove(it);
                    }
                }
            };
            types.forEach(_function_1);
        }
    }

    public boolean isCommitted(TypeElement typeElement) {
        return this.commitedGenTypeElements.contains(typeElement.getQualifiedName().toString());
    }

    public boolean isCommitted(String fqn) {
        return this.commitedGenTypeElements.contains(fqn);
    }

    public Set<String> getAnnotatedClassesThatDependentOn(TypeElement type) {
        Set _emptySet_1;
        Set _emptySet;
        HashSet _xblockexpression = null;
        String fqn = type.getQualifiedName().toString();
        HashSet result = CollectionLiterals.newHashSet();
        Set _elvis = null;
        Set _get = this.annotatedClassesThatDependOnThatType.get(fqn);
        _elvis = _get != null ? _get : (_emptySet = CollectionLiterals.emptySet());
        Iterables.addAll((Collection)result, (Iterable)_elvis);
        Set _elvis_1 = null;
        Set _get_1 = this.annotatedClassesThatDependOnThatType.get(type.getSimpleName().toString());
        _elvis_1 = _get_1 != null ? _get_1 : (_emptySet_1 = CollectionLiterals.emptySet());
        result.addAll(_elvis_1);
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected void _registerTypeDependencyForAnnotatedClass(TypeElement annotatedClass, DeclaredType type) {
        if (type == null || !Objects.equal((Object)((Object)type.getKind()), (Object)((Object)TypeKind.DECLARED)) && !Objects.equal((Object)((Object)type.getKind()), (Object)((Object)TypeKind.ERROR))) {
            return;
        }
        Consumer<TypeMirror> _function = it -> this.registerTypeDependencyForAnnotatedClass(annotatedClass, (TypeMirror)it);
        type.getTypeArguments().forEach(_function);
        TypeMirror rawType = this.erasure(type);
        try {
            TypeElement typeElement = this.asTypeElement(rawType);
            String typeFqn = typeElement.getQualifiedName().toString();
            String annotatedClassFqn = annotatedClass.getQualifiedName().toString();
            if (typeFqn.startsWith("java") || typeFqn.equals(annotatedClassFqn) || !this.isGenerated(typeElement) || Objects.equal((Object)typeElement, (Object)this._generateClassContext.getCurrentGeneratedClass()) || this._generateClassContext.getCurrentGeneratedClass() != null && typeFqn.startsWith(this._generateClassContext.getCurrentGeneratedClass().getQualifiedName() + ".") || this.isCommitted(typeElement)) {
                return;
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The type element for ");
            _builder.append((Object)type);
            _builder.append(" already existes but might be re-generated during incremental build.");
            this.registerTypeDependencyForAnnotatedClassByFqn(annotatedClassFqn, typeFqn, (CharSequence)_builder);
        }
        catch (Throwable _t) {
            if (_t instanceof TypeElementNotFoundException) {
                TypeElementNotFoundException e = (TypeElementNotFoundException)_t;
                String _string = annotatedClass.getQualifiedName().toString();
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("TypeElement for ");
                _builder_1.append((Object)type);
                _builder_1.append(" not found. Using ");
                String _fqn = e.getFqn();
                _builder_1.append(_fqn);
                _builder_1.append(" as short name or fqn for dependency registration.");
                this.registerTypeDependencyForAnnotatedClassByFqn(_string, e.getFqn(), (CharSequence)_builder_1);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected void _registerTypeDependencyForAnnotatedClass(TypeElement annotatedClass, TypeMirror type) {
    }

    public void registerTypeDependencyForCurrentAnnotatedClass(TypeMirror type) {
        boolean _tripleNotEquals;
        TypeElement _currentAnnotatedClass = this._generateClassContext.currentAnnotatedClass();
        boolean bl = _tripleNotEquals = _currentAnnotatedClass != null;
        if (_tripleNotEquals) {
            this.registerTypeDependencyForAnnotatedClass(this._generateClassContext.currentAnnotatedClass(), type);
        }
    }

    private TypeMirror _erasure(GenDeclaredType type) {
        return type.erasure();
    }

    private TypeMirror _erasure(GenTypeMirror type) {
        return type;
    }

    private TypeMirror _erasure(TypeMirror type) {
        return this._processingEnvironment.getTypeUtils().erasure(type);
    }

    private void registerTypeDependencyForAnnotatedClassByFqn(String annotatedClassFqn, String typeFqnOrSimpleName, CharSequence causeMsg) {
        Pair _mappedTo;
        String _elvis = null;
        String _get = this.typeElementSimpleNameToFqn.get(typeFqnOrSimpleName);
        _elvis = _get != null ? _get : typeFqnOrSimpleName;
        String typeFqn = _elvis;
        MoreCollectionExtensions.getOrCreateSet(this.annotatedClassesThatDependOnThatType, typeFqn).add(annotatedClassFqn);
        GenTypeElement _currentGeneratedClass = this._generateClassContext.getCurrentGeneratedClass();
        Name _qualifiedName = null;
        if (_currentGeneratedClass != null) {
            _qualifiedName = _currentGeneratedClass.getQualifiedName();
        }
        String _string = null;
        if (_qualifiedName != null) {
            _string = _qualifiedName.toString();
        }
        String genClassFqn = _string;
        Set<Pair<String, String>> _orCreateSet = MoreCollectionExtensions.getOrCreateSet(this.typesOnWhichThatAnnotatedClassDependsOn, annotatedClassFqn);
        boolean isNewDependency = _orCreateSet.add((Pair<String, String>)(_mappedTo = Pair.of((Object)genClassFqn, (Object)typeFqn)));
        if (isNewDependency) {
            Functions.Function1 _function = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Registered dependency from ");
                _builder.append(annotatedClassFqn);
                _builder.append(" to ");
                _builder.append(typeFqn);
                _builder.append(". Generated class: ");
                _builder.append(genClassFqn);
                _builder.append(". Details: ");
                _builder.append((Object)causeMsg);
                return _builder.toString();
            };
            this.messageCollector.printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function);
        }
    }

    public boolean hasUnresolvedTypeDependencies(String annotatedClassFqn, Set<String> annotatedClassesInSameCycle) {
        boolean _xblockexpression = false;
        Set<String> dependsOn = this.getTypesOnWhichThatAnnotatedClassDependsOn(annotatedClassFqn);
        Functions.Function1 _function = it -> {
            boolean _notEquals;
            boolean _xblockexpression_1 = false;
            String annotatedClassForType = this.annotatedClassForGenTypeElement.get(it);
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)annotatedClassForType, (Object)annotatedClassFqn);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean _or = false;
                if (annotatedClassForType != null && !annotatedClassesInSameCycle.contains(annotatedClassForType) && this.genTypeElementInCurrentRoundByFqn.containsKey(it)) {
                    _or = true;
                } else {
                    boolean _and_1 = false;
                    if (annotatedClassForType != null && annotatedClassesInSameCycle.contains(annotatedClassForType)) {
                        _and_1 = false;
                    } else {
                        boolean _xblockexpression_2 = false;
                        TypeElement te = this.typeElementCache.getTypeElement((String)it);
                        _and_1 = _xblockexpression_2 = te == null || te.asType().getKind() == TypeKind.ERROR;
                    }
                    _or = _and_1;
                }
                _and = _or;
            }
            _xblockexpression_1 = _and;
            return _xblockexpression_1;
        };
        _xblockexpression = IterableExtensions.exists(dependsOn, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public Set<String> getTypesOnWhichThatAnnotatedClassDependsOn(CharSequence annotatedClassFqn) {
        Functions.Function1 _function = it -> (String)it.getValue();
        return IterableExtensions.toSet((Iterable)IterableExtensions.map(this.getTypesByGenClassOnWhichThatAnnotatedClassDependsOn(annotatedClassFqn), (Functions.Function1)_function));
    }

    public Set<Pair<String, String>> getTypesByGenClassOnWhichThatAnnotatedClassDependsOn(CharSequence annotatedClassFqn) {
        Set _emptySet;
        Set _elvis = null;
        Set _get = this.typesOnWhichThatAnnotatedClassDependsOn.get(annotatedClassFqn.toString());
        _elvis = _get != null ? _get : (_emptySet = CollectionLiterals.emptySet());
        return _elvis;
    }

    public void handleTypeElementNotFound(CharSequence msg, TypeElement annotatedClass, Procedures.Procedure1<? super Object> closure) {
        try {
            closure.apply(null);
        }
        catch (Throwable _t) {
            if (_t instanceof TypeElementNotFoundException) {
                TypeElementNotFoundException e = (TypeElementNotFoundException)_t;
                this.handleTypeElementNotFound(msg, e.getFqn(), annotatedClass);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public <T> T handleTypeElementNotFound(T defaultValue, CharSequence msg, TypeElement annotatedClass, Functions.Function1<? super Object, ? extends T> closure) {
        Object _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = closure.apply(null);
        }
        catch (Throwable _t) {
            if (_t instanceof TypeElementNotFoundException) {
                TypeElementNotFoundException e = (TypeElementNotFoundException)_t;
                this.handleTypeElementNotFound(msg, e.getFqn(), annotatedClass);
                return defaultValue;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return (T)_xtrycatchfinallyexpression;
    }

    public <T> T handleTypeElementNotFound(T defaultValue, CharSequence msg, Functions.Function1<? super Object, ? extends T> closure) {
        T _xblockexpression = null;
        TypeElement annotatedClass = this._generateClassContext.currentAnnotatedClass();
        _xblockexpression = this.handleTypeElementNotFound(defaultValue, msg, annotatedClass, closure);
        return _xblockexpression;
    }

    public void handleTypeElementNotFound(TypeElementNotFoundException e, TypeElement annotatedClass) {
        this.handleTypeElementNotFound((CharSequence)e.getMessage(), e.getFqn(), annotatedClass);
    }

    public void handleTypeElementNotFound(CharSequence msg, String typeFqnOrShortname) {
        this.handleTypeElementNotFound(msg, typeFqnOrShortname, this._generateClassContext.currentAnnotatedClass());
    }

    public void handleTypeElementNotFound(CharSequence msg, String typeFqnOrShortname, TypeElement annotatedClass) {
        if (annotatedClass != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)msg);
            _builder.append(" Missing type: ");
            _builder.append(typeFqnOrShortname);
            String errorMsg = _builder.toString();
            this.registerTypeDependencyForAnnotatedClassByFqn(annotatedClass.getQualifiedName().toString(), typeFqnOrShortname, msg);
            this.messageCollector.reportRuleError(errorMsg);
        }
    }

    public boolean startUsingUncomittedGenTypes() {
        this.returnUncommitedGenTypes = true;
        return true;
    }

    public boolean stopUsingUncommitedGenTypes() {
        this.returnUncommitedGenTypes = false;
        return false;
    }

    public void cleanUpTypesAtEndOfRound() {
        this.genTypeElementInCurrentRoundByFqn.clear();
    }

    public TypeElement asTypeElement(TypeMirror declType) {
        TypeElement _accept = null;
        if (declType != null) {
            abstract class __TypesRegistry_1
            extends SimpleTypeVisitor8<TypeElement, Void> {
                __TypesRegistry_1() {
                }

                public abstract TypeElement visitGenDeclared(GenDeclaredType var1);

                public abstract TypeElement visitGenUnresolvedType(GenUnresolvedType var1);
            }
            __TypesRegistry_1 ___TypesRegistry_1 = new __TypesRegistry_1(){
                {
                }

                @Override
                public TypeElement defaultAction(TypeMirror declType, Void v) {
                    Element _asElement = TypesRegistry.this._types.asElement(declType);
                    return (TypeElement)_asElement;
                }

                @Override
                public TypeElement visitDeclared(DeclaredType declType, Void v) {
                    TypeElement te;
                    TypeElement _xblockexpression_1;
                    TypeElement _xblockexpression = null;
                    if (declType instanceof GenDeclaredType) {
                        return this.visitGenDeclared((GenDeclaredType)declType);
                    }
                    Element e = declType.asElement();
                    TypeElement _xifexpression = null;
                    if (e instanceof TypeElement) {
                        _xblockexpression_1 = null;
                        te = (TypeElement)e;
                        boolean _startsWith = te.getClass().getName().startsWith("org.eclipse.jdt.");
                        if (_startsWith) {
                            te = TypesRegistry.this.typeElementCache.getTypeElement(te.getQualifiedName().toString());
                        }
                        if (te == null) {
                            String _string = TypesRegistry.this.erasure(declType).toString();
                            throw new TypeElementNotFoundException(_string);
                        }
                    } else {
                        String _string = TypesRegistry.this.erasure(declType).toString();
                        throw new TypeElementNotFoundException(_string);
                    }
                    TypeElement _elvis = null;
                    TypeElement _findGenTypeElementForFqn = TypesRegistry.this.findGenTypeElementForFqn(te.getQualifiedName().toString());
                    _elvis = _findGenTypeElementForFqn != null ? _findGenTypeElementForFqn : te;
                    _xifexpression = _xblockexpression_1 = _elvis;
                    _xblockexpression = _xifexpression;
                    return _xblockexpression;
                }

                @Override
                public TypeElement visitGenDeclared(GenDeclaredType genDeclType) {
                    Element _asElement = genDeclType.asElement();
                    return (TypeElement)_asElement;
                }

                @Override
                public TypeElement visitError(ErrorType declType, Void v) {
                    boolean _not;
                    TypeElement _xblockexpression = null;
                    if (declType instanceof GenUnresolvedType) {
                        return this.visitGenUnresolvedType((GenUnresolvedType)declType);
                    }
                    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(declType.getTypeArguments());
                    boolean bl = _not = !_isNullOrEmpty;
                    if (_not) {
                        return TypesRegistry.this.asTypeElement(TypesRegistry.this.erasure(declType));
                    }
                    TypeElement e = TypesRegistry.this.findGenTypeElementForShortName(TypesRegistry.this.getSimpleNameForErrorType(declType));
                    TypeElement _xifexpression = null;
                    if (e == null) {
                        String _simpleNameForErrorType = TypesRegistry.this.getSimpleNameForErrorType(declType);
                        throw new TypeElementNotFoundException(_simpleNameForErrorType);
                    }
                    _xifexpression = e;
                    _xblockexpression = _xifexpression;
                    return _xblockexpression;
                }

                @Override
                public TypeElement visitGenUnresolvedType(GenUnresolvedType genDeclType) {
                    TypeElement te = TypesRegistry.this.findTypeElement(genDeclType.qualifiedName());
                    if (te != null) {
                        return te;
                    }
                    return new GenUnresolvedTypeElement(genDeclType);
                }
            };
            _accept = declType.accept(___TypesRegistry_1, null);
        }
        return _accept;
    }

    public boolean hasGenericDependencyOnTriggerShadowAnnotation(TypeElement annotatedClass, Iterable<AnnotationMirror> triggers) {
        boolean _xblockexpression = false;
        String acFqn = annotatedClass.getQualifiedName().toString();
        Functions.Function1 _function = it -> {
            boolean _xblockexpression_1 = false;
            String triggerFqn = this.asTypeElement(it.getAnnotationType()).getQualifiedName().toString();
            boolean shadow = true;
            _xblockexpression_1 = this.getAnnotatedClassesDependingGenericallyOnThatTriggerAnnotation(triggerFqn, true).contains(acFqn);
            return _xblockexpression_1;
        };
        _xblockexpression = IterableExtensions.exists(triggers, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public Set<String> getAnnotatedClassesDependingGenericallyOnThatTriggerAnnotation(String triggerFqn, boolean shadow) {
        Set _emptySet;
        Set _elvis = null;
        Pair _mappedTo = Pair.of((Object)triggerFqn, (Object)shadow);
        Set _get = this.genericTriggerDependencies.get(_mappedTo);
        _elvis = _get != null ? _get : (_emptySet = CollectionLiterals.emptySet());
        return _elvis;
    }

    public Iterable<TypeElement> getAnnotatedClassesDependingGenericallyOnThatTriggerAnnotations(Iterable<AnnotationMirror> triggers) {
        Iterable _xblockexpression = null;
        HashSet annotatedClasses = CollectionLiterals.newHashSet();
        Functions.Function1 _function = it -> this.asTypeElement(it.getAnnotationType()).getQualifiedName().toString();
        Consumer<String> _function_1 = triggerFqn -> {
            annotatedClasses.addAll(this.getAnnotatedClassesDependingGenericallyOnThatTriggerAnnotation((String)triggerFqn, true));
            annotatedClasses.addAll(this.getAnnotatedClassesDependingGenericallyOnThatTriggerAnnotation((String)triggerFqn, false));
        };
        IterableExtensions.toSet((Iterable)IterableExtensions.map(triggers, (Functions.Function1)_function)).forEach(_function_1);
        Functions.Function1 _function_2 = it -> this.findTypeElement((String)it);
        Functions.Function1 _function_3 = it -> it != null;
        Functions.Function1 _function_4 = it -> {
            TypeKind _kind = it.asType().getKind();
            return _kind != TypeKind.ERROR;
        };
        _xblockexpression = IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)annotatedClasses, (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
        return _xblockexpression;
    }

    public Iterable<TypeElement> findAllTypeElementsWithTriggerAnnotation(String triggerFqn, boolean shadow) {
        return this.findAllTypeElementsWithTriggerAnnotation((String)null, triggerFqn, shadow);
    }

    public Iterable<TypeElement> findAllTypeElementsWithTriggerAnnotation(TypeElement annotatedClass, String triggerFqn, boolean shadow) {
        Iterable<TypeElement> _xblockexpression = null;
        Name _qualifiedName = null;
        if (annotatedClass != null) {
            _qualifiedName = annotatedClass.getQualifiedName();
        }
        String _string = null;
        if (_qualifiedName != null) {
            _string = _qualifiedName.toString();
        }
        String acFqn = _string;
        _xblockexpression = this.findAllTypeElementsWithTriggerAnnotation(acFqn, triggerFqn, shadow);
        return _xblockexpression;
    }

    public Iterable<TypeElement> findAllTypeElementsWithTriggerAnnotation(String clienAnnotatedClassFqn, String triggerFqn, boolean shadow) {
        Set _emptySet;
        Iterable _xblockexpression = null;
        ElementsExtensions ElementsExtensions2 = ExtensionRegistry.get(ElementsExtensions.class);
        Set _elvis = null;
        Pair _mappedTo = Pair.of((Object)triggerFqn, (Object)shadow);
        Set _get = this.allAnnotatedClassesByTrigger.get(_mappedTo);
        _elvis = _get != null ? _get : (_emptySet = CollectionLiterals.emptySet());
        Set typeFqns = _elvis;
        if (clienAnnotatedClassFqn != null) {
            Pair _mappedTo_1 = Pair.of((Object)triggerFqn, (Object)shadow);
            MoreCollectionExtensions.getOrCreateSet(this.genericTriggerDependencies, _mappedTo_1).add(clienAnnotatedClassFqn);
        }
        Functions.Function1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Found types for trigger ");
            _builder.append(triggerFqn);
            _builder.append(", ");
            _builder.append((Object)shadow);
            _builder.append(": ");
            _builder.append((Object)typeFqns);
            return _builder.toString();
        };
        ExtensionRegistry.get(MessageCollector.class).printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function);
        if (clienAnnotatedClassFqn != null) {
            Functions.Function1 _function_1 = it -> {
                TypeElement _findTypeElement = this.findTypeElement((String)it);
                return _findTypeElement == null;
            };
            Consumer<String> _function_2 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Generic dependency on trigger annotation ");
                _builder.append(triggerFqn);
                this.registerTypeDependencyForAnnotatedClassByFqn(clienAnnotatedClassFqn, (String)it, (CharSequence)_builder);
            };
            IterableExtensions.filter((Iterable)typeFqns, (Functions.Function1)_function_1).forEach(_function_2);
        }
        Functions.Function1 _function_3 = it -> this.findTypeElement((String)it);
        Functions.Function1 _function_4 = it -> it != null;
        Functions.Function1 _function_5 = it -> {
            TypeKind _kind = it.asType().getKind();
            return _kind != TypeKind.ERROR;
        };
        Functions.Function1 _function_6 = it -> {
            AnnotationMirror _annotationMirror = ElementsExtensions2.annotationMirror((Element)it, triggerFqn);
            return _annotationMirror != null;
        };
        Iterable elements = IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)typeFqns, (Functions.Function1)_function_3), (Functions.Function1)_function_4), (Functions.Function1)_function_5), (Functions.Function1)_function_6);
        Functions.Function1 _function_7 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Found type elements for trigger ");
            _builder.append(triggerFqn);
            _builder.append(", ");
            _builder.append((Object)shadow);
            _builder.append(": ");
            Functions.Function1 _function_8 = it_1 -> it_1.getQualifiedName();
            Iterable _map = IterableExtensions.map((Iterable)elements, (Functions.Function1)_function_8);
            _builder.append((Object)_map);
            return _builder.toString();
        };
        ExtensionRegistry.get(MessageCollector.class).printDiagnosticMessage((Functions.Function1<? super Object, ? extends CharSequence>)_function_7);
        _xblockexpression = elements;
        return _xblockexpression;
    }

    public TypeElement findTypeElement(String typeFqn) {
        TypeElement _typeElement;
        TypeElement _elvis = null;
        TypeElement _findGenTypeElementForFqn = this.findGenTypeElementForFqn(typeFqn);
        _elvis = _findGenTypeElementForFqn != null ? _findGenTypeElementForFqn : (_typeElement = this.typeElementCache.getTypeElement(typeFqn));
        return _elvis;
    }

    public TypeElement findGenTypeElementForShortName(String shortname) {
        TypeElement _findTypeInCurrentGeneratedClass;
        TypeElement _elvis = null;
        String _get = this.typeElementSimpleNameToFqn.get(shortname);
        TypeElement _findGenTypeElementForFqn = null;
        if (_get != null) {
            _findGenTypeElementForFqn = this.findGenTypeElementForFqn(_get);
        }
        _elvis = _findGenTypeElementForFqn != null ? _findGenTypeElementForFqn : (_findTypeInCurrentGeneratedClass = this.findTypeInCurrentGeneratedClass(shortname));
        return _elvis;
    }

    public TypeElement findGenTypeElementForFqn(String fqn) {
        TypeElement _elvis = null;
        TypeElement _findTypeInCurrentGeneratedClass = this.findTypeInCurrentGeneratedClass(fqn);
        if (_findTypeInCurrentGeneratedClass != null) {
            _elvis = _findTypeInCurrentGeneratedClass;
        } else {
            GenTypeElement _xifexpression = null;
            if (this.returnUncommitedGenTypes || this.isCommitted(fqn)) {
                _xifexpression = this.genTypeElementInCurrentRoundByFqn.get(fqn);
            }
            _elvis = _xifexpression;
        }
        return _elvis;
    }

    protected TypeElement findTypeInCurrentGeneratedClass(String typeFqnOrShortname) {
        GenTypeElement currGenClass = this._generateClassContext.getCurrentGeneratedClass();
        if (currGenClass != null) {
            boolean _contains = this.typesNotFoundInGenClass.get((Object)currGenClass).contains(typeFqnOrShortname);
            if (_contains) {
                return null;
            }
            TypeElement _elvis = null;
            TypeElement _findTypeInGeneratedClass = this.findTypeInGeneratedClass(currGenClass, typeFqnOrShortname);
            if (_findTypeInGeneratedClass != null) {
                _elvis = _findTypeInGeneratedClass;
            } else {
                Set<GenTypeElement> _auxTopLevelClasses = this._generateClassContext.getCurrentPrimaryGenClass().getAuxTopLevelClasses();
                Iterable _map = null;
                if (_auxTopLevelClasses != null) {
                    Functions.Function1 _function = it -> this.findTypeInGeneratedClass((GenTypeElement)it, typeFqnOrShortname);
                    _map = IterableExtensions.map(_auxTopLevelClasses, (Functions.Function1)_function);
                }
                TypeElement _findFirst = null;
                if (_map != null) {
                    Functions.Function1 _function_1 = it -> it != null;
                    _findFirst = (TypeElement)IterableExtensions.findFirst((Iterable)_map, (Functions.Function1)_function_1);
                }
                _elvis = _findFirst;
            }
            TypeElement found = _elvis;
            if (found == null) {
                this.typesNotFoundInGenClass.put((Object)currGenClass, (Object)typeFqnOrShortname);
            }
            return found;
        }
        return null;
    }

    private TypeElement findTypeInGeneratedClass(GenTypeElement genClass, String typeFqnOrShortname) {
        int _length;
        int _plus;
        String[] innerClassPath;
        Element innerClass;
        String genClassFqn = genClass.getQualifiedName().toString();
        if (Objects.equal((Object)typeFqnOrShortname, (Object)genClassFqn) || Objects.equal((Object)typeFqnOrShortname, (Object)genClass.getSimpleName().toString())) {
            return genClass;
        }
        boolean _startsWith = typeFqnOrShortname.startsWith(genClassFqn + ".");
        if (_startsWith && (innerClass = this.findNestedElement(genClass, innerClassPath = typeFqnOrShortname.substring(_plus = (_length = genClassFqn.length()) + 1).split("\\."))) instanceof TypeElement) {
            return (TypeElement)innerClass;
        }
        Element _enclosingElement = genClass.getEnclosingElement();
        if (_enclosingElement instanceof GenTypeElement) {
            Element _enclosingElement_1 = genClass.getEnclosingElement();
            return this.findTypeInGeneratedClass((GenTypeElement)_enclosingElement_1, typeFqnOrShortname);
        }
        return null;
    }

    public Element findNestedElement(Element e, String[] path) {
        Element _xblockexpression = null;
        Element result = e;
        for (String segment : path) {
            Functions.Function1 _function = it -> it.getSimpleName().contentEquals(segment);
            if ((result = (Element)IterableExtensions.findFirst(result.getEnclosedElements(), (Functions.Function1)_function)) != null) continue;
            return null;
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public boolean registerMetaTypeElement(TypeElement rootMetaTypeElement, TypeElement triggerAnnotation) {
        return MoreCollectionExtensions.getOrCreateSet(this.metaTypeElementsToTriggerAnnotations, rootMetaTypeElement.getQualifiedName().toString()).add(triggerAnnotation.getQualifiedName().toString());
    }

    public Set<String> getTriggerAnnotationsForMetaTypeElements(Iterable<TypeElement> metaTypeElements) {
        Functions.Function1 _function = it -> {
            Set _emptySet;
            Set _elvis = null;
            Set _get = this.metaTypeElementsToTriggerAnnotations.get(it.getQualifiedName().toString());
            _elvis = _get != null ? _get : (_emptySet = CollectionLiterals.emptySet());
            return _elvis;
        };
        return IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map(metaTypeElements, (Functions.Function1)_function)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void persistMultiMap(Map<K, Set<V>> map, String fileName, Functions.Function2<? super K, ? super V, ? extends List<String>> lineCreator) {
        try {
            Writer _openWriter = this._processingEnvironment.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", fileName, new Element[0]).openWriter();
            try (BufferedWriter writer = new BufferedWriter(_openWriter);){
                BiConsumer<Object, Set> _function = (k, values) -> {
                    Consumer<Object> _function_1 = v -> {
                        try {
                            writer.append(IterableExtensions.join((Iterable)((Iterable)lineCreator.apply(k, v)), (CharSequence)","));
                            writer.newLine();
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    };
                    values.forEach(_function_1);
                };
                map.forEach(_function);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void loadMultiMap(Map<K, Set<V>> map, String fileName, Functions.Function1<? super List<String>, ? extends Pair<K, V>> lineParser) {
        block11: {
            try {
                map.clear();
                try (BufferedReader reader = null;){
                    BufferedReader _bufferedReader;
                    Reader _openReader = this._processingEnvironment.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "", fileName).openReader(true);
                    reader = _bufferedReader = new BufferedReader(_openReader);
                    String[] line = null;
                    do {
                        String _readLine = reader.readLine();
                        String[] _split = null;
                        if (_readLine != null) {
                            _split = _readLine.split(",");
                        }
                        if ((line = _split) == null) continue;
                        String[] _converted_line = line;
                        Pair keyValue = (Pair)lineParser.apply((Object)((List)Conversions.doWrapArray((Object)_converted_line)));
                        MoreCollectionExtensions.getOrCreateSet(map, keyValue.getKey()).add(keyValue.getValue());
                    } while (line != null);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    public CharSequence getSimpleOrPartiallyQualifiedName(Element typeElement) {
        if (typeElement instanceof TypeElement) {
            return this._getSimpleOrPartiallyQualifiedName((TypeElement)typeElement);
        }
        if (typeElement != null) {
            return this._getSimpleOrPartiallyQualifiedName(typeElement);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(typeElement).toString());
    }

    public String tryToGetFqnForErrorType(TypeMirror errorType) {
        if (errorType instanceof GenDeclaredType) {
            return this._tryToGetFqnForErrorType((GenDeclaredType)errorType);
        }
        if (errorType != null) {
            return this._tryToGetFqnForErrorType(errorType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(errorType).toString());
    }

    public String getSimpleNameForErrorType(TypeMirror errorType) {
        if (errorType instanceof GenDeclaredType) {
            return this._getSimpleNameForErrorType((GenDeclaredType)errorType);
        }
        if (errorType != null) {
            return this._getSimpleNameForErrorType(errorType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(errorType).toString());
    }

    public void registerTypeDependencyForAnnotatedClass(TypeElement annotatedClass, TypeMirror type) {
        if (type instanceof DeclaredType) {
            this._registerTypeDependencyForAnnotatedClass(annotatedClass, (DeclaredType)type);
            return;
        }
        if (type != null) {
            this._registerTypeDependencyForAnnotatedClass(annotatedClass, type);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(annotatedClass, type).toString());
    }

    private TypeMirror erasure(TypeMirror type) {
        if (type instanceof GenDeclaredType) {
            return this._erasure((GenDeclaredType)type);
        }
        if (type instanceof GenTypeMirror) {
            return this._erasure((GenTypeMirror)type);
        }
        if (type != null) {
            return this._erasure(type);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type).toString());
    }

    @Pure
    public boolean isThrowTypeElementNotFoundExceptionWhenResolvingSimpleTypeNames() {
        return this.throwTypeElementNotFoundExceptionWhenResolvingSimpleTypeNames;
    }

    public void setThrowTypeElementNotFoundExceptionWhenResolvingSimpleTypeNames(boolean throwTypeElementNotFoundExceptionWhenResolvingSimpleTypeNames) {
        this.throwTypeElementNotFoundExceptionWhenResolvingSimpleTypeNames = throwTypeElementNotFoundExceptionWhenResolvingSimpleTypeNames;
    }

    private static /* synthetic */ CharSequence lambda$loadMultiMap$60(String fileName, Exception e, Object it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Loading ");
        _builder.append(fileName);
        _builder.append(" failed: ");
        _builder.append((Object)e);
        return _builder.toString();
    }

    private static /* synthetic */ CharSequence lambda$loadGenericDependencies$8(Exception e, Object it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Loading .japkitGenericDependencies failed: ");
        _builder.append((Object)e);
        return _builder.toString();
    }
}

