/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.bean;

import com.github.jarvisframework.tool.core.bean.BeanDesc;
import com.github.jarvisframework.tool.core.bean.BeanDescCache;
import com.github.jarvisframework.tool.core.bean.BeanException;
import com.github.jarvisframework.tool.core.bean.BeanInfoCache;
import com.github.jarvisframework.tool.core.bean.BeanPath;
import com.github.jarvisframework.tool.core.bean.DynaBean;
import com.github.jarvisframework.tool.core.bean.PropDesc;
import com.github.jarvisframework.tool.core.bean.copier.BeanCopier;
import com.github.jarvisframework.tool.core.bean.copier.CopyOptions;
import com.github.jarvisframework.tool.core.bean.copier.ValueProvider;
import com.github.jarvisframework.tool.core.collection.CollectionUtils;
import com.github.jarvisframework.tool.core.convert.Convert;
import com.github.jarvisframework.tool.core.lang.Editor;
import com.github.jarvisframework.tool.core.map.CaseInsensitiveMap;
import com.github.jarvisframework.tool.core.map.MapUtils;
import com.github.jarvisframework.tool.core.util.ArrayUtils;
import com.github.jarvisframework.tool.core.util.ClassUtils;
import com.github.jarvisframework.tool.core.util.ModifierUtils;
import com.github.jarvisframework.tool.core.util.ReflectUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class BeanUtils {
    public static boolean isReadableBean(Class<?> clazz) {
        return BeanUtils.hasGetter(clazz) || BeanUtils.hasPublicField(clazz);
    }

    public static boolean isBean(Class<?> clazz) {
        return BeanUtils.hasSetter(clazz) || BeanUtils.hasPublicField(clazz);
    }

    public static boolean hasSetter(Class<?> clazz) {
        if (ClassUtils.isNormalClass(clazz)) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasGetter(Class<?> clazz) {
        if (ClassUtils.isNormalClass(clazz)) {
            for (Method method : clazz.getMethods()) {
                if (method.getParameterTypes().length != 0 || !method.getName().startsWith("get") && !method.getName().startsWith("is")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPublicField(Class<?> clazz) {
        if (ClassUtils.isNormalClass(clazz)) {
            for (Field field : clazz.getFields()) {
                if (!ModifierUtils.isPublic(field) || ModifierUtils.isStatic(field)) continue;
                return true;
            }
        }
        return false;
    }

    public static DynaBean createDynaBean(Object bean) {
        return new DynaBean(bean);
    }

    public static PropertyEditor findEditor(Class<?> type) {
        return PropertyEditorManager.findEditor(type);
    }

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        return BeanDescCache.INSTANCE.getBeanDesc(clazz, () -> new BeanDesc(clazz));
    }

    public static void descForEach(Class<?> clazz, Consumer<? super PropDesc> action) {
        BeanUtils.getBeanDesc(clazz).getProps().forEach(action);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws BeanException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new BeanException(e);
        }
        return ArrayUtils.filter(beanInfo.getPropertyDescriptors(), t -> false == "class".equals(t.getName()));
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws BeanException {
        return BeanInfoCache.INSTANCE.getPropertyDescriptorMap(clazz, ignoreCase, () -> BeanUtils.internalGetPropertyDescriptorMap(clazz, ignoreCase));
    }

    private static Map<String, PropertyDescriptor> internalGetPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws BeanException {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(clazz);
        CaseInsensitiveMap<String, PropertyDescriptor> map = ignoreCase ? new CaseInsensitiveMap(propertyDescriptors.length, 1.0f) : new HashMap(propertyDescriptors.length, 1.0f);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            map.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return map;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName) throws BeanException {
        return BeanUtils.getPropertyDescriptor(clazz, fieldName, false);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName, boolean ignoreCase) throws BeanException {
        Map<String, PropertyDescriptor> map = BeanUtils.getPropertyDescriptorMap(clazz, ignoreCase);
        return null == map ? null : map.get(fieldName);
    }

    public static Object getFieldValue(Object bean, String fieldNameOrIndex) {
        if (null == bean || null == fieldNameOrIndex) {
            return null;
        }
        if (bean instanceof Map) {
            return ((Map)bean).get(fieldNameOrIndex);
        }
        if (bean instanceof Collection) {
            return CollectionUtils.get((Collection)bean, Integer.parseInt(fieldNameOrIndex));
        }
        if (ArrayUtils.isArray(bean)) {
            return ArrayUtils.get(bean, Integer.parseInt(fieldNameOrIndex));
        }
        return ReflectUtils.getFieldValue(bean, fieldNameOrIndex);
    }

    public static void setFieldValue(Object bean, String fieldNameOrIndex, Object value) {
        if (bean instanceof Map) {
            ((Map)bean).put(fieldNameOrIndex, value);
        } else if (bean instanceof List) {
            CollectionUtils.setOrAppend((List)bean, Convert.toInt(fieldNameOrIndex), value);
        } else if (ArrayUtils.isArray(bean)) {
            ArrayUtils.setOrAppend(bean, (int)Convert.toInt(fieldNameOrIndex), value);
        } else {
            ReflectUtils.setFieldValue(bean, fieldNameOrIndex, value);
        }
    }

    public static <T> T getProperty(Object bean, String expression) {
        return (T)BeanPath.create(expression).get(bean);
    }

    public static void setProperty(Object bean, String expression, Object value) {
        BeanPath.create(expression).set(bean, value);
    }

    @Deprecated
    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtils.fillBeanWithMap(map, ReflectUtils.newInstanceIfPossible(beanClass), isIgnoreError);
    }

    @Deprecated
    public static <T> T mapToBeanIgnoreCase(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtils.fillBeanWithMapIgnoreCase(map, ReflectUtils.newInstanceIfPossible(beanClass), isIgnoreError);
    }

    @Deprecated
    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, CopyOptions copyOptions) {
        return BeanUtils.fillBeanWithMap(map, ReflectUtils.newInstanceIfPossible(beanClass), copyOptions);
    }

    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, boolean isToCamelCase, CopyOptions copyOptions) {
        return BeanUtils.fillBeanWithMap(map, ReflectUtils.newInstanceIfPossible(beanClass), isToCamelCase, copyOptions);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isIgnoreError) {
        return BeanUtils.fillBeanWithMap(map, bean, false, isIgnoreError);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase, boolean isIgnoreError) {
        return BeanUtils.fillBeanWithMap(map, bean, isToCamelCase, CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T fillBeanWithMapIgnoreCase(Map<?, ?> map, T bean, boolean isIgnoreError) {
        return BeanUtils.fillBeanWithMap(map, bean, CopyOptions.create().setIgnoreCase(true).setIgnoreError(isIgnoreError));
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, CopyOptions copyOptions) {
        return BeanUtils.fillBeanWithMap(map, bean, false, copyOptions);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase, CopyOptions copyOptions) {
        if (MapUtils.isEmpty(map)) {
            return bean;
        }
        if (isToCamelCase) {
            map = MapUtils.toCamelCaseMap(map);
        }
        BeanUtils.copyProperties(map, bean, copyOptions);
        return bean;
    }

    public static <T> T toBean(Object source, Class<T> clazz) {
        return BeanUtils.toBean(source, clazz, null);
    }

    public static <T> T toBeanIgnoreError(Object source, Class<T> clazz) {
        return BeanUtils.toBean(source, clazz, CopyOptions.create().setIgnoreError(true));
    }

    public static <T> T toBeanIgnoreCase(Object source, Class<T> clazz, boolean ignoreError) {
        return BeanUtils.toBean(source, clazz, CopyOptions.create().setIgnoreCase(true).setIgnoreError(ignoreError));
    }

    public static <T> T toBean(Object source, Class<T> clazz, CopyOptions options) {
        T target = ReflectUtils.newInstanceIfPossible(clazz);
        BeanUtils.copyProperties(source, target, options);
        return target;
    }

    public static <T> T toBean(Class<T> beanClass, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        return BeanUtils.fillBean(ReflectUtils.newInstanceIfPossible(beanClass), valueProvider, copyOptions);
    }

    public static <T> T fillBean(T bean, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        if (null == valueProvider) {
            return bean;
        }
        return BeanCopier.create(valueProvider, bean, copyOptions).copy();
    }

    public static Map<String, Object> beanToMap(Object bean) {
        return BeanUtils.beanToMap(bean, false, false);
    }

    public static Map<String, Object> beanToMap(Object bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        return BeanUtils.beanToMap(bean, new LinkedHashMap<String, Object>(), isToUnderlineCase, ignoreNullValue);
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (bean == null) {
            return null;
        }
        return BeanUtils.beanToMap(bean, targetMap, ignoreNullValue, key -> isToUnderlineCase ? StringUtils.toUnderlineCase(key) : key);
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean ignoreNullValue, Editor<String> keyEditor) {
        if (bean == null) {
            return null;
        }
        return BeanCopier.create(bean, targetMap, CopyOptions.create().setIgnoreNullValue(ignoreNullValue).setFieldNameEditor(keyEditor)).copy();
    }

    public static <T> T copyProperties(Object source, Class<T> tClass, String ... ignoreProperties) {
        T target = ReflectUtils.newInstanceIfPossible(tClass);
        BeanUtils.copyProperties(source, target, CopyOptions.create().setIgnoreProperties(ignoreProperties));
        return target;
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) {
        BeanUtils.copyProperties(source, target, CopyOptions.create().setIgnoreProperties(ignoreProperties));
    }

    public static void copyProperties(Object source, Object target, boolean ignoreCase) {
        BeanCopier.create(source, target, CopyOptions.create().setIgnoreCase(ignoreCase)).copy();
    }

    public static void copyProperties(Object source, Object target, CopyOptions copyOptions) {
        if (null == copyOptions) {
            copyOptions = new CopyOptions();
        }
        BeanCopier.create(source, target, copyOptions).copy();
    }

    public static boolean isMatchName(Object bean, String beanClassName, boolean isSimple) {
        return ClassUtils.getClassName(bean, isSimple).equals(isSimple ? StringUtils.upperFirst(beanClassName) : beanClassName);
    }

    public static <T> T trimStrFields(T bean, String ... ignoreFields) {
        Field[] fields;
        if (bean == null) {
            return null;
        }
        for (Field field : fields = ReflectUtils.getFields(bean.getClass())) {
            String trimVal;
            String val;
            if (ModifierUtils.isStatic(field) || ignoreFields != null && ArrayUtils.containsIgnoreCase(ignoreFields, field.getName()) || !String.class.equals(field.getType()) || null == (val = (String)ReflectUtils.getFieldValue(bean, field)) || val.equals(trimVal = StringUtils.trim(val))) continue;
            ReflectUtils.setFieldValue(bean, field, (Object)trimVal);
        }
        return bean;
    }

    public static boolean isNotEmpty(Object bean, String ... ignoreFiledNames) {
        return false == BeanUtils.isEmpty(bean, ignoreFiledNames);
    }

    public static boolean isEmpty(Object bean, String ... ignoreFiledNames) {
        if (null != bean) {
            for (Field field : ReflectUtils.getFields(bean.getClass())) {
                if (ModifierUtils.isStatic(field) || ArrayUtils.contains(ignoreFiledNames, field.getName()) || null == ReflectUtils.getFieldValue(bean, field)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasNullField(Object bean, String ... ignoreFiledNames) {
        if (null == bean) {
            return true;
        }
        for (Field field : ReflectUtils.getFields(bean.getClass())) {
            if (ModifierUtils.isStatic(field) || ArrayUtils.contains(ignoreFiledNames, field.getName()) || null != ReflectUtils.getFieldValue(bean, field)) continue;
            return true;
        }
        return false;
    }
}

