/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.bean;

import com.github.jarvisframework.tool.core.annotation.AnnotationUtils;
import com.github.jarvisframework.tool.core.annotation.PropIgnore;
import com.github.jarvisframework.tool.core.bean.BeanException;
import com.github.jarvisframework.tool.core.convert.Convert;
import com.github.jarvisframework.tool.core.util.ClassUtils;
import com.github.jarvisframework.tool.core.util.ModifierUtils;
import com.github.jarvisframework.tool.core.util.ReflectUtils;
import com.github.jarvisframework.tool.core.util.TypeUtils;
import java.beans.Transient;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class PropDesc {
    final Field field;
    protected Method getter;
    protected Method setter;

    public PropDesc(Field field, Method getter, Method setter) {
        this.field = field;
        this.getter = ClassUtils.setAccessible(getter);
        this.setter = ClassUtils.setAccessible(setter);
    }

    public String getFieldName() {
        return ReflectUtils.getFieldName(this.field);
    }

    public String getRawFieldName() {
        return null == this.field ? null : this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public Type getFieldType() {
        if (null != this.field) {
            return TypeUtils.getType(this.field);
        }
        return this.findPropType(this.getter, this.setter);
    }

    public Class<?> getFieldClass() {
        if (null != this.field) {
            return TypeUtils.getClass(this.field);
        }
        return this.findPropClass(this.getter, this.setter);
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public boolean isReadable(boolean checkTransient) {
        if (null == this.getter && !ModifierUtils.isPublic(this.field)) {
            return false;
        }
        if (checkTransient && this.isTransientForGet()) {
            return false;
        }
        return false == this.isIgnoreGet();
    }

    public Object getValue(Object bean) {
        if (null != this.getter) {
            return ReflectUtils.invoke(bean, this.getter, new Object[0]);
        }
        if (ModifierUtils.isPublic(this.field)) {
            return ReflectUtils.getFieldValue(bean, this.field);
        }
        return null;
    }

    public Object getValue(Object bean, Type targetType, boolean ignoreError) {
        Object convertValue;
        Object result;
        block3: {
            result = null;
            try {
                result = this.getValue(bean);
            }
            catch (Exception e) {
                if (ignoreError) break block3;
                throw new BeanException(e, "Get value of [{}] error!", this.getFieldName());
            }
        }
        if (null != result && null != targetType && null != (convertValue = Convert.convertWithCheck(targetType, result, null, ignoreError))) {
            result = convertValue;
        }
        return result;
    }

    public boolean isWritable(boolean checkTransient) {
        if (null == this.setter && !ModifierUtils.isPublic(this.field)) {
            return false;
        }
        if (checkTransient && this.isTransientForSet()) {
            return false;
        }
        return false == this.isIgnoreSet();
    }

    public PropDesc setValue(Object bean, Object value) {
        if (null != this.setter) {
            ReflectUtils.invoke(bean, this.setter, value);
        } else if (ModifierUtils.isPublic(this.field)) {
            ReflectUtils.setFieldValue(bean, this.field, value);
        }
        return this;
    }

    public PropDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError) {
        block5: {
            Class<?> propClass;
            if (ignoreNull && null == value) {
                return this;
            }
            if (null != value && !(propClass = this.getFieldClass()).isInstance(value)) {
                value = Convert.convertWithCheck(propClass, value, null, ignoreError);
            }
            if (null != value || !ignoreNull) {
                try {
                    this.setValue(bean, value);
                }
                catch (Exception e) {
                    if (ignoreError) break block5;
                    throw new BeanException(e, "Set value of [{}] error!", this.getFieldName());
                }
            }
        }
        return this;
    }

    private Type findPropType(Method getter, Method setter) {
        Type type = null;
        if (null != getter) {
            type = TypeUtils.getReturnType(getter);
        }
        if (null == type && null != setter) {
            type = TypeUtils.getParamType(setter, 0);
        }
        return type;
    }

    private Class<?> findPropClass(Method getter, Method setter) {
        Class<?> type = null;
        if (null != getter) {
            type = TypeUtils.getReturnClass(getter);
        }
        if (null == type && null != setter) {
            type = TypeUtils.getFirstParamClass(setter);
        }
        return type;
    }

    private boolean isIgnoreSet() {
        return AnnotationUtils.hasAnnotation(this.field, PropIgnore.class) || AnnotationUtils.hasAnnotation(this.setter, PropIgnore.class);
    }

    private boolean isIgnoreGet() {
        return AnnotationUtils.hasAnnotation(this.field, PropIgnore.class) || AnnotationUtils.hasAnnotation(this.getter, PropIgnore.class);
    }

    private boolean isTransientForGet() {
        boolean isTransient = ModifierUtils.hasModifier(this.field, ModifierUtils.ModifierType.TRANSIENT);
        if (!isTransient && null != this.getter && !(isTransient = ModifierUtils.hasModifier(this.getter, ModifierUtils.ModifierType.TRANSIENT))) {
            isTransient = AnnotationUtils.hasAnnotation(this.getter, Transient.class);
        }
        return isTransient;
    }

    private boolean isTransientForSet() {
        boolean isTransient = ModifierUtils.hasModifier(this.field, ModifierUtils.ModifierType.TRANSIENT);
        if (!isTransient && null != this.setter && !(isTransient = ModifierUtils.hasModifier(this.setter, ModifierUtils.ModifierType.TRANSIENT))) {
            isTransient = AnnotationUtils.hasAnnotation(this.setter, Transient.class);
        }
        return isTransient;
    }
}

