/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.bean.copier;

import com.github.jarvisframework.tool.core.lang.Editor;
import com.github.jarvisframework.tool.core.map.MapUtils;
import com.github.jarvisframework.tool.core.util.ObjectUtils;
import java.io.Serializable;
import java.util.Map;

public class CopyOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Class<?> editable;
    protected boolean ignoreNullValue;
    protected String[] ignoreProperties;
    protected boolean ignoreError;
    protected boolean ignoreCase;
    protected Map<String, String> fieldMapping;
    private Map<String, String> reversedFieldMapping;
    protected Editor<String> fieldNameEditor;
    private boolean transientSupport = true;

    public static CopyOptions create() {
        return new CopyOptions();
    }

    public static CopyOptions create(Class<?> editable, boolean ignoreNullValue, String ... ignoreProperties) {
        return new CopyOptions(editable, ignoreNullValue, ignoreProperties);
    }

    public CopyOptions() {
    }

    public CopyOptions(Class<?> editable, boolean ignoreNullValue, String ... ignoreProperties) {
        this.editable = editable;
        this.ignoreNullValue = ignoreNullValue;
        this.ignoreProperties = ignoreProperties;
    }

    public CopyOptions setEditable(Class<?> editable) {
        this.editable = editable;
        return this;
    }

    public CopyOptions setIgnoreNullValue(boolean ignoreNullVall) {
        this.ignoreNullValue = ignoreNullVall;
        return this;
    }

    public CopyOptions ignoreNullValue() {
        return this.setIgnoreNullValue(true);
    }

    public CopyOptions setIgnoreProperties(String ... ignoreProperties) {
        this.ignoreProperties = ignoreProperties;
        return this;
    }

    public CopyOptions setIgnoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
        return this;
    }

    public CopyOptions ignoreError() {
        return this.setIgnoreError(true);
    }

    public CopyOptions setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    public CopyOptions ignoreCase() {
        return this.setIgnoreCase(true);
    }

    public CopyOptions setFieldMapping(Map<String, String> fieldMapping) {
        this.fieldMapping = fieldMapping;
        return this;
    }

    public CopyOptions setFieldNameEditor(Editor<String> fieldNameEditor) {
        this.fieldNameEditor = fieldNameEditor;
        return this;
    }

    public boolean isTransientSupport() {
        return this.transientSupport;
    }

    public CopyOptions setTransientSupport(boolean transientSupport) {
        this.transientSupport = transientSupport;
        return this;
    }

    protected String getMappedFieldName(String fieldName, boolean reversed) {
        Map<String, String> mapping;
        Map<String, String> map = mapping = reversed ? this.getReversedMapping() : this.fieldMapping;
        if (MapUtils.isEmpty(mapping)) {
            return fieldName;
        }
        return ObjectUtils.defaultIfNull(mapping.get(fieldName), fieldName);
    }

    protected String editFieldName(String fieldName) {
        return null != this.fieldNameEditor ? this.fieldNameEditor.edit(fieldName) : fieldName;
    }

    private Map<String, String> getReversedMapping() {
        if (null == this.fieldMapping) {
            return null;
        }
        if (null == this.reversedFieldMapping) {
            this.reversedFieldMapping = MapUtils.reverse(this.fieldMapping);
        }
        return this.reversedFieldMapping;
    }
}

