/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.bean.copier.provider;

import com.github.jarvisframework.tool.core.bean.copier.ValueProvider;
import com.github.jarvisframework.tool.core.convert.Convert;
import com.github.jarvisframework.tool.core.map.CaseInsensitiveMap;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.lang.reflect.Type;
import java.util.Map;

public class MapValueProvider
implements ValueProvider<String> {
    private final Map<?, ?> map;
    private final boolean ignoreError;

    public MapValueProvider(Map<?, ?> map, boolean ignoreCase) {
        this(map, ignoreCase, false);
    }

    public MapValueProvider(Map<?, ?> map, boolean ignoreCase, boolean ignoreError) {
        this.map = false == ignoreCase || map instanceof CaseInsensitiveMap ? map : new CaseInsensitiveMap(map);
        this.ignoreError = ignoreError;
    }

    @Override
    public Object value(String key, Type valueType) {
        Object value = this.map.get(key);
        if (null == value) {
            value = this.map.get(StringUtils.toUnderlineCase(key));
        }
        return Convert.convertWithCheck(valueType, value, null, this.ignoreError);
    }

    @Override
    public boolean containsKey(String key) {
        if (this.map.containsKey(key)) {
            return true;
        }
        return this.map.containsKey(StringUtils.toUnderlineCase(key));
    }
}

