/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.collection;

import com.github.jarvisframework.tool.core.bean.BeanUtils;
import com.github.jarvisframework.tool.core.collection.ArrayIter;
import com.github.jarvisframework.tool.core.collection.EnumerationIter;
import com.github.jarvisframework.tool.core.collection.IterUtils;
import com.github.jarvisframework.tool.core.collection.IteratorEnumeration;
import com.github.jarvisframework.tool.core.collection.ListUtils;
import com.github.jarvisframework.tool.core.collection.TransCollection;
import com.github.jarvisframework.tool.core.comparator.PinyinComparator;
import com.github.jarvisframework.tool.core.comparator.PropertyComparator;
import com.github.jarvisframework.tool.core.convert.Convert;
import com.github.jarvisframework.tool.core.convert.ConverterRegistry;
import com.github.jarvisframework.tool.core.exception.UtilException;
import com.github.jarvisframework.tool.core.lang.Editor;
import com.github.jarvisframework.tool.core.lang.Filter;
import com.github.jarvisframework.tool.core.lang.Matcher;
import com.github.jarvisframework.tool.core.lang.func.Func1;
import com.github.jarvisframework.tool.core.lang.hash.Hash32;
import com.github.jarvisframework.tool.core.map.MapUtils;
import com.github.jarvisframework.tool.core.util.ArrayUtils;
import com.github.jarvisframework.tool.core.util.ClassUtils;
import com.github.jarvisframework.tool.core.util.ObjectUtils;
import com.github.jarvisframework.tool.core.util.ReflectUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.core.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Function;
import java.util.function.Predicate;

public class CollectionUtils {
    public static <T> Set<T> emptyIfNull(Set<T> set) {
        return null == set ? Collections.emptySet() : set;
    }

    public static <T> List<T> emptyIfNull(List<T> set) {
        return null == set ? Collections.emptyList() : set;
    }

    public static <T> Collection<T> union(Collection<T> coll1, Collection<T> coll2) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (CollectionUtils.isEmpty(coll1)) {
            list.addAll(coll2);
        } else if (CollectionUtils.isEmpty(coll2)) {
            list.addAll(coll1);
        } else {
            Map<T, Integer> map1 = CollectionUtils.countMap(coll1);
            Map<T, Integer> map2 = CollectionUtils.countMap(coll2);
            HashSet<T> elts = CollectionUtils.newHashSet(coll2);
            elts.addAll(coll1);
            for (Object t : elts) {
                int m = Math.max(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0));
                for (int i = 0; i < m; ++i) {
                    list.add(t);
                }
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> Collection<T> union(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        Collection<T> union = CollectionUtils.union(coll1, coll2);
        for (Collection<T> coll : otherColls) {
            union = CollectionUtils.union(union, coll);
        }
        return union;
    }

    @SafeVarargs
    public static <T> Set<T> unionDistinct(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        LinkedHashSet<Object> result = CollectionUtils.isEmpty(coll1) ? new LinkedHashSet() : new LinkedHashSet<T>(coll1);
        if (CollectionUtils.isNotEmpty(coll2)) {
            result.addAll(coll2);
        }
        if (ArrayUtils.isNotEmpty(otherColls)) {
            for (Collection<T> otherColl : otherColls) {
                result.addAll(otherColl);
            }
        }
        return result;
    }

    @SafeVarargs
    public static <T> List<T> unionAll(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        ArrayList<Object> result = CollectionUtils.isEmpty(coll1) ? new ArrayList() : new ArrayList<T>(coll1);
        if (CollectionUtils.isNotEmpty(coll2)) {
            result.addAll(coll2);
        }
        if (ArrayUtils.isNotEmpty(otherColls)) {
            for (Collection<T> otherColl : otherColls) {
                result.addAll(otherColl);
            }
        }
        return result;
    }

    public static <T> Collection<T> intersection(Collection<T> coll1, Collection<T> coll2) {
        ArrayList list = new ArrayList();
        if (CollectionUtils.isNotEmpty(coll1) && CollectionUtils.isNotEmpty(coll2)) {
            Map<T, Integer> map1 = CollectionUtils.countMap(coll1);
            Map<T, Integer> map2 = CollectionUtils.countMap(coll2);
            HashSet elts = CollectionUtils.newHashSet(coll2);
            for (Object t : elts) {
                int m = Math.min(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0));
                for (int i = 0; i < m; ++i) {
                    list.add(t);
                }
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> Collection<T> intersection(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        Collection<T> intersection = CollectionUtils.intersection(coll1, coll2);
        if (CollectionUtils.isEmpty(intersection)) {
            return intersection;
        }
        for (Collection<T> coll : otherColls) {
            if (!CollectionUtils.isEmpty(intersection = CollectionUtils.intersection(intersection, coll))) continue;
            return intersection;
        }
        return intersection;
    }

    @SafeVarargs
    public static <T> Set<T> intersectionDistinct(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        if (CollectionUtils.isEmpty(coll1) || CollectionUtils.isEmpty(coll2)) {
            return new LinkedHashSet();
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>(coll1);
        if (ArrayUtils.isNotEmpty(otherColls)) {
            for (Collection<T> otherColl : otherColls) {
                if (!CollectionUtils.isNotEmpty(otherColl)) {
                    return new LinkedHashSet();
                }
                result.retainAll(otherColl);
            }
        }
        result.retainAll(coll2);
        return result;
    }

    public static <T> Collection<T> disjunction(Collection<T> coll1, Collection<T> coll2) {
        if (CollectionUtils.isEmpty(coll1)) {
            return coll2;
        }
        if (CollectionUtils.isEmpty(coll2)) {
            return coll1;
        }
        ArrayList result = new ArrayList();
        Map<T, Integer> map1 = CollectionUtils.countMap(coll1);
        Map<T, Integer> map2 = CollectionUtils.countMap(coll2);
        HashSet<T> elts = CollectionUtils.newHashSet(coll2);
        elts.addAll(coll1);
        for (Object t : elts) {
            int m = Math.abs(Convert.toInt(map1.get(t), 0) - Convert.toInt(map2.get(t), 0));
            for (int i = 0; i < m; ++i) {
                result.add(t);
            }
        }
        return result;
    }

    public static <T> Collection<T> subtract(Collection<T> coll1, Collection<T> coll2) {
        Collection<T> result = ObjectUtils.clone(coll1);
        result.removeAll(coll2);
        return result;
    }

    public static <T> List<T> subtractToList(Collection<T> coll1, Collection<T> coll2) {
        if (CollectionUtils.isEmpty(coll1)) {
            return ListUtils.empty();
        }
        if (CollectionUtils.isEmpty(coll2)) {
            return ListUtils.list(true, coll1);
        }
        LinkedList<T> result = new LinkedList<T>();
        HashSet<T> set = new HashSet<T>(coll2);
        for (T t : coll1) {
            if (set.contains(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static boolean contains(Collection<?> collection, Object value) {
        return CollectionUtils.isNotEmpty(collection) && collection.contains(value);
    }

    public static <T> boolean contains(Collection<T> collection, Predicate<? super T> containFunc) {
        if (CollectionUtils.isEmpty(collection)) {
            return false;
        }
        for (T t : collection) {
            if (!containFunc.test(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(Collection<?> coll1, Collection<?> coll2) {
        if (CollectionUtils.isEmpty(coll1) || CollectionUtils.isEmpty(coll2)) {
            return false;
        }
        if (coll1.size() < coll2.size()) {
            for (Object object : coll1) {
                if (!coll2.contains(object)) continue;
                return true;
            }
        } else {
            for (Object object : coll2) {
                if (!coll1.contains(object)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAll(Collection<?> coll1, Collection<?> coll2) {
        if (CollectionUtils.isEmpty(coll1)) {
            return CollectionUtils.isEmpty(coll2);
        }
        if (CollectionUtils.isEmpty(coll2)) {
            return true;
        }
        if (coll1.size() < coll2.size()) {
            return false;
        }
        for (Object object : coll2) {
            if (coll1.contains(object)) continue;
            return false;
        }
        return true;
    }

    public static <T> Map<T, Integer> countMap(Iterable<T> collection) {
        return IterUtils.countMap(null == collection ? null : collection.iterator());
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction) {
        if (null == iterable) {
            return null;
        }
        return IterUtils.join(iterable.iterator(), conjunction);
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction, String prefix, String suffix) {
        if (null == iterable) {
            return null;
        }
        return IterUtils.join(iterable.iterator(), conjunction, prefix, suffix);
    }

    @Deprecated
    public static <T> String join(Iterator<T> iterator, CharSequence conjunction) {
        return IterUtils.join(iterator, conjunction);
    }

    public static <T> List<T> popPart(Stack<T> surplusAlaDatas, int partSize) {
        if (CollectionUtils.isEmpty(surplusAlaDatas)) {
            return ListUtils.empty();
        }
        ArrayList<T> currentAlaDatas = new ArrayList<T>();
        int size = surplusAlaDatas.size();
        if (size > partSize) {
            for (int i = 0; i < partSize; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        }
        return currentAlaDatas;
    }

    public static <T> List<T> popPart(Deque<T> surplusAlaDatas, int partSize) {
        if (CollectionUtils.isEmpty(surplusAlaDatas)) {
            return ListUtils.empty();
        }
        ArrayList<T> currentAlaDatas = new ArrayList<T>();
        int size = surplusAlaDatas.size();
        if (size > partSize) {
            for (int i = 0; i < partSize; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        }
        return currentAlaDatas;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return MapUtils.newHashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isOrder) {
        return MapUtils.newHashMap(size, isOrder);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapUtils.newHashMap(size);
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... ts) {
        return CollectionUtils.set(false, ts);
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... ts) {
        return (LinkedHashSet)CollectionUtils.set(true, ts);
    }

    @SafeVarargs
    public static <T> HashSet<T> set(boolean isSorted, T ... ts) {
        if (null == ts) {
            return isSorted ? new LinkedHashSet() : new HashSet();
        }
        int initialCapacity = Math.max((int)((float)ts.length / 0.75f) + 1, 16);
        HashSet set = isSorted ? new LinkedHashSet(initialCapacity) : new HashSet(initialCapacity);
        Collections.addAll(set, ts);
        return set;
    }

    public static <T> HashSet<T> newHashSet(Collection<T> collection) {
        return CollectionUtils.newHashSet(false, collection);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Collection<T> collection) {
        return isSorted ? new LinkedHashSet<T>(collection) : new HashSet<T>(collection);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Iterator<T> iter) {
        HashSet set;
        if (null == iter) {
            return CollectionUtils.set(isSorted, null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return set;
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Enumeration<T> enumeration) {
        HashSet set;
        if (null == enumeration) {
            return CollectionUtils.set(isSorted, null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return set;
    }

    public static <T> List<T> list(boolean isLinked) {
        return ListUtils.list(isLinked);
    }

    @SafeVarargs
    public static <T> List<T> list(boolean isLinked, T ... values) {
        return ListUtils.list(isLinked, values);
    }

    public static <T> List<T> list(boolean isLinked, Collection<T> collection) {
        return ListUtils.list(isLinked, collection);
    }

    public static <T> List<T> list(boolean isLinked, Iterable<T> iterable) {
        return ListUtils.list(isLinked, iterable);
    }

    public static <T> List<T> list(boolean isLinked, Iterator<T> iter) {
        return ListUtils.list(isLinked, iter);
    }

    public static <T> List<T> list(boolean isLinked, Enumeration<T> enumeration) {
        return ListUtils.list(isLinked, enumeration);
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T ... values) {
        return ListUtils.toList(values);
    }

    @SafeVarargs
    public static <T> ArrayList<T> toList(T ... values) {
        return ListUtils.toList(values);
    }

    public static <T> ArrayList<T> newArrayList(Collection<T> collection) {
        return ListUtils.toList(collection);
    }

    public static <T> ArrayList<T> newArrayList(Iterable<T> iterable) {
        return ListUtils.toList(iterable);
    }

    public static <T> ArrayList<T> newArrayList(Iterator<T> iterator) {
        return ListUtils.toList(iterator);
    }

    public static <T> ArrayList<T> newArrayList(Enumeration<T> enumeration) {
        return ListUtils.toList(enumeration);
    }

    @SafeVarargs
    public static <T> LinkedList<T> newLinkedList(T ... values) {
        return ListUtils.toLinkedList(values);
    }

    public static <T> CopyOnWriteArrayList<T> newCopyOnWriteArrayList(Collection<T> collection) {
        return ListUtils.toCopyOnWriteArrayList(collection);
    }

    public static <T> BlockingQueue<T> newBlockingQueue(int capacity, boolean isLinked) {
        AbstractQueue queue = isLinked ? new LinkedBlockingDeque(capacity) : new ArrayBlockingQueue(capacity);
        return queue;
    }

    public static <T> Collection<T> create(Class<?> collectionType) {
        Collection<Object> list;
        if (collectionType.isAssignableFrom(AbstractCollection.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (collectionType.isAssignableFrom(LinkedHashSet.class)) {
            list = new LinkedHashSet();
        } else if (collectionType.isAssignableFrom(TreeSet.class)) {
            list = new TreeSet();
        } else if (collectionType.isAssignableFrom(EnumSet.class)) {
            list = EnumSet.noneOf(ClassUtils.getTypeArgument(collectionType));
        } else if (collectionType.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(LinkedList.class)) {
            list = new LinkedList();
        } else {
            try {
                list = (Collection)ReflectUtils.newInstance(collectionType, new Object[0]);
            }
            catch (Exception e) {
                throw new UtilException(e);
            }
        }
        return list;
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType) {
        return MapUtils.createMap(mapType);
    }

    public static <T> ArrayList<T> distinct(Collection<T> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return new ArrayList();
        }
        if (collection instanceof Set) {
            return new ArrayList<T>(collection);
        }
        return new ArrayList<T>(new LinkedHashSet<T>(collection));
    }

    public static <T> List<T> sub(List<T> list, int start, int end) {
        return ListUtils.sub(list, start, end);
    }

    public static <T> List<T> sub(List<T> list, int start, int end, int step) {
        return ListUtils.sub(list, start, end, step);
    }

    public static <T> List<T> sub(Collection<T> collection, int start, int end) {
        return CollectionUtils.sub(collection, start, end, 1);
    }

    public static <T> List<T> sub(Collection<T> list, int start, int end, int step) {
        if (list == null || list.isEmpty()) {
            return ListUtils.empty();
        }
        return CollectionUtils.sub(new ArrayList<T>(list), start, end, step);
    }

    public static <T> List<List<T>> split(Collection<T> collection, int size) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (CollectionUtils.isEmpty(collection)) {
            return result;
        }
        ArrayList<T> subList = new ArrayList<T>(size);
        for (T t : collection) {
            if (subList.size() >= size) {
                result.add(subList);
                subList = new ArrayList(size);
            }
            subList.add(t);
        }
        result.add(subList);
        return result;
    }

    public static <T> Collection<T> filter(Collection<T> collection, Editor<T> editor) {
        if (null == collection || null == editor) {
            return collection;
        }
        Collection<T> collection2 = ObjectUtils.clone(collection);
        try {
            collection2.clear();
        }
        catch (UnsupportedOperationException e) {
            collection2 = new ArrayList<T>();
        }
        for (T t : collection) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            collection2.add(modified);
        }
        return collection2;
    }

    public static <T> List<T> filter(List<T> list, Editor<T> editor) {
        return ListUtils.filter(list, editor);
    }

    public static <T> Collection<T> filterNew(Collection<T> collection, Filter<T> filter) {
        if (null == collection || null == filter) {
            return collection;
        }
        Collection<T> collection2 = ObjectUtils.clone(collection);
        try {
            collection2.clear();
        }
        catch (UnsupportedOperationException e) {
            collection2 = new ArrayList<T>();
        }
        for (T t : collection) {
            if (!filter.accept(t)) continue;
            collection2.add(t);
        }
        return collection2;
    }

    public static <T> List<T> filterNew(List<T> list, Filter<T> filter) {
        return ListUtils.filter(list, (T t) -> filter.accept(t) ? t : null);
    }

    public static <T extends Collection<E>, E> T removeAny(T collection, E ... elesRemoved) {
        collection.removeAll(CollectionUtils.newHashSet(elesRemoved));
        return collection;
    }

    public static <T extends Collection<E>, E> T filter(T collection, Filter<E> filter) {
        return IterUtils.filter(collection, filter);
    }

    public static <T extends Collection<E>, E> T removeNull(T collection) {
        return CollectionUtils.filter(collection, Objects::nonNull);
    }

    public static <T extends Collection<E>, E extends CharSequence> T removeEmpty(T collection) {
        return CollectionUtils.filter(collection, StringUtils::isNotEmpty);
    }

    public static <T extends Collection<E>, E extends CharSequence> T removeBlank(T collection) {
        return CollectionUtils.filter(collection, StringUtils::isNotBlank);
    }

    public static List<Object> extract(Iterable<?> collection, Editor<Object> editor) {
        return CollectionUtils.extract(collection, editor, false);
    }

    public static List<Object> extract(Iterable<?> collection, Editor<Object> editor, boolean ignoreNull) {
        return CollectionUtils.map(collection, editor::edit, ignoreNull);
    }

    public static <T, R> List<R> map(Iterable<T> collection, Function<? super T, ? extends R> func, boolean ignoreNull) {
        ArrayList<R> fieldValueList = new ArrayList<R>();
        if (null == collection) {
            return fieldValueList;
        }
        for (T bean : collection) {
            R value = func.apply(bean);
            if (null == value && ignoreNull) continue;
            fieldValueList.add(value);
        }
        return fieldValueList;
    }

    public static List<Object> getFieldValues(Iterable<?> collection, String fieldName) {
        return CollectionUtils.getFieldValues(collection, fieldName, false);
    }

    public static List<Object> getFieldValues(Iterable<?> collection, String fieldName, boolean ignoreNull) {
        return CollectionUtils.map(collection, bean -> {
            if (bean instanceof Map) {
                return ((Map)bean).get(fieldName);
            }
            return ReflectUtils.getFieldValue(bean, fieldName);
        }, ignoreNull);
    }

    public static <T> List<T> getFieldValues(Iterable<?> collection, String fieldName, Class<T> elementType) {
        List<Object> fieldValues = CollectionUtils.getFieldValues(collection, fieldName);
        return Convert.toList(elementType, fieldValues);
    }

    public static <K, V> Map<K, V> fieldValueMap(Iterable<V> iterable, String fieldName) {
        return IterUtils.fieldValueMap(null == iterable ? null : iterable.iterator(), fieldName);
    }

    public static <K, V> Map<K, V> fieldValueAsMap(Iterable<?> iterable, String fieldNameForKey, String fieldNameForValue) {
        return IterUtils.fieldValueAsMap(null == iterable ? null : iterable.iterator(), fieldNameForKey, fieldNameForValue);
    }

    public static <T> T findOne(Iterable<T> collection, Filter<T> filter) {
        if (null != collection) {
            for (T t : collection) {
                if (!filter.accept(t)) continue;
                return t;
            }
        }
        return null;
    }

    public static <T> T findOneByField(Iterable<T> collection, String fieldName, Object fieldValue) {
        return (T)CollectionUtils.findOne(collection, t -> {
            if (t instanceof Map) {
                Map map = (Map)t;
                Object value = map.get(fieldName);
                return ObjectUtils.equal(value, fieldValue);
            }
            Object value = ReflectUtils.getFieldValue(t, fieldName);
            return ObjectUtils.equal(value, fieldValue);
        });
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Editor<Map.Entry<K, V>> editor) {
        return MapUtils.filter(map, editor);
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Filter<Map.Entry<K, V>> filter) {
        return MapUtils.filter(map, filter);
    }

    public static <T> int count(Iterable<T> iterable, Matcher<T> matcher) {
        int count = 0;
        if (null != iterable) {
            for (T t : iterable) {
                if (null != matcher && !matcher.match(t)) continue;
                ++count;
            }
        }
        return count;
    }

    public static <T> int[] indexOfAll(Collection<T> collection, Matcher<T> matcher) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        if (null != collection) {
            int index = 0;
            for (T t : collection) {
                if (null == matcher || matcher.match(t)) {
                    indexList.add(index);
                }
                ++index;
            }
        }
        return Convert.convert(int[].class, indexList);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T extends Collection<E>, E> T defaultIfEmpty(T collection, T defaultCollection) {
        return CollectionUtils.isEmpty(collection) ? defaultCollection : collection;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return MapUtils.isEmpty(map);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return IterUtils.isEmpty(iterable);
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return IterUtils.isEmpty(iterator);
    }

    public static boolean isEmpty(Enumeration<?> enumeration) {
        return null == enumeration || false == enumeration.hasMoreElements();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return false == CollectionUtils.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return MapUtils.isNotEmpty(map);
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return IterUtils.isNotEmpty(iterable);
    }

    public static boolean isNotEmpty(Iterator<?> iterator) {
        return IterUtils.isNotEmpty(iterator);
    }

    public static boolean isNotEmpty(Enumeration<?> enumeration) {
        return null != enumeration && enumeration.hasMoreElements();
    }

    public static boolean hasNull(Iterable<?> iterable) {
        return IterUtils.hasNull(iterable);
    }

    public static Map<String, String> zip(String keys, String values, String delimiter, boolean isOrder) {
        return ArrayUtils.zip(StringUtils.split((CharSequence)keys, delimiter), StringUtils.split((CharSequence)values, delimiter), isOrder);
    }

    public static Map<String, String> zip(String keys, String values, String delimiter) {
        return CollectionUtils.zip(keys, values, delimiter, false);
    }

    public static <K, V> Map<K, V> zip(Collection<K> keys, Collection<V> values) {
        int entryCount;
        if (CollectionUtils.isEmpty(keys) || CollectionUtils.isEmpty(values)) {
            return MapUtils.empty();
        }
        HashMap<K, V> map = CollectionUtils.newHashMap(entryCount);
        Iterator<K> keyIterator = keys.iterator();
        Iterator<V> valueIterator = values.iterator();
        for (entryCount = Math.min(keys.size(), values.size()); entryCount > 0; --entryCount) {
            map.put(keyIterator.next(), valueIterator.next());
        }
        return map;
    }

    public static <K, V> HashMap<K, V> toMap(Iterable<Map.Entry<K, V>> entryIter) {
        return IterUtils.toMap(entryIter);
    }

    public static HashMap<Object, Object> toMap(Object[] array) {
        return MapUtils.of(array);
    }

    public static <T> TreeSet<T> toTreeSet(Collection<T> collection, Comparator<T> comparator) {
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        treeSet.addAll(collection);
        return treeSet;
    }

    public static <E> Enumeration<E> asEnumeration(Iterator<E> iter) {
        return new IteratorEnumeration<E>(iter);
    }

    public static <E> Iterator<E> asIterator(Enumeration<E> e) {
        return IterUtils.asIterator(e);
    }

    public static <E> Iterable<E> asIterable(Iterator<E> iter) {
        return IterUtils.asIterable(iter);
    }

    public static <E> Collection<E> toCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (ArrayList<E>)iterable : CollectionUtils.newArrayList(iterable.iterator());
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<? extends Map<K, V>> mapList) {
        return MapUtils.toListMap(mapList);
    }

    public static <K, V> List<Map<K, V>> toMapList(Map<K, ? extends Iterable<V>> listMap) {
        return MapUtils.toMapList(listMap);
    }

    public static <K, V> Map<K, V> toMap(Iterable<V> values, Map<K, V> map, Func1<V, K> keyFunc) {
        return IterUtils.toMap(null == values ? null : values.iterator(), map, keyFunc);
    }

    public static <K, V, E> Map<K, V> toMap(Iterable<E> values, Map<K, V> map, Func1<E, K> keyFunc, Func1<E, V> valueFunc) {
        return IterUtils.toMap(null == values ? null : values.iterator(), map, keyFunc, valueFunc);
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value) {
        return CollectionUtils.addAll(collection, value, TypeUtils.getTypeArgument(collection.getClass()));
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value, Type elementType) {
        Iterator<Object> iter;
        if (null == collection || null == value) {
            return collection;
        }
        if (TypeUtils.isUnknown((Type)elementType)) {
            elementType = Object.class;
        }
        if (value instanceof Iterator) {
            iter = (Iterator)value;
        } else if (value instanceof Iterable) {
            iter = ((Iterable)value).iterator();
        } else if (value instanceof Enumeration) {
            iter = new EnumerationIter((Enumeration)value);
        } else if (ArrayUtils.isArray(value)) {
            iter = new ArrayIter(value);
        } else if (value instanceof CharSequence) {
            String arrayStr = StringUtils.unWrap((CharSequence)value, '[', ']');
            iter = StringUtils.splitTrim((CharSequence)arrayStr, ',').iterator();
        } else {
            iter = CollectionUtils.newArrayList(value).iterator();
        }
        ConverterRegistry convert = ConverterRegistry.getInstance();
        while (iter.hasNext()) {
            collection.add(convert.convert((Type)elementType, iter.next()));
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterator<T> iterator) {
        if (null != collection && null != iterator) {
            while (iterator.hasNext()) {
                collection.add(iterator.next());
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterable<T> iterable) {
        return CollectionUtils.addAll(collection, iterable.iterator());
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Enumeration<T> enumeration) {
        if (null != collection && null != enumeration) {
            while (enumeration.hasMoreElements()) {
                collection.add(enumeration.nextElement());
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, T[] values) {
        if (null != collection && null != values) {
            Collections.addAll(collection, values);
        }
        return collection;
    }

    public static <T> List<T> addAllIfNotContains(List<T> list, List<T> otherList) {
        for (T t : otherList) {
            if (list.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    public static <T> T get(Collection<T> collection, int index) {
        if (null == collection) {
            return null;
        }
        int size = collection.size();
        if (0 == size) {
            return null;
        }
        if (index < 0) {
            index += size;
        }
        if (index >= size) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(index);
        }
        int i = 0;
        for (T t : collection) {
            if (i > index) break;
            if (i == index) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public static <T> List<T> getAny(Collection<T> collection, int ... indexes) {
        int size = collection.size();
        ArrayList<Object> result = new ArrayList<Object>();
        if (collection instanceof List) {
            List list = (List)collection;
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                result.add(list.get(index));
            }
        } else {
            Object[] array = collection.toArray();
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                result.add(array[index]);
            }
        }
        return result;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        return IterUtils.getFirst(iterable);
    }

    public static <T> T getFirst(Iterator<T> iterator) {
        return IterUtils.getFirst(iterator);
    }

    public static <T> T getLast(Collection<T> collection) {
        return CollectionUtils.get(collection, -1);
    }

    public static Class<?> getElementType(Iterable<?> iterable) {
        return IterUtils.getElementType(iterable);
    }

    public static Class<?> getElementType(Iterator<?> iterator) {
        return IterUtils.getElementType(iterator);
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, K ... keys) {
        ArrayList<V> values = new ArrayList<V>();
        for (K k : keys) {
            values.add(map.get(k));
        }
        return values;
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, Iterable<K> keys) {
        return CollectionUtils.valuesOfKeys(map, keys.iterator());
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, Iterator<K> keys) {
        ArrayList<V> values = new ArrayList<V>();
        while (keys.hasNext()) {
            values.add(map.get(keys.next()));
        }
        return values;
    }

    @SafeVarargs
    public static <T> List<T> sortPageAll(int pageNo, int pageSize, Comparator<T> comparator, Collection<T> ... colls) {
        ArrayList<T> list = new ArrayList<T>(pageNo * pageSize);
        for (Collection<T> coll : colls) {
            list.addAll(coll);
        }
        if (null != comparator) {
            list.sort(comparator);
        }
        return CollectionUtils.page(pageNo, pageSize, list);
    }

    public static <T> List<T> page(int pageNo, int pageSize, List<T> list) {
        return ListUtils.page(pageNo, pageSize, list);
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<? super T> comparator) {
        ArrayList<T> list = new ArrayList<T>(collection);
        list.sort(comparator);
        return list;
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> c) {
        return ListUtils.sort(list, c);
    }

    public static <T> List<T> sortByProperty(Collection<T> collection, String property) {
        return CollectionUtils.sort(collection, new PropertyComparator(property));
    }

    public static <T> List<T> sortByProperty(List<T> list, String property) {
        return ListUtils.sortByProperty(list, property);
    }

    public static List<String> sortByPinyin(Collection<String> collection) {
        return CollectionUtils.sort(collection, new PinyinComparator());
    }

    public static List<String> sortByPinyin(List<String> list) {
        return ListUtils.sortByPinyin(list);
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> result = new TreeMap<K, V>(comparator);
        result.putAll(map);
        return result;
    }

    public static <K, V> LinkedHashMap<K, V> sortToMap(Collection<Map.Entry<K, V>> entryCollection, Comparator<Map.Entry<K, V>> comparator) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(entryCollection);
        list.sort(comparator);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V> LinkedHashMap<K, V> sortByEntry(Map<K, V> map, Comparator<Map.Entry<K, V>> comparator) {
        return CollectionUtils.sortToMap(map.entrySet(), comparator);
    }

    public static <K, V> List<Map.Entry<K, V>> sortEntryToList(Collection<Map.Entry<K, V>> collection) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(collection);
        list.sort((o1, o2) -> {
            Object v1 = o1.getValue();
            Object v2 = o2.getValue();
            if (v1 instanceof Comparable) {
                return ((Comparable)v1).compareTo(v2);
            }
            return v1.toString().compareTo(v2.toString());
        });
        return list;
    }

    public static <T> void forEach(Iterator<T> iterator, Consumer<T> consumer) {
        int index = 0;
        while (iterator.hasNext()) {
            consumer.accept(iterator.next(), index);
            ++index;
        }
    }

    public static <T> void forEach(Enumeration<T> enumeration, Consumer<T> consumer) {
        int index = 0;
        while (enumeration.hasMoreElements()) {
            consumer.accept(enumeration.nextElement(), index);
            ++index;
        }
    }

    public static <K, V> void forEach(Map<K, V> map, KVConsumer<K, V> kvConsumer) {
        int index = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            kvConsumer.accept(entry.getKey(), entry.getValue(), index);
            ++index;
        }
    }

    public static <T> List<List<T>> group(Collection<T> collection, Hash32<T> hash) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (CollectionUtils.isEmpty(collection)) {
            return result;
        }
        if (null == hash) {
            hash = t -> null == t ? 0 : t.hashCode();
        }
        for (T t2 : collection) {
            int index = hash.hash32(t2);
            if (result.size() - 1 < index) {
                while (result.size() - 1 < index) {
                    result.add(null);
                }
                result.set(index, CollectionUtils.newArrayList(t2));
                continue;
            }
            List subList = (List)result.get(index);
            if (null == subList) {
                result.set(index, CollectionUtils.newArrayList(t2));
                continue;
            }
            subList.add(t2);
        }
        return result;
    }

    public static <T> List<List<T>> groupByField(Collection<T> collection, final String fieldName) {
        return CollectionUtils.group(collection, new Hash32<T>(){
            private final List<Object> fieldNameList = new ArrayList<Object>();

            @Override
            public int hash32(T t) {
                if (null == t || !BeanUtils.isBean(t.getClass())) {
                    return 0;
                }
                Object value = ReflectUtils.getFieldValue(t, fieldName);
                int hash = this.fieldNameList.indexOf(value);
                if (hash < 0) {
                    this.fieldNameList.add(value);
                    return this.fieldNameList.size() - 1;
                }
                return hash;
            }
        });
    }

    public static <T> List<T> reverse(List<T> list) {
        return ListUtils.reverse(list);
    }

    public static <T> List<T> reverseNew(List<T> list) {
        return ListUtils.reverseNew(list);
    }

    public static <T> List<T> setOrAppend(List<T> list, int index, T element) {
        return ListUtils.setOrAppend(list, index, element);
    }

    public static <K> Set<K> keySet(Collection<Map<K, ?>> mapCollection) {
        if (CollectionUtils.isEmpty(mapCollection)) {
            return new HashSet();
        }
        HashSet<K> set = new HashSet<K>(mapCollection.size() * 16);
        for (Map<K, ?> map : mapCollection) {
            set.addAll(map.keySet());
        }
        return set;
    }

    public static <V> List<V> values(Collection<Map<?, V>> mapCollection) {
        ArrayList<V> values = new ArrayList<V>();
        for (Map<?, V> map : mapCollection) {
            values.addAll(map.values());
        }
        return values;
    }

    public static <T extends Comparable<? super T>> T max(Collection<T> coll) {
        return (T)((Comparable)Collections.max(coll));
    }

    public static <T extends Comparable<? super T>> T min(Collection<T> coll) {
        return (T)((Comparable)Collections.min(coll));
    }

    public static <T> Collection<T> unmodifiable(Collection<? extends T> c) {
        return Collections.unmodifiableCollection(c);
    }

    public static <E, T extends Collection<E>> T empty(Class<?> collectionClass) {
        if (null == collectionClass) {
            return (T)Collections.emptyList();
        }
        if (Set.class.isAssignableFrom(collectionClass)) {
            if (NavigableSet.class == collectionClass) {
                return (T)Collections.emptyNavigableSet();
            }
            if (SortedSet.class == collectionClass) {
                return (T)Collections.emptySortedSet();
            }
            return (T)Collections.emptySet();
        }
        if (List.class.isAssignableFrom(collectionClass)) {
            return (T)Collections.emptyList();
        }
        throw new IllegalArgumentException(StringUtils.format((CharSequence)"[{}] is not support to get empty!", collectionClass));
    }

    public static void clear(Collection<?> ... collections) {
        for (Collection<?> collection : collections) {
            if (!CollectionUtils.isNotEmpty(collection)) continue;
            collection.clear();
        }
    }

    public static <T> void padLeft(List<T> list, int minLen, T padObj) {
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            CollectionUtils.padRight(list, minLen, padObj);
            return;
        }
        for (int i = list.size(); i < minLen; ++i) {
            list.add(0, padObj);
        }
    }

    public static <T> void padRight(Collection<T> list, int minLen, T padObj) {
        Objects.requireNonNull(list);
        for (int i = list.size(); i < minLen; ++i) {
            list.add(padObj);
        }
    }

    public static <F, T> Collection<T> trans(Collection<F> collection, Function<? super F, ? extends T> function) {
        return new TransCollection<F, T>(collection, function);
    }

    @FunctionalInterface
    public static interface KVConsumer<K, V> {
        public void accept(K var1, V var2, int var3);
    }

    @FunctionalInterface
    public static interface Consumer<T> {
        public void accept(T var1, int var2);
    }
}

