/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.collection;

import com.github.jarvisframework.tool.core.collection.CopiedIter;
import com.github.jarvisframework.tool.core.collection.EnumerationIter;
import com.github.jarvisframework.tool.core.collection.TransIter;
import com.github.jarvisframework.tool.core.exception.UtilException;
import com.github.jarvisframework.tool.core.lang.Filter;
import com.github.jarvisframework.tool.core.lang.func.Func1;
import com.github.jarvisframework.tool.core.map.MapUtils;
import com.github.jarvisframework.tool.core.util.ArrayUtils;
import com.github.jarvisframework.tool.core.util.ObjectUtils;
import com.github.jarvisframework.tool.core.util.ReflectUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class IterUtils {
    public static boolean isEmpty(Iterable<?> iterable) {
        return null == iterable || IterUtils.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return null == iterator || false == iterator.hasNext();
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return null != iterable && IterUtils.isNotEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(Iterator<?> iterator) {
        return null != iterator && iterator.hasNext();
    }

    public static boolean hasNull(Iterable<?> iter) {
        return IterUtils.hasNull(null == iter ? null : iter.iterator());
    }

    public static boolean hasNull(Iterator<?> iter) {
        if (null == iter) {
            return true;
        }
        while (iter.hasNext()) {
            if (null != iter.next()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNull(Iterable<?> iter) {
        return IterUtils.isAllNull(null == iter ? null : iter.iterator());
    }

    public static boolean isAllNull(Iterator<?> iter) {
        if (null == iter) {
            return true;
        }
        while (iter.hasNext()) {
            if (null == iter.next()) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static <T> Map<T, Integer> countMap(Iterable<T> iter) {
        return IterUtils.countMap(null == iter ? null : iter.iterator());
    }

    public static <T> Map<T, Integer> countMap(Iterator<T> iter) {
        HashMap<T, Integer> countMap = new HashMap<T, Integer>();
        if (null != iter) {
            while (iter.hasNext()) {
                T t = iter.next();
                Integer count = (Integer)countMap.get(t);
                if (null == count) {
                    countMap.put(t, 1);
                    continue;
                }
                countMap.put(t, count + 1);
            }
        }
        return countMap;
    }

    @Deprecated
    public static <K, V> Map<K, V> fieldValueMap(Iterable<V> iter, String fieldName) {
        return IterUtils.fieldValueMap(null == iter ? null : iter.iterator(), fieldName);
    }

    public static <K, V> Map<K, V> fieldValueMap(Iterator<V> iter, String fieldName) {
        return IterUtils.toMap(iter, new HashMap(), (V value) -> ReflectUtils.getFieldValue(value, fieldName));
    }

    @Deprecated
    public static <K, V> Map<K, V> fieldValueAsMap(Iterable<?> iterable, String fieldNameForKey, String fieldNameForValue) {
        return IterUtils.fieldValueAsMap(null == iterable ? null : iterable.iterator(), fieldNameForKey, fieldNameForValue);
    }

    public static <K, V> Map<K, V> fieldValueAsMap(Iterator<?> iter, String fieldNameForKey, String fieldNameForValue) {
        return IterUtils.toMap(iter, new HashMap(), (E value) -> ReflectUtils.getFieldValue(value, fieldNameForKey), (E value) -> ReflectUtils.getFieldValue(value, fieldNameForValue));
    }

    public static <V> List<Object> fieldValueList(Iterable<V> iterable, String fieldName) {
        return IterUtils.fieldValueList(null == iterable ? null : iterable.iterator(), fieldName);
    }

    public static <V> List<Object> fieldValueList(Iterator<V> iter, String fieldName) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (null != iter) {
            while (iter.hasNext()) {
                V value = iter.next();
                result.add(ReflectUtils.getFieldValue(value, fieldName));
            }
        }
        return result;
    }

    @Deprecated
    public static <T> String join(Iterable<T> iterable, CharSequence conjunction) {
        if (null == iterable) {
            return null;
        }
        return IterUtils.join(iterable.iterator(), conjunction);
    }

    @Deprecated
    public static <T> String join(Iterable<T> iterable, CharSequence conjunction, String prefix, String suffix) {
        if (null == iterable) {
            return null;
        }
        return IterUtils.join(iterable.iterator(), conjunction, prefix, suffix);
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction) {
        return IterUtils.join(iterator, conjunction, null, null);
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction, String prefix, String suffix) {
        if (null == iterator) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (iterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            T item = iterator.next();
            if (ArrayUtils.isArray(item)) {
                sb.append(ArrayUtils.join(ArrayUtils.wrap(item), conjunction, prefix, suffix));
                continue;
            }
            if (item instanceof Iterable) {
                sb.append(IterUtils.join((Iterable)item, conjunction, prefix, suffix));
                continue;
            }
            if (item instanceof Iterator) {
                sb.append(IterUtils.join((Iterator)item, conjunction, prefix, suffix));
                continue;
            }
            sb.append(StringUtils.wrap(String.valueOf(item), prefix, suffix));
        }
        return sb.toString();
    }

    public static <K, V> HashMap<K, V> toMap(Iterable<Map.Entry<K, V>> entryIter) {
        HashMap<K, V> map = new HashMap<K, V>();
        if (IterUtils.isNotEmpty(entryIter)) {
            for (Map.Entry<K, V> entry : entryIter) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public static <K, V> Map<K, V> toMap(Iterable<K> keys, Iterable<V> values) {
        return IterUtils.toMap(keys, values, false);
    }

    public static <K, V> Map<K, V> toMap(Iterable<K> keys, Iterable<V> values, boolean isOrder) {
        return IterUtils.toMap(null == keys ? null : keys.iterator(), null == values ? null : values.iterator(), isOrder);
    }

    public static <K, V> Map<K, V> toMap(Iterator<K> keys, Iterator<V> values) {
        return IterUtils.toMap(keys, values, false);
    }

    public static <K, V> Map<K, V> toMap(Iterator<K> keys, Iterator<V> values, boolean isOrder) {
        HashMap<K, Object> resultMap = MapUtils.newHashMap(isOrder);
        if (IterUtils.isNotEmpty(keys)) {
            while (keys.hasNext()) {
                resultMap.put(keys.next(), null != values && values.hasNext() ? (Object)values.next() : null);
            }
        }
        return resultMap;
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<V> iterable, Function<V, K> keyMapper) {
        return IterUtils.toListMap(iterable, keyMapper, v -> v);
    }

    public static <T, K, V> Map<K, List<V>> toListMap(Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return IterUtils.toListMap(MapUtils.newHashMap(), iterable, keyMapper, valueMapper);
    }

    public static <T, K, V> Map<K, List<V>> toListMap(Map<K, List<V>> resultMap, Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        if (null == resultMap) {
            resultMap = MapUtils.newHashMap();
        }
        if (ObjectUtils.isNull(iterable)) {
            return resultMap;
        }
        for (T value : iterable) {
            resultMap.computeIfAbsent(keyMapper.apply(value), k -> new ArrayList()).add(valueMapper.apply(value));
        }
        return resultMap;
    }

    public static <K, V> Map<K, V> toMap(Iterable<V> iterable, Function<V, K> keyMapper) {
        return IterUtils.toMap(iterable, keyMapper, (T v) -> v);
    }

    public static <T, K, V> Map<K, V> toMap(Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return IterUtils.toMap(MapUtils.newHashMap(), iterable, keyMapper, valueMapper);
    }

    public static <T, K, V> Map<K, V> toMap(Map<K, V> resultMap, Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        if (null == resultMap) {
            resultMap = MapUtils.newHashMap();
        }
        if (ObjectUtils.isNull(iterable)) {
            return resultMap;
        }
        for (T value : iterable) {
            resultMap.put(keyMapper.apply(value), valueMapper.apply(value));
        }
        return resultMap;
    }

    public static <E> List<E> toList(Iterable<E> iter) {
        if (null == iter) {
            return null;
        }
        return IterUtils.toList(iter.iterator());
    }

    public static <E> List<E> toList(Iterator<E> iter) {
        ArrayList<E> list = new ArrayList<E>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static <E> Iterator<E> asIterator(Enumeration<E> e) {
        return new EnumerationIter<E>(e);
    }

    public static <E> Iterable<E> asIterable(Iterator<E> iter) {
        return () -> iter;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        if (null == iterable) {
            return null;
        }
        return IterUtils.getFirst(iterable.iterator());
    }

    public static <T> T getFirst(Iterator<T> iterator) {
        if (null != iterator && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static Class<?> getElementType(Iterable<?> iterable) {
        if (null != iterable) {
            Iterator<?> iterator = iterable.iterator();
            return IterUtils.getElementType(iterator);
        }
        return null;
    }

    public static Class<?> getElementType(Iterator<?> iterator) {
        Object t;
        CopiedIter iter2 = new CopiedIter(iterator);
        if (iter2.hasNext() && null != (t = iter2.next())) {
            return t.getClass();
        }
        return null;
    }

    public static <T extends Iterable<E>, E> T filter(T iter, Filter<E> filter) {
        if (null == iter) {
            return null;
        }
        IterUtils.filter(iter.iterator(), filter);
        return iter;
    }

    public static <E> Iterator<E> filter(Iterator<E> iter, Filter<E> filter) {
        if (null == iter || null == filter) {
            return iter;
        }
        while (iter.hasNext()) {
            if (filter.accept(iter.next())) continue;
            iter.remove();
        }
        return iter;
    }

    public static <K, V> Map<K, V> toMap(Iterator<V> iterator, Map<K, V> map, Func1<V, K> keyFunc) {
        return IterUtils.toMap(iterator, map, keyFunc, (E value) -> value);
    }

    public static <K, V, E> Map<K, V> toMap(Iterator<E> iterator, Map<K, V> map, Func1<E, K> keyFunc, Func1<E, V> valueFunc) {
        if (null == iterator) {
            return map;
        }
        if (null == map) {
            map = MapUtils.newHashMap(true);
        }
        while (iterator.hasNext()) {
            E element = iterator.next();
            try {
                map.put(keyFunc.call(element), valueFunc.call(element));
            }
            catch (Exception e) {
                throw new UtilException(e);
            }
        }
        return map;
    }

    public static <T> Iterator<T> empty() {
        return Collections.emptyIterator();
    }

    public static <F, T> Iterator<T> trans(Iterator<F> iterator, Function<? super F, ? extends T> function) {
        return new TransIter<F, T>(iterator, function);
    }
}

