/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.collection;

import com.github.jarvisframework.tool.core.collection.CollectionUtils;
import com.github.jarvisframework.tool.core.comparator.PinyinComparator;
import com.github.jarvisframework.tool.core.comparator.PropertyComparator;
import com.github.jarvisframework.tool.core.convert.Convert;
import com.github.jarvisframework.tool.core.lang.Editor;
import com.github.jarvisframework.tool.core.lang.Matcher;
import com.github.jarvisframework.tool.core.util.ArrayUtils;
import com.github.jarvisframework.tool.core.util.ObjectUtils;
import com.github.jarvisframework.tool.core.util.PageUtils;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ListUtils {
    public static <T> List<T> list(boolean isLinked) {
        return isLinked ? new LinkedList() : new ArrayList();
    }

    @SafeVarargs
    public static <T> List<T> list(boolean isLinked, T ... values) {
        if (ArrayUtils.isEmpty(values)) {
            return ListUtils.list(isLinked);
        }
        AbstractList arrayList = isLinked ? new LinkedList() : new ArrayList(values.length);
        Collections.addAll(arrayList, values);
        return arrayList;
    }

    public static <T> List<T> list(boolean isLinked, Collection<T> collection) {
        if (null == collection) {
            return ListUtils.list(isLinked);
        }
        return isLinked ? new LinkedList<T>(collection) : new ArrayList<T>(collection);
    }

    public static <T> List<T> list(boolean isLinked, Iterable<T> iterable) {
        if (null == iterable) {
            return ListUtils.list(isLinked);
        }
        return ListUtils.list(isLinked, iterable.iterator());
    }

    public static <T> List<T> list(boolean isLinked, Iterator<T> iter) {
        List<T> list = ListUtils.list(isLinked);
        if (null != iter) {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list;
    }

    public static <T> List<T> list(boolean isLinked, Enumeration<T> enumRation) {
        List<T> list = ListUtils.list(isLinked);
        if (null != enumRation) {
            while (enumRation.hasMoreElements()) {
                list.add(enumRation.nextElement());
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> ArrayList<T> toList(T ... values) {
        return (ArrayList)ListUtils.list(false, values);
    }

    @SafeVarargs
    public static <T> LinkedList<T> toLinkedList(T ... values) {
        return (LinkedList)ListUtils.list(true, values);
    }

    public static <T> CopyOnWriteArrayList<T> toCopyOnWriteArrayList(Collection<T> collection) {
        return null == collection ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<T>(collection);
    }

    public static <T> ArrayList<T> toList(Collection<T> collection) {
        return (ArrayList)ListUtils.list(false, collection);
    }

    public static <T> ArrayList<T> toList(Iterable<T> iterable) {
        return (ArrayList)ListUtils.list(false, iterable);
    }

    public static <T> ArrayList<T> toList(Iterator<T> iterator) {
        return (ArrayList)ListUtils.list(false, iterator);
    }

    public static <T> ArrayList<T> toList(Enumeration<T> enumeration) {
        return (ArrayList)ListUtils.list(false, enumeration);
    }

    public static <T> List<T> page(int pageNo, int pageSize, List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList(0);
        }
        int resultSize = list.size();
        if (resultSize <= pageSize) {
            if (pageNo < 1) {
                return Collections.unmodifiableList(list);
            }
            return new ArrayList(0);
        }
        int[] startEnd = PageUtils.transToStartEnd(pageNo, pageSize);
        if (startEnd[1] > resultSize) {
            startEnd[1] = resultSize;
        }
        return list.subList(startEnd[0], startEnd[1]);
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> c) {
        list.sort(c);
        return list;
    }

    public static <T> List<T> sortByProperty(List<T> list, String property) {
        return ListUtils.sort(list, new PropertyComparator(property));
    }

    public static List<String> sortByPinyin(List<String> list) {
        return ListUtils.sort(list, new PinyinComparator());
    }

    public static <T> List<T> reverse(List<T> list) {
        Collections.reverse(list);
        return list;
    }

    public static <T> List<T> reverseNew(List<T> list) {
        List<T> list2 = ObjectUtils.clone(list);
        return ListUtils.reverse(list2);
    }

    public static <T> List<T> setOrAppend(List<T> list, int index, T element) {
        if (index < list.size()) {
            list.set(index, element);
        } else {
            list.add(element);
        }
        return list;
    }

    public static <T> List<T> sub(List<T> list, int start, int end) {
        return ListUtils.sub(list, start, end, 1);
    }

    public static <T> List<T> sub(List<T> list, int start, int end, int step) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return new ArrayList(0);
        }
        int size = list.size();
        if (start < 0) {
            start += size;
        }
        if (end < 0) {
            end += size;
        }
        if (start == size) {
            return new ArrayList(0);
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > size) {
            if (start >= size) {
                return new ArrayList(0);
            }
            end = size;
        }
        if (step <= 1) {
            return list.subList(start, end);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (int i = start; i < end; i += step) {
            result.add(list.get(i));
        }
        return result;
    }

    public static <T> List<T> filter(List<T> list, Editor<T> editor) {
        if (null == list || null == editor) {
            return list;
        }
        AbstractList list2 = list instanceof LinkedList ? new LinkedList() : new ArrayList(list.size());
        for (T t : list) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            list2.add(modified);
        }
        return list2;
    }

    public static <T> int[] indexOfAll(List<T> list, Matcher<T> matcher) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        if (null != list) {
            int index = 0;
            for (T t : list) {
                if (null == matcher || matcher.match(t)) {
                    indexList.add(index);
                }
                ++index;
            }
        }
        return Convert.convert(int[].class, indexList);
    }

    public static <T> List<T> unmodifiable(List<T> list) {
        if (null == list) {
            return null;
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> empty() {
        return Collections.emptyList();
    }
}

