/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.comparator;

import com.github.jarvisframework.tool.core.bean.BeanUtils;
import com.github.jarvisframework.tool.core.comparator.ComparatorException;
import com.github.jarvisframework.tool.core.comparator.CompareUtils;
import com.github.jarvisframework.tool.core.util.ObjectUtils;
import java.io.Serializable;
import java.util.Comparator;

public class PropertyComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 9157326766723846313L;
    private final String property;
    private final boolean isNullGreater;

    public PropertyComparator(String property) {
        this(property, true);
    }

    public PropertyComparator(String property, boolean isNullGreater) {
        this.property = property;
        this.isNullGreater = isNullGreater;
    }

    @Override
    public int compare(T o1, T o2) {
        Comparable v2;
        Comparable v1;
        if (o1 == o2) {
            return 0;
        }
        if (null == o1) {
            return this.isNullGreater ? 1 : -1;
        }
        if (null == o2) {
            return this.isNullGreater ? -1 : 1;
        }
        try {
            v1 = (Comparable)BeanUtils.getProperty(o1, this.property);
            v2 = (Comparable)BeanUtils.getProperty(o2, this.property);
        }
        catch (Exception e) {
            throw new ComparatorException(e);
        }
        return this.compare(o1, o2, v1, v2);
    }

    private int compare(T o1, T o2, Comparable fieldValue1, Comparable fieldValue2) {
        int result = ObjectUtils.compare(fieldValue1, fieldValue2, this.isNullGreater);
        if (0 == result) {
            result = CompareUtils.compare(o1, o2, this.isNullGreater);
        }
        return result;
    }
}

