/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.comparator;

import com.github.jarvisframework.tool.core.util.ObjectUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

public class VersionComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 8083701245147495562L;
    public static final VersionComparator INSTANCE = new VersionComparator();

    @Override
    public int compare(String version1, String version2) {
        if (ObjectUtils.equal(version1, version2)) {
            return 0;
        }
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 == null) {
            return -1;
        }
        if (version2 == null) {
            return 1;
        }
        List<String> v1s = StringUtils.split((CharSequence)version1, '.');
        List<String> v2s = StringUtils.split((CharSequence)version2, '.');
        int diff = 0;
        int minLength = Math.min(v1s.size(), v2s.size());
        for (int i = 0; i < minLength; ++i) {
            String v1 = v1s.get(i);
            String v2 = v2s.get(i);
            diff = v1.length() - v2.length();
            if (0 == diff) {
                diff = v1.compareTo(v2);
            }
            if (diff != 0) break;
        }
        return diff != 0 ? diff : v1s.size() - v2s.size();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object) {
            return false;
        }
        if (object.getClass().equals(this.getClass())) {
            VersionComparator other = (VersionComparator)object;
            return this.equals(other);
        }
        return false;
    }
}

