/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.convert;

import com.github.jarvisframework.tool.core.convert.Converter;
import com.github.jarvisframework.tool.core.util.ArrayUtils;
import com.github.jarvisframework.tool.core.util.CharUtils;
import com.github.jarvisframework.tool.core.util.ClassUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.io.Serializable;
import java.util.Map;

public abstract class AbstractConverter<T>
implements Converter<T>,
Serializable {
    private static final long serialVersionUID = 1L;

    public T convertQuietly(Object value, T defaultValue) {
        try {
            return this.convert(value, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public T convert(Object value, T defaultValue) {
        Class<Object> targetType = this.getTargetType();
        if (null == targetType && null == defaultValue) {
            throw new NullPointerException(StringUtils.format((CharSequence)"[type] and [defaultValue] are both null for Converter [{}], we can not know what type to convert !", this.getClass().getName()));
        }
        if (null == targetType) {
            targetType = defaultValue.getClass();
        }
        if (null == value) {
            return defaultValue;
        }
        if (null == defaultValue || targetType.isInstance(defaultValue)) {
            if (targetType.isInstance(value) && !Map.class.isAssignableFrom(targetType)) {
                return (T)targetType.cast(value);
            }
            T result = this.convertInternal(value);
            return null == result ? defaultValue : result;
        }
        throw new IllegalArgumentException(StringUtils.format((CharSequence)"Default value [{}]({}) is not the instance of [{}]", defaultValue, defaultValue.getClass(), targetType));
    }

    protected abstract T convertInternal(Object var1);

    protected String convertToStr(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (ArrayUtils.isArray(value)) {
            return ArrayUtils.toString(value);
        }
        if (CharUtils.isChar(value)) {
            return CharUtils.toString(((Character)value).charValue());
        }
        return value.toString();
    }

    public Class<T> getTargetType() {
        return ClassUtils.getTypeArgument(this.getClass());
    }
}

