/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.convert;

import com.github.jarvisframework.tool.core.convert.BasicType;
import com.github.jarvisframework.tool.core.convert.ConvertException;
import com.github.jarvisframework.tool.core.convert.ConverterRegistry;
import com.github.jarvisframework.tool.core.convert.NumberChineseFormatter;
import com.github.jarvisframework.tool.core.convert.NumberWordFormatter;
import com.github.jarvisframework.tool.core.convert.impl.CollectionConverter;
import com.github.jarvisframework.tool.core.convert.impl.EnumConverter;
import com.github.jarvisframework.tool.core.convert.impl.MapConverter;
import com.github.jarvisframework.tool.core.lang.Assert;
import com.github.jarvisframework.tool.core.lang.TypeReference;
import com.github.jarvisframework.tool.core.text.UnicodeUtils;
import com.github.jarvisframework.tool.core.util.CharsetUtils;
import com.github.jarvisframework.tool.core.util.ClassUtils;
import com.github.jarvisframework.tool.core.util.HexUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class Convert {
    public static String toString(Object value, String defaultValue) {
        return Convert.convertQuietly(String.class, value, defaultValue);
    }

    public static String toString(Object value) {
        return Convert.toString(value, null);
    }

    public static String[] toStringArray(Object value) {
        return Convert.convert(String[].class, value);
    }

    public static Character toChar(Object value, Character defaultValue) {
        return Convert.convertQuietly(Character.class, value, defaultValue);
    }

    public static Character toChar(Object value) {
        return Convert.toChar(value, null);
    }

    public static Character[] toCharArray(Object value) {
        return Convert.convert(Character[].class, value);
    }

    public static Byte toByte(Object value, Byte defaultValue) {
        return Convert.convertQuietly(Byte.class, value, defaultValue);
    }

    public static Byte toByte(Object value) {
        return Convert.toByte(value, null);
    }

    public static Byte[] toByteArray(Object value) {
        return Convert.convert(Byte[].class, value);
    }

    public static byte[] toPrimitiveByteArray(Object value) {
        return Convert.convert(byte[].class, value);
    }

    public static Short toShort(Object value, Short defaultValue) {
        return Convert.convertQuietly(Short.class, value, defaultValue);
    }

    public static Short toShort(Object value) {
        return Convert.toShort(value, null);
    }

    public static Short[] toShortArray(Object value) {
        return Convert.convert(Short[].class, value);
    }

    public static Number toNumber(Object value, Number defaultValue) {
        return Convert.convertQuietly(Number.class, value, defaultValue);
    }

    public static Number toNumber(Object value) {
        return Convert.toNumber(value, null);
    }

    public static Number[] toNumberArray(Object value) {
        return Convert.convert(Number[].class, value);
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        return Convert.convertQuietly(Integer.class, value, defaultValue);
    }

    public static Integer toInt(Object value) {
        return Convert.toInt(value, null);
    }

    public static Integer[] toIntArray(Object value) {
        return Convert.convert(Integer[].class, value);
    }

    public static Long toLong(Object value, Long defaultValue) {
        return Convert.convertQuietly(Long.class, value, defaultValue);
    }

    public static Long toLong(Object value) {
        return Convert.toLong(value, null);
    }

    public static Long[] toLongArray(Object value) {
        return Convert.convert(Long[].class, value);
    }

    public static Double toDouble(Object value, Double defaultValue) {
        return Convert.convertQuietly(Double.class, value, defaultValue);
    }

    public static Double toDouble(Object value) {
        return Convert.toDouble(value, null);
    }

    public static Double[] toDoubleArray(Object value) {
        return Convert.convert(Double[].class, value);
    }

    public static Float toFloat(Object value, Float defaultValue) {
        return Convert.convertQuietly(Float.class, value, defaultValue);
    }

    public static Float toFloat(Object value) {
        return Convert.toFloat(value, null);
    }

    public static Float[] toFloatArray(Object value) {
        return Convert.convert(Float[].class, value);
    }

    public static Boolean toBoolean(Object value, Boolean defaultValue) {
        return Convert.convertQuietly(Boolean.class, value, defaultValue);
    }

    public static Boolean toBoolean(Object value) {
        return Convert.toBoolean(value, null);
    }

    public static Boolean[] toBooleanArray(Object value) {
        return Convert.convert(Boolean[].class, value);
    }

    public static BigInteger toBigInteger(Object value, BigInteger defaultValue) {
        return Convert.convertQuietly(BigInteger.class, value, defaultValue);
    }

    public static BigInteger toBigInteger(Object value) {
        return Convert.toBigInteger(value, null);
    }

    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        return Convert.convertQuietly(BigDecimal.class, value, defaultValue);
    }

    public static BigDecimal toBigDecimal(Object value) {
        return Convert.toBigDecimal(value, null);
    }

    public static Date toDate(Object value, Date defaultValue) {
        return Convert.convertQuietly(Date.class, value, defaultValue);
    }

    public static LocalDateTime toLocalDateTime(Object value, LocalDateTime defaultValue) {
        return Convert.convertQuietly(LocalDateTime.class, value, defaultValue);
    }

    public static LocalDateTime toLocalDateTime(Object value) {
        return Convert.toLocalDateTime(value, null);
    }

    public static Date toInstant(Object value, Date defaultValue) {
        return Convert.convertQuietly(Instant.class, value, defaultValue);
    }

    public static Date toDate(Object value) {
        return Convert.toDate(value, null);
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value, E defaultValue) {
        return new EnumConverter(clazz).convertQuietly(value, defaultValue);
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value) {
        return Convert.toEnum(clazz, value, null);
    }

    public static Collection<?> toCollection(Class<?> collectionType, Class<?> elementType, Object value) {
        return new CollectionConverter(collectionType, elementType).convert(value, null);
    }

    public static List<?> toList(Object value) {
        return Convert.convert(List.class, value);
    }

    public static <T> List<T> toList(Class<T> elementType, Object value) {
        return (List)Convert.toCollection(ArrayList.class, elementType, value);
    }

    public static <K, V> Map<K, V> toMap(Class<K> keyType, Class<V> valueType, Object value) {
        return new MapConverter((Type)((Object)HashMap.class), keyType, valueType).convert(value, null);
    }

    public static <T> T convertByClassName(String className, Object value) throws ConvertException {
        return Convert.convert(ClassUtils.loadClass(className), value);
    }

    public static <T> T convert(Class<T> type, Object value) throws ConvertException {
        return Convert.convert(type, value);
    }

    public static <T> T convert(TypeReference<T> reference, Object value) throws ConvertException {
        return Convert.convert(reference.getType(), value, null);
    }

    public static <T> T convert(Type type, Object value) throws ConvertException {
        return Convert.convert(type, value, null);
    }

    public static <T> T convert(Class<T> type, Object value, T defaultValue) throws ConvertException {
        return Convert.convert(type, value, defaultValue);
    }

    public static <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        return Convert.convertWithCheck(type, value, defaultValue, false);
    }

    public static <T> T convertQuietly(Type type, Object value) {
        return Convert.convertQuietly(type, value, null);
    }

    public static <T> T convertQuietly(Type type, Object value, T defaultValue) {
        return Convert.convertWithCheck(type, value, defaultValue, true);
    }

    public static <T> T convertWithCheck(Type type, Object value, T defaultValue, boolean quietly) {
        ConverterRegistry registry = ConverterRegistry.getInstance();
        try {
            return registry.convert(type, value, defaultValue);
        }
        catch (Exception e) {
            if (quietly) {
                return defaultValue;
            }
            throw e;
        }
    }

    public static String toSBC(String input) {
        return Convert.toSBC(input, null);
    }

    public static String toSBC(String input, Set<Character> notConvertSet) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toDBC(String input) {
        return Convert.toDBC(input, null);
    }

    public static String toDBC(String text, Set<Character> notConvertSet) {
        if (StringUtils.isBlank(text)) {
            return text;
        }
        char[] c = text.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == '\u3000' || c[i] == '\u00a0' || c[i] == '\u2007' || c[i] == '\u202f') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static String toHex(String str, Charset charset) {
        return HexUtils.encodeHexStr(str, charset);
    }

    public static String toHex(byte[] bytes) {
        return HexUtils.encodeHexStr(bytes);
    }

    public static byte[] hexToBytes(String src) {
        return HexUtils.decodeHex(src.toCharArray());
    }

    @Deprecated
    public static String hexStringToString(String hexStr, Charset charset) {
        return Convert.hexToString(hexStr, charset);
    }

    public static String hexToString(String hexStr, Charset charset) {
        return HexUtils.decodeHexStr(hexStr, charset);
    }

    public static String stringToUnicode(String strText) {
        return UnicodeUtils.toUnicode(strText);
    }

    public static String unicodeToString(String unicode) {
        return UnicodeUtils.toString(unicode);
    }

    public static String convertCharset(String str, String sourceCharset, String destCharset) {
        if (StringUtils.hasBlank(str, sourceCharset, destCharset)) {
            return str;
        }
        return CharsetUtils.convert(str, sourceCharset, destCharset);
    }

    public static long convertTime(long sourceDuration, TimeUnit sourceUnit, TimeUnit destUnit) {
        Assert.notNull(sourceUnit, "sourceUnit is null !", new Object[0]);
        Assert.notNull(destUnit, "destUnit is null !", new Object[0]);
        return destUnit.convert(sourceDuration, sourceUnit);
    }

    public static Class<?> wrap(Class<?> clazz) {
        return BasicType.wrap(clazz);
    }

    public static Class<?> unWrap(Class<?> clazz) {
        return BasicType.unWrap(clazz);
    }

    public static String numberToWord(Number number) {
        return NumberWordFormatter.format(number);
    }

    public static String numberToChinese(double number, boolean isUseTraditonal) {
        return NumberChineseFormatter.format(number, isUseTraditonal);
    }

    public static String digitToChinese(Number n) {
        if (null == n) {
            return "\u96f6";
        }
        return NumberChineseFormatter.format(n.doubleValue(), true, true);
    }

    public static byte intToByte(int intValue) {
        return (byte)intValue;
    }

    public static int byteToUnsignedInt(byte byteValue) {
        return byteValue & 0xFF;
    }

    public static short bytesToShort(byte[] bytes) {
        return (short)(bytes[1] & 0xFF | (bytes[0] & 0xFF) << 8);
    }

    public static byte[] shortToBytes(short shortValue) {
        byte[] b = new byte[2];
        b[1] = (byte)(shortValue & 0xFF);
        b[0] = (byte)(shortValue >> 8 & 0xFF);
        return b;
    }

    public static int bytesToInt(byte[] bytes) {
        return bytes[3] & 0xFF | (bytes[2] & 0xFF) << 8 | (bytes[1] & 0xFF) << 16 | (bytes[0] & 0xFF) << 24;
    }

    public static byte[] intToBytes(int intValue) {
        return new byte[]{(byte)(intValue >> 24 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)};
    }

    public static byte[] longToBytes(long longValue) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(longValue & 0xFFL);
            longValue >>= 8;
        }
        return result;
    }

    public static long bytesToLong(byte[] bytes) {
        long values = 0L;
        for (int i = 0; i < 8; ++i) {
            values <<= 8;
            values |= (long)(bytes[i] & 0xFF);
        }
        return values;
    }
}

