/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.convert.impl;

import com.github.jarvisframework.tool.core.bean.BeanUtils;
import com.github.jarvisframework.tool.core.bean.copier.BeanCopier;
import com.github.jarvisframework.tool.core.bean.copier.CopyOptions;
import com.github.jarvisframework.tool.core.bean.copier.ValueProvider;
import com.github.jarvisframework.tool.core.convert.AbstractConverter;
import com.github.jarvisframework.tool.core.map.MapProxy;
import com.github.jarvisframework.tool.core.util.ObjectUtils;
import com.github.jarvisframework.tool.core.util.ReflectUtils;
import com.github.jarvisframework.tool.core.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.Map;

public class BeanConverter<T>
extends AbstractConverter<T> {
    private static final long serialVersionUID = 1L;
    private final Type beanType;
    private final Class<T> beanClass;
    private final CopyOptions copyOptions;

    public BeanConverter(Type beanType) {
        this(beanType, CopyOptions.create().setIgnoreError(true));
    }

    public BeanConverter(Class<T> beanClass) {
        this(beanClass, CopyOptions.create().setIgnoreError(true));
    }

    public BeanConverter(Type beanType, CopyOptions copyOptions) {
        this.beanType = beanType;
        this.beanClass = TypeUtils.getClass(beanType);
        this.copyOptions = copyOptions;
    }

    @Override
    protected T convertInternal(Object value) {
        if (value instanceof Map || value instanceof ValueProvider || BeanUtils.isBean(value.getClass())) {
            if (value instanceof Map && this.beanClass.isInterface()) {
                return MapProxy.create((Map)value).toProxyBean(this.beanClass);
            }
            return BeanCopier.create(value, ReflectUtils.newInstanceIfPossible(this.beanClass), this.beanType, this.copyOptions).copy();
        }
        if (value instanceof byte[]) {
            return ObjectUtils.deserialize((byte[])value);
        }
        return null;
    }

    @Override
    public Class<T> getTargetType() {
        return this.beanClass;
    }
}

